/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.utils.BotpDrawServiceUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.BotpPO.downNodeBill;
import org.apache.commons.lang3.StringUtils;

public class UnAuditValidator
extends AbstractValidator {
    private static final String CAS_AGENTPAYBILL = "cas_agentpaybill";
    private static final String CAS_PAYBILL = "cas_paybill";
    Log log = LogFactory.getLog(UnAuditValidator.class);

    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("hasvoucher");
        preparePropertys.add("isredoffset");
        return preparePropertys;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntitys = this.getDataEntities();
        Set pkSet = Arrays.stream(dataEntitys).map(v -> (Long)v.getBillPkId()).collect(Collectors.toSet());
        DynamicObjectCollection hasVoucherBillArr = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", pkSet)});
        Set hasVoucherBillIds = hasVoucherBillArr.stream().map(v -> v.getLong("sourcebillid")).collect(Collectors.toSet());
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            Object billPkId = dataEntity.getBillPkId();
            DynamicObject bill = dataEntity.getDataEntity();
            String entityName = bill.getDataEntityType().getName();
            if (billPkId != null) {
                String operationName = this.getOperationName();
                DynamicProperty property = dataEntity.getDataEntity().getDynamicObjectType().getProperty("hasvoucher");
                if (hasVoucherBillIds.contains(billPkId) || property != null && ((Boolean)dataEntity.getValue("hasvoucher")).booleanValue()) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8%1$s\u3002\u5982\u786e\u5b9a\u8981%2$s\uff0c\u8bf7\u5148\u5220\u9664\u5173\u8054\u7684\u51ed\u8bc1\u3002", (String)"UnAuditValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]), operationName, operationName));
                    continue;
                }
                Map targetBills = BFTrackerServiceHelper.findTargetBills((String)entityName, (Long[])new Long[]{(Long)billPkId});
                if (this.sourceBillRange(entityName) && this.targetBillCheck(bill)) continue;
                if (targetBills != null && targetBills.size() > 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u8fdb\u884c%s\u3002", (String)"UnAuditValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]), operationName));
                    continue;
                }
            }
            if (!ErEntityTypeUtils.isPublicReimburseBill((String)bill.getDataEntityType().getName()) && !ErEntityTypeUtils.isDailyReimburseBill((String)bill.getDataEntityType().getName())) continue;
            if (bill.getBoolean("isredoffset")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u7ea2\u51b2\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"UnAuditValidator_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!bill.getBoolean("ischangeinvoice")) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u6362\u53d1\u7968\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"UnAuditValidator_5", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean targetBillCheck(DynamicObject bill) {
        String entityId = bill.getDataEntityType().getName();
        Map directTrackDownBills = BotpDrawServiceUtil.getDirectTrackDownBills((String)entityId, (Long[])new Long[]{ErCommonUtils.getPk((Object)bill)});
        List downNodeBills = directTrackDownBills.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (downNodeBills.size() == 0) {
            return false;
        }
        HashMap<String, HashSet<Long>> mapOfDownBills = new HashMap<String, HashSet<Long>>(downNodeBills.size());
        for (downNodeBill downNodeBill2 : downNodeBills) {
            String billEntityId = downNodeBill2.getTableDefine().getEntityNumber();
            HashSet<Long> ids = (HashSet<Long>)mapOfDownBills.get(billEntityId);
            if (ids == null) {
                ids = new HashSet<Long>();
            }
            ids.add(downNodeBill2.getPk());
            mapOfDownBills.put(billEntityId, ids);
        }
        Set entries = mapOfDownBills.entrySet();
        boolean flag = true;
        for (Map.Entry entry : entries) {
            DynamicObjectCollection downBill = QueryServiceHelper.query((String)((String)entry.getKey()), (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", entry.getValue())});
            flag &= downBill.stream().allMatch(e -> e.getString("billstatus").equals("H"));
        }
        return flag || downNodeBills.stream().filter(e -> {
            String entityKey = e.getTableDefine().getEntityKey();
            return !StringUtils.equalsIgnoreCase((CharSequence)entityKey, (CharSequence)CAS_AGENTPAYBILL) && !StringUtils.equalsIgnoreCase((CharSequence)entityKey, (CharSequence)CAS_PAYBILL);
        }).collect(Collectors.toSet()).isEmpty();
    }

    private boolean sourceBillRange(String entityId) {
        this.log.info(">>>>>UnAuditValidator_sourceBillRange:entityId=" + entityId);
        boolean flag = ErEntityTypeUtils.isDailyApplyBill((String)entityId) || ErEntityTypeUtils.isDailyReimburseBill((String)entityId) || ErEntityTypeUtils.isPublicReimburseBill((String)entityId) || ErEntityTypeUtils.isTripReimburseBill((String)entityId) || ErEntityTypeUtils.isDailyLoanBill((String)entityId) || ErEntityTypeUtils.isWithholdingBill((String)entityId) || ErEntityTypeUtils.isApplyPayBill((String)entityId) || ErEntityTypeUtils.isPrePayBill((String)entityId) || ErEntityTypeUtils.isTripReqBill((String)entityId) || ErEntityTypeUtils.isApplyProjectBill((String)entityId) || ErEntityTypeUtils.isCostEstimateBill((String)entityId) || StringUtils.equalsIgnoreCase((CharSequence)entityId, (CharSequence)"er_checkingpaybill") || StringUtils.equalsIgnoreCase((CharSequence)entityId, (CharSequence)"er_publicreimassetbill") || StringUtils.equalsIgnoreCase((CharSequence)entityId, (CharSequence)"er_contractbill");
        this.log.info(">>>>>UnAuditValidator_sourceBillRange:flag=" + flag);
        return flag;
    }
}

