/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator.amount.control;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import org.apache.commons.lang3.StringUtils;

public class AmountFreedSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntitys;
        for (ExtendedDataEntity dataEntity : dataEntitys = this.getDataEntities()) {
            if (!this.checkMustInput(dataEntity)) continue;
            this.checkDataUnique(dataEntity);
            this.checkBusinessLegitimate(dataEntity);
        }
    }

    private boolean checkMustInput(ExtendedDataEntity extDataEntity) {
        DynamicObject dataEntity = extDataEntity.getDataEntity();
        boolean isDefault = dataEntity.getBoolean("isdefault");
        DynamicObjectCollection expenseDOs = dataEntity.getDynamicObjectCollection("expenseitem");
        if (!isDefault && (expenseDOs == null || expenseDOs.isEmpty())) {
            this.addErrorMessage(extDataEntity, ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AmountFreedSaveValidator_8", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void checkDataUnique(ExtendedDataEntity dataEntity) {
        QFilter qFilter;
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        String number = dynamicObject.getString("number");
        String name = dynamicObject.getString("name");
        Object pkValue = dynamicObject.getPkValue();
        boolean isDefault = dynamicObject.getBoolean("isdefault");
        Long orgId = Long.valueOf(dynamicObject.getDynamicObject("createorg").getPkValue().toString());
        QFilter baseDataProFilter = new QFilter("createorg", "=", (Object)orgId);
        QFilter commonFilter = baseDataProFilter.and(new QFilter("id", "!=", pkValue));
        IErDao dao = ErDaoFactory.getInstance((String)dynamicObject.getDataEntityType().getName());
        if (dao.isExist(qFilter = commonFilter.copy().and(new QFilter("number", "=", (Object)number)))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u7ec4\u7ec7\u4e0b\u4f7f\u7528\u7684\u989d\u5ea6\u91ca\u653e\u65b9\u6848\u7f16\u7801\u5fc5\u987b\u552f\u4e00\u3002", (String)"AmountFreedSaveValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        if (dao.isExist(qFilter = commonFilter.copy().and(new QFilter("name", "=", (Object)name)))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u7ec4\u7ec7\u4e0b\u4f7f\u7528\u7684\u989d\u5ea6\u91ca\u653e\u65b9\u6848\u540d\u79f0\u5fc5\u987b\u552f\u4e00\u3002", (String)"AmountFreedSaveValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        if (isDefault) {
            QFilter defaultDataQFilter = commonFilter.copy().and(new QFilter("isdefault", "=", (Object)Boolean.TRUE));
            if (dao.isExist(defaultDataQFilter)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5728\u8be5\u7ec4\u7ec7\u4e0b\u53ea\u80fd\u5b58\u5728\u4e00\u6761\u9002\u7528\u6240\u6709\u8d39\u7528\u9879\u76ee\u7684\u6570\u636e\u3002", (String)"AmountFreedSaveValidator_9", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
        } else {
            DynamicObject[] expenseItemDOs;
            DynamicObjectCollection expenseitem = dynamicObject.getDynamicObjectCollection("expenseitem");
            List pkIds = expenseitem.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
            qFilter = commonFilter.copy().and(new QFilter("expenseitem.fbasedataid_id", "in", pkIds));
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)dynamicObject.getDataEntityType().getName(), (String)"id, expenseitem.fbasedataid_id", (QFilter[])new QFilter[]{qFilter}, (String)"id").select("expenseitem.fbasedataid_id");
            HashSet expenseItemIds = Sets.newHashSet();
            for (Row row : dataSet) {
                expenseItemIds.add(row.getLong("expenseitem.fbasedataid_id"));
            }
            if (expenseItemIds.size() > 0 && (expenseItemDOs = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)expenseItemIds)})) != null && expenseItemDOs.length > 0) {
                List expenseItemNames = Arrays.stream(expenseItemDOs).map(DO -> DO.getString("name")).collect(Collectors.toList());
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5728\u8be5\u7ec4\u7ec7\u4e0b\u7684\u91ca\u653e\u65b9\u6848\u4e0d\u552f\u4e00\u3002", (String)"AmountFreedSaveValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]), StringUtils.join(expenseItemNames, (String)", ")));
            }
        }
    }

    private void checkBusinessLegitimate(ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        if (dynamicObject.getBoolean("nextmonthfree")) {
            return;
        }
        DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("entryentity");
        int totalRate = 0;
        HashMap dayCount = Maps.newHashMap();
        for (DynamicObject d : entry) {
            totalRate += d.getInt("freedrate");
            int count = 1;
            if (dayCount.containsKey(d.getInt("freedday"))) {
                count = (Integer)dayCount.get(d.getInt("freedday")) + 1;
            }
            dayCount.put(d.getInt("freedday"), count);
        }
        for (Map.Entry dayEntry : dayCount.entrySet()) {
            if ((Integer)dayEntry.getValue() <= 1) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u91ca\u653e\u65e5\u671f\u4e0d\u80fd\u91cd\u590d\u3002", (String)"AmountFreedSaveValidator_11", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        if (totalRate != 100) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u91ca\u653e\u6bd4\u4f8b\u5408\u8ba1\u4e0d\u7b49\u4e8e100%\uff0c\u8bf7\u4fee\u6539\u91ca\u653e\u6bd4\u4f8b\u3002", (String)"AmountFreedSaveValidator_10", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
    }
}

