/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator.amount.control;

import java.time.LocalDate;
import java.time.Month;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.daily.service.ReimburseAmountControlService;
import kd.fi.er.business.daily.service.model.ReimburseAmountControlResultBO;
import kd.fi.er.business.expand.ErExpandServiceFacade;
import kd.fi.er.business.ext.enums.ErExtcaseEnum;
import kd.fi.er.business.ext.helper.ErExtHelper;
import kd.fi.er.business.reimamountctl.utils.DailyReimQuotaValidate;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class DailyReimAmountControlValidate
extends AbstractValidator {
    protected MainEntityType billEntityType;
    private static final Log log = LogFactory.getLog(DailyReimAmountControlValidate.class);

    public DailyReimAmountControlValidate(MainEntityType billEntityType) {
        this.billEntityType = billEntityType;
    }

    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            List validMsgs;
            Object invokeExtService;
            Long companyId;
            boolean isControl;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObject company = dataEntity.getDynamicObject("company");
            if (company == null || !(isControl = SystemParamterUtil.isEnableReimburseControlByCompany((Long)(companyId = ErCommonUtils.getPk((Object)company))))) continue;
            String ctrlCompanyName = ReimburseControlUtils.getPersonReimCtlCompanyField();
            if (dataEntity.getDynamicObjectType().getProperties().get((Object)ctrlCompanyName) != null && dataEntity.get(ctrlCompanyName) == null) {
                String reimCompanyAlias = ((IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)ctrlCompanyName)).getDisplayName().getLocaleValue();
                this.addFatalErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"DailyReimAmountControlValidate_5", (String)"fi-er-opplugin", (Object[])new Object[0]), reimCompanyAlias));
                continue;
            }
            List empCltList = SystemParamterUtil.getEmpCltBillList((Long)companyId);
            List deptCltList = SystemParamterUtil.getDeptCltBillList((Long)companyId);
            boolean allowOverYear = ReimburseControlUtils.isAllowPreviousYear((Long)companyId);
            Month maxMonth = ReimburseControlUtils.deadlineMonthOfAllowPreviousYes((Long)companyId);
            boolean iscontinueValidate = true;
            DynamicObjectCollection expenseEntrys = dataEntity.getDynamicObjectCollection("expenseentryentity");
            for (DynamicObject expenseEntry : expenseEntrys) {
                DynamicObject entryExpenseitem = expenseEntry.getDynamicObject("expenseitem");
                if (entryExpenseitem == null) {
                    iscontinueValidate = false;
                    continue;
                }
                String isreimburseamountctl = entryExpenseitem.getString("isreimburseamountctl");
                if ("0".equals(isreimburseamountctl) || "3".equals(isreimburseamountctl)) continue;
                DynamicObject reimburseUser = ErEntityTypeUtils.isPublicReimburseBill((String)this.billEntityType.toString()) ? (expenseEntry.containsProperty("pubreimburser") ? expenseEntry.getDynamicObject("pubreimburser") : dataEntity.getDynamicObject("applier")) : expenseEntry.getDynamicObject("reimburser");
                if ("1".equals(isreimburseamountctl) && reimburseUser == null && (empCltList.contains("1") && ErEntityTypeUtils.isDailyReimburseBill((String)this.billEntityType.toString()) || empCltList.contains("3") && ErEntityTypeUtils.isPublicReimburseBill((String)this.billEntityType.toString()))) {
                    iscontinueValidate = false;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u62a5\u9500\u4eba\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u62a5\u9500\u4eba\u3002", (String)"DailyReimAmountControlValidate_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    break;
                }
                DynamicObject ctrlDept = expenseEntry.getDynamicObject("reimctldept");
                if ("2".equals(isreimburseamountctl) && ctrlDept == null && (deptCltList.contains("1") && ErEntityTypeUtils.isDailyReimburseBill((String)this.billEntityType.toString()) || deptCltList.contains("3") && ErEntityTypeUtils.isPublicReimburseBill((String)this.billEntityType.toString()))) {
                    iscontinueValidate = false;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u90e8\u95e8\u989d\u5ea6\u63a7\u5236\u7684\u8d39\u7528\u9879\u76ee\uff0c\u989d\u5ea6\u63a7\u5236\u90e8\u95e8\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"DailyReimAmountControlValidate_3", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    break;
                }
                if (!(ErEntityTypeUtils.isDailyReimburseBill((String)this.billEntityType.toString()) && ("2".equals(isreimburseamountctl) && deptCltList.contains("1") || "1".equals(isreimburseamountctl) && empCltList.contains("1"))) && (!ErEntityTypeUtils.isPublicReimburseBill((String)this.billEntityType.toString()) || (!"2".equals(isreimburseamountctl) || !deptCltList.contains("3")) && (!"1".equals(isreimburseamountctl) || !empCltList.contains("3")))) continue;
                LocalDate happenDate = ErCommonUtils.getLocalDateFromDate((Date)expenseEntry.getDate("happendate"));
                if (happenDate == null) {
                    iscontinueValidate = false;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8d39\u7528\u53d1\u751f\u65e5\u671f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"DailyReimAmountControlValidate_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    break;
                }
                LocalDate currentLocalDate = ReimburseControlUtils.currentLocalDate();
                if (!allowOverYear && happenDate.getYear() < currentLocalDate.getYear()) {
                    iscontinueValidate = false;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u989d\u5ea6\u4e0d\u5141\u8bb8\u8de8\u5e74\u62a5\u9500\uff0c\u8bf7\u4fee\u6539\u8d39\u7528\u53d1\u751f\u65e5\u671f\u3002", (String)"DailyReimAmountControlValidate_6", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    break;
                }
                if (allowOverYear && happenDate.getYear() == currentLocalDate.getYear() - 1 && currentLocalDate.getMonthValue() > maxMonth.getValue()) {
                    iscontinueValidate = false;
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5728\u622a\u6b62\u6708\u4efd\uff08%d\u6708\uff09\u540e\u62a5\u9500\u8de8\u5e74\u989d\u5ea6\uff0c\u8bf7\u4fee\u6539\u8d39\u7528\u53d1\u751f\u65e5\u671f\u3002", (String)"DailyReimAmountControlValidate_7", (String)"fi-er-opplugin", (Object[])new Object[0]), maxMonth.getValue()));
                    break;
                }
                if (happenDate.getYear() > currentLocalDate.getYear() - 2) continue;
                iscontinueValidate = false;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8d39\u7528\u53d1\u751f\u65e5\u671f\u5728\u4e24\u5e74\u524d\uff0c\u4e0d\u5141\u8bb8\u62a5\u9500\uff0c\u8bf7\u4fee\u6539\u8d39\u7528\u53d1\u751f\u65e5\u671f\u3002", (String)"DailyReimAmountControlValidate_8", (String)"fi-er-opplugin", (Object[])new Object[0]));
                break;
            }
            if (!"-1".equals(invokeExtService = ErExpandServiceFacade.get().invokeExtService("ext.service.er.amountControl", "amountControl", new Object[]{dataEntity}, new Class[]{DynamicObject.class})) && Boolean.FALSE.equals(invokeExtService)) {
                iscontinueValidate = false;
            }
            List result = ErExtHelper.invokeMutiParamsExpandPlugin((ErExtcaseEnum)ErExtcaseEnum.ER_EXTCASE_AMOUNTCT, (Object[])new Object[]{dataEntity});
            for (Object item : result) {
                if (!Boolean.FALSE.equals(item)) continue;
                iscontinueValidate = false;
                break;
            }
            if (!iscontinueValidate || (validMsgs = DailyReimQuotaValidate.validDailyReimQuota((DynamicObject)dataEntity, (String)this.billEntityType.toString(), (ExtendedDataEntity[])this.getDataEntities())).isEmpty()) continue;
            ErrorLevel errorLevel = ErrorLevel.Error;
            String reimburseLimitControlType = ReimburseAmountControlService.getReimburseLimitControlType((Long)companyId);
            if ("3".equals(reimburseLimitControlType)) {
                errorLevel = ErrorLevel.Warning;
                if (ErStdConfig.quotaZeroIsCtrl() && validMsgs.contains(ReimburseAmountControlResultBO.getNoQuotaMsg())) {
                    errorLevel = ErrorLevel.Error;
                }
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"web", (CharSequence)RequestContext.get().getClient())) {
                ErrorLevel finalErrorLevel = errorLevel;
                validMsgs.forEach(e -> this.addMessage(extendedDataEntity, (String)e, finalErrorLevel));
                continue;
            }
            String msg = (String)validMsgs.get(0);
            if (msg.length() > 20) {
                msg = ResManager.loadKDString((String)"\u8d85\u989d\u5ea6\u6216\u8005\u8d85\u6b21\u6570\u62a5\u9500\u3002", (String)"DailyReimAmountControlValidate_9", (String)"fi-er-opplugin", (Object[])new Object[0]);
            }
            this.addMessage(extendedDataEntity, msg, errorLevel);
        }
    }
}

