/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator.invoicecloud.checkInvoice;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.image.ImageServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.model.DetailExpenseModel;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractCheckInvoiceValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(AbstractCheckInvoiceValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            this.validateEachDataEntity(dataEntity);
        }
    }

    private void validateEachDataEntity(ExtendedDataEntity dataEntity) {
        DynamicObject bill = dataEntity.getDataEntity();
        DynamicObject company = bill.getDynamicObject("company");
        if (company == null) {
            return;
        }
        this.checkInvoiceImageTemp(bill, dataEntity);
        this.checkExpenseItemInvoiceCurrency(bill, dataEntity);
        this.checkNoInvoice(bill, dataEntity);
        this.checkMustMapInvoice(bill, dataEntity);
        this.checkInvoiceAmount(bill, dataEntity);
        this.checkInvoiceTitle(bill, dataEntity);
    }

    protected void checkNoInvoice(DynamicObject bill, ExtendedDataEntity dataEntity) {
        log.info("\u68c0\u67e5\u53d1\u7968\u53f7\u5fc5\u5f55");
        DynamicObject company = bill.getDynamicObject("company");
        Long companyId = (Long)company.getPkValue();
        Boolean invoiceIsMust = ReimburseControlUtils.invoiceIsMust((Long)companyId);
        if (!invoiceIsMust.booleanValue()) {
            return;
        }
        boolean supplementInvoice = bill.getBoolean("needsuppleinvoice");
        if (supplementInvoice) {
            return;
        }
        Boolean billHeadNoInvoice = bill.getBoolean("noinvoice");
        if (billHeadNoInvoice.booleanValue()) {
            return;
        }
        List<DetailExpenseModel> detailExpenseEntry = this.getDetailExpenseEntry(bill, dataEntity);
        for (DetailExpenseModel expenseModel : detailExpenseEntry) {
            boolean invoiceOk;
            boolean itemOk;
            int parentIndex;
            int rowIndex;
            DynamicObject expenseEntry = expenseModel.getDynamicObject();
            boolean amountOk = this.checkReimAmount(expenseEntry, bill, dataEntity, rowIndex = expenseModel.getRowIndex(), parentIndex = expenseModel.getParentIndex());
            if (!amountOk || !(itemOk = this.checkItem(expenseEntry, bill, dataEntity, rowIndex, parentIndex)) || (invoiceOk = this.checkDetailExpenseInvoice(expenseEntry, bill, dataEntity, rowIndex, parentIndex))) continue;
            this.addErrorMessage(dataEntity, bill, rowIndex, parentIndex);
        }
    }

    protected void checkInvoiceImageTemp(DynamicObject bill, ExtendedDataEntity dataEntity) {
        log.info("\u68c0\u67e5\u5f71\u50cf\u6a21\u677f");
        DynamicObjectCollection invoiceEntries = bill.getDynamicObjectCollection("invoiceentry");
        if (invoiceEntries.size() <= 0) {
            log.info("\u53d1\u7968\u5206\u5f55\u6ca1\u6709\u53d1\u7968\uff0c\u4e0d\u8fdb\u884c\u6821\u9a8c");
            return;
        }
        DynamicObject company = bill.getDynamicObject("company");
        String mainEntityId = bill.getDataEntityType().getName();
        if (company == null) {
            log.info("\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u6821\u9a8c");
            return;
        }
        Long companyId = (Long)company.getPkValue();
        boolean isImageTemp = SystemParamterUtil.isMapInvoiceCloudImage((Long)companyId);
        if (isImageTemp) {
            String configPrintTemplateFormId = ImageServiceHelper.getConfigedPrintTplFormNumber((DynamicObject)bill, (String)mainEntityId, (Long)companyId);
            if (StringUtils.isBlank((CharSequence)configPrintTemplateFormId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u5355\u636e\u5f71\u50cf\u6a21\u677f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"AbstractCheckInvoiceValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
        } else {
            log.info("\u6ca1\u6709\u96c6\u6210\u53d1\u7968\u4e91\u5f71\u50cf\uff0c\u4e0d\u8fdb\u884c\u6821\u9a8c");
        }
    }

    protected void checkMustMapInvoice(DynamicObject bill, ExtendedDataEntity dataEntity) {
        log.info("\u68c0\u67e5\u53d1\u7968\u662f\u5426\u4e00\u5b9a\u8981\u548c\u8d39\u7528\u660e\u7ec6\u5173\u8054");
        if (ErStdConfig.getInvoiceMustWithExpense()) {
            List results = InvoiceUtils.checkUnbindInvoice((DynamicObject)bill, (ExtendedDataEntity)dataEntity);
            for (String result : results) {
                this.addErrorMessage(dataEntity, result);
            }
        }
    }

    private void checkInvoiceAmount(DynamicObject bill, ExtendedDataEntity dataEntity) {
        log.info("\u68c0\u67e5\u53d1\u7968\u91d1\u989d");
        DynamicObject company = bill.getDynamicObject("company");
        InvoiceUtils.BillEntityType billType = this.getEntityType();
        Long companyId = (Long)company.getPkValue();
        Boolean mustCheck = SystemParamterUtil.isAmountOverInvoice((Long)companyId);
        if (!mustCheck.booleanValue()) {
            List results = InvoiceUtils.checkAmount((Object)bill, (InvoiceUtils.BillEntityType)billType);
            for (String result : results) {
                this.addErrorMessage(dataEntity, result);
            }
        }
    }

    private void checkInvoiceTitle(DynamicObject bill, ExtendedDataEntity dataEntity) {
        ErrorLevel level;
        log.info("\u68c0\u67e5\u53d1\u7968\u62ac\u5934\u7a0e\u53f7");
        DynamicObject invoiceOrgDO = bill.getDynamicObject(this.getCostCompanyField());
        List results = InvoiceUtils.checkBuyerNameAndTaxNo((DynamicObject)bill, (Long)ErCommonUtils.getPk((Object)invoiceOrgDO), (DynamicObject)invoiceOrgDO, (boolean)false);
        if (results.size() > 0) {
            level = ErrorLevel.Error;
        } else {
            level = ErrorLevel.Warning;
            results = InvoiceUtils.checkBuyerNameAndTaxNo((DynamicObject)bill, (Long)ErCommonUtils.getPk((Object)invoiceOrgDO), (DynamicObject)invoiceOrgDO, (boolean)true);
        }
        for (String result : results) {
            this.addMessage(dataEntity, result, level);
        }
    }

    private void checkExpenseItemInvoiceCurrency(DynamicObject billObject, ExtendedDataEntity dataEntity) {
        DynamicObject companyDynamicObj = billObject.getDynamicObject(this.getCompanyField());
        String checkType = SystemParamterUtil.checkInvoiceCurrencyType((Long)ErCommonUtils.getPk((Object)companyDynamicObj));
        if ("0".equals(checkType)) {
            return;
        }
        ErrorLevel errorLevel = "2".equals(checkType) ? ErrorLevel.Error : ErrorLevel.Warning;
        List<DetailExpenseModel> detailExpenseEntry = this.getDetailExpenseEntry(billObject, dataEntity);
        for (DetailExpenseModel expenseModel : detailExpenseEntry) {
            int rowIndex = expenseModel.getRowIndex();
            int parentIndex = expenseModel.getParentIndex();
            DynamicObject detailExpense = expenseModel.getDynamicObject();
            this.checkDetailCurrency(detailExpense, billObject, dataEntity, errorLevel, rowIndex, parentIndex);
        }
    }

    public String getCostCompanyField() {
        return "costcompany";
    }

    public String getCompanyField() {
        return "company";
    }

    public abstract InvoiceUtils.BillEntityType getEntityType();

    public abstract List<DetailExpenseModel> getDetailExpenseEntry(DynamicObject var1, ExtendedDataEntity var2);

    public abstract boolean checkReimAmount(DynamicObject var1, DynamicObject var2, ExtendedDataEntity var3, int var4, int var5);

    public abstract boolean checkItem(DynamicObject var1, DynamicObject var2, ExtendedDataEntity var3, int var4, int var5);

    public abstract void checkDetailCurrency(DynamicObject var1, DynamicObject var2, ExtendedDataEntity var3, ErrorLevel var4, int var5, int var6);

    public abstract boolean checkDetailExpenseInvoice(DynamicObject var1, DynamicObject var2, ExtendedDataEntity var3, int var4, int var5);

    public void addErrorMessage(ExtendedDataEntity dataEntity, DynamicObject billObject, int rowIndex, int parentIndex) {
    }

    public void addCurrencyErrorMessage(ExtendedDataEntity dataEntity, DynamicObject billObject, ErrorLevel errorLevel, int rowIndex, int parentIndex) {
    }
}

