/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator.invoicecloud.checkInvoice;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.model.DetailExpenseModel;
import kd.fi.er.validator.invoicecloud.checkInvoice.AbstractCheckInvoiceValidator;

public class CheckingPaySubmitCheckInvoiceValidator
extends AbstractCheckInvoiceValidator {
    @Override
    public String getCostCompanyField() {
        return "company";
    }

    @Override
    public String getCompanyField() {
        return "appliercompany";
    }

    @Override
    public InvoiceUtils.BillEntityType getEntityType() {
        return InvoiceUtils.BillEntityType.CheckingPayBill;
    }

    @Override
    public List<DetailExpenseModel> getDetailExpenseEntry(DynamicObject bill, ExtendedDataEntity dataEntity) {
        DynamicObjectCollection expenseEntry = bill.getDynamicObjectCollection("entryentity");
        ArrayList<DetailExpenseModel> models = new ArrayList<DetailExpenseModel>(expenseEntry.size());
        for (int rowIndex = 0; rowIndex < expenseEntry.size(); ++rowIndex) {
            DynamicObject dynamicObject = (DynamicObject)expenseEntry.get(rowIndex);
            DetailExpenseModel model = new DetailExpenseModel(dynamicObject, rowIndex, -1);
            models.add(model);
        }
        return models;
    }

    @Override
    public boolean checkReimAmount(DynamicObject detailExpense, DynamicObject billObject, ExtendedDataEntity dataEntity, int rowIndex, int parentIndex) {
        return true;
    }

    @Override
    public boolean checkItem(DynamicObject detailExpense, DynamicObject billObject, ExtendedDataEntity dataEntity, int rowIndex, int parentIndex) {
        return true;
    }

    @Override
    public void checkDetailCurrency(DynamicObject detailExpense, DynamicObject billObject, ExtendedDataEntity dataEntity, ErrorLevel errorLevel, int rowIndex, int parentIndex) {
        DynamicObject currency = billObject.getDynamicObject("currency");
        long currencyId = (Long)currency.getPkValue();
        List invoiceInfo = InvoiceUtils.getNonAutoInvoiceInfoByItemId((DynamicObject)billObject, (Long)((Long)detailExpense.getPkValue()));
        Set invoiceCurrencySet = invoiceInfo.stream().map(invoiceEntry -> {
            DynamicObject invoiceCurrency = invoiceEntry.getDynamicObject("invoicecurrency");
            if (invoiceCurrency == null) {
                return 0L;
            }
            return (Long)invoiceCurrency.getPkValue();
        }).collect(Collectors.toSet());
        if (invoiceInfo == null || invoiceInfo.isEmpty()) {
            return;
        }
        if (invoiceCurrencySet.size() != 1) {
            this.addCurrencyErrorMessage(dataEntity, billObject, errorLevel, rowIndex, parentIndex);
            return;
        }
        Long invoiceCurrencyId = (Long)invoiceCurrencySet.iterator().next();
        if (!Objects.equals(currencyId, invoiceCurrencyId)) {
            this.addCurrencyErrorMessage(dataEntity, billObject, errorLevel, rowIndex, parentIndex);
            return;
        }
    }

    @Override
    public boolean checkDetailExpenseInvoice(DynamicObject detailExpense, DynamicObject billObject, ExtendedDataEntity dataEntity, int rowIndex, int parentIndex) {
        return true;
    }

    @Override
    protected void checkNoInvoice(DynamicObject bill, ExtendedDataEntity dataEntity) {
    }

    @Override
    protected void checkMustMapInvoice(DynamicObject bill, ExtendedDataEntity dataEntity) {
    }

    @Override
    public void addCurrencyErrorMessage(ExtendedDataEntity dataEntity, DynamicObject billObject, ErrorLevel errorLevel, int rowIndex, int parentIndex) {
        String fmt = ResManager.loadKDString((String)"\u7b2c%s\u884c\u7ed3\u7b97\u5355\u5173\u8054\u4fe1\u606f\u5e01\u79cd\u4e0e\u53d1\u7968\u4fe1\u606f\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CheckingPaySubmitCheckInvoiceValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]);
        this.addMessage(dataEntity, String.format(fmt, rowIndex + 1), errorLevel);
    }
}

