/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator.publicbiz.bill.contract;

import java.math.BigDecimal;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.utils.ErCommonUtils;

public class ErContractProjectAmountValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObjectCollection projects = dataEntity.getDataEntity().getDynamicObjectCollection("projectentryentity");
            if (projects.isEmpty()) continue;
            this.checkValidateAmount(dataEntity);
        }
    }

    private void checkValidateAmount(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection entries = dataEntity.getDataEntity().getDynamicObjectCollection("expenseentryentity");
        DynamicObjectCollection projects = dataEntity.getDataEntity().getDynamicObjectCollection("projectentryentity");
        String writeofftype = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)dataEntity.getDataEntity().get("company")), (String)"er010");
        String changetype = (String)dataEntity.getValue("changetype");
        String detailtype = (String)dataEntity.getValue("detailtype");
        if ("biztype_stopbill".equals(detailtype) || "B".equals(changetype)) {
            return;
        }
        if (WriteOffTypeEnum.ORGI_WO.getValue().equals(writeofftype)) {
            BigDecimal oriexpenseAmt = entries.stream().map(entry -> (BigDecimal)entry.get("expenseamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal orivalidateAmt = BigDecimal.ZERO;
            if (entries != null && entries.size() > 0 && ((DynamicObject)entries.get(0)).getDynamicObject("entrycurrency") != null) {
                orivalidateAmt = projects.stream().filter(t -> t.get("projectcurrency") != null && t.getDynamicObject("projectcurrency").getPkValue() == ((DynamicObject)entries.get(0)).getDynamicObject("entrycurrency").getPkValue()).map(entry -> (BigDecimal)entry.get("oriprojectcanamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            BigDecimal oriwriteAmt = projects.stream().map(entry -> (BigDecimal)entry.get("oriprojectwriteoffamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (oriexpenseAmt.compareTo(orivalidateAmt) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u542b\u7a0e\u91d1\u989d\u539f\u5e01\u5927\u4e8e\u7acb\u9879\u53ef\u7528\u5408\u540c\u91d1\u989d\u539f\u5e01\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"ErContractProjectAmountValidator_3", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            if (oriwriteAmt.compareTo(oriexpenseAmt) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51b2\u9500\u91d1\u989d\u539f\u5e01\u5927\u4e8e\u542b\u7a0e\u91d1\u989d\u539f\u5e01\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"ErContractProjectAmountValidator_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
        } else {
            BigDecimal expenseAmt = entries.stream().map(entry -> (BigDecimal)entry.get("currexpenseamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal validateAmt = projects.stream().map(entry -> (BigDecimal)entry.get("projectcanamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal writeAmt = projects.stream().map(entry -> (BigDecimal)entry.get("projectwriteoffamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (expenseAmt.compareTo(validateAmt) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u542b\u7a0e\u91d1\u989d\u5927\u4e8e\u7acb\u9879\u53ef\u7528\u5408\u540c\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"ErContractProjectAmountValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            if (writeAmt.compareTo(expenseAmt) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51b2\u9500\u91d1\u989d\u5927\u4e8e\u542b\u7a0e\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"ErContractProjectAmountValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
        }
        if (!(projects == null || projects.isEmpty() || "biztype_stopbill".equals(detailtype) || "B".equals(changetype))) {
            Long sourcebillid = ((DynamicObject)projects.get(0)).getLong("sourcebillid");
            String srcbilltype = ((DynamicObject)projects.get(0)).getString("srcbilltype");
            if (sourcebillid != 0L && "er_applyprojectbill".equals(srcbilltype)) {
                DynamicObjectCollection applyprojectList;
                BigDecimal writeoffamount = BigDecimal.ZERO;
                BigDecimal availableamount = BigDecimal.ZERO;
                Set idList = projects.stream().map(exp -> exp.getLong("sourcebillid")).collect(Collectors.toSet());
                if (idList != null && idList.size() > 0 && (applyprojectList = QueryServiceHelper.query((String)"er_applyprojectbill", (String)"id,nonpayamount,notpayamount,billno,availableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)})) != null && applyprojectList.size() > 0) {
                    for (DynamicObject applyproject : applyprojectList) {
                        availableamount = applyproject.getBigDecimal("availableamount");
                        writeoffamount = projects.stream().filter(m -> m.getLong("sourcebillid") == applyproject.getLong("id")).map(n -> n.getBigDecimal("projectwriteoffamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        if (writeoffamount.compareTo(availableamount) <= 0) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7acb\u9879\u5355\u201c%1$s\u201d\u5173\u8054\u7684\u7533\u8bf7\u91d1\u989d\u5408\u8ba1\u4e0d\u5141\u8bb8\u8d85\u51fa\u8be5\u7acb\u9879\u5355\u53ef\u7528\u91d1\u989d\u3002", (String)"RelationContractAmountValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]), applyproject.get("billno")));
                    }
                }
            }
        }
    }
}

