/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator.publicbiz.bill.project;

import java.math.BigDecimal;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import org.apache.commons.lang3.StringUtils;

public class ProjectBillValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(ProjectBillValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities != null && dataEntities.length > 0) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObjectCollection expenseentry;
                String detailType;
                DynamicObject bill = dataEntity.getDataEntity();
                if (!ErEntityTypeUtils.isApplyProjectBill((String)bill.getDataEntityType().getName()) || !"biztype_changebill".equals(detailType = bill.getString("detailtype")) || (expenseentry = bill.getDynamicObjectCollection("expenseentryentity")) == null || expenseentry.size() <= 0) continue;
                Long relationsize = bill.getDynamicObjectCollection("expenseentryentity").stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getString("wbsrcbillno"))).map(o -> o.getString("wbsrcbillno")).distinct().count();
                if (relationsize > 1L) {
                    DynamicObjectCollection applyprojectList;
                    Long wbsrcbillid = ((DynamicObject)expenseentry.get(0)).getLong("wbsrcbillid");
                    String wbsrcbilltype = ((DynamicObject)expenseentry.get(0)).getString("wbsrcbilltype");
                    if (wbsrcbillid == 0L || !"er_applyprojectbill".equals(wbsrcbilltype)) continue;
                    BigDecimal currexpenseamount = BigDecimal.ZERO;
                    BigDecimal availableAmount = BigDecimal.ZERO;
                    Set idList = expenseentry.stream().map(exp -> exp.getLong("wbsrcbillid")).collect(Collectors.toSet());
                    if (idList == null || idList.size() <= 0 || (applyprojectList = QueryServiceHelper.query((String)"er_applyprojectbill", (String)"id,availableamount,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)})) == null || applyprojectList.size() <= 0) continue;
                    for (DynamicObject applyproject : applyprojectList) {
                        availableAmount = applyproject.getBigDecimal("availableamount");
                        currexpenseamount = expenseentry.stream().filter(m -> m.getLong("wbsrcbillid") == applyproject.getLong("id")).map(n -> n.getBigDecimal("currexpenseamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        logger.info("---availableAmount---" + availableAmount + "---currexpenseamount---" + currexpenseamount);
                        if (currexpenseamount.add(availableAmount).compareTo(BigDecimal.ZERO) >= 0) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u91d1\u989d\u672c\u4f4d\u5e01\u5408\u8ba1\u4e0d\u5141\u8bb8\u8d85\u51fa\u7acb\u9879\u5355\u201c%1$s\u201d\u53ef\u7528\u91d1\u989d\u3002", (String)"RelationContractAmountValidator_5", (String)"fi-er-opplugin", (Object[])new Object[0]), applyproject.get("billno")));
                    }
                    continue;
                }
                for (DynamicObject exp2 : expenseentry) {
                    if (exp2.getBigDecimal("expenseamount").add(exp2.getBigDecimal("entrychangeableamount")).compareTo(BigDecimal.ZERO) >= 0) continue;
                    return;
                }
                BigDecimal currexpenseamount = AmountUtils.getEntryAmount((DynamicObjectCollection)expenseentry, (String)"currexpenseamount");
                BigDecimal availableamount = bill.getBigDecimal("availableamount");
                String billno = ((DynamicObject)expenseentry.get(0)).getString("wbsrcbillno");
                if (currexpenseamount.add(availableamount).compareTo(BigDecimal.ZERO) >= 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u91d1\u989d\u672c\u4f4d\u5e01\u5408\u8ba1\u4e0d\u5141\u8bb8\u8d85\u51fa\u7acb\u9879\u5355\u201c%1$s\u201d\u53ef\u7528\u91d1\u989d\u3002", (String)"RelationContractAmountValidator_5", (String)"fi-er-opplugin", (Object[])new Object[0]), billno));
            }
        }
    }
}

