/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator.trip.checking;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class TripDateSubmitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntitys;
        for (ExtendedDataEntity dataEntity : dataEntitys = this.getDataEntities()) {
            if (this.checkTripDate(dataEntity)) continue;
        }
    }

    private boolean checkTripDate(ExtendedDataEntity dataEntity) {
        DynamicObject bill = dataEntity.getDataEntity();
        String dateSelectRange = SystemParamterUtil.getTripReimDateSelectRange((Long)ErCommonUtils.getPk((Object)bill.get("company")));
        if (StringUtils.equals((CharSequence)"1", (CharSequence)dateSelectRange)) {
            return true;
        }
        DynamicObjectCollection trips = (DynamicObjectCollection)bill.get("tripentry");
        if (trips == null || trips.isEmpty()) {
            return true;
        }
        Boolean isValid = true;
        for (int tripIndex = 0; tripIndex < trips.size(); ++tripIndex) {
            DynamicObject trip = (DynamicObject)trips.get(tripIndex);
            DynamicObjectCollection entries = (DynamicObjectCollection)trip.get("entryentity");
            if (entries == null || entries.isEmpty()) continue;
            for (int index = 0; index < entries.size(); ++index) {
                Date now;
                DynamicObject entry = (DynamicObject)entries.get(index);
                Date endDate = entry.getDate("trip2enddate");
                if (entry.getBigDecimal("orientryamount").compareTo(BigDecimal.ZERO) == 0) continue;
                String settlmentType = entry.getString("settlementtype");
                if (endDate == null || "2".equals(settlmentType) || !endDate.after(now = new Date())) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u4e2a\u884c\u7a0b\uff0c\u5dee\u65c5\u660e\u7ec6\u7b2c%2$s\u884c\u7a0b\u7ed3\u675f\u65e5\u671f\u8d85\u8fc7\u5f53\u524d\u65e5\u671f\u3002", (String)"TripDateSubmitValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]), tripIndex + 1, index + 1));
                isValid = false;
            }
        }
        return isValid;
    }
}

