/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.web.openapi;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.plugin.ApiSavePlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ErExpenseitemSaveInparameter
implements ApiSavePlugin {
    private static String REG = ";";
    private static final Log logger = LogFactory.getLog(ErExpenseitemSaveInparameter.class);
    public static List<String> message = new ArrayList<String>();

    public List<Map<String, Object>> preHandleRequestData(List<Map<String, Object>> reqData) {
        for (Map<String, Object> data : reqData) {
            message = this.beforeImportOp(data);
        }
        return reqData;
    }

    private List<String> beforeImportOp(Map dataMap) {
        if (dataMap.get("createorg") == null) {
            long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
            DynamicObject rootOrg = QueryServiceHelper.queryOne((String)"bos_org", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)rootOrgId)});
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", (String)rootOrg.get("number"));
            dataMap.put("createorg", map);
        }
        ArrayList<String> importlogs = new ArrayList<String>();
        String relbilltype = ObjectUtils.defaultIfNull(dataMap.get("relbilltype"), (Object)"").toString();
        String itemNumber = (String)dataMap.get("number");
        String[] numberArr = itemNumber.split("\\.");
        HashMap parent = (HashMap)dataMap.get("parent");
        if (numberArr.length > 1) {
            Optional<DynamicObject> firstExpItemOptional;
            String prefixNumber = itemNumber.substring(0, itemNumber.lastIndexOf("."));
            if (parent != null) {
                String parentNumber = (String)parent.get("number");
                if (!StringUtils.equals((CharSequence)prefixNumber, (CharSequence)parentNumber)) {
                    importlogs.add(String.format("\"%s\"\u7684\u7f16\u7801\u5c42\u6b21\u548c\u4e0a\u7ea7\u7f16\u7801\"%s\"\u4e0d\u4e00\u81f4;", itemNumber, parentNumber));
                }
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("number", prefixNumber);
                dataMap.put("parent", map);
            }
            String createOrgNumber = (String)((HashMap)dataMap.get("createorg")).get("number");
            List createOrgIds = QueryServiceHelper.queryPrimaryKeys((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)createOrgNumber)}, null, (int)-1);
            if (createOrgIds.size() == 0) {
                importlogs.add(String.format("\u7f16\u7801\u4e3a\"%s\u7684\u521b\u5efa\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", createOrgNumber));
            }
            QFilter qFilter = new QFilter("number", "=", (Object)prefixNumber);
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)((Long)createOrgIds.get(0)));
            QFilter totalFilter = qFilter.and(baseDataFilter);
            logger.info("ExpenseItemImportDataOp>>>:" + totalFilter.toString());
            DynamicObjectCollection expenseItems = QueryServiceHelper.query((String)"er_expenseitemedit", (String)"id,number,level", (QFilter[])new QFilter[]{totalFilter});
            if (expenseItems.size() > 1) {
                importlogs.add(String.format("\u4e0a\u7ea7\u8d39\u7528\u9879\u76ee\u7f16\u7801\"%s\"\u5728\u7cfb\u7edf\u4e2d\u91cd\u590d\uff0c\u6682\u4e0d\u652f\u6301\u5bfc\u5165;", prefixNumber));
            }
            if (!(firstExpItemOptional = expenseItems.stream().findFirst()).isPresent()) {
                importlogs.add(String.format("\u672a\u627e\u5230\u4e0a\u7ea7\u8d39\u7528\u9879\u76ee\"%s\";", prefixNumber));
            }
            firstExpItemOptional.ifPresent(parentExp -> dataMap.put("level", parentExp.getInt("level") + 1));
        } else {
            dataMap.put("level", 1);
        }
        if (StringUtils.isNotBlank((CharSequence)relbilltype)) {
            String[] billtypes = relbilltype.split(REG);
            Map<String, Object> billtypeMap = this.getBillTypeMap();
            for (String billtype : billtypes) {
                if (billtypeMap.get(billtype) != null) continue;
                importlogs.add(String.format("\u672a\u627e\u5230\u5355\u636e\u7c7b\u578b\"%s\";", billtype));
            }
        }
        return importlogs;
    }

    private Map<String, Object> getBillTypeMap() {
        HashMap billtypeMap = Maps.newHashMapWithExpectedSize((int)16);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"er_billtype", (String)"name,number", (QFilter[])new QFilter[]{QFilter.isNotNull((String)"name")});
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            DynamicObject billtype = (DynamicObject)iterator.next().getValue();
            billtypeMap.put(billtype.getString("name"), billtype.getPkValue());
        }
        return billtypeMap;
    }
}

