/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.aef;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.aef.GetBizBillInfoImpl;
import kd.bos.ext.fi.aef.TicketType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.kingdee.QueryInvoiceDetailBO;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.model.invoice.InvoiceDetailRetrunVO;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.fi.er.common.utils.ThrowableHelper;
import org.apache.commons.lang3.StringUtils;

public class ErGetBizBillInfoImpl
extends GetBizBillInfoImpl {
    private static final String ALGO = ErGetBizBillInfoImpl.class.getName();
    private static final Log logger = LogFactory.getLog(ErGetBizBillInfoImpl.class);

    public Map<Long, List<JSONObject>> getBizBillTicketList(String billType, Set<Long> billIds) {
        return this.getBizBillTicketList(billType, billIds, true);
    }

    public Map<Long, List<JSONObject>> getBizBillTicketListNew(String billType, Set<Long> billIds) {
        return this.getBizBillTicketList(billType, billIds, false);
    }

    public Map<Long, List<JSONObject>> getBizBillTicketList(String billType, Set<Long> billIds, boolean oldInterface) {
        logger.info(String.format("\u4f1a\u8ba1\u7535\u5b50\u6863\u6848\u8d39\u7528\u5904\u7406\u8c03\u5165\uff0cbillType=%1$s, billIds=%2$s", billType, billIds));
        if (!(ErEntityTypeUtils.isPublicReimburseBill(billType) || ErEntityTypeUtils.isTripReimburseBill(billType) || ErEntityTypeUtils.isDailyReimburseBill(billType))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u5355\u636e\u7c7b\u578b\uff1a%1$s", (String)"ErGetBizBillInfoImpl_0", (String)"fi-er-business", (Object[])new Object[0]), billType));
        }
        Map<Long, List<JSONObject>> result = this._getBizBillInvoiceLst(billType, billIds, oldInterface);
        if (ErEntityTypeUtils.isPublicReimburseBill(billType)) {
            String selectFields = "id, expenseentryentity.entrycontractno contractno";
            QFilter[] filters = new QFilter("id", "in", result.keySet()).toArray();
            HashMap<Long, HashSet<String>> contractNoBillMap = new HashMap<Long, HashSet<String>>();
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)ALGO, (String)billType, (String)selectFields, (QFilter[])filters, (String)"id asc");){
                for (Row row : ds) {
                    Long billId = row.getLong("id");
                    HashSet<String> contractNos = (HashSet<String>)contractNoBillMap.get(billId);
                    if (contractNos == null) {
                        contractNos = new HashSet<String>();
                        contractNoBillMap.put(billId, contractNos);
                    }
                    contractNos.add(row.getString("contractno"));
                }
            }
            for (Map.Entry mapEntry : contractNoBillMap.entrySet()) {
                String contractNoStr = ErCommonUtils.join((Collection)mapEntry.getValue(), ",");
                List<JSONObject> ticketLst = result.get(mapEntry.getKey());
                for (JSONObject ticket : ticketLst) {
                    ticket.put("ContractNumber", (Object)contractNoStr);
                }
            }
        }
        logger.info("\u4f20\u9012\u56de\u4f1a\u8ba1\u7535\u5b50\u6863\u6848\u7684\u6570\u636e\uff1a" + JSONObject.toJSONString(result));
        return result;
    }

    private Map<Long, List<JSONObject>> _getBizBillInvoiceLst(String billType, Set<Long> billIds, boolean oldInterface) {
        String costCompanyField = null;
        String serialNoField = null;
        String invoiceCodeField = null;
        String invoiceNoField = null;
        String validatestField = null;
        String inoutamountField = null;
        String redField = null;
        String billStatusField = null;
        String invoiceTypeField = null;
        String xbrlField = null;
        String invoicedateField = "invoiceentry.invoicedate";
        String totalamountField = "invoiceentry.totalamount";
        costCompanyField = "costcompany";
        serialNoField = "invoiceentry.serialno";
        invoiceCodeField = "invoiceentry.invoicecode";
        invoiceNoField = "invoiceentry.invoiceno";
        validatestField = "invoiceentry.ie_validatest";
        inoutamountField = "invoiceentry.inoutamount";
        redField = "invoiceentry.isred";
        billStatusField = "billstatus";
        invoiceTypeField = "invoiceentry.invoicetype";
        xbrlField = "invoiceentry.isxbrl";
        StringBuilder sb = new StringBuilder("id");
        sb.append(",").append(costCompanyField).append(" costCompanyField");
        sb.append(",").append(serialNoField).append(" serialNoField");
        sb.append(",").append(invoiceCodeField).append(" invoiceCodeField");
        sb.append(",").append(invoiceNoField).append(" invoiceNoField");
        sb.append(",").append(validatestField).append(" validatestField");
        sb.append(",").append(inoutamountField).append(" inoutamountField");
        sb.append(",").append(redField).append(" redField");
        sb.append(",").append(billStatusField).append(" billStatusField");
        sb.append(",").append(invoiceTypeField).append(" invoiceTypeField");
        sb.append(",").append(invoicedateField).append(" invoicedateField");
        sb.append(",").append(totalamountField).append(" totalamountField");
        sb.append(", invoiceentry.makeoutcompname as  makeoutcompname , invoiceentry.salertaxno_h as salertaxno_h, invoiceentry.invoicenotaxamount as invoicenotaxamount, invoiceentry.taxamount_invoice as taxamount_invoice, invoiceentry.invoicecurrency as currency, bookeddate, bizdate ");
        String selectFields = sb.toString();
        String sel = "invoicetype.number no,tickettype";
        DynamicObjectCollection col = QueryServiceHelper.query((String)"er_aeftickettype", (String)sel, (QFilter[])new QFilter("id", "!=", (Object)0L).toArray());
        HashMap<String, String> invoiceTypeMap = new HashMap<String, String>(col.size());
        for (DynamicObject ticketType : col) {
            invoiceTypeMap.put(ticketType.getString("no"), ticketType.getString("tickettype"));
        }
        QFilter[] filters = new QFilter[]{new QFilter(invoiceTypeField, "in", invoiceTypeMap.keySet()), new QFilter("id", "in", billIds)};
        HashMap<Long, List<JSONObject>> result = new HashMap<Long, List<JSONObject>>();
        HashMap<String, ArrayList<JSONObject>> serialNoMap = new HashMap<String, ArrayList<JSONObject>>();
        HashMap costCompanyMap = new HashMap();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ALGO, (String)billType, (String)selectFields, (QFilter[])filters, (String)"id asc");){
            for (Row row : ds) {
                Long billId = row.getLong("id");
                ArrayList<JSONObject> invoiceLst = (ArrayList<JSONObject>)result.get(billId);
                if (result.get(billId) == null) {
                    invoiceLst = new ArrayList<JSONObject>();
                    result.put(billId, invoiceLst);
                }
                JSONObject jsonObject = new JSONObject();
                invoiceLst.add(jsonObject);
                Long costCompanyId = row.getLong("costCompanyField");
                HashSet<String> serialNos = (HashSet<String>)costCompanyMap.get(costCompanyId);
                if (serialNos == null) {
                    serialNos = new HashSet<String>();
                    costCompanyMap.put(costCompanyId, serialNos);
                }
                jsonObject.put("costcompany", (Object)costCompanyId);
                String serialNo = row.getString("serialNoField");
                if (!oldInterface) {
                    jsonObject.put("billid", (Object)serialNo);
                    jsonObject.put("seqno", (Object)serialNo);
                } else {
                    jsonObject.put("seqNo", (Object)serialNo);
                }
                serialNos.add(serialNo);
                ArrayList<JSONObject> jsonObjectLst = (ArrayList<JSONObject>)serialNoMap.get(serialNo);
                if (jsonObjectLst == null) {
                    jsonObjectLst = new ArrayList<JSONObject>();
                    serialNoMap.put(serialNo, jsonObjectLst);
                }
                jsonObjectLst.add(jsonObject);
                if (oldInterface) {
                    this.build(invoiceTypeMap, row, jsonObject);
                    continue;
                }
                this.buildNew(invoiceTypeMap, row, jsonObject);
            }
        }
        boolean aws = !KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud();
        ArrayList<InvoiceVO> allInvoiceVOs = new ArrayList<InvoiceVO>();
        block13: for (Map.Entry mapEntry : costCompanyMap.entrySet()) {
            QueryInvoiceDetailBO queryInvoiceDetailBO = this.buildQueryInvoiceDetailBO((Long)mapEntry.getKey(), (Set)mapEntry.getValue());
            List<InvoiceVO> invoiceVOs = null;
            int retryTime = 2;
            for (int i = 1; i <= retryTime; ++i) {
                try {
                    invoiceVOs = aws ? APIHelper.queryInvoiceDetailBySerialNo(queryInvoiceDetailBO) : ErGetBizBillInfoImpl.queryInvoiceDetail(new ArrayList((Collection)mapEntry.getValue()));
                    allInvoiceVOs.addAll(invoiceVOs);
                    continue block13;
                }
                catch (Exception e) {
                    if (i < retryTime) continue;
                    logger.error("\u7535\u5b50\u51ed\u8bc1\u8c03\u7528\u53d1\u7968\u4e91:", (Throwable)e);
                    throw new KDException(String.format(ResManager.loadKDString((String)"\u8d39\u7528\u4f1a\u8ba1\u7535\u5b50\u6863\u6848\uff0c\u8bf7\u6c42\u53d1\u7968\u4e91\u5931\u8d25: %1$s", (String)"ErGetBizBillInfoImpl_2", (String)"fi-er-business", (Object[])new Object[0]), ThrowableHelper.toString((Exception)e)));
                }
            }
        }
        for (InvoiceVO invoiceVO : allInvoiceVOs) {
            String xbrlUrl = invoiceVO.getXbrlUrl();
            String fileUrl = invoiceVO.getDownloadUrl();
            String serialNo = invoiceVO.getSerialNo();
            List jsonObjectLst = (List)serialNoMap.get(serialNo);
            if (CollectionUtils.isEmpty((Collection)jsonObjectLst)) continue;
            for (JSONObject jsonObject : jsonObjectLst) {
                String aefTicketType = (String)jsonObject.get((Object)"tickettype");
                if (oldInterface) {
                    if (TicketType.ATR_RECEIVER.getValue().equals(aefTicketType)) {
                        jsonObject.put("ElectronicInvoiceAirTransportReceiptNumber", (Object)invoiceVO.getInvoiceNo());
                    } else if (TicketType.RAI_RECEIVER.getValue().equals(aefTicketType)) {
                        jsonObject.put("ElectronicInvoiceRailwayETicketNumber", (Object)invoiceVO.getNumber());
                    }
                    if (xbrlUrl == null) continue;
                    jsonObject.put("xbrlUrl", (Object)xbrlUrl);
                    continue;
                }
                if (TicketType.ATR_RECEIVER.getValue().equals(aefTicketType)) {
                    jsonObject.put("invoicenumber", (Object)invoiceVO.getInvoiceNo());
                } else if (TicketType.RAI_RECEIVER.getValue().equals(aefTicketType)) {
                    jsonObject.put("invoicenumber", (Object)invoiceVO.getNumber());
                }
                if (xbrlUrl == null) continue;
                jsonObject.put("fileurl", (Object)fileUrl);
            }
        }
        return result;
    }

    private void build(Map<String, String> invoiceTypeMap, Row row, JSONObject jsonObject) {
        jsonObject.put("UniqueCodeOfInvoice", (Object)(row.getString("invoiceCodeField") + row.getString("invoiceNoField")));
        jsonObject.put("WhetherInvoiceHasBeenChecked", (Object)Boolean.valueOf("1".equals(row.getString("validatestField"))).toString());
        BigDecimal inoutamountFieldValue = row.getBigDecimal("inoutamountField");
        jsonObject.put("AmountOfTransferredOutInputVat", (Object)inoutamountFieldValue.toPlainString());
        jsonObject.put("WhetherInputVatHasBeenTransferredOut", (Object)Boolean.valueOf(inoutamountFieldValue.compareTo(BigDecimal.ZERO) > 0).toString());
        jsonObject.put("WhetherInvoiceIsRedInvoice", (Object)row.getBoolean("redField").toString());
        jsonObject.put("WhetherInvoiceHasBeenPaid", (Object)Boolean.valueOf("G".equals(row.getString("billStatusField"))).toString());
        String invoiceTypeFieldValue = row.getString("invoiceTypeField");
        jsonObject.put("invoiceTypeFieldValue", (Object)invoiceTypeFieldValue);
        TicketType ticketType = TicketType.valueOf((String)invoiceTypeMap.get(invoiceTypeFieldValue));
        jsonObject.put("tickettype", (Object)ticketType.getValue());
        if (ticketType == TicketType.RAI_RECEIVER) {
            jsonObject.put("ElectronicInvoiceRailwayETicketNumber", (Object)row.getString("invoiceNoField"));
        } else if (ticketType == TicketType.NTREV_GPM_RECEIVER) {
            StringBuilder _sb = new StringBuilder();
            _sb.append(row.getString("invoiceCodeField")).append("-").append(row.getString("invoiceNoField"));
            jsonObject.put("EINVOICE_ID", (Object)_sb.reverse());
            jsonObject.put("BILL_DATE", (Object)ErGetBizBillInfoImpl.formate(row.getDate("invoicedateField")));
            jsonObject.put("PAID_AMT", (Object)row.getBigDecimal("totalamountField"));
        } else if (ticketType != null && Arrays.asList("EINV_ORD_RECEIVER", "EINV_SPCL_RECEIVER").contains(ticketType.name())) {
            this.buildEinvInfo(row, jsonObject);
        } else if (ticketType != null && ticketType == TicketType.EFI) {
            StringBuilder _sb = new StringBuilder();
            _sb.append(row.getString("invoiceCodeField")).append("-").append(row.getString("invoiceNoField"));
            jsonObject.put("EInvoiceID", (Object)_sb.reverse());
            jsonObject.put("IssueDate", (Object)ErGetBizBillInfoImpl.formate(row.getDate("invoicedateField")));
            jsonObject.put("TotalAmount", (Object)row.getBigDecimal("totalamountField"));
        }
    }

    private void buildNew(Map<String, String> invoiceTypeMap, Row row, JSONObject jsonObject) {
        jsonObject.put("currency", (Object)row.getLong("currency"));
        jsonObject.put("bookdate", row.get("bizdate"));
        jsonObject.put("org", (Object)row.getLong("costCompanyField"));
        jsonObject.put("hasbeenchecked", (Object)Boolean.valueOf("1".equals(row.getString("validatestField"))).toString());
        BigDecimal inoutamountFieldValue = row.getBigDecimal("inoutamountField");
        jsonObject.put("transferredoutamount", (Object)inoutamountFieldValue.toPlainString());
        jsonObject.put("istransferredout", (Object)(inoutamountFieldValue.compareTo(BigDecimal.ZERO) > 0 ? "1" : "0"));
        jsonObject.put("isredinvoice", (Object)(row.getBoolean("redField") != false ? "1" : "0"));
        jsonObject.put("hasbeenpaid", (Object)("G".equals(row.getString("billStatusField")) ? "1" : "0"));
        String invoiceTypeFieldValue = row.getString("invoiceTypeField");
        TicketType ticketType = TicketType.valueOf((String)invoiceTypeMap.get(invoiceTypeFieldValue));
        jsonObject.put("tickettype", (Object)ticketType.getValue());
        if (ticketType == TicketType.RAI_RECEIVER) {
            jsonObject.put("invoicenumber", (Object)row.getString("invoiceNoField"));
        } else if (ticketType == TicketType.NTREV_GPM_RECEIVER) {
            StringBuilder _sb = new StringBuilder();
            _sb.append(row.getString("invoiceCodeField")).append("-").append(row.getString("invoiceNoField"));
            jsonObject.put("einvoiceid", (Object)_sb.reverse());
            jsonObject.put("billdate", (Object)ErGetBizBillInfoImpl.formate(row.getDate("invoicedateField")));
            jsonObject.put("paidamt", (Object)row.getBigDecimal("totalamountField"));
        } else if (ticketType != null && Arrays.asList("EINV_ORD_RECEIVER", "EINV_SPCL_RECEIVER").contains(ticketType.name())) {
            this.buildEinvInfoNew(row, jsonObject);
        } else if (ticketType == TicketType.EFI) {
            StringBuilder _sb = new StringBuilder();
            _sb.append(row.getString("invoiceCodeField")).append("-").append(row.getString("invoiceNoField"));
            jsonObject.put("einvoiceid", (Object)_sb.reverse());
            jsonObject.put("billdate", (Object)ErGetBizBillInfoImpl.formate(row.getDate("invoicedateField")));
            jsonObject.put("paidamt", (Object)row.getBigDecimal("totalamountField"));
        }
    }

    private void buildEinvInfoNew(Row row, JSONObject jsonObject) {
        jsonObject.put("invoicenumber", (Object)row.getString("invoiceNoField"));
        jsonObject.put("nameofseller", (Object)row.getString("makeoutcompname"));
        jsonObject.put("taxsocialcreditcode", (Object)row.getString("salertaxno_h"));
        jsonObject.put("totalamountexcludingtax", (Object)row.getBigDecimal("invoicenotaxamount"));
        jsonObject.put("totaltaxamount", (Object)row.getBigDecimal("taxamount_invoice"));
        jsonObject.put("taxincludedamountinfigure", (Object)row.getBigDecimal("totalamountField"));
        jsonObject.put("dateofissue", (Object)row.getDate("invoicedateField"));
        jsonObject.put("isredinvoice", (Object)(row.getBoolean("redField") != false ? "1" : "0"));
        jsonObject.put("hasbeenchecked", (Object)("1".equals(row.getString("validatestField")) ? "1" : "0"));
    }

    private QueryInvoiceDetailBO buildQueryInvoiceDetailBO(Long costCompanyId, Set<String> serialNos) {
        QueryInvoiceDetailBO queryInvoiceDetailBO = new QueryInvoiceDetailBO();
        queryInvoiceDetailBO.setSerialNo(ErCommonUtils.join(serialNos, ","));
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(costCompanyId);
        if (config == null) {
            DynamicObject costCompany = BusinessDataServiceHelper.loadSingleFromCache((Object)costCompanyId, (String)"bos_org");
            String orgName = costCompany.getString("name");
            String msg = String.format(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u3010%1$s\u3011\u672a\u542f\u7528\u53d1\u7968\u4e91\u914d\u7f6e\u3002", (String)"ErGetBizBillInfoImpl_3", (String)"fi-er-business", (Object[])new Object[0]), orgName);
            String logMsg = String.format("%1$sserialNos=%2$s", msg, serialNos);
            logger.info(logMsg);
            throw new KDBizException(msg);
        }
        queryInvoiceDetailBO.setTaxNo(config.getTaxRegnum());
        queryInvoiceDetailBO.setCompanyName(config.getFirmname());
        queryInvoiceDetailBO.setCostCompany(costCompanyId.toString());
        return queryInvoiceDetailBO;
    }

    public Map<String, JSONObject> getSeqNoAndJson(Map<String, Map<Long, Set<String>>> ticketTypeAndSeqNos) {
        return this.getSeqNoAndJson(ticketTypeAndSeqNos, true);
    }

    public Map<String, JSONObject> getSeqNoAndJsonNew(Map<String, Map<Long, Set<String>>> ticketTypeAndSeqNos) {
        return this.getSeqNoAndJson(ticketTypeAndSeqNos, false);
    }

    public Map<String, JSONObject> getSeqNoAndJson(Map<String, Map<Long, Set<String>>> ticketTypeAndSeqNos, boolean oldInterface) {
        logger.info("\u603b\u8d26\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u5165\u53c2\uff1a {}", (Object)JSONObject.toJSONString(ticketTypeAndSeqNos));
        ArrayList<Object> invoiceIns = new ArrayList<Object>(10);
        for (Map.Entry<String, Map<Long, Set<String>>> entry : ticketTypeAndSeqNos.entrySet()) {
            for (Map.Entry<Long, Set<String>> ent : entry.getValue().entrySet()) {
                JSONObject j = new JSONObject();
                j.put("type", (Object)entry.getKey());
                j.put("costcompany", (Object)ent.getKey());
                j.put("serialno", ent.getValue());
                invoiceIns.add(j);
            }
        }
        Map<Long, List<JSONObject>> costCompanyMap = invoiceIns.stream().collect(Collectors.groupingBy(m -> m.getLong("costcompany")));
        ArrayList<InvoiceVO> invoiceOuts = new ArrayList<InvoiceVO>(invoiceIns.size());
        int retryTimes = 2;
        boolean aws = !KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud();
        block4: for (Map.Entry entry : costCompanyMap.entrySet()) {
            HashSet<String> set = new HashSet<String>();
            ((List)entry.getValue()).stream().forEach(m -> set.addAll((Set)m.get((Object)"serialno")));
            QueryInvoiceDetailBO queryInvoiceDetailBO = this.buildQueryInvoiceDetailBO((Long)entry.getKey(), set);
            List<InvoiceVO> invoiceVOs = null;
            for (int i = 1; i <= retryTimes; ++i) {
                try {
                    invoiceVOs = aws ? APIHelper.queryInvoiceDetailBySerialNo(queryInvoiceDetailBO) : ErGetBizBillInfoImpl.queryInvoiceDetail(new ArrayList<String>(set));
                    invoiceOuts.addAll(invoiceVOs);
                    continue block4;
                }
                catch (Exception e) {
                    if (i < retryTimes) continue;
                    logger.info(e.getMessage(), (Object)e);
                    continue;
                }
            }
        }
        String sel = "invoicetype.number no,tickettype";
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"er_aeftickettype", (String)sel, (QFilter[])new QFilter("id", "!=", (Object)0L).toArray());
        Map<String, List<String>> map = dynamicObjectCollection.stream().collect(Collectors.groupingBy(v -> v.getString("tickettype"), Collectors.mapping(v -> v.getString("no"), Collectors.toList())));
        String invoiceInfo = invoiceOuts.size() > 10 ? JSONObject.toJSONString(invoiceOuts.subList(0, 10)) : JSONObject.toJSONString(invoiceOuts);
        logger.info("\u53d1\u7968\u4fe1\u606f\uff1a {}", (Object)invoiceInfo);
        Map<String, JSONObject> result = null;
        result = oldInterface ? this.buildOutParam(invoiceOuts, map) : this.buildNewOutParam(invoiceOuts, map);
        return result;
    }

    public static List<InvoiceVO> queryInvoiceDetail(List list) {
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        logger.info("\u67e5\u8be2\u53d1\u7968\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)list));
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"query", (Object[])new Object[]{JSON.toJSON((Object)list)});
        String respJson = JSON.toJSONString((Object)result);
        logger.info("\u67e5\u8be2\u53d1\u7968\uff0c\u8fd4\u56de\u7684\u8be6\u7ec6\u4fe1\u606f\uff1a{}", (Object)respJson);
        InvoiceDetailRetrunVO invoiceDetailReturnVO = (InvoiceDetailRetrunVO)JSON.parseObject((String)respJson, InvoiceDetailRetrunVO.class);
        String errcode = invoiceDetailReturnVO.getErrcode();
        if (StringUtils.equals((CharSequence)errcode, (CharSequence)"0000")) {
            return invoiceDetailReturnVO.getData();
        }
        logger.error("\u67e5\u8be2\u53d1\u7968\u8be6\u60c5\u8fd4\u56de\u6570\u636e\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a{}", (Object)invoiceDetailReturnVO.getDescription());
        return Collections.emptyList();
    }

    private Map<String, JSONObject> buildOutParam(List<InvoiceVO> invoiceOuts, Map<String, List<String>> map) {
        HashMap results = Maps.newHashMapWithExpectedSize((int)invoiceOuts.size());
        block0: for (InvoiceVO vo : invoiceOuts) {
            JSONObject out = new JSONObject();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                String key = entry.getKey();
                List<String> values = entry.getValue();
                out.put("invoicecode", (Object)vo.getInvoiceCode());
                if (!values.contains(vo.getInvoiceType())) continue;
                logger.info("\u603b\u8d26\u7968\u636e\u7c7b\u578b: {}, \u8d39\u7528\u7968\u636e\u7c7b\u578b\uff1a {}\uff0c \u53d1\u7968\u5e8f\u5217\u53f7\uff1a {}", new Object[]{key, vo.getInvoiceType(), vo.getSerialNo()});
                if (TicketType.ATR_RECEIVER.name().equals(key)) {
                    out.put("ElectronicInvoiceAirTransportReceiptNumber", (Object)vo.getInvoiceNo());
                    out.put("Fare", (Object)vo.getAmount());
                    out.put("IssueParty", (Object)vo.getFillingUnit());
                    out.put("IssueDate", (Object)ErGetBizBillInfoImpl.formate(vo.getInvoiceDate()));
                    out.put("WhetherInvoiceIsRedInvoice", (Object)ErGetBizBillInfoImpl.hasBeenChecked(vo.getType(), "1"));
                    out.put("WhetherInvoiceHasBeenChecked", (Object)ErGetBizBillInfoImpl.hasBeenChecked(vo.getCheckStatus(), "1"));
                    results.put(vo.getSerialNo(), out);
                    continue block0;
                }
                if (TicketType.RAI_RECEIVER.name().equals(key)) {
                    out.put("ElectronicInvoiceRailwayETicketNumber", (Object)vo.getInvoiceNo());
                    out.put("DateOfIssue", (Object)ErGetBizBillInfoImpl.formate(vo.getInvoiceDate()));
                    out.put("TotalAmountExcludingTax", (Object)vo.getTotalAmount());
                    if (vo.getTotalAmount() != null && vo.getTaxAmount() != null) {
                        out.put("TotalAmountExcludingTax", (Object)vo.getTotalAmount().subtract(vo.getTaxAmount()));
                    }
                    out.put("TaxRate", (Object)vo.getTaxRate());
                    out.put("TaxAmount", (Object)vo.getTaxAmount());
                    results.put(vo.getSerialNo(), out);
                    continue block0;
                }
                if (Arrays.asList(TicketType.INV_TLF_RECEIVER.name(), TicketType.INV_ORD_RECEIVER.name(), TicketType.INV_SPCL_RECEIVER.name()).contains(key)) {
                    out.put("NameOfSeller", (Object)vo.getSalerName());
                    out.put("TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller", (Object)vo.getSalerTaxNo());
                    out.put("TotalAmountExcludingTax", (Object)vo.getTotalAmount());
                    if (vo.getTotalAmount() != null && vo.getTaxAmount() != null) {
                        out.put("TotalAmountExcludingTax", (Object)vo.getTotalAmount().subtract(vo.getTaxAmount()));
                    }
                    out.put("TotalTaxAmount", (Object)vo.getTaxAmount());
                    out.put("TaxIncludedAmountInFigures", (Object)vo.getTotalAmount());
                    out.put("DateOfIssue", (Object)ErGetBizBillInfoImpl.formate(vo.getInvoiceDate()));
                    results.put(vo.getSerialNo(), out);
                    continue block0;
                }
                if (Arrays.asList("EINV_ORD_RECEIVER", "EINV_SPCL_RECEIVER").contains(key)) {
                    out.put("SellerName", (Object)vo.getSalerName());
                    out.put("SellerIdNum", (Object)vo.getSalerTaxNo());
                    out.put("TotalAmWithoutTax", (Object)vo.getTotalAmount().subtract(vo.getTaxAmount()));
                    out.put("TotalTaxAmount", (Object)vo.getTaxAmount());
                    out.put("TotalTax-includedAmount", (Object)vo.getTotalAmount());
                    out.put("RequestTime", (Object)ErGetBizBillInfoImpl.formate(vo.getInvoiceDate()));
                    out.put("WhetherEinvoiceIsRedEinvoice", (Object)ErGetBizBillInfoImpl.hasBeenChecked(vo.getType(), "1"));
                    out.put("WhetherEinvoiceHasBeenChecked", (Object)ErGetBizBillInfoImpl.hasBeenChecked(vo.getCheckStatus(), "1"));
                    results.put(vo.getSerialNo(), out);
                    continue block0;
                }
                if (!"EFI".equals(key)) continue;
                out.put("IssueDate", (Object)ErGetBizBillInfoImpl.formate(vo.getInvoiceDate()));
                out.put("TotalAmount", (Object)vo.getTotalAmount());
                out.put("WhetherInvoiceIsRedInvoice", (Object)ErGetBizBillInfoImpl.hasBeenChecked(vo.getType(), "1"));
                out.put("WhetherInvoiceHasBeenChecked", (Object)ErGetBizBillInfoImpl.hasBeenChecked(vo.getCheckStatus(), "1"));
                results.put(vo.getSerialNo(), out);
                continue block0;
            }
        }
        return results;
    }

    private static String formate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    private static String hasBeenChecked(String value, String expectedY) {
        if (expectedY.equals(value)) {
            return Boolean.TRUE.toString();
        }
        return Boolean.FALSE.toString();
    }

    private Map<String, JSONObject> buildNewOutParam(List<InvoiceVO> invoiceOuts, Map<String, List<String>> map) {
        HashMap results = Maps.newHashMapWithExpectedSize((int)invoiceOuts.size());
        block0: for (InvoiceVO vo : invoiceOuts) {
            JSONObject out = new JSONObject();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                String key = entry.getKey();
                List<String> values = entry.getValue();
                out.put("invoicecode", (Object)vo.getInvoiceCode());
                if (!values.contains(vo.getInvoiceType())) continue;
                logger.info("\u603b\u8d26\u7968\u636e\u7c7b\u578b: {}, \u8d39\u7528\u7968\u636e\u7c7b\u578b\uff1a {}\uff0c \u53d1\u7968\u5e8f\u5217\u53f7\uff1a {}", new Object[]{key, vo.getInvoiceType(), vo.getSerialNo()});
                if (TicketType.ATR_RECEIVER.name().equals(key)) {
                    out.put("invoicenumber", (Object)vo.getInvoiceNo());
                    out.put("fare", (Object)vo.getAmount());
                    out.put("IssueParty", (Object)vo.getFillingUnit());
                    out.put("IssueDate", (Object)vo.getInvoiceDate());
                    out.put("isredinvoice", (Object)vo.getType());
                    out.put("hasbeenchecked", (Object)ErGetBizBillInfoImpl.valueToBoolean(vo.getCheckStatus()));
                    results.put(vo.getSerialNo(), out);
                    continue block0;
                }
                if (TicketType.RAI_RECEIVER.name().equals(key)) {
                    out.put("invoicenumber", (Object)vo.getInvoiceNo());
                    out.put("dateofissue", (Object)vo.getInvoiceDate());
                    out.put("totalamountexcludingtax", (Object)vo.getTotalAmount());
                    if (vo.getTotalAmount() != null && vo.getTaxAmount() != null) {
                        out.put("totalamountexcludingtax", (Object)vo.getTotalAmount().subtract(vo.getTaxAmount()));
                    }
                    out.put("taxrate", vo.getTaxRate() == null ? null : vo.getTaxRate().toString());
                    out.put("taxamount", (Object)vo.getTaxAmount());
                    out.put("isredinvoice", (Object)ErGetBizBillInfoImpl.valueToBoolean(vo.getType()));
                    out.put("hasbeenchecked", (Object)ErGetBizBillInfoImpl.valueToBoolean(vo.getCheckStatus()));
                    results.put(vo.getSerialNo(), out);
                    continue block0;
                }
                if (Arrays.asList(TicketType.INV_TLF_RECEIVER.name(), TicketType.INV_ORD_RECEIVER.name(), TicketType.INV_SPCL_RECEIVER.name()).contains(key)) {
                    out.put("invoicenumber", (Object)vo.getInvoiceNo());
                    out.put("nameofseller", (Object)vo.getSalerName());
                    out.put("taxsocialcreditcode", (Object)vo.getSalerTaxNo());
                    out.put("totalamountexcludingtax", (Object)vo.getTotalAmount());
                    if (vo.getTotalAmount() != null && vo.getTaxAmount() != null) {
                        out.put("totalamountexcludingtax", (Object)vo.getTotalAmount().subtract(vo.getTaxAmount()));
                    }
                    out.put("totaltaxamount", (Object)vo.getTaxAmount());
                    out.put("taxincludedamountinfigure", (Object)vo.getTotalAmount());
                    out.put("dateofissue", (Object)vo.getInvoiceDate());
                    out.put("isredinvoice", (Object)ErGetBizBillInfoImpl.valueToBoolean(vo.getType()));
                    out.put("hasbeenchecked", (Object)ErGetBizBillInfoImpl.valueToBoolean(vo.getCheckStatus()));
                    results.put(vo.getSerialNo(), out);
                    continue block0;
                }
                if (Arrays.asList("EINV_ORD_RECEIVER", "EINV_SPCL_RECEIVER").contains(key)) {
                    out.put("invoicenumber", (Object)vo.getInvoiceNo());
                    out.put("nameofseller", (Object)vo.getSalerName());
                    out.put("taxsocialcreditcode", (Object)vo.getSalerTaxNo());
                    out.put("totalamountexcludingtax", (Object)vo.getTotalAmount().subtract(vo.getTaxAmount()));
                    out.put("totaltaxamount", (Object)vo.getTaxAmount());
                    out.put("taxincludedamountinfigure", (Object)vo.getTotalAmount());
                    out.put("dateofissue", (Object)vo.getInvoiceDate());
                    out.put("isredinvoice", (Object)ErGetBizBillInfoImpl.valueToBoolean(vo.getType()));
                    out.put("hasbeenchecked", (Object)ErGetBizBillInfoImpl.valueToBoolean(vo.getCheckStatus()));
                    results.put(vo.getSerialNo(), out);
                    continue block0;
                }
                if (!Arrays.asList("EFI", "NTREV_GPM_RECEIVER").contains(key)) continue;
                out.put("billdate", (Object)vo.getInvoiceDate());
                out.put("paidamt", (Object)vo.getTotalAmount());
                out.put("isredinvoice", (Object)ErGetBizBillInfoImpl.valueToBoolean(vo.getType()));
                out.put("hasbeenchecked", (Object)ErGetBizBillInfoImpl.valueToBoolean(vo.getCheckStatus()));
                StringBuilder sb = new StringBuilder(vo.getInvoiceCode());
                sb.append(vo.getInvoiceNo());
                out.put("einvoiceid", (Object)sb.reverse());
                out.put("invoicenumber", (Object)vo.getInvoiceNo());
                results.put(vo.getSerialNo(), out);
                continue block0;
            }
        }
        return results;
    }

    private static String valueToBoolean(String val) {
        return "1".equals(val) ? "1" : "0";
    }

    private void buildEinvInfo(Row row, JSONObject jsonObject) {
        jsonObject.put("InvoiceNumber", (Object)row.getString("invoiceNoField"));
        jsonObject.put("SellerName", (Object)row.getString("makeoutcompname"));
        jsonObject.put("SellerIdNum", (Object)row.getString("salertaxno_h"));
        jsonObject.put("TotalAmWithoutTax", (Object)row.getBigDecimal("invoicenotaxamount"));
        jsonObject.put("TotalTaxAm", (Object)row.getBigDecimal("taxamount_invoice"));
        jsonObject.put("TotalTaxAmount", (Object)row.getBigDecimal("taxamount_invoice"));
        jsonObject.put("TotalTax-includedAmount", (Object)row.getBigDecimal("totalamountField"));
        jsonObject.put("RequestTime", (Object)ErGetBizBillInfoImpl.formate(row.getDate("invoicedateField")));
        jsonObject.put("WhetherEinvoiceIsRedEinvoice", (Object)row.getBoolean("redField").toString());
        jsonObject.put("WhetherEinvoiceHasBeenChecked", (Object)Boolean.valueOf("1".equals(row.getString("validatestField"))).toString());
        jsonObject.put("WhetherEinvoiceHasBeenPaid", (Object)Boolean.valueOf("G".equals(row.getString("billStatusField"))).toString());
    }
}

