/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.ai;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.ais.model.ShowBillFormData;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.er.business.ai.response.ErAiResponseModel;
import kd.fi.er.business.ai.response.model.NumCardModel;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.servicehelper.TripReimburseServiceHelper;
import kd.fi.er.business.trip.dailybiz.TripNotReimbursedOrderUtil;
import kd.fi.er.business.utils.ErAIUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.TripReimburseTypeControlUtils;
import org.apache.commons.lang3.StringUtils;

public class AICreateTripReimburseApiPlugin
extends AbstractBillWebApiPlugin {
    private static final Log logger = LogFactory.getLog(AICreateTripReimburseApiPlugin.class);
    private IFormView view;
    private IDataModel model;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAICommand(AICommandEvent e) {
        Map params = e.getCommand().getParameter();
        ApiResult result = new ApiResult();
        try {
            result.setData((Object)this.doAiTripReqPushTripReim(params));
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
        finally {
            if (this.view != null) {
                this.view.close();
            }
        }
        result.setSuccess(true);
        e.setResult(result);
        logger.info(String.format("\u5c0fK\u7b2c\u4e8c\u4e2a\u63a5\u53e3\u5165\u53c2%1$s;\u5c0fK\u7ed3\u675fdoAICommand\u65b9\u6cd5\uff0c\u8fd4\u56de\u6570\u636e\u4e3a:%2$s", params.toString(), SerializationUtils.toJsonString((Object)result.getData())));
    }

    private ErAiResponseModel doAiTripReqPushTripReim(Map params) {
        Set resultBillIds;
        QFilter repaymentStatusFilter;
        QFilter repaymentIdFilter;
        DynamicObjectCollection existingBillIds;
        Object id = params.get("billId");
        logger.info("\u5c0fK\u4f20\u5165\u7684\u5355\u636eid\u4e3a:" + id);
        if (null == id || StringUtils.isBlank((CharSequence)id.toString())) {
            ErAiResponseModel model = ErAiResponseModel.createTextResponse(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u51fa\u5dee\u7533\u8bf7\u5355\u8fdb\u884c\u62a5\u9500\u3002", (String)"AICreateTripReimburseApiPlugin_0", (String)"fi-er-business", (Object[])new Object[0]));
            return model;
        }
        ArrayList<Long> selectedIds = new ArrayList<Long>();
        selectedIds.add(Long.valueOf(id.toString()));
        MainEntityType billEntityType = MetadataServiceHelper.getDataEntityType((String)"er_tripreqbill");
        DynamicObject[] selectedBills = BusinessDataServiceHelper.load((Object[])selectedIds.toArray(), (DynamicObjectType)billEntityType);
        if (selectedBills.length <= 0) {
            ErAiResponseModel model = ErAiResponseModel.createTextResponse(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u8981\u62a5\u9500\u7684\u51fa\u5dee\u7533\u8bf7\u5355\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u662f\u5426\u5b58\u5728\u3002", (String)"AICreateTripReimburseApiPlugin_1", (String)"fi-er-business", (Object[])new Object[0]));
            return model;
        }
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"er_tripreqbill", (Long[])selectedIds.toArray(new Long[0]));
        HashSet targetBillIds = (HashSet)targetBills.get("er_tripreimbursebill");
        if (targetBillIds != null && (existingBillIds = QueryServiceHelper.query((String)"er_tripreimbursebill", (String)"id,billstatus", (QFilter[])new QFilter[]{repaymentIdFilter = new QFilter("id", "in", (Object)targetBillIds), repaymentStatusFilter = new QFilter("billstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"A", "D"}))})).size() > 0) {
            Long billId = (Long)((DynamicObject)existingBillIds.get(0)).get("id");
            ErAiResponseModel model = this.getResponseModel(billId, params);
            return model;
        }
        String warningStr = TripNotReimbursedOrderUtil.getNotUsedOrderWarningStrByReq(Arrays.asList(Arrays.stream(selectedBills).toArray()));
        if (StringUtils.isNotBlank((CharSequence)warningStr)) {
            ErAiResponseModel model = ErAiResponseModel.createTextResponse(warningStr);
            return model;
        }
        TripReimburseTypeControlUtils.setTripReqBillReimType(selectedIds);
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("er_tripreqbill");
        pushArgs.setAppId("tra");
        String formId = TripReimburseTypeControlUtils.getTripReqBillReimType(selectedIds, false);
        pushArgs.setTargetEntityNumber("er_tripreimbursebill");
        Boolean isloan = selectedBills[0].getBoolean("isloan");
        String botpRuleId = this.getBotpRule(formId, isloan);
        pushArgs.setRuleId(botpRuleId);
        ArrayList selectedRows = new ArrayList();
        selectedIds.stream().forEach(v -> {
            ListSelectedRow selectedRow = new ListSelectedRow(v);
            selectedRows.add(selectedRow);
        });
        pushArgs.setSelectedRows(selectedRows);
        logger.info(String.format("\u5c0fK\u4e0b\u63a8formid:%1$s,\u5c0fK\u4e0b\u63a8\u8bbe\u7f6eBOTP\u89c4\u5219 isloan:%2$s,\u5c0fK\u4e0b\u63a8\u8bbe\u7f6eBOTP\u89c4\u5219id:%3$s,\u5c0fK\u4e0b\u63a8 pushArgs\uff1a%4$s", formId, isloan, botpRuleId, JSON.toJSONString((Object)pushArgs)));
        ConvertOperationResult convertResult = new ConvertOperationResult();
        try {
            convertResult = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
        }
        catch (Exception exception) {
            String message = exception.getMessage();
            return ErAiResponseModel.createTextResponse(message);
        }
        ErAiResponseModel model = !convertResult.isSuccess() || convertResult.getTargetBillIds().size() == 0 ? ErAiResponseModel.createTextResponse(((SourceBillReport)convertResult.getBillReports().get(0)).toString()) : ((resultBillIds = convertResult.getTargetBillIds()).size() == 1 ? this.getResponseModel(Long.valueOf(resultBillIds.iterator().next().toString()), params) : ErAiResponseModel.createTextResponse(ResManager.loadKDString((String)"\u751f\u6210\u5dee\u65c5\u62a5\u9500\u5355\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\u751f\u6210\u591a\u5f20\u5355\u636e\uff0c\u8bf7\u8fdb\u5165\u51fa\u5dee\u7533\u8bf7\u5355\u5217\u8868\u624b\u52a8\u751f\u6210\u3002", (String)"AICreateTripReimburseApiPlugin_2", (String)"fi-er-business", (Object[])new Object[0])));
        return model;
    }

    private ErAiResponseModel getResponseModel(Long billId, Map<String, Object> params) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"er_tripreimbursebill");
        if (bill == null) {
            logger.info("\u5c0fK\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664,\u5355\u636eid\u4e3a:" + billId);
            return ErAiResponseModel.createTextResponse(ResManager.loadKDString((String)"\u751f\u6210\u5dee\u65c5\u62a5\u9500\u5355\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AICreateTripReimburseApiPlugin_7", (String)"fi-er-business", (Object[])new Object[0]));
        }
        int billkind = bill.getInt("billkind");
        String formId = "er_tripreimbursebill";
        String formidmob = "er_tripreimbursebill_mob";
        if (billkind == 1) {
            formId = "er_tripreimbill_grid";
            formidmob = "er_tripreim_grid_mb";
        }
        this.view = ErAIUtils.getView(formId);
        this.model = ErAIUtils.getModel(this.view, Long.parseLong(billId.toString()));
        TripReimburseServiceHelper.handleExpenseFieldDefaultValue(this.model);
        this.model.getDataEntity(true).set("origin", (Object)3);
        OperationServiceHelper.executeOperate((String)"save", (String)"er_tripreimbursebill", (DynamicObject[])new DynamicObject[]{this.model.getDataEntity(true)}, (OperateOption)OperateOption.create());
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("id", billId);
        responseMap.put("description", bill.getString("description"));
        responseMap.put("from", bill.getString("rfrom"));
        responseMap.put("to", bill.getString("rto"));
        DynamicObjectCollection tripentrys = bill.getDynamicObjectCollection("tripentry");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        responseMap.put("startdate", "");
        responseMap.put("enddate", "");
        for (DynamicObject tripentry : tripentrys) {
            Object startdate = tripentry.getDate("startdate");
            Date enddate = tripentry.getDate("startdate");
            if (null != startdate) {
                responseMap.put("startdate", sdf.format((Date)startdate));
            }
            if (null != enddate) {
                responseMap.put("enddate", sdf.format(enddate));
            }
            DynamicObjectCollection entryentitys = tripentry.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryentity : entryentitys) {
                if (null == startdate && null != (startdate = entryentity.getDate("trip2startdate"))) {
                    responseMap.put("startdate", sdf.format((Date)startdate));
                }
                if (null != enddate || null == (enddate = entryentity.getDate("trip2enddate"))) continue;
                responseMap.put("enddate", sdf.format(enddate));
            }
        }
        DynamicObject costcompany = bill.getDynamicObject("costcompany");
        if (costcompany == null) {
            return ErAiResponseModel.createTextResponse(ResManager.loadKDString((String)"\u5f53\u524d\u5dee\u65c5\u62a5\u9500\u5355\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AICreateTripReimburseApiPlugin_4", (String)"fi-er-business", (Object[])new Object[0]));
        }
        String YZJ_CHATBOT = params.get("AI_DEVICE").toString();
        switch (YZJ_CHATBOT) {
            case "APP_CHATBOT": {
                StringBuilder url = new StringBuilder(RequestContext.get().getClientFullContextPath()).append((CharSequence)new StringBuilder("mobile.html#/form/")).append(formidmob).append("?");
                url.append("billStatusValue=1&").append("pkId=").append(bill.getPkValue());
                url.append("&returnDefaultHome=true&isAI=true&app=tra");
                responseMap.put("billUrl", url);
                logger.info("\u5c0fK\u751f\u6210\u7684url\u4e3a:" + url);
                break;
            }
            case "CQ_CHATBOT": {
                String billUrl = SerializationUtils.toJsonString((Object)new ShowBillFormData("tra", formId, (Object)billId));
                responseMap.put("billUrl", String.format("bizAction://%s?%s", "ShowBillForm", billUrl));
            }
        }
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(ErCommonUtils.getPk(costcompany));
        if (config == null) {
            return ErAiResponseModel.createTextResponse(ResManager.loadKDString((String)"\u5f53\u524d\u8d39\u7528\u627f\u62c5\u516c\u53f8\u7684\u53d1\u7968\u4e91\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AICreateTripReimburseApiPlugin_5", (String)"fi-er-business", (Object[])new Object[0]));
        }
        Map<String, Object> dataParam = ErAIUtils.getInvoiceDataParam(config, "er_tripreimbursebill_" + billId, "tra");
        responseMap.put("billNumber", billId);
        responseMap.put("ticketParam", config.genTicketParam());
        responseMap.put("random", UUID.randomUUID().toString().replace("-", ""));
        ArrayList<Map<String, Object>> cardBody = new ArrayList<Map<String, Object>>();
        cardBody.add(responseMap);
        NumCardModel numCardModel = new NumCardModel();
        numCardModel.setTitle(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u62a5\u9500\u5355\uff0c\u8bf7\u5173\u8054\u53d1\u7968\u4fe1\u606f\u3002", (String)"AICreateTripReimburseApiPlugin_6", (String)"fi-er-business", (Object[])new Object[0]));
        numCardModel.setCardBody(cardBody);
        numCardModel.setDataParam(dataParam);
        logger.info("\u5c0fK\u8fd4\u56de\u5c0fK\u4e0b\u63a8\u751f\u6210\u7684\u5dee\u65c5\u62a5\u9500\u5355\u6570\u636e\u4e3a" + SerializationUtils.toJsonString(cardBody));
        return ErAiResponseModel.createCardJsonResponse(numCardModel, params.get("cardId"), null);
    }

    public String getBotpRule(String formId, Boolean isloan) {
        if (isloan.booleanValue()) {
            if ("er_tripreimbill_grid".equals(formId)) {
                return "1003623628845294592";
            }
            if ("er_tripreimbursebill".equals(formId)) {
                return "317070662978247680";
            }
        } else {
            if ("er_tripreimbill_grid".equals(formId)) {
                return "1006628811002885120";
            }
            if ("er_tripreimbursebill".equals(formId)) {
                return "331669392830235648";
            }
        }
        return "";
    }
}

