/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.ai;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.ai.response.ErAiResponseModel;
import kd.fi.er.business.ai.response.model.NumCardModel;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.kingdee.action.QueryByPersonalNoAction;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.ErAIUtils;
import org.apache.commons.lang3.StringUtils;

public class AIGetInvoiceCloudCfgApiPlugin
extends AbstractBillWebApiPlugin {
    private static final Log logger = LogFactory.getLog(AIGetInvoiceCloudCfgApiPlugin.class);

    public void doAICommand(AICommandEvent e) {
        Map params = e.getCommand().getParameter();
        logger.info("xiaok AIGetInvoiceCloudcfgApiPlugin params" + params.toString());
        ApiResult result = new ApiResult();
        result.setData((Object)this.getInvoiceDataResult(params));
        result.setSuccess(true);
        e.setResult(result);
        logger.info("xiaok AIGetInvoiceCloudcfgApiPlugin result" + SerializationUtils.toJsonString((Object)result.getData()));
    }

    private ErAiResponseModel getInvoiceDataResult(Map params) {
        String billType = params.getOrDefault("billFormId", "er_dailyreimbursebill");
        long applierId = RequestContext.get().getCurrUserId();
        Map<String, Object> userMap = CoreBaseBillServiceHelper.createNewData(applierId);
        if (!userMap.containsKey("costcompany")) {
            ErAiResponseModel model = ErAiResponseModel.createTextResponse(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"AIGetInvoiceCloudCfgApiPlugin_0", (String)"fi-er-business", (Object[])new Object[0]));
            return model;
        }
        Long costCompanyId = (Long)userMap.get("costcompany");
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(costCompanyId);
        if (config == null) {
            return ErAiResponseModel.createTextResponse(ResManager.loadKDString((String)"\u5f53\u524d\u8d39\u7528\u627f\u62c5\u516c\u53f8\u7684\u53d1\u7968\u4e91\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AIGetInvoiceCloudCfgApiPlugin_1", (String)"fi-er-business", (Object[])new Object[0]));
        }
        HashMap<String, Object> dataParam = new HashMap<String, Object>();
        Map<String, Object> userKeyParam = ErAIUtils.getInvoiceDataParam(config);
        dataParam.put("userKeyParam", userKeyParam);
        JSONArray data = new JSONArray();
        Integer total = 0;
        if (params.get("getInvoiceInfo") != null) {
            try {
                logger.info("\u3010\u53d1\u7968\u4e91\u3011\u5c0fK \u5c1d\u8bd5\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6token\u3002");
                HashMap<String, Object> paramsMap = new HashMap<String, Object>();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                Date date = new Date();
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                cal.add(1, -1);
                String stractTime = format.format(cal.getTime());
                String endTime = format.format(date);
                paramsMap.put("collectTimeStart", stractTime);
                paramsMap.put("collectTimeEnd", endTime);
                paramsMap.put("expenseStatuses", new int[]{1});
                paramsMap.put("checkStatuses", new int[]{1, 3});
                paramsMap.put("userType", 3);
                paramsMap.put("userId", String.valueOf(applierId));
                paramsMap.put("config", config);
                QueryByPersonalNoAction queryByPersonalNoAction = new QueryByPersonalNoAction(paramsMap);
                String resultStr = queryByPersonalNoAction.execute();
                JSONObject result = (JSONObject)JSONObject.parseObject((String)resultStr, JSONObject.class);
                String errCode = result.getString("errcode");
                Integer responseCode = result.getInteger("responseCode");
                if (StringUtils.equals((CharSequence)errCode, (CharSequence)"0000") && responseCode == 200) {
                    if (result != null && result.containsKey((Object)"totalElement")) {
                        total = result.getInteger("totalElement");
                    }
                    if (result != null && result.containsKey((Object)"data")) {
                        data = result.getJSONArray("data");
                    }
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                return ErAiResponseModel.createTextResponse(e.getMessage());
            }
        }
        dataParam.put("invoiceInfo", data);
        dataParam.put("total", total);
        NumCardModel numCardModel = new NumCardModel();
        numCardModel.setDataParam(dataParam);
        return ErAiResponseModel.createCardJsonResponse(numCardModel, params.get("cardId"), null);
    }
}

