/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.ai.aireimburse;

import java.util.Map;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.er.business.ai.ErAIService;
import kd.fi.er.business.ai.aireimburse.AbstractAIReimburseAPIPlugin;
import kd.fi.er.business.ai.response.ErAiResponseModel;
import kd.fi.er.business.utils.ErAIUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.formplugin.daily.web.util.WriteOffMoneyUtils;
import kd.sdk.fi.er.extpoint.ai.IAIReimburseService;
import org.apache.commons.lang3.StringUtils;

public class AICreateReimBillAndImportInvoiceApiPlugin
extends AbstractAIReimburseAPIPlugin {
    private static final Log logger = LogFactory.getLog(AICreateReimBillAndImportInvoiceApiPlugin.class);
    protected PluginProxy<IAIReimburseService> afterSelectInvoicePluginProxy = PluginProxy.create(null, IAIReimburseService.class, (String)"FI_ER_AI_REIMBURSE", null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAICommand(AICommandEvent e) {
        Map params = e.getCommand().getParameter();
        this.formId = "er_dailyreimbursebill";
        this.formidmob = "er_dailyreimbursebill_mob";
        this.appId = "exp";
        this.setFormId(this.formId);
        this.afterSelectInvoicePluginProxy.callReplace(p -> {
            p.initDataMember((AbstractBillWebApiPlugin)this, params);
            return null;
        });
        logger.info("xiaok AICreateReimBillAndImportInvoice params" + params.toString());
        ApiResult result = new ApiResult();
        String error = ErAIService.preCommonHandleData(params);
        if (error != null) {
            result.setSuccess(false);
            result.setMessage(error);
            e.setResult(result);
            return;
        }
        Map bizData = this.parseAIObjectByKey(params);
        String jsondata = SerializationUtils.toJsonString((Object)bizData);
        ApiResult ret = ErAIUtils.executeSaveOperation(this.formId, jsondata);
        if (!ret.getSuccess()) {
            this.responseModel = ErAiResponseModel.createTextResponse(ret.getMessage());
            logger.info("xiaok AICreateReimBillAndImportInvoice \u521b\u5efa\u8868\u5355\u5931\u8d25\u3002formId=" + this.formId + ret.getErrorCode() + ret.getMessage());
            result.setData((Object)this.responseModel);
            result.setSuccess(true);
            result.setMessage(ret.getMessage());
            e.setResult(result);
            return;
        }
        String pkId = ErAIUtils.parsePkId(ret);
        if (pkId == null) {
            this.responseModel = ErAiResponseModel.createTextResponse(ResManager.loadKDString((String)"\u4e1a\u52a1\u5e73\u53f0\u521b\u5efa\u8868\u5355\u5931\u8d25\uff0cpkId\u4e3a\u7a7a\u3002", (String)"AICreateReimBillAndImportInvoiceApiPlugin_0", (String)"fi-er-business", (Object[])new Object[0]));
            logger.info("xiaok AICreateReimBillAndImportInvoice \u521b\u5efa\u8868\u5355\u5931\u8d25,save\u5f97\u5230pkId\u4e3a\u7a7a,formId=" + this.formId + params + ret.getErrorCode() + ret.getMessage());
            result.setData((Object)this.responseModel);
            result.setSuccess(true);
            e.setResult(result);
            return;
        }
        try {
            this.view = ErAIUtils.getView(this.formId);
            this.model = ErAIUtils.getModel(this.view, Long.parseLong(pkId));
            this.afterSelectInvoicePluginProxy.callReplace(p -> {
                p.afterCreateView(this.view, params);
                return null;
            });
            String errMsg = ErAIUtils.importInvoiceToBill(this.view, params);
            if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                this.responseModel = ErAiResponseModel.createTextResponse(errMsg);
                result.setData((Object)this.responseModel);
                result.setSuccess(true);
                e.setResult(result);
            }
            WriteOffMoneyUtils.refreshBillHeadAmount(this.model);
            this.afterSelectInvoicePluginProxy.callReplace(p -> {
                p.afterCreateView(this.view, params);
                return null;
            });
            OperationServiceHelper.executeOperate((String)"save", (String)this.formId, (DynamicObject[])new DynamicObject[]{this.model.getDataEntity(true)}, (OperateOption)OperateOption.create());
            this.responseModel = this.getResponseModel(params, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u76f8\u5173\u660e\u7ec6\uff0c\u8bf7\u5b8c\u5584\u8d39\u7528\u660e\u7ec6\u540e\u63d0\u4ea4\u3002", (String)"AICreateReimBillAndImportInvoiceApiPlugin_1", (String)"fi-er-business", (Object[])new Object[0]));
            this.afterSelectInvoicePluginProxy.callReplace(p -> {
                p.responseModelExt(this.view, (Object)this.responseModel, params);
                return null;
            });
            logger.info("xiaok AIGetInvoiceCloudcfgApiPlugin result" + SerializationUtils.toJsonString((Object)result.getData()));
            result.setData((Object)this.responseModel);
            e.setResult(result);
        }
        catch (Exception exception) {
            result.setSuccess(false);
            result.setMessage(exception.toString());
            e.setResult(result);
            logger.error((Throwable)exception);
        }
        finally {
            if (this.view != null) {
                this.view.close();
            }
        }
    }

    protected DynamicObjectCollection query(String entityName, String selectFields, QFilter[] filters, String orderBys, int top) {
        for (QFilter filter : filters) {
            filter.__setProperty("id");
            if (!(filter.getValue() instanceof DynamicObject)) continue;
            filter.__setValue((Object)ErCommonUtils.getPk(filter.getValue()));
        }
        return QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys, (int)top);
    }
}

