/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.ai.response;

import kd.fi.er.business.ai.response.model.NumCardModel;

public class ErAiResponseModel {
    private String type;
    private Object content;
    private Object cardId;
    private String readWords;

    private ErAiResponseModel(String type, Object content) {
        this.type = type;
        this.content = content;
    }

    private ErAiResponseModel(String type, Object content, Object cardId, String readWords) {
        this.type = type;
        this.content = content;
        this.cardId = cardId;
        this.readWords = readWords;
    }

    public static ErAiResponseModel createTextResponse(String content) {
        return new ErAiResponseModel(Type.TEXT.toString(), content);
    }

    public static ErAiResponseModel createnNumCardResponse(NumCardModel numCardModel) {
        return new ErAiResponseModel(Type.JSON.toString(), numCardModel);
    }

    public static ErAiResponseModel createCardJsonResponse(NumCardModel numCardModel, Object cardId, String readWords) {
        return new ErAiResponseModel(Type.CARDJSON.toString(), numCardModel, cardId, readWords);
    }

    public String getType() {
        return this.type;
    }

    public Object getContent() {
        return this.content;
    }

    public Object getCardId() {
        return this.cardId;
    }

    public Object getReadWords() {
        return this.readWords;
    }

    public static enum Type {
        TEXT,
        SELECTS,
        URL,
        JSON,
        CARDJSON;

    }
}

