/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.amount.control;

import java.util.PriorityQueue;

public class AmountFreed {
    private PriorityQueue<AmountFreedEntry> p = new PriorityQueue();

    public static AmountFreed buildAmountFreed() {
        return new AmountFreed();
    }

    public void setAmountFreedEntry(int freedDay, int freedRate) {
        AmountFreedEntry amountFreedEntry = new AmountFreedEntry(freedDay, freedRate);
        this.p.add(amountFreedEntry);
    }

    public int getHaveFeededAmount(int day) {
        int totalFreedRate = 0;
        while (this.p.peek() != null && day >= this.p.peek().getFreedDay()) {
            AmountFreedEntry peek = (AmountFreedEntry)this.p.remove();
            totalFreedRate += peek.getFreedRate().intValue();
        }
        return totalFreedRate;
    }

    public static void main(String[] args) {
        AmountFreed amountFreed = AmountFreed.buildAmountFreed();
        for (int i = 0; i < 10; ++i) {
            amountFreed.setAmountFreedEntry(i, i * 5);
        }
    }

    private static class AmountFreedEntry
    implements Comparable<AmountFreedEntry> {
        private Integer freedDay;
        private Integer freedRate;

        public AmountFreedEntry() {
        }

        public AmountFreedEntry(Integer freedDay, Integer freedRate) {
            this.freedDay = freedDay;
            this.freedRate = freedRate;
        }

        public Integer getFreedDay() {
            return this.freedDay;
        }

        public void setFreedDay(Integer freedDay) {
            this.freedDay = freedDay;
        }

        public Integer getFreedRate() {
            return this.freedRate;
        }

        public void setFreedRate(Integer freedRate) {
            this.freedRate = freedRate;
        }

        @Override
        public int compareTo(AmountFreedEntry o) {
            return this.getFreedDay() - o.getFreedDay();
        }
    }
}

