/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.billingpool.validate;

import java.math.BigDecimal;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.billingpool.service.WriteOffBillingInfo;
import kd.fi.er.business.billingpool.validate.IBillingValidate;

public class WriteOffValidate
implements IBillingValidate {
    private static Log logger = LogFactory.getLog(WriteOffValidate.class);
    private WriteOffBillingInfo writeOffInfo;

    public WriteOffValidate(WriteOffBillingInfo writeOffInfo) {
        this.writeOffInfo = writeOffInfo;
    }

    @Override
    public void doValidate() {
        Object dataEntity = this.writeOffInfo.getDataEntity();
        if (dataEntity instanceof DynamicObject) {
            if (!Objects.equals(this.writeOffInfo.getCurrency(), this.writeOffInfo.getWriteOffArgs().getCurrency())) {
                logger.info("writeOffInfo.getCurrency(): {}, writeOffInfo.getWriteOffArgs().getCurrency():{}", (Object)this.writeOffInfo.getCurrency(), (Object)this.writeOffInfo.getWriteOffArgs().getCurrency());
            }
            if (BigDecimal.ZERO.compareTo(this.writeOffInfo.getWriteOffArgs().getPoolreimburseamount()) == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968(%s)\u8bf7\u586b\u5199\u672c\u6b21\u62a5\u9500\u91d1\u989d", (String)"billingpool_amountzerovalidate", (String)"fi-er-business", (Object[])new Object[]{((DynamicObject)dataEntity).get("invoiceno")}));
            }
            BigDecimal balanceAmt = this.writeOffInfo.getBalanceAmt();
            BigDecimal execAmount = this.writeOffInfo.getExecAmount();
            if (this.writeOffInfo.isForward()) {
                if (!this.writeOffInfo.getWriteOffArgs().isExcessreim() && balanceAmt.add(execAmount).compareTo(BigDecimal.ZERO) < 0) {
                    logger.error("balanceAmt:{},execAmount:{}", (Object)balanceAmt, (Object)execAmount);
                    throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968(%s)\u672c\u6b21\u62a5\u9500\u91d1\u989d\u8d85\u51fa\u53ef\u7528\u91d1\u989d", (String)"billingpool_validate", (String)"fi-er-business", (Object[])new Object[]{((DynamicObject)dataEntity).get("invoiceno")}));
                }
            } else {
                BigDecimal totalAmt = this.writeOffInfo.getTotalAmt();
                if (!this.writeOffInfo.getWriteOffArgs().isExcessreim() && balanceAmt.add(execAmount.negate()).compareTo(totalAmt) > 0) {
                    logger.error("balanceAmt:{},execAmount:{}", (Object)balanceAmt, (Object)execAmount);
                    throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968(%s)\u672c\u6b21\u62a5\u9500\u91d1\u989d\u8d85\u51fa\u53ef\u7528\u91d1\u989d", (String)"billingpool_validate", (String)"fi-er-business", (Object[])new Object[]{((DynamicObject)dataEntity).get("invoiceno")}));
                }
            }
        }
    }
}

