/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.daily.amount.service.factory;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.daily.amount.service.DeptReimAmountService;
import kd.fi.er.business.daily.amount.service.EmployeeReimAmountService;
import org.apache.commons.lang3.StringUtils;

public class ReimAmountServiceFactory {
    private static Log logger = LogFactory.getLog(ReimAmountServiceFactory.class);
    private static Set<Class<?>> reimAmountServiceInterfaces = new HashSet(2);
    private static final ConcurrentHashMap<Class<?>, Object> services = new ConcurrentHashMap();
    private static Object lock = new Object();

    private ReimAmountServiceFactory() {
        throw new RuntimeException("factory couldn't be instanced...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getSingletonService(Class<T> clazz) {
        Object object = lock;
        synchronized (object) {
            try {
                if (reimAmountServiceInterfaces.contains(clazz)) {
                    ReimAmountServiceFactory.updateServiceFromConfig(clazz);
                } else {
                    services.put(clazz, clazz.newInstance());
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        return (T)services.get(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearInvoiceServiceBean() {
        Object object = lock;
        synchronized (object) {
            reimAmountServiceInterfaces.forEach(reimAmount -> services.remove(reimAmount));
        }
    }

    private static <T> void updateServiceFromConfig(Class<T> clazz) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        QFilter qFilter = QFilter.of((String)"enable=? and status=?", (Object[])new Object[]{"1", "C"});
        Map serviceDOFromCache = BusinessDataServiceHelper.loadFromCache((String)"er_extamountquery", (QFilter[])new QFilter[]{qFilter});
        if (serviceDOFromCache == null || serviceDOFromCache.size() != 1) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u53ef\u7528\u7684\u989d\u5ea6\u6269\u5c55\u914d\u7f6e\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a, \u5f53\u524d\u6269\u5c55\u6570\u91cf:%s", (String)"ReimAmountServiceFactory_0", (String)"fi-er-business", (Object[])new Object[0]), serviceDOFromCache == null ? 0 : serviceDOFromCache.size()));
        }
        DynamicObject serviceDO = (DynamicObject)serviceDOFromCache.values().iterator().next();
        DynamicObjectCollection serviceEntrys = serviceDO.getDynamicObjectCollection("extamountqueryentry");
        Map<String, String> serviceMap = serviceEntrys.stream().collect(Collectors.toMap(entry -> entry.getString("servicename"), entry -> entry.getString("serviceclass")));
        if (!serviceMap.containsKey(clazz.getName())) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u989d\u5ea6\u67e5\u8be2\u6ca1\u6709\u5b9e\u73b0\u8fd9\u4e2a\u670d\u52a1\u65b9\u6cd5:%s", (String)"ReimAmountServiceFactory_2", (String)"fi-er-business", (Object[])new Object[0]), clazz.getName()));
        }
        for (Map.Entry<String, String> entry2 : serviceMap.entrySet()) {
            Class<?> serviceInterfaceClass = Class.forName(entry2.getKey());
            if (services.containsKey(serviceInterfaceClass) && StringUtils.equals((CharSequence)services.get(serviceInterfaceClass).getClass().getName(), (CharSequence)entry2.getValue())) continue;
            services.put(Class.forName(entry2.getKey()), Class.forName(entry2.getValue()).newInstance());
        }
    }

    static {
        reimAmountServiceInterfaces.add(DeptReimAmountService.class);
        reimAmountServiceInterfaces.add(EmployeeReimAmountService.class);
    }
}

