/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.daily.reimburse.topublic;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.daily.reimburse.topublic.AccountInfo;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.PayerTypeEnum;

public class PublicReimbursePayerAcctUtils {
    private static String CASACCOUNTENTITY = "am_accountbank";
    private static final String BANKACCOUNT = "bankaccount";
    private static final String ACCOUNTNAME = "accountname";
    private static final String BANK = "bank";
    private static final String CURRENCY = "currency";
    private static final String ISDEFAULT = "isdefault_bank";
    private static final String ENTRY_BANK = "entry_bank";

    private PublicReimbursePayerAcctUtils() {
        throw new AssertionError((Object)"this class can't be instanced! please use static method.");
    }

    public static List<AccountInfo> getAccountInfoByPayerId(String payerType, Long payerId) {
        ArrayList<AccountInfo> accountInfoList = new ArrayList<AccountInfo>();
        DynamicObjectCollection accounts = null;
        if (payerType.equals(PayerTypeEnum.CASORG.getType())) {
            accounts = QueryServiceHelper.query((String)CASACCOUNTENTITY, (String)"bankaccountnumber as bankaccount,acctname as accountname,bank.bebank as bank,defaultcurrency,currency,isdefaultrec as isdefault_bank", (QFilter[])new QFilter[]{new QFilter("company", "=", (Object)payerId)});
        } else {
            DynamicObject supplierOrCustorme = BusinessDataServiceHelper.loadSingle((String)payerType, (String)"bankaccount,accountname,bank,currency,isdefault_bank", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)payerId)});
            if (supplierOrCustorme != null) {
                accounts = supplierOrCustorme.getDynamicObjectCollection(ENTRY_BANK);
            }
        }
        if (accounts != null && accounts.size() > 0) {
            for (DynamicObject oneAccount : accounts) {
                AccountInfo accountInfo = PublicReimbursePayerAcctUtils.setAccountInfo(payerType, oneAccount);
                accountInfoList.add(accountInfo);
            }
        }
        return accountInfoList;
    }

    public static AccountInfo getBankInfo(String payerType, long entryKey) {
        DynamicObject bankInfo = null;
        if (payerType.equals(PayerTypeEnum.CASORG.getType())) {
            DynamicObject accountBank;
            bankInfo = accountBank = QueryServiceHelper.queryOne((String)CASACCOUNTENTITY, (String)"bankaccountnumber as bankaccount,acctname as accountname,bank.bebank as bank,currency,defaultcurrency, isdefaultrec as isdefault_bank", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)entryKey)});
        } else if (payerType.equals(PayerTypeEnum.PAYER.getType())) {
            DynamicObject accountBank;
            bankInfo = accountBank = QueryServiceHelper.queryOne((String)payerType, (String)"payeraccount as bankaccount,payeraccountname as accountname,payerbank as bank,currency, isdefault as isdefault_bank", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)entryKey)});
        } else {
            DynamicObject accountBank = BusinessDataServiceHelper.loadSingle((String)payerType, (String)"bankaccount,accountname,bank,currency,isdefault_bank", (QFilter[])new QFilter[]{new QFilter("entry_bank.id", "=", (Object)entryKey)});
            if (accountBank == null) {
                return null;
            }
            DynamicObjectCollection entryBanks = accountBank.getDynamicObjectCollection(ENTRY_BANK);
            if (entryBanks.isEmpty()) {
                return null;
            }
            int i = 0;
            for (DynamicObject entryBank : entryBanks) {
                if (entryBank.getPkValue().equals(entryKey)) {
                    bankInfo = (DynamicObject)entryBanks.get(i);
                }
                ++i;
            }
        }
        return PublicReimbursePayerAcctUtils.setAccountInfo(payerType, bankInfo);
    }

    public static AccountInfo getPayerDefaultInfo(String payerType, Long payerId) {
        AccountInfo accountInfo = null;
        DynamicObject accountBank = null;
        if (payerType.equals(PayerTypeEnum.CASORG.getType())) {
            accountBank = QueryServiceHelper.queryOne((String)CASACCOUNTENTITY, (String)"bankaccountnumber as bankaccount,acctname as accountname,bank.bebank as bank,currency, defaultcurrency,isdefaultrec as isdefault_bank", (QFilter[])new QFilter[]{new QFilter("company", "=", (Object)payerId), new QFilter("isdefaultrec", "=", (Object)Character.valueOf('1'))});
        } else {
            DynamicObject supplierOrCustomer = BusinessDataServiceHelper.loadSingle((String)payerType, (String)"bankaccount,accountname,bank,currency,isdefault_bank", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)payerId)});
            if (supplierOrCustomer == null) {
                return accountInfo;
            }
            DynamicObjectCollection entryBanks = supplierOrCustomer.getDynamicObjectCollection(ENTRY_BANK);
            for (DynamicObject entry : entryBanks) {
                boolean isdefault = entry.getBoolean(ISDEFAULT);
                if (!isdefault) continue;
                accountBank = entry;
                break;
            }
        }
        return PublicReimbursePayerAcctUtils.setAccountInfo(payerType, accountBank);
    }

    private static AccountInfo setAccountInfo(String payerType, DynamicObject bankInfo) {
        Long currencyId;
        Long bankId;
        if (bankInfo == null) {
            return null;
        }
        AccountInfo accountInfo = new AccountInfo();
        accountInfo.setAccount(bankInfo.getString(BANKACCOUNT));
        accountInfo.setAccountName(bankInfo.getString(ACCOUNTNAME));
        accountInfo.setDefault(bankInfo.getBoolean(ISDEFAULT));
        if (payerType.equals(PayerTypeEnum.CASORG.getType())) {
            bankId = bankInfo.getLong(BANK);
            currencyId = bankInfo.getLong("defaultcurrency");
        } else if (payerType.equals(PayerTypeEnum.PAYER.getType())) {
            bankId = bankInfo.getLong(BANK);
            currencyId = bankInfo.getLong(CURRENCY);
        } else {
            bankId = bankInfo.getDynamicObject(BANK) == null ? Long.valueOf(0L) : bankInfo.getDynamicObject(BANK).getPkValue();
            currencyId = bankInfo.getDynamicObject(CURRENCY) == null ? Long.valueOf(0L) : bankInfo.getDynamicObject(CURRENCY).getPkValue();
        }
        accountInfo.setBeBank(bankId);
        accountInfo.setCurrency(currencyId);
        return accountInfo;
    }

    public static void fillBankInfo(IDataModel model, AccountInfo accountInfo, Integer rowIndex) {
        DynamicObject payMode = (DynamicObject)model.getValue("paymode", rowIndex.intValue());
        String settlementtype = null;
        if (payMode != null) {
            settlementtype = payMode.getString("settlementtype");
        }
        if (accountInfo == null || "0".equals(settlementtype)) {
            if (rowIndex != -1) {
                PublicReimbursePayerAcctUtils.setValueDIY(model, "payeraccount02", null, rowIndex);
                PublicReimbursePayerAcctUtils.setValueDIY(model, "payeraccount01", null, rowIndex);
            }
            PublicReimbursePayerAcctUtils.setValueDIY(model, "payeraccount", null, rowIndex);
            PublicReimbursePayerAcctUtils.setValueDIY(model, "payerbank", null, rowIndex);
            PublicReimbursePayerAcctUtils.setValueDIY(model, "payeraccountname", null, rowIndex);
        } else {
            String payerAccount = accountInfo.getAccount();
            if (rowIndex != -1) {
                PublicReimbursePayerAcctUtils.setValueDIY(model, "payeraccount02", PublicReimbursePayerAcctUtils.getHideMidPayerAccount(payerAccount), rowIndex);
                PublicReimbursePayerAcctUtils.setValueDIY(model, "payeraccount01", PublicReimbursePayerAcctUtils.getHideTailPayerAccount(payerAccount), rowIndex);
            }
            PublicReimbursePayerAcctUtils.setValueDIY(model, "payeraccount", payerAccount, rowIndex);
            PublicReimbursePayerAcctUtils.setValueDIY(model, "payerbank", accountInfo.getBeBank(), rowIndex);
            PublicReimbursePayerAcctUtils.setValueDIY(model, "payeraccountname", accountInfo.getAccountName(), rowIndex);
        }
        if (rowIndex != -1) {
            String isgetaccountcurrency = "0";
            if (model.getValue("company") != null) {
                isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((DynamicObject)model.getValue("company")).getPkValue());
            }
            if ("1".equals(isgetaccountcurrency)) {
                Long tragCurrencyId = (Long)((DynamicObject)model.getValue(CURRENCY)).getPkValue();
                if (accountInfo != null) {
                    tragCurrencyId = ErCommonUtils.getPk(accountInfo.getCurrency() == null ? null : accountInfo.getCurrency());
                }
                model.beginInit();
                PublicReimbursePayerAcctUtils.setValueDIY(model, "iscurrency", Boolean.TRUE, -1);
                PublicReimbursePayerAcctUtils.setValueDIY(model, "accountcurrency", null, rowIndex);
                model.endInit();
                PublicReimbursePayerAcctUtils.setValueDIY(model, "accountcurrency", tragCurrencyId, rowIndex);
            }
        }
    }

    public static Object getPayerPkId(IDataModel model, String payerType) {
        PayerTypeEnum payerTypeEnum = PayerTypeEnum.getValue((String)payerType);
        DynamicObject payer = (DynamicObject)model.getValue(payerTypeEnum.name());
        if (payer == null) {
            return null;
        }
        return payer.getPkValue();
    }

    public static String getHideMidPayerAccount(String account) {
        if (account == null) {
            return "";
        }
        StringBuffer account_show = new StringBuffer();
        if (account.length() > 10) {
            account_show.append(account.substring(0, 6));
            account_show.append("***");
            account_show.append(account.substring(account.length() - 4, account.length()));
        } else {
            account_show.append(account);
        }
        return String.valueOf(account_show);
    }

    public static String getHideTailPayerAccount(String account) {
        if (account == null) {
            return "";
        }
        StringBuffer account_show = new StringBuffer();
        if (account.length() > 4) {
            account_show.append('(');
            account_show.append('*');
            account_show.append(account.substring(account.length() - 4, account.length()));
            account_show.append(')');
        } else {
            account_show.append(account);
        }
        return String.valueOf(account_show);
    }

    public static void clearOldPayer(IFormView view, Integer rowIndex, String payerType) {
        IDataModel model = view.getModel();
        model.beginInit();
        IDataEntityProperty property = model.getProperty("supplier");
        if (property != null) {
            PublicReimbursePayerAcctUtils.setValueDIY(model, "supplier", null, rowIndex);
        }
        if ((property = model.getProperty("customer")) != null) {
            PublicReimbursePayerAcctUtils.setValueDIY(model, "customer", null, rowIndex);
        }
        if ((property = model.getProperty("casorg")) != null) {
            PublicReimbursePayerAcctUtils.setValueDIY(model, "casorg", null, rowIndex);
        }
        if ((property = model.getProperty("payername")) != null) {
            PublicReimbursePayerAcctUtils.setValueDIY(model, "payername", null, rowIndex);
        }
        PublicReimbursePayerAcctUtils.setValueDIY(model, "payer", null, rowIndex);
        if (rowIndex != -1) {
            PublicReimbursePayerAcctUtils.setValueDIY(model, "payeraccount02", null, rowIndex);
            PublicReimbursePayerAcctUtils.setValueDIY(model, "payeraccount01", null, rowIndex);
        }
        if (!PayerTypeEnum.OTHER.getType().equals(payerType)) {
            PublicReimbursePayerAcctUtils.setValueDIY(model, "payername", null, rowIndex);
            PublicReimbursePayerAcctUtils.setValueDIY(model, "payeraccount", null, rowIndex);
            PublicReimbursePayerAcctUtils.setValueDIY(model, "payerbank", null, rowIndex);
            PublicReimbursePayerAcctUtils.setValueDIY(model, "payeraccountname", null, rowIndex);
        }
        if (rowIndex >= 0) {
            ErCommonUtils.updateView(view, (int)rowIndex, "supplier", "customer", "casorg", "payer", "payeraccount01", "payeraccount02", "payername", "payeraccount", "payerbank", "payeraccountname");
        } else {
            view.updateView();
        }
        model.endInit();
    }

    public static void setValueDIY(IDataModel model, String fieldName, Object value, int rowIndex) {
        if (model.getProperty(fieldName) == null) {
            return;
        }
        if (rowIndex == -1) {
            model.setValue(fieldName, value);
        } else {
            model.setValue(fieldName, value, rowIndex);
        }
    }

    public static Object getValueDIY(IDataModel model, String fieldName, int rowIndex) {
        if (model.getProperty(fieldName) == null) {
            return null;
        }
        if (rowIndex == -1) {
            return model.getValue(fieldName);
        }
        return model.getValue(fieldName, rowIndex);
    }

    public static void updateViewDIY(IFormView view, String fieldName, int rowIndex) {
        if (view.getModel().getProperty(fieldName) == null) {
            return;
        }
        if (rowIndex == -1) {
            view.updateView(fieldName);
        } else {
            view.updateView(fieldName, rowIndex);
        }
    }

    static {
        if (ErCommonUtils.isXkModeType()) {
            CASACCOUNTENTITY = "bd_accountbanks";
        }
    }
}

