/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.daily.service.impl;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.amount.control.AmountFreedService;
import kd.fi.er.business.daily.service.ReimburseAmountControlService;
import kd.fi.er.business.daily.service.model.ReimburseAmountBO;
import kd.fi.er.business.daily.service.model.ReimburseAmountControlResultBO;
import kd.fi.er.business.utils.CollectorsUtil;
import kd.fi.er.business.utils.ReimburseControlUtils;

public class MonthlyControlServiceImpl
implements ReimburseAmountControlService {
    private AmountFreedService amountFreedService;
    private static final Log log = LogFactory.getLog(MonthlyControlServiceImpl.class);

    @Override
    public ReimburseAmountControlResultBO validate(Long companyId, Long userId, Long expenseItemId, Long currencyId, List<ReimburseAmountBO> reimburseAmountBOs, List<Long> notInIds) {
        log.info(String.format("\u6309\u6708\u63a7\u5236: \u516c\u53f8:%d, \u7528\u6237:%d, \u8d39\u7528\u9879\u76ee:%d, \u5e01\u79cd:%d, \u8fdb\u884c\u63a7\u5236\u7684\u8d39\u7528\u9879\u76ee\u4fe1\u606f:%s", companyId, userId, expenseItemId, currencyId, JSON.toJSONString(reimburseAmountBOs)));
        Map<YearMonth, BigDecimal> reimburseAmountPerMonth = reimburseAmountBOs.stream().collect(Collectors.groupingBy(reimburseAmountBO -> YearMonth.from(reimburseAmountBO.getHappenDate()), CollectorsUtil.summingBigDecimal(ReimburseAmountBO::getAmount)));
        ReimburseAmountControlResultBO result = new ReimburseAmountControlResultBO();
        result.setOver(false);
        for (Map.Entry<YearMonth, BigDecimal> entry : reimburseAmountPerMonth.entrySet()) {
            YearMonth yearMonth = entry.getKey();
            BigDecimal needReimburseAmount = entry.getValue();
            BigDecimal reimbursedAmout = this.getReimbursedAmountByMonth(companyId, userId, expenseItemId, currencyId, yearMonth, notInIds);
            BigDecimal reimburseLimitAmount = this.getReimburseLimitAmountByMonth(companyId, userId, expenseItemId, currencyId, yearMonth);
            BigDecimal balanceAmount = reimburseLimitAmount.subtract(reimbursedAmout);
            if (balanceAmount.compareTo(needReimburseAmount) >= 0) continue;
            result.setOver(true);
            result.setBalanceAmount(balanceAmount);
            result.setTotalAmount(reimburseLimitAmount);
            result.setBalanceAmount(balanceAmount);
            result.setCurrencyId(currencyId);
            result.setExpenseItemId(expenseItemId);
            result.setReimbursePeriod(String.format(ResManager.loadKDString((String)"%s\u6708", (String)"MonthlyControlServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]), yearMonth.getMonthValue()));
            result.setReimUserOrDeptName(ReimburseControlUtils.getUserName(userId));
            result.setInTable(ReimburseAmountControlService.hasReimburseAmountData(companyId, userId, expenseItemId, currencyId, Year.of(yearMonth.getYear())));
            break;
        }
        return result;
    }

    @Override
    public ReimburseAmountControlResultBO validateDeptReim(Long companyId, Long deptId, Long expenseItemId, Long currencyId, List<ReimburseAmountBO> reimburseAmountBOs, List<Long> notInIds) {
        log.info(String.format("\u90e8\u95e8\u989d\u5ea6\u6309\u6708\u63a7\u5236: \u516c\u53f8:%d, \u90e8\u95e8:%d, \u8d39\u7528\u9879\u76ee:%d, \u5e01\u79cd:%d, \u8fdb\u884c\u63a7\u5236\u7684\u8d39\u7528\u9879\u76ee\u4fe1\u606f:%s", companyId, deptId, expenseItemId, currencyId, JSON.toJSONString(reimburseAmountBOs)));
        Map<YearMonth, BigDecimal> reimburseAmountPerMonth = reimburseAmountBOs.stream().collect(Collectors.groupingBy(reimburseAmountBO -> YearMonth.from(reimburseAmountBO.getHappenDate()), CollectorsUtil.summingBigDecimal(ReimburseAmountBO::getAmount)));
        ReimburseAmountControlResultBO result = new ReimburseAmountControlResultBO();
        result.setOver(false);
        for (Map.Entry<YearMonth, BigDecimal> entry : reimburseAmountPerMonth.entrySet()) {
            YearMonth yearMonth = entry.getKey();
            BigDecimal needReimburseAmount = entry.getValue();
            BigDecimal reimbursedAmout = this.getDeptReimbursedAmountByMonth(companyId, deptId, expenseItemId, currencyId, yearMonth, notInIds);
            BigDecimal reimburseLimitAmount = this.getDeptReimburseLimitAmountByMonth(companyId, deptId, expenseItemId, currencyId, yearMonth);
            BigDecimal balanceAmount = reimburseLimitAmount.subtract(reimbursedAmout);
            if (balanceAmount.compareTo(needReimburseAmount) >= 0) continue;
            result.setOver(true);
            result.setBalanceAmount(balanceAmount);
            result.setTotalAmount(reimburseLimitAmount);
            result.setBalanceAmount(balanceAmount);
            result.setCurrencyId(currencyId);
            result.setExpenseItemId(expenseItemId);
            result.setReimbursePeriod(String.format(ResManager.loadKDString((String)"%s\u6708", (String)"MonthlyControlServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]), yearMonth.getMonthValue()));
            result.setReimUserOrDeptName(ReimburseControlUtils.getOrgName(deptId));
            result.setInTable(ReimburseAmountControlService.hasDeptReimburseAmountData(companyId, deptId, expenseItemId, currencyId, Year.of(yearMonth.getYear())));
            break;
        }
        return result;
    }

    @Override
    public BigDecimal getReimburseLimitAmountByMonth(Long companyId, Long userId, Long expenseItemId, Long currencyId, YearMonth yearMonth) {
        BigDecimal releaseRatio = BigDecimal.ONE;
        YearMonth currentYearMonth = YearMonth.from(ReimburseControlUtils.currentLocalDate());
        if (currentYearMonth.equals(yearMonth) && this.amountFreedService != null) {
            releaseRatio = this.amountFreedService.getHaveFreededAmount(companyId, expenseItemId);
        }
        BigDecimal amount = this.getReimburseMonthlyAmountLimited(companyId, userId, expenseItemId, currencyId, Year.of(yearMonth.getYear())).get(yearMonth.getMonth());
        BigDecimal releaseAmount = amount.multiply(releaseRatio);
        return releaseAmount;
    }

    @Override
    public BigDecimal getDeptReimburseLimitAmountByMonth(Long companyId, Long deptId, Long expenseItemId, Long currencyId, YearMonth yearMonth) {
        BigDecimal amount = this.getDeptReimburseMonthlyAmountLimited(companyId, deptId, expenseItemId, currencyId, Year.of(yearMonth.getYear())).get(yearMonth.getMonth());
        return amount;
    }

    @Override
    public BigDecimal getReimbursedAmountByMonth(Long companyId, Long userId, Long expenseItemId, Long currencyId, YearMonth yearMonth, List<Long> notInIds) {
        LocalDate beginDate = LocalDate.of(yearMonth.getYear(), yearMonth.getMonth(), 1);
        LocalDate endDate = yearMonth.atEndOfMonth();
        BigDecimal amount = this.getUserReimbursedAmountBetween(companyId, userId, expenseItemId, currencyId, beginDate, endDate, notInIds);
        return amount;
    }

    @Override
    public BigDecimal getDeptReimbursedAmountByMonth(Long companyId, Long deptId, Long expenseItemId, Long currencyId, YearMonth yearMonth, List<Long> notInIds) {
        LocalDate beginDate = LocalDate.of(yearMonth.getYear(), yearMonth.getMonth(), 1);
        LocalDate endDate = yearMonth.atEndOfMonth();
        BigDecimal amount = this.getDeptReimbursedAmountBetween(companyId, deptId, expenseItemId, currencyId, beginDate, endDate, notInIds);
        return amount;
    }

    public AmountFreedService getAmountFreedService() {
        return this.amountFreedService;
    }

    public void setAmountFreedService(AmountFreedService amountFreedService) {
        this.amountFreedService = amountFreedService;
    }

    @Override
    public BigDecimal getAuditReimbursedAmountByMonth(Long companyId, Long userId, Long expenseItemId, Long currencyId, YearMonth yearMonth) {
        LocalDate beginDate = LocalDate.of(yearMonth.getYear(), yearMonth.getMonth(), 1);
        LocalDate endDate = yearMonth.atEndOfMonth();
        return this.getAuditReimbursedAmountBetween(companyId, userId, expenseItemId, currencyId, beginDate, endDate);
    }

    @Override
    public Map<String, LocalDate> getReimburseBillHappenDatePeriod(YearMonth yearMonth) {
        LocalDate beginDate = LocalDate.of(yearMonth.getYear(), yearMonth.getMonth(), 1);
        LocalDate endDate = yearMonth.atEndOfMonth();
        HashMap<String, LocalDate> datePeriod = new HashMap<String, LocalDate>(2);
        datePeriod.put("start", beginDate);
        datePeriod.put("end", endDate);
        return datePeriod;
    }
}

