/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.daily.service.impl;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.daily.service.ReimburseAmountControlService;
import kd.fi.er.business.daily.service.model.ReimburseAmountBO;
import kd.fi.er.business.daily.service.model.ReimburseAmountControlResultBO;
import kd.fi.er.business.utils.ReimburseControlUtils;

public class YearlyControlServiceImpl
implements ReimburseAmountControlService {
    private static final Log log = LogFactory.getLog(YearlyControlServiceImpl.class);

    @Override
    public ReimburseAmountControlResultBO validate(Long companyId, Long userId, Long expenseItemId, Long currencyId, List<ReimburseAmountBO> rawReimburseAmountBOs, List<Long> notInIds) {
        log.info(String.format("\u6309\u5e74\u63a7\u5236: \u516c\u53f8:%d, \u7528\u6237:%d, \u8d39\u7528\u9879\u76ee:%d, \u5e01\u79cd:%d, \u8fdb\u884c\u63a7\u5236\u7684\u8d39\u7528\u9879\u76ee\u4fe1\u606f:%s", companyId, userId, expenseItemId, currencyId, JSON.toJSONString(rawReimburseAmountBOs)));
        Map<Integer, List<ReimburseAmountBO>> reimburseAmountByYears = rawReimburseAmountBOs.stream().collect(Collectors.groupingBy(obj -> obj.getHappenDate().getYear()));
        ReimburseAmountControlResultBO result = null;
        for (Map.Entry<Integer, List<ReimburseAmountBO>> pair : reimburseAmountByYears.entrySet()) {
            List<ReimburseAmountBO> reimburseAmountBOs = pair.getValue();
            LocalDate startHappenDate = LocalDate.of(reimburseAmountBOs.get(0).getHappenDate().getYear(), 1, 1);
            BigDecimal reimbursedAmount = this.getReimbursedAmountByMonth(companyId, userId, expenseItemId, currencyId, YearMonth.from(startHappenDate), notInIds);
            BigDecimal reimburseLimitAmount = this.getReimburseLimitAmountByMonth(companyId, userId, expenseItemId, currencyId, YearMonth.from(startHappenDate));
            BigDecimal needReimburseAmount = reimburseAmountBOs.stream().map(reimburseAmountBO -> reimburseAmountBO.getAmount()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
            BigDecimal balanceAmount = reimburseLimitAmount.subtract(reimbursedAmount);
            result = new ReimburseAmountControlResultBO(false, reimburseLimitAmount, balanceAmount, currencyId, expenseItemId, ResManager.loadKDString((String)"1-12\u6708", (String)"YearlyControlServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]), ReimburseControlUtils.getUserName(userId));
            if (balanceAmount.compareTo(needReimburseAmount) >= 0) {
                result.setOver(false);
                continue;
            }
            result.setOver(true);
            result.setInTable(ReimburseAmountControlService.hasReimburseAmountData(companyId, userId, expenseItemId, currencyId, Year.of(startHappenDate.getYear())));
            break;
        }
        return result;
    }

    @Override
    public ReimburseAmountControlResultBO validateDeptReim(Long companyId, Long deptId, Long expenseItemId, Long currencyId, List<ReimburseAmountBO> rawReimburseAmountBOs, List<Long> notInIds) {
        log.info(String.format("\u90e8\u95e8\u989d\u5ea6\u6309\u5e74\u63a7\u5236: \u516c\u53f8:%d, \u90e8\u95e8:%d, \u8d39\u7528\u9879\u76ee:%d, \u5e01\u79cd:%d, \u8fdb\u884c\u63a7\u5236\u7684\u8d39\u7528\u9879\u76ee\u4fe1\u606f:%s", companyId, deptId, expenseItemId, currencyId, JSON.toJSONString(rawReimburseAmountBOs)));
        Map<Integer, List<ReimburseAmountBO>> reimburseAmountByYears = rawReimburseAmountBOs.stream().collect(Collectors.groupingBy(obj -> obj.getHappenDate().getYear()));
        ReimburseAmountControlResultBO result = null;
        for (Map.Entry<Integer, List<ReimburseAmountBO>> pair : reimburseAmountByYears.entrySet()) {
            List<ReimburseAmountBO> reimburseAmountBOs = pair.getValue();
            LocalDate startHappenDate = LocalDate.of(reimburseAmountBOs.get(0).getHappenDate().getYear(), 1, 1);
            BigDecimal reimbursedAmount = this.getDeptReimbursedAmountByMonth(companyId, deptId, expenseItemId, currencyId, YearMonth.from(startHappenDate), notInIds);
            BigDecimal reimburseLimitAmount = this.getDeptReimburseLimitAmountByMonth(companyId, deptId, expenseItemId, currencyId, YearMonth.from(startHappenDate));
            BigDecimal needReimburseAmount = reimburseAmountBOs.stream().map(reimburseAmountBO -> reimburseAmountBO.getAmount()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
            BigDecimal balanceAmount = reimburseLimitAmount.subtract(reimbursedAmount);
            result = new ReimburseAmountControlResultBO(false, reimburseLimitAmount, balanceAmount, currencyId, expenseItemId, ResManager.loadKDString((String)"1-12\u6708", (String)"YearlyControlServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]), ReimburseControlUtils.getOrgName(deptId));
            if (balanceAmount.compareTo(needReimburseAmount) >= 0) {
                result.setOver(false);
                continue;
            }
            result.setInTable(ReimburseAmountControlService.hasDeptReimburseAmountData(companyId, deptId, expenseItemId, currencyId, Year.of(startHappenDate.getYear())));
            result.setOver(true);
            break;
        }
        return result;
    }

    @Override
    public BigDecimal getReimburseLimitAmountByMonth(Long companyId, Long userId, Long expenseItemId, Long currencyId, YearMonth yearMonth) {
        BigDecimal reimburseLimitAmount = this.getReimbuseAmountLimitByYear(companyId, userId, expenseItemId, currencyId, Year.from(yearMonth));
        log.info(String.format("\u6309\u5e74\u63a7\u5236:\u516c\u53f8:%d,\u7528\u6237:%d, \u8d39\u7528\u9879\u76ee:%d, \u5e01\u79cd:%d, \u5e74\u6708:%s, \u5f53\u5e74\u603b\u989d\u5ea6:%s", companyId, userId, expenseItemId, currencyId, yearMonth.toString(), reimburseLimitAmount));
        return reimburseLimitAmount;
    }

    @Override
    public BigDecimal getDeptReimburseLimitAmountByMonth(Long companyId, Long deptId, Long expenseItemId, Long currencyId, YearMonth yearMonth) {
        BigDecimal reimburseLimitAmount = this.getDeptReimbuseAmountLimitByYear(companyId, deptId, expenseItemId, currencyId, Year.from(yearMonth));
        log.info(String.format("\u6309\u5e74\u63a7\u5236:\u516c\u53f8:%d,\u90e8\u95e8:%d, \u8d39\u7528\u9879\u76ee:%d, \u5e01\u79cd:%d, \u5e74\u6708:%s, \u5f53\u5e74\u603b\u989d\u5ea6:%s", companyId, deptId, expenseItemId, currencyId, yearMonth.toString(), reimburseLimitAmount));
        return reimburseLimitAmount;
    }

    @Override
    public BigDecimal getDeptReimbursedAmountByMonth(Long companyId, Long deptId, Long expenseItemId, Long currencyId, YearMonth yearMonth, List<Long> notInIds) {
        LocalDate startHappenDate = LocalDate.of(yearMonth.getYear(), 1, 1);
        LocalDate endHappenDate = LocalDate.of(yearMonth.getYear(), 12, 31);
        BigDecimal reimbursedAmount = this.getDeptReimbursedAmountBetween(companyId, deptId, expenseItemId, currencyId, startHappenDate, endHappenDate, notInIds);
        return reimbursedAmount;
    }

    @Override
    public BigDecimal getReimbursedAmountByMonth(Long companyId, Long userId, Long expenseItemId, Long currencyId, YearMonth yearMonth, List<Long> notInIds) {
        LocalDate startHappenDate = LocalDate.of(yearMonth.getYear(), 1, 1);
        LocalDate endHappenDate = LocalDate.of(yearMonth.getYear(), 12, 31);
        BigDecimal reimbursedAmount = this.getUserReimbursedAmountBetween(companyId, userId, expenseItemId, currencyId, startHappenDate, endHappenDate, notInIds);
        return reimbursedAmount;
    }

    @Override
    public BigDecimal getAuditReimbursedAmountByMonth(Long companyId, Long userId, Long expenseItemId, Long currencyId, YearMonth yearMonth) {
        LocalDate startHappenDate = LocalDate.of(yearMonth.getYear(), 1, 1);
        LocalDate endHappenDate = LocalDate.of(yearMonth.getYear(), 12, 31);
        return this.getAuditReimbursedAmountBetween(companyId, userId, expenseItemId, currencyId, startHappenDate, endHappenDate);
    }

    @Override
    public Map<String, LocalDate> getReimburseBillHappenDatePeriod(YearMonth yearMonth) {
        LocalDate beginDate = LocalDate.of(yearMonth.getYear(), 1, 1);
        LocalDate endDate = LocalDate.of(yearMonth.getYear(), 12, 31);
        HashMap<String, LocalDate> datePeriod = new HashMap<String, LocalDate>(2);
        datePeriod.put("start", beginDate);
        datePeriod.put("end", endDate);
        return datePeriod;
    }
}

