/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.dao.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.dao.ITipsDao;
import kd.fi.er.business.dao.impl.ErDaoOrmImpl;

public class TipsDaoOrmImpl
extends ErDaoOrmImpl
implements ITipsDao {
    public static final String entityName = "er_tips";
    public static final IDataEntityType entityType = EntityMetadataCache.getDataEntityType((String)"er_tips");

    public TipsDaoOrmImpl() {
        super(entityName);
    }

    @Override
    public DynamicObject createNewTips(Object tripReqBillId, Object applierId, String cityName, Date beginDate, Date endDate, DynamicObject weatherCache) {
        DynamicObject newTips = this.getEmptyDynamicObject();
        newTips.set("tripReqBillId", (Object)tripReqBillId.toString());
        newTips.set("applierId", applierId);
        newTips.set("city", (Object)cityName);
        newTips.set("beginDate", (Object)beginDate);
        newTips.set("endDate", (Object)endDate);
        if (weatherCache != null) {
            this.fillTripTipsByWeatherCache(weatherCache, newTips);
        }
        return newTips;
    }

    private void fillTripTipsByWeatherCache(DynamicObject weatherCache, DynamicObject newTips) {
        newTips.set("curtemperature", weatherCache.get("curtemperature"));
        DynamicObjectCollection weatherEntries = weatherCache.getDynamicObjectCollection("entryentity");
        List weatherEntryList = weatherEntries.stream().filter(v -> this.inRange(newTips.getDate("beginDate"), newTips.getDate("endDate"), v.getDate("date"))).collect(Collectors.toList());
        DynamicObjectCollection entries = newTips.getDynamicObjectCollection("entryentity");
        entries.clear();
        DynamicObjectType dt = entries.getDynamicObjectType();
        for (DynamicObject weatherEntry : weatherEntryList) {
            DynamicObject entry = new DynamicObject(dt);
            entry.set("date", weatherEntry.get("date"));
            entry.set("weather", weatherEntry.get("weather"));
            entry.set("temperature", weatherEntry.get("temperature"));
            entry.set("temperatureHigh", weatherEntry.get("temperatureHigh"));
            entries.add((Object)entry);
        }
    }

    private boolean inRange(Date beginDate, Date endDate, Date d) {
        boolean ret;
        boolean bl = ret = d.compareTo(beginDate) >= 0;
        if (endDate != null) {
            ret = ret && d.compareTo(endDate) <= 0;
        }
        return ret;
    }

    @Override
    public int deleteTips(Object tripReqBillId) {
        DynamicObject[] tips = this.query(new QFilter("tripReqBillId", "=", tripReqBillId));
        Object[] pks = Arrays.asList(tips).stream().map(v -> v.get("id")).collect(Collectors.toList()).toArray(new Object[0]);
        QFilter f = new QFilter("id", "in", (Object)pks);
        return DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{f});
    }

    @Override
    public DynamicObject[] queryTips(List cityIds) {
        return this.query(new QFilter("city.id", "in", (Object)cityIds));
    }

    @Override
    public void updateTripTipsByWeatherCache(DynamicObject[] tripTips, DynamicObject[] weatherCaches) {
        List<DynamicObject> cacheLst = Arrays.asList(weatherCaches);
        int len = tripTips.length;
        for (int i = 0; i < len; ++i) {
            DynamicObject tripTipObj = tripTips[i];
            cacheLst.stream().filter(v -> v.getString("city").equals(tripTipObj.getString("city"))).findFirst().ifPresent(v -> this.fillTripTipsByWeatherCache(tripTipObj, (DynamicObject)v));
        }
        SaveServiceHelper.save((DynamicObject[])tripTips);
    }
}

