/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.datacheck.validator;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.er.business.domain.amount.IApplyBillAmountService;
import kd.fi.er.business.domain.amount.ILoanBillAmountService;
import kd.fi.er.business.domain.amount.IReimurseBillAmountSevice;
import kd.fi.er.business.utils.FieldNameHelper;
import kd.fi.er.common.field.head.BillHeadFields;

public class BizAmountCheckCondition {
    private static BillHeadFields getBillHeadFields(DynamicObject dataEntity) {
        return FieldNameHelper.getBillHeadInstance(dataEntity.getDataEntityType().getName());
    }

    static class ReimBurseBizAmountCheck<T extends IReimurseBillAmountSevice> {
        ReimBurseBizAmountCheck() {
        }

        public String sumOfEntryAndHeadValidator(DynamicObject dataEntity, T reimburseBizService) {
            DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
            BillHeadFields billHeadInstance = BizAmountCheckCondition.getBillHeadFields(dataEntity);
            if (billHeadInstance != null) {
                BigDecimal headNotPayAmount;
                BigDecimal sumNotPayAmountOfEntry;
                BigDecimal headPayAmount;
                BigDecimal sumPayAmountOfEntry;
                if (properties.get((Object)"payedamount") != null && (sumPayAmountOfEntry = reimburseBizService.calcEntryPayAmount(dataEntity)).compareTo(headPayAmount = dataEntity.getBigDecimal(billHeadInstance.payedAmtFiled)) != 0) {
                    return String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u5206\u5f55\u5df2\u4ed8\u91d1\u989d\u6c47\u603b%1$s\u4e0e\u5355\u5934\u5df2\u4ed8\u91d1\u989d%2$s\u4e0d\u76f8\u7b49\u3002", (String)"CommonAmountCheckCondition_6", (String)"fi-er-business", (Object[])new Object[0]), sumPayAmountOfEntry, headPayAmount);
                }
                if (properties.get((Object)"notpayamount") != null && (sumNotPayAmountOfEntry = reimburseBizService.calcEntryNotPayAmount(dataEntity)).compareTo(headNotPayAmount = dataEntity.getBigDecimal("notpayamount")) != 0) {
                    return String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u5206\u5f55\u672a\u4ed8\u91d1\u989d\u6c47\u603b%1$s\u4e0e\u5355\u5934\u672a\u4ed8\u91d1\u989d%2$s\u4e0d\u76f8\u7b49\u3002", (String)"CommonAmountCheckCondition_7", (String)"fi-er-business", (Object[])new Object[0]), sumNotPayAmountOfEntry, headNotPayAmount);
                }
            }
            return null;
        }
    }

    static class LoanBizAmountCheck<T extends ILoanBillAmountService> {
        LoanBizAmountCheck() {
        }

        public String sumOfEntryAndHeadValidator(DynamicObject dataEntity, T loanBizService) {
            DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
            BillHeadFields billHeadInstance = BizAmountCheckCondition.getBillHeadFields(dataEntity);
            if (billHeadInstance != null) {
                BigDecimal headNotPayAmount;
                BigDecimal sumNotPayAmountOfEntry;
                BigDecimal headPayAmount;
                BigDecimal sumPayAmountOfEntry;
                if (properties.get((Object)"payamount") != null && (sumPayAmountOfEntry = loanBizService.calcEntryPayAmount(dataEntity)).compareTo(headPayAmount = dataEntity.getBigDecimal(billHeadInstance.payedAmtFiled)) != 0) {
                    return String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u5206\u5f55\u5df2\u4ed8\u91d1\u989d\u6c47\u603b%1$s\u4e0e\u5355\u5934\u5df2\u4ed8\u91d1\u989d%2$s\u4e0d\u76f8\u7b49\u3002", (String)"CommonAmountCheckCondition_6", (String)"fi-er-business", (Object[])new Object[0]), sumPayAmountOfEntry, headPayAmount);
                }
                if (properties.get((Object)"notpayamount") != null && (sumNotPayAmountOfEntry = loanBizService.calcEntryNotPayAmount(dataEntity)).compareTo(headNotPayAmount = dataEntity.getBigDecimal("notpayamount")) != 0) {
                    return String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u5206\u5f55\u672a\u4ed8\u91d1\u989d\u6c47\u603b%1$s\u4e0e\u5355\u5934\u672a\u4ed8\u91d1\u989d%2$s\u4e0d\u76f8\u7b49\u3002", (String)"CommonAmountCheckCondition_7", (String)"fi-er-business", (Object[])new Object[0]), sumNotPayAmountOfEntry, headNotPayAmount);
                }
                if (properties.get((Object)"balanceamount") != null) {
                    BigDecimal sumLoanBalanceAmountOfEntry = loanBizService.calcEntryLoanBalanceAmount(dataEntity);
                    BigDecimal headLoanBalanceAmount = dataEntity.getBigDecimal("balanceamount");
                    if (dataEntity.getString("billstatus").equals("G") && sumLoanBalanceAmountOfEntry.compareTo(headLoanBalanceAmount) != 0) {
                        return String.format(ResManager.loadKDString((String)"\u501f\u6b3e\u660e\u7ec6\u5206\u5f55\u501f\u6b3e\u4f59\u989d\uff08\u672c\u4f4d\u5e01\uff09\u6c47\u603b%1$s\u4e0e\u5355\u5934\u501f\u6b3e\u4f59\u989d%2$s\u4e0d\u76f8\u7b49\u3002", (String)"CommonAmountCheckCondition_10", (String)"fi-er-business", (Object[])new Object[0]), sumLoanBalanceAmountOfEntry, headLoanBalanceAmount);
                    }
                }
            }
            return null;
        }
    }

    static class ApplyBizAmountCheck<T extends IApplyBillAmountService> {
        ApplyBizAmountCheck() {
        }
    }
}

