/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.domain.amount.imp;

import java.math.BigDecimal;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.er.business.domain.amount.IBillAmountService;
import kd.fi.er.business.domain.amount.IReimurseBillAmountSevice;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.field.writeoffmoney.TripReimburseWriteOffFields;

public class TripReimBillAmountServiceImp
implements IBillAmountService,
IReimurseBillAmountSevice {
    @Override
    public BigDecimal calcPayAmount(DynamicObject dataEntity) {
        long companyid = (Long)dataEntity.getDynamicObject("company").getPkValue();
        String writeOffType = (String)ErCommonUtils.getLoanCheckType(companyid);
        return AmountChangeUtil.calculatePayAmount(dataEntity, writeOffType);
    }

    @Override
    public BigDecimal getPayAmountNow(DynamicObject dataEntity) {
        return dataEntity.getBigDecimal(TripReimburseWriteOffFields.getInstance().encashAmtKey);
    }

    @Override
    public BigDecimal calcCurrApproveAmount(DynamicObject dataEntity) {
        DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("tripentry").stream().flatMap(card -> card.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toCollection(DynamicObjectCollection::new));
        return AmountUtils.getEntryAmount(entryentity, "entryappamount");
    }
}

