/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.fatvs.skilldata;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.ext.fi.fatvs.skilldata.ISkillRunnable;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.utils.ErConstants;
import org.apache.commons.lang3.StringUtils;

public class AutoInvoiceSkill
implements ISkillRunnable {
    private static final Log logger = LogFactory.getLog(AutoInvoiceSkill.class);
    private static final String skillNumber = "znfpbx";
    private static final String DateType_Range = "range";
    private static final String DateType_Fix = "fix";
    private static final String dailyAllSql_Range = "select count(1) as count from t_er_dailyreimbursebill where fcreatetime >= '%s' and fcreatetime <= '%s'";
    private static final String dailyAutoSql_Range = "select count(1) as count from t_er_dailyreimbursebill where fcreatetime >= '%s' and fcreatetime <= '%s' and fautomapinvoice = '1'";
    private static final String publicAllSql_Range = "select count(1) as count from t_er_pubreimbill where fcreatetime >= '%s' and fcreatetime <= '%s'";
    private static final String publicAutoSql_Range = "select count(1) as count from t_er_pubreimbill where fcreatetime >= '%s' and fcreatetime <= '%s' and fautomapinvoice = '1'";
    private static final String tripAllSql_Range = "select count(1) as count from t_er_reimbursebill where fcreatetime >= '%s' and fcreatetime <= '%s'";
    private static final String tripAutoSql_Range = "select count(1) as count from t_er_reimbursebill where fcreatetime >= '%s' and fcreatetime <= '%s' and fautomapinvoice = '1'";
    private static final String dailyAllSql_Fix = "select count(1) as count from t_er_dailyreimbursebill where fcreatetime = '%s'";
    private static final String dailyAutoSql_Fix = "select count(1) as count from t_er_dailyreimbursebill where fcreatetime = '%s' and fautomapinvoice = '1'";
    private static final String publicAllSql_Fix = "select count(1) as count from t_er_pubreimbill where fcreatetime = '%s'";
    private static final String publicAutoSql_Fix = "select count(1) as count from t_er_pubreimbill where fcreatetime = '%s' and fautomapinvoice = '1'";
    private static final String tripAllSql_Fix = "select count(1) as count from t_er_reimbursebill where fcreatetime = '%s'";
    private static final String tripAutoSql_Fix = "select count(1) as count from t_er_reimbursebill where fcreatetime = '%s' and fautomapinvoice = '1'";

    public SkillRunResult pullData(SkillRunContext skillRunContext) {
        String skillNum = skillRunContext.getSkillNum();
        SkillRunResult skillResult = skillRunContext.getSkillResult();
        if (StringUtils.equals((CharSequence)skillNum, (CharSequence)skillNumber)) {
            skillResult.setDate(skillRunContext.getStartTime());
            skillResult.setSkillNum(skillNum);
            skillResult.setTotalCount(Integer.valueOf(this.getRangeDateCount(skillRunContext.getStartTime(), skillRunContext.getEndTime())));
            skillResult.setFailCount(Integer.valueOf(0));
            skillResult.setData(this.genStatisticsData());
        }
        return skillResult;
    }

    public List genStatisticsData() {
        ArrayList data = new ArrayList();
        LocalDate now = LocalDate.now();
        String year_cur = String.valueOf(now.getYear());
        String month_cur = String.valueOf(now.getMonth().getValue());
        LocalDate last = now.plusMonths(-1L).with(TemporalAdjusters.firstDayOfMonth());
        String year_last = String.valueOf(last.getYear());
        String month_last = String.valueOf(last.getMonth().getValue());
        HashMap<String, String> syznbxzs = new HashMap<String, String>(4);
        syznbxzs.put("number", "syznbxzs");
        syznbxzs.put("name", ResManager.loadKDString((String)"\u4e0a\u6708\u667a\u80fd\u62a5\u9500\u603b\u6570", (String)"CloseBill_1", (String)"fi-er-business", (Object[])new Object[0]));
        syznbxzs.put("value", this.getAutoDateData(year_last, month_last, "", DateType_Range));
        syznbxzs.put("valueType", "0");
        HashMap<String, String> byznbxzs = new HashMap<String, String>(4);
        byznbxzs.put("number", "byznbxzs");
        byznbxzs.put("name", ResManager.loadKDString((String)"\u672c\u6708\u667a\u80fd\u62a5\u9500\u603b\u6570", (String)"CloseBill_2", (String)"fi-er-business", (Object[])new Object[0]));
        byznbxzs.put("value", this.getAutoDateData(year_cur, month_cur, "", DateType_Range));
        byznbxzs.put("valueType", "0");
        HashMap<String, String> byznbxzb = new HashMap<String, String>(4);
        byznbxzb.put("number", "byznbxzb");
        byznbxzb.put("name", ResManager.loadKDString((String)"\u672c\u6708\u667a\u80fd\u62a5\u9500\u5360\u6bd4", (String)"CloseBill_3", (String)"fi-er-business", (Object[])new Object[0]));
        byznbxzb.put("value", this.getMonthRate(year_cur, month_cur, "", DateType_Range));
        byznbxzb.put("valueType", "1");
        data.add(syznbxzs);
        data.add(byznbxzs);
        data.add(byznbxzb);
        return data;
    }

    private String getAutoDateData(String year, String month, String day, String dateType) {
        String tripAuto;
        String publicAuto;
        String dailyAuto;
        LocalDate today = LocalDate.now();
        if (dateType.equalsIgnoreCase(DateType_Range)) {
            String endDateStr;
            String startDateStr;
            String qYear = StringUtils.isEmpty((CharSequence)year) ? String.valueOf(today.getYear()) : year;
            if (StringUtils.isEmpty((CharSequence)month)) {
                startDateStr = qYear + "-01-01";
                endDateStr = qYear + "-12-31";
            } else {
                LocalDate startDate = LocalDate.of(Integer.parseInt(qYear), Integer.parseInt(month), 1);
                LocalDate endDate = startDate.with(TemporalAdjusters.lastDayOfMonth());
                startDateStr = startDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
                endDateStr = endDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
            }
            dailyAuto = String.format(dailyAutoSql_Range, startDateStr, endDateStr);
            publicAuto = String.format(publicAutoSql_Range, startDateStr, endDateStr);
            tripAuto = String.format(tripAutoSql_Range, startDateStr, endDateStr);
        } else {
            String fixDateStr = year + "-" + month + "-" + day;
            dailyAuto = String.format(dailyAutoSql_Fix, fixDateStr);
            publicAuto = String.format(publicAutoSql_Fix, fixDateStr);
            tripAuto = String.format(tripAutoSql_Fix, fixDateStr);
        }
        int count = 0;
        logger.info(String.format("\u3010\u8d22\u7a0e\u3011\u667a\u80fd\u53d1\u7968\u62a5\u9500dailyAuto:%1$s,publicAuto:%2$s,tripAuto:%3$s", dailyAuto, publicAuto, tripAuto));
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)ErConstants.FI_DB_ROUTE, (String)dailyAuto);){
            for (Row row : ds) {
                count += row.getInteger("count").intValue();
            }
        }
        ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)ErConstants.FI_DB_ROUTE, (String)publicAuto);
        var11_9 = null;
        try {
            for (Row row : ds) {
                count += row.getInteger("count").intValue();
            }
        }
        catch (Throwable throwable) {
            var11_9 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var11_9 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var11_9.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)ErConstants.FI_DB_ROUTE, (String)tripAuto);
        var11_9 = null;
        try {
            for (Row row : ds) {
                count += row.getInteger("count").intValue();
            }
        }
        catch (Throwable throwable) {
            var11_9 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var11_9 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var11_9.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        return String.valueOf(count);
    }

    private String getAllDateData(String year, String month, String day, String dateType) {
        String tripAll;
        String publicAll;
        String dailyAll;
        LocalDate today = LocalDate.now();
        if (dateType.equalsIgnoreCase(DateType_Range)) {
            String endDateStr;
            String startDateStr;
            String qYear = StringUtils.isEmpty((CharSequence)year) ? String.valueOf(today.getYear()) : year;
            if (StringUtils.isEmpty((CharSequence)month)) {
                startDateStr = qYear + "-01-01";
                endDateStr = qYear + "-12-31";
            } else {
                LocalDate startDate = LocalDate.of(Integer.parseInt(qYear), Integer.parseInt(month), 1);
                LocalDate endDate = startDate.with(TemporalAdjusters.lastDayOfMonth());
                startDateStr = startDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
                endDateStr = endDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
            }
            dailyAll = String.format(dailyAllSql_Range, startDateStr, endDateStr);
            publicAll = String.format(publicAllSql_Range, startDateStr, endDateStr);
            tripAll = String.format(tripAllSql_Range, startDateStr, endDateStr);
        } else {
            String fixDateStr = year + "-" + month + "-" + day;
            dailyAll = String.format(dailyAllSql_Fix, fixDateStr);
            publicAll = String.format(publicAllSql_Fix, fixDateStr);
            tripAll = String.format(tripAllSql_Fix, fixDateStr);
        }
        int count = 0;
        logger.info(String.format("\u3010\u8d22\u7a0e\u3011\u667a\u80fd\u53d1\u7968\u62a5\u9500dailyAll:%1$s, publicAll:%2$s, tripAll:%3$s", dailyAll, publicAll, tripAll));
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)ErConstants.FI_DB_ROUTE, (String)dailyAll);){
            for (Row row : ds) {
                count += row.getInteger("count").intValue();
            }
        }
        ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)ErConstants.FI_DB_ROUTE, (String)publicAll);
        var11_9 = null;
        try {
            for (Row row : ds) {
                count += row.getInteger("count").intValue();
            }
        }
        catch (Throwable throwable) {
            var11_9 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var11_9 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var11_9.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)ErConstants.FI_DB_ROUTE, (String)tripAll);
        var11_9 = null;
        try {
            for (Row row : ds) {
                count += row.getInteger("count").intValue();
            }
        }
        catch (Throwable throwable) {
            var11_9 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var11_9 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var11_9.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        return String.valueOf(count);
    }

    private int getRangeDateCount(Date startDate, Date endDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startDateStr = format.format(startDate);
        String endDateStr = format.format(endDate);
        String dailyAuto = String.format(dailyAutoSql_Range, startDateStr, endDateStr);
        String publicAuto = String.format(publicAutoSql_Range, startDateStr, endDateStr);
        String tripAuto = String.format(tripAutoSql_Range, startDateStr, endDateStr);
        int count = 0;
        logger.info(String.format("\u3010\u8d22\u7a0e\u3011\u667a\u80fd\u53d1\u7968\u62a5\u9500dailyAuto:%1$s, publicAuto:%2$s, tripAuto:%3$s", dailyAuto, publicAuto, tripAuto));
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)ErConstants.FI_DB_ROUTE, (String)dailyAuto);){
            for (Row row : ds) {
                count += row.getInteger("count").intValue();
            }
        }
        ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)ErConstants.FI_DB_ROUTE, (String)publicAuto);
        var11_11 = null;
        try {
            for (Row row : ds) {
                count += row.getInteger("count").intValue();
            }
        }
        catch (Throwable throwable) {
            var11_11 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var11_11 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var11_11.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)ErConstants.FI_DB_ROUTE, (String)tripAuto);
        var11_11 = null;
        try {
            for (Row row : ds) {
                count += row.getInteger("count").intValue();
            }
        }
        catch (Throwable throwable) {
            var11_11 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var11_11 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var11_11.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        return count;
    }

    private String getMonthRate(String year, String month, String day, String dateType) {
        String allDateData = this.getAllDateData(year, month, day, dateType);
        String autoDateData = this.getAutoDateData(year, month, day, dateType);
        BigDecimal all = new BigDecimal(allDateData);
        BigDecimal auto = new BigDecimal(autoDateData);
        BigDecimal result = auto.divide(all, 2, 4).multiply(new BigDecimal(100));
        return result + "%";
    }
}

