/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.fatvs.skilldata;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.FourTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.fatvs.skilldata.ISkillRunnable;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.er.business.fatvs.skilldata.model.FiveTuple;
import kd.fi.er.business.fatvs.skilldata.util.SkillCommonUtil;

public class CheckingPayBillIndexSkill
implements ISkillRunnable {
    private static final Log logger = LogFactory.getLog(CheckingPayBillIndexSkill.class);
    private static final String INVOICE_FULL_PROCESS_INDEX = "slfpqlcxshcl";
    private static final String CURRENT_MONTH_PLANE_INVOICE_TOTAL = "dyyjscfjfpzs";
    private static final String CURRENT_MONTH_TRAIN_INVOICE_TOTAL = "dyyjschcfpzs";
    private static final String CURRENT_MONTH_UPLOAD_INVOICE_TOTAL = "dyyjscfpzs";
    private static final String CURRENT_MONTH_UPLOAD_INVOICE_RATE = "dyyjscfpbl";
    private static final String PRE_MONTH_UPLOAD_INVOICE_TOTAL = "syyjscfpzs";

    public SkillRunResult pullData(SkillRunContext skillRunContext) {
        String skillNum = skillRunContext.getSkillNum();
        SkillRunResult skillResult = skillRunContext.getSkillResult();
        Date startTime = skillRunContext.getStartTime();
        Date endTime = skillRunContext.getEndTime();
        skillResult.setDate(skillRunContext.getStartTime());
        skillResult.setSkillNum(skillNum);
        try {
            if (INVOICE_FULL_PROCESS_INDEX.equals(skillNum)) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                QFilter currentMonthFirstFilter = new QFilter("bizdate", ">=", (Object)format.parse(SkillCommonUtil.getTime(0)));
                QFilter currentMonthEndFilter = new QFilter("bizdate", "<", (Object)format.parse(SkillCommonUtil.getTime(1)));
                QFilter[] qFilters = new QFilter[]{currentMonthFirstFilter, currentMonthEndFilter};
                FourTuple<String, Integer, Integer, Integer> returnData = this.dealData(this.executeSql(qFilters));
                QFilter preMonthFirstFilter = new QFilter("bizdate", ">=", (Object)format.parse(SkillCommonUtil.getTime(-1)));
                QFilter preMonthEndFilter = new QFilter("bizdate", "<", (Object)format.parse(SkillCommonUtil.getTime(0)));
                qFilters = new QFilter[]{preMonthFirstFilter, preMonthEndFilter};
                Integer preMonthTotalCount = this.identifyData((List<DynamicObject>)this.executeSql(qFilters));
                FiveTuple<Object, Object, Object, Object, Integer> fiveTuple = new FiveTuple<Object, Object, Object, Object, Integer>(returnData.item1, returnData.item2, returnData.item3, returnData.item4, preMonthTotalCount);
                skillResult.setData(this.dealReturnData(fiveTuple));
                QFilter periodStartFilter = new QFilter("bizdate", ">=", (Object)startTime);
                QFilter periodEndFilter = new QFilter("bizdate", "<=", (Object)endTime);
                DynamicObjectCollection dynamicObjects = this.executeSql(new QFilter[]{periodStartFilter, periodEndFilter});
                skillResult.setTotalCount(Integer.valueOf(dynamicObjects.size()));
            }
        }
        catch (Exception e) {
            logger.error("\u6307\u6807\u62a5\u9519", (Throwable)e);
        }
        return skillResult;
    }

    private List<Map<String, String>> dealReturnData(FiveTuple<String, Integer, Integer, Integer, Integer> fiveTuple) {
        ArrayList resList = Lists.newArrayListWithCapacity((int)4);
        HashMap<String, Object> resMap = new HashMap<String, Object>(4);
        resMap.put("number", CURRENT_MONTH_UPLOAD_INVOICE_RATE);
        resMap.put("name", ResManager.loadKDString((String)"\u5f53\u6708\u4e00\u952e\u4e0a\u4f20\u53d1\u7968\u6bd4\u4f8b", (String)"CheckingPayBillIndexSkill_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
        resMap.put("value", fiveTuple.item1);
        resMap.put("valueType", "1");
        resList.add(resMap);
        resMap = new HashMap(4);
        resMap.put("number", CURRENT_MONTH_PLANE_INVOICE_TOTAL);
        resMap.put("name", ResManager.loadKDString((String)"\u5f53\u6708\u4e00\u952e\u4e0a\u4f20\u98de\u673a\u53d1\u7968\u603b\u6570", (String)"CheckingPayBillIndexSkill_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
        resMap.put("value", String.valueOf(fiveTuple.item2));
        resMap.put("valueType", "0");
        resList.add(resMap);
        resMap = new HashMap(4);
        resMap.put("number", CURRENT_MONTH_TRAIN_INVOICE_TOTAL);
        resMap.put("name", ResManager.loadKDString((String)"\u5f53\u6708\u4e00\u952e\u4e0a\u4f20\u706b\u8f66\u53d1\u7968\u603b\u6570", (String)"CheckingPayBillIndexSkill_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
        resMap.put("value", String.valueOf(fiveTuple.item3));
        resMap.put("valueType", "0");
        resList.add(resMap);
        resMap = new HashMap(4);
        resMap.put("number", CURRENT_MONTH_UPLOAD_INVOICE_TOTAL);
        resMap.put("name", ResManager.loadKDString((String)"\u5f53\u6708\u4e00\u952e\u4e0a\u4f20\u53d1\u7968\u603b\u6570", (String)"CheckingPayBillIndexSkill_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
        resMap.put("value", String.valueOf(fiveTuple.item4));
        resMap.put("valueType", "0");
        resList.add(resMap);
        resMap = new HashMap(4);
        resMap.put("number", PRE_MONTH_UPLOAD_INVOICE_TOTAL);
        resMap.put("name", ResManager.loadKDString((String)"\u4e0a\u6708\u4e00\u952e\u4e0a\u4f20\u53d1\u7968\u603b\u6570", (String)"CheckingPayBillIndexSkill_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
        resMap.put("value", String.valueOf(fiveTuple.item5));
        resMap.put("valueType", "0");
        resList.add(resMap);
        return resList;
    }

    private FourTuple<String, Integer, Integer, Integer> dealData(DynamicObjectCollection currentMonthTotalData) {
        List<String> planeOperationTypeList = Arrays.asList("2", "4");
        List<String> trainOperationTypeList = Collections.singletonList("6");
        List<DynamicObject> planeData = currentMonthTotalData.stream().filter(bill -> planeOperationTypeList.contains(bill.getString("operationtype"))).collect(Collectors.toList());
        Integer planeTotalCount = this.identifyData(planeData);
        List<DynamicObject> trainData = currentMonthTotalData.stream().filter(bill -> trainOperationTypeList.contains(bill.getString("operationtype"))).collect(Collectors.toList());
        Integer trainCount = this.identifyData(trainData);
        Integer currentMonthTotalCount = this.identifyData((List<DynamicObject>)currentMonthTotalData);
        int invoiceTotal = 0;
        for (DynamicObject dynamicObject : currentMonthTotalData) {
            DynamicObjectCollection invoiceentry = dynamicObject.getDynamicObjectCollection("invoiceentry");
            if (invoiceentry.isEmpty()) continue;
            invoiceTotal = Integer.sum(invoiceTotal, invoiceentry.size());
        }
        String rate = "0.00%";
        if (invoiceTotal != 0) {
            rate = new BigDecimal(currentMonthTotalCount).divide(new BigDecimal(invoiceTotal), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP) + "%";
        }
        return new FourTuple((Object)rate, (Object)planeTotalCount, (Object)trainCount, (Object)currentMonthTotalCount);
    }

    private Integer identifyData(List<DynamicObject> dynamicObjects) {
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return 0;
        }
        DynamicObjectCollection totalList = new DynamicObjectCollection();
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryentity)) continue;
            totalList.addAll((Collection)entryentity);
        }
        if (CollectionUtils.isEmpty((Collection)totalList)) {
            return 0;
        }
        Integer totalCount = 0;
        Long count = totalList.stream().filter(bill -> bill.getBoolean("isuploadinvoicecloud") && StringUtils.isEmpty((String)bill.getString("invoicenum"))).count();
        List invoiceNums = totalList.stream().filter(bill -> bill.get("invoicenum") != null && StringUtils.isNotEmpty((String)bill.getString("invoicenum"))).map(bill -> bill.getString("invoicenum_tag")).collect(Collectors.toList());
        HashSet set = Sets.newHashSetWithExpectedSize((int)16);
        for (String invoiceNum : invoiceNums) {
            set.addAll(Arrays.asList(invoiceNum.split(",")));
        }
        totalCount = Integer.sum(totalCount, set.size());
        totalCount = Integer.sum(totalCount, count.intValue());
        return totalCount;
    }

    private DynamicObjectCollection executeSql(QFilter[] qFilters) {
        Map dataMap = BusinessDataServiceHelper.loadFromCache((String)"er_checkingpaybill", (String)"id,operationtype,entryentity.isuploadinvoicecloud,entryentity.invoicenum,entryentity.invoicenum_tag,invoiceentry", (QFilter[])qFilters);
        if (dataMap.isEmpty()) {
            return new DynamicObjectCollection();
        }
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        Set entries = dataMap.entrySet();
        for (Map.Entry entry : entries) {
            dynamicObjects.add(entry.getValue());
        }
        return dynamicObjects;
    }
}

