/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.handler;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;

public abstract class MultiAccountEntryHandler {
    public static String ACC_ENTRY_NAME;
    public static DynamicObject applier;

    public abstract void generateAccountEntry(IFormView var1);

    public void clearAccountEntry(IDataModel model) {
        model.deleteEntryData(ACC_ENTRY_NAME);
    }

    protected void showConfirm(Set<Long> reimburseIds, IFormView view) {
        Map userArray;
        if (!reimburseIds.isEmpty() && (userArray = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", reimburseIds)})) != null && userArray.size() > 0) {
            ArrayList<String> userNameList = new ArrayList<String>(userArray.size());
            for (Map.Entry entry : userArray.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)entry.getValue();
                userNameList.add(dynamicObject.getLocaleString("name").getLocaleValue());
            }
            view.showConfirm(String.format(ResManager.loadKDString((String)"%s\u6ca1\u6709\u81ea\u52a8\u4ea7\u751f\u6536\u6b3e\u4fe1\u606f\uff0c\u8bf7\u624b\u5de5\u6dfb\u52a0\u3002", (String)"MultiAccountEntryHandler_0", (String)"fi-er-business", (Object[])new Object[0]), userNameList), MessageBoxOptions.OK);
        }
    }

    protected Set<Long> buildAccountEntryView(Map<Long, BigDecimal> applierAmountMap, IFormView view) {
        HashSet<Long> failedIds = new HashSet<Long>(applierAmountMap.size());
        applierAmountMap.forEach((reimburserId, approveCurrAmount) -> {
            IDataModel model = view.getModel();
            List<DynamicObject> defaultAccounts = PayeeServiceHelper.getOtherDefaultAccountByPayerID(reimburserId, null, false);
            if (defaultAccounts == null || defaultAccounts.isEmpty()) {
                failedIds.add((Long)reimburserId);
                return;
            }
            DynamicObject defaultAccount = defaultAccounts.get(0);
            if (null == defaultAccount) {
                failedIds.add((Long)reimburserId);
                return;
            }
            int rowIndex = model.createNewEntryRow(ACC_ENTRY_NAME);
            CoreBaseBillServiceHelper.fillAccountEntry(model, rowIndex, defaultAccount);
            Map<String, Object> currencyMap = AmountChangeUtil.getCurrencyPayerAndParam(model, rowIndex, reimburserId);
            BigDecimal approveOriAmount = AmountChangeUtil.getOriAmount(approveCurrAmount, currencyMap, (String)model.getValue("accquotetype", rowIndex));
            model.setValue("accountcurrency", currencyMap.get("currencyId"), rowIndex);
            model.setValue("accexchangerate", currencyMap.get("exchangeRate"), rowIndex);
            model.setValue("receiveamount", approveCurrAmount, rowIndex);
            model.setValue("orireceiveamount", (Object)approveOriAmount, rowIndex);
            model.setValue("accnotpayamount", approveCurrAmount, rowIndex);
            model.setValue("oriaccnotpayamount", (Object)approveOriAmount, rowIndex);
        });
        return failedIds;
    }
}

