/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.kingdee;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.concurrency.KdForkJoinWorkerThreadFactory;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceStatusEnum;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.kingdee.QueryInvoiceDetailBO;
import kd.fi.er.business.invoicecloud.kingdee.UserKeyAction;
import kd.fi.er.business.invoicecloud.kingdee.action.AbstractAction;
import kd.fi.er.business.invoicecloud.kingdee.action.QueryBySerialNoAction;
import kd.fi.er.business.invoicecloud.kingdee.action.QueryTemplateInvoiceFileAction;
import kd.fi.er.business.invoicecloud.kingdee.action.SelectInvoiceAction;
import kd.fi.er.business.invoicecloud.kingdee.action.TokenAction;
import kd.fi.er.business.invoicecloud.model.AWSInvoiceData;
import kd.fi.er.business.invoicecloud.provider.param.req.DeleteInvoiceReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.UpdateInvoiceStatusReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.ValidateInvocieReqParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.DeleteInvoiceRespParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.UpdateInvoiceStatusRespParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.ValidateInvocieRespParam;
import kd.fi.er.business.invoicecloud.provider.service.CommonInvoiceService;
import kd.fi.er.business.invoicecloud.provider.service.factory.InvoiceServiceFactory;
import kd.fi.er.business.invoicecloud.request.bean.CommonUserKeyRequestParam;
import kd.fi.er.business.invoicecloud.request.bean.CommonUserKeyRespParam;
import kd.fi.er.business.invoicecloud.request.bean.EventCodeReqBean;
import kd.fi.er.business.invoicecloud.request.bean.EventCodeRespBean;
import kd.fi.er.business.invoicecloud.v2.util.AllInvoiceUrl;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;
import kd.fi.er.common.model.invoice.AttachVo;
import kd.fi.er.common.model.invoice.InvoiceAttachmentVo;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.fi.er.common.model.invoice.Response;
import kd.fi.er.common.utils.Er;
import kd.fi.er.common.utils.MD5;
import kd.sdk.fi.er.extpoint.invoicecloud.AfterSelectInvoice;
import org.apache.commons.lang3.StringUtils;

public class APIHelper {
    private static Log logger = LogFactory.getLog(APIHelper.class);
    private static final String LOGSTRING = "APIHelper>>> ";
    public static final ForkJoinPool.ForkJoinWorkerThreadFactory kdForkJoinWorkerThreadFactory = new KdForkJoinWorkerThreadFactory();
    private static final Map<String, String> sscBillToNormalBill = new HashMap<String, String>();

    public static String fetchSerialNo(String msg) {
        Map originData = (Map)Er.jsonToObj((String)msg, Map.class);
        return APIHelper.fetchSerialNo(originData);
    }

    public static String fetchSerialNo(Map originData) {
        List rawInvoiceData;
        Map data = (Map)originData.get("data");
        if (data.get("invoicesData") != null) {
            rawInvoiceData = (List)data.get("invoicesData");
        } else if (data.get("invoiceData") != null) {
            rawInvoiceData = (List)data.get("invoiceData");
        } else {
            logger.error(String.format("\u9009\u62e9\u53d1\u7968\u524d\u7aef\u8fd4\u56de\u7684msg\u4e2d\uff0c\u6ca1\u6709invoiceData\u548cinvoicesData: %s", Er.objToJson((Object)originData)));
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u8fd4\u56de\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"APIHelper_0", (String)"fi-er-business", (Object[])new Object[0]));
        }
        return rawInvoiceData.stream().map(v -> v.get("serialNo").toString()).collect(Collectors.joining(","));
    }

    @Deprecated
    public static List<Map> queryRawBySerialNo(String taxRegNum, String serialNo) {
        QueryBySerialNoAction action = new QueryBySerialNoAction(serialNo);
        Map response = APIHelper.invokeAction(taxRegNum, (AbstractAction)action);
        return (List)response.get("data");
    }

    public static List<InvoiceVO> queryInvoiceDetailBySerialNo(QueryInvoiceDetailBO queryBO) throws Exception {
        return APIHelper.queryInvoiceDetailBySerialNo(queryBO, null);
    }

    public static List<InvoiceVO> queryInvoiceDetailBySerialNo(QueryInvoiceDetailBO queryBO, PluginProxy<AfterSelectInvoice> afterSelectInvoicePluginProxy) throws Exception {
        CommonInvoiceService commonInvoiceService = InvoiceServiceFactory.getSingletonService(CommonInvoiceService.class);
        if (commonInvoiceService == null) {
            logger.info("\u3010\u53d1\u7968\u4e91\u3011\u672a\u627e\u5230CommonInvoiceService\u670d\u52a1\u3002");
            return new ArrayList<InvoiceVO>();
        }
        List<InvoiceVO> result = commonInvoiceService.batchQueryInvoiceVosBySerialNos(queryBO, afterSelectInvoicePluginProxy);
        logger.info("\u3010\u53d1\u7968\u4e91\u3011\u5408\u5e76\u540e\u67e5\u8be2\u5230\u7684\u53d1\u7968\u4fe1\u606f\u4e3a: " + JSONArray.toJSONString(result));
        return result;
    }

    @Deprecated
    private static Map invokeAction(String taxRegNum, AbstractAction action) {
        String raw_response = action.execute();
        Map response = APIHelper.handleRawResponse(raw_response, taxRegNum, action, false);
        return response;
    }

    private static Map invokeAction(Long orgId, AbstractAction action) {
        Map response;
        try {
            String raw_response = action.execute();
            response = APIHelper.handleRawResponse(raw_response, orgId, action, false);
        }
        catch (Exception e) {
            logger.error("\u3010\u53d1\u7968\u4e91\u3011" + e, (Throwable)e);
            throw e;
        }
        return response;
    }

    @Deprecated
    public static String getToken(String taxRegNum) {
        String errcode;
        if (ErStdConfig.getBoolean("intranet")) {
            return "whatever";
        }
        TokenAction tokenAction = new TokenAction(taxRegNum);
        String raw_response = tokenAction.execute();
        Map response = (Map)Er.jsonToObj((String)raw_response, Map.class);
        if (response != null && response.get("errcode") != null && (errcode = response.get("errcode").toString()).equals("0000")) {
            String access_token = (String)response.get("access_token");
            return access_token;
        }
        String description = null;
        if (response != null) {
            description = String.valueOf(response.get("description"));
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25\uff0c\u4f01\u4e1a\u7a0e\u53f7: %1$s\uff0c\u5931\u8d25\u539f\u56e0: %2$s", (String)"APIHelper_37", (String)"fi-er-business", (Object[])new Object[0]), taxRegNum, description));
    }

    public static String getCacheToken(Long orgId, boolean needRefresh) throws KDBizException {
        String token;
        if (needRefresh) {
            AppCache.get((String)"er").remove("invoicetoken" + orgId);
        }
        if (StringUtils.isNotEmpty((CharSequence)(token = (String)AppCache.get((String)"er").get("invoicetoken" + orgId, String.class)))) {
            logger.info("\u3010\u53d1\u7968\u4e91\u3011\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6token");
            return token;
        }
        try {
            token = APIHelper.getToken(orgId);
            return token;
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
            Exception e = exception;
            if (StringUtils.isNotEmpty((CharSequence)token)) {
                logger.info("\u3010\u53d1\u7968\u4e91\u3011\u7f13\u5b58token ");
                AppCache.get((String)"er").put("invoicetoken" + orgId, (Object)token);
                return token;
            }
            if (e != null) {
                throw new KDBizException(e.toString());
            }
            return token;
        }
    }

    public static String getToken(Long orgId) {
        String errcode;
        if (ErStdConfig.getBoolean("intranet")) {
            return "whatever";
        }
        TokenAction tokenAction = new TokenAction(orgId);
        String raw_response = tokenAction.execute();
        Map response = (Map)Er.jsonToObj((String)raw_response, Map.class);
        if (response != null && response.get("errcode") != null && (errcode = response.get("errcode").toString()).equals("0000")) {
            logger.info("\u3010\u8c03\u7528\u53d1\u7968\u4e91\u3011\u83b7\u53d6token\u6210\u529f");
            String access_token = (String)response.get("access_token");
            return access_token;
        }
        String description = null;
        if (response != null) {
            description = String.valueOf(response.get("description"));
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25\u3002\u516c\u53f8ID\uff1a%1$s\uff0c\u5931\u8d25\u539f\u56e0\uff1a%2$s", (String)"APIHelper_29", (String)"fi-er-business", (Object[])new Object[0]), orgId.toString(), description));
    }

    @Deprecated
    public static String getUserKey(String taxRegNum, String userId, String bxdKey) {
        if (ErStdConfig.getBoolean("intranet")) {
            return "whatever";
        }
        UserKeyAction userKeyAction = new UserKeyAction(taxRegNum, userId, bxdKey);
        Map response = APIHelper.invokeAction(taxRegNum, (AbstractAction)userKeyAction);
        Map data = (Map)response.get("data");
        return data.get("userKey").toString();
    }

    public static String getUserKey(Long orgId, String userId, String bxdKey) {
        if (ErStdConfig.getBoolean("intranet")) {
            return "whatever";
        }
        UserKeyAction userKeyAction = new UserKeyAction(orgId, userId, bxdKey);
        Map response = APIHelper.invokeAction(orgId, (AbstractAction)userKeyAction);
        Map data = (Map)response.get("data");
        return data.get("userKey").toString();
    }

    @Deprecated
    public static UpdateInvoiceStatusRespParam updateInvoiceStatus(String taxRegNum, InvoiceStatusEnum invoiceStatus, String billTypeAndId, String serialNo, String billNumber) throws Exception {
        UpdateInvoiceStatusRespParam updateInvoiceStatusRespParam = new UpdateInvoiceStatusRespParam();
        updateInvoiceStatusRespParam.setErrcode("0000");
        if (ErStdConfig.getBoolean("intranet")) {
            logger.info("\u3010\u5355\u636e\u64cd\u4f5c\u3011\u5185\u7f51\u6a21\u5f0f");
            return updateInvoiceStatusRespParam;
        }
        if (StringUtils.isBlank((CharSequence)serialNo)) {
            serialNo = "";
        }
        List<String> serialNoSet = Arrays.stream(serialNo.split(",")).filter(s -> StringUtils.isNotBlank((CharSequence)s)).collect(Collectors.toList());
        UpdateInvoiceStatusReqParam request = new UpdateInvoiceStatusReqParam();
        request.setBillId(billTypeAndId);
        request.setBillNumber(billNumber);
        request.setInvoiceStatus(invoiceStatus);
        request.setSerialNos(serialNoSet);
        ArrayList awsInvoiceDatas = Lists.newArrayListWithExpectedSize((int)request.getSerialNos().size());
        for (String sNo : serialNoSet) {
            AWSInvoiceData awsInvoiceData = new AWSInvoiceData();
            awsInvoiceData.setSerialNo(sNo);
            awsInvoiceDatas.add(awsInvoiceData);
        }
        request.setInvoiceData(awsInvoiceDatas);
        request.setTaxRegNum(taxRegNum);
        request.setTicketParam(KingdeeInvoiceCloudConfig.getTicketParam(taxRegNum));
        return APIHelper.updateInvoiceStatus(request);
    }

    public static UpdateInvoiceStatusRespParam updateInvoiceStatus(InvoiceCloudCfgBO invoiceCloudCfgBO, InvoiceStatusEnum invoiceStatus, String billTypeAndId, String serialNo, String billNumber) throws Exception {
        UpdateInvoiceStatusRespParam updateInvoiceStatusRespParam = new UpdateInvoiceStatusRespParam();
        updateInvoiceStatusRespParam.setErrcode("0000");
        if (StringUtils.isBlank((CharSequence)serialNo)) {
            serialNo = "";
        }
        if (invoiceCloudCfgBO == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u542f\u7528\u53d1\u7968\u4e91\uff0c\u8bf7\u5148\u914d\u7f6e\u53d1\u7968\u4e91\u3002", (String)"APIHelper_22", (String)"fi-er-business", (Object[])new Object[0]));
        }
        List<String> serialNoSet = Arrays.stream(serialNo.split(",")).filter(s -> StringUtils.isNotBlank((CharSequence)s)).collect(Collectors.toList());
        UpdateInvoiceStatusReqParam request = new UpdateInvoiceStatusReqParam();
        request.setBillId(billTypeAndId);
        request.setBillNumber(billNumber);
        request.setInvoiceStatus(invoiceStatus);
        request.setSerialNos(serialNoSet);
        ArrayList awsInvoiceDatas = Lists.newArrayListWithExpectedSize((int)request.getSerialNos().size());
        for (String sNo : serialNoSet) {
            AWSInvoiceData awsInvoiceData = new AWSInvoiceData();
            awsInvoiceData.setSerialNo(sNo);
            awsInvoiceDatas.add(awsInvoiceData);
        }
        request.setInvoiceData(awsInvoiceDatas);
        request.setTaxRegNum(invoiceCloudCfgBO.getTaxRegnum());
        request.setTicketParam(invoiceCloudCfgBO.genTicketParam());
        request.setOrgId(invoiceCloudCfgBO.getInvoiceOrgId());
        return APIHelper.updateInvoiceStatus(request);
    }

    public static UpdateInvoiceStatusRespParam updateInvoiceStatus(UpdateInvoiceStatusReqParam request) throws Exception {
        UpdateInvoiceStatusRespParam updateInvoiceStatusRespParam = new UpdateInvoiceStatusRespParam();
        updateInvoiceStatusRespParam.setErrcode("0000");
        CommonInvoiceService commonInvoiceService = InvoiceServiceFactory.getSingletonService(CommonInvoiceService.class);
        if (commonInvoiceService == null) {
            logger.info("\u3010\u53d1\u7968\u4e91\u3011\u672a\u627e\u5230CommonInvoiceService\u670d\u52a1\u3002");
            return updateInvoiceStatusRespParam;
        }
        updateInvoiceStatusRespParam = commonInvoiceService.updateInvoiceStatus(request);
        return updateInvoiceStatusRespParam;
    }

    @Deprecated
    public static DeleteInvoiceRespParam del(String taxRegNum, String billId) throws InvoiceCloudException {
        if (ErStdConfig.isDev()) {
            DeleteInvoiceRespParam deleteInvoiceRespParam = new DeleteInvoiceRespParam();
            deleteInvoiceRespParam.setErrcode("0000");
            return deleteInvoiceRespParam;
        }
        DeleteInvoiceReqParam request = new DeleteInvoiceReqParam();
        CommonInvoiceService commonInvoiceService = InvoiceServiceFactory.getSingletonService(CommonInvoiceService.class);
        if (commonInvoiceService == null) {
            logger.info("\u3010\u53d1\u7968\u4e91\u3011\u672a\u627e\u5230CommonInvoiceService\u670d\u52a1\u3002");
            return new DeleteInvoiceRespParam();
        }
        request.setBillId(billId);
        request.setTaxRegNum(taxRegNum);
        return commonInvoiceService.deleteInvoicesByBillId(request);
    }

    @Deprecated
    public static DeleteInvoiceRespParam del(Long invoiceOrgId, String billId) throws InvoiceCloudException {
        return APIHelper.del(new DeleteInvoiceReqParam(), invoiceOrgId, billId);
    }

    public static DeleteInvoiceRespParam del(DeleteInvoiceReqParam request, Long invoiceOrgId, String billId) throws InvoiceCloudException {
        if (ErStdConfig.isDev()) {
            DeleteInvoiceRespParam deleteInvoiceRespParam = new DeleteInvoiceRespParam();
            deleteInvoiceRespParam.setErrcode("0000");
            return deleteInvoiceRespParam;
        }
        CommonInvoiceService commonInvoiceService = InvoiceServiceFactory.getSingletonService(CommonInvoiceService.class);
        if (commonInvoiceService == null) {
            logger.info("\u3010\u53d1\u7968\u4e91\u3011\u672a\u627e\u5230CommonInvoiceService\u670d\u52a1\u3002");
            return new DeleteInvoiceRespParam();
        }
        request.setBillId(billId);
        request.setTaxRegNum(KingdeeInvoiceCloudConfig.getTaxRegNum(invoiceOrgId));
        request.setOrgId(invoiceOrgId);
        return commonInvoiceService.deleteInvoicesByBillId(request);
    }

    @Deprecated
    public static Map selectInvoice(String taxRegNum, String batchNumber, String eid, String ticketParam) {
        try {
            SelectInvoiceAction action = new SelectInvoiceAction(batchNumber, eid, ticketParam);
            return APIHelper.invokeAction(taxRegNum, (AbstractAction)action);
        }
        catch (KDBizException e) {
            return null;
        }
    }

    @Deprecated
    private static Map handleRawResponse(String raw_response, String taxRegNum, AbstractAction action, boolean reInvoke) {
        String errMsg = ResManager.loadKDString((String)"\u539f\u56e0\u4e0d\u660e", (String)"APIHelper_4", (String)"fi-er-business", (Object[])new Object[0]);
        Map response = null;
        try {
            response = (Map)Er.jsonToObj((String)raw_response, Map.class);
        }
        catch (Exception e) {
            errMsg = ResManager.loadKDString((String)"\u54cd\u5e94\u4fe1\u606f\u89e3\u6790\u51fa\u9519\u3002", (String)"APIHelper_5", (String)"fi-er-business", (Object[])new Object[0]);
            logger.error("\u54cd\u5e94\u4fe1\u606f\u89e3\u6790\u51fa\u9519", (Throwable)e);
        }
        if (response != null && response.get("errcode") != null) {
            String errcode = response.get("errcode").toString();
            if (errcode.equals("0000")) {
                logger.info("\u3010\u8c03\u7528\u53d1\u7968\u4e91\u3011\u6210\u529f");
                return response;
            }
            if (response.get("description") != null) {
                errMsg = response.get("description").toString();
            }
        }
        StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u201c\u8c03\u7528\u53d1\u7968\u4e91\u201d\u5931\u8d25\uff0c\u9519\u8bef\u63cf\u8ff0: %1$s", (String)"APIHelper_30", (String)"fi-er-business", (Object[])new Object[0])).append(System.lineSeparator()).append(ResManager.loadKDString((String)"\u8c03\u7528\u4fe1\u606f: %2$s", (String)"APIHelper_31", (String)"fi-er-business", (Object[])new Object[0])).append(System.lineSeparator()).append(ResManager.loadKDString((String)"\u54cd\u5e94\u4fe1\u606f: %3$s", (String)"APIHelper_32", (String)"fi-er-business", (Object[])new Object[0]));
        String logfmt = sb.toString();
        logger.info(String.format(logfmt, errMsg, action.desc(), raw_response));
        String msgfmt = ResManager.loadKDString((String)"\u8c03\u7528\u53d1\u7968\u4e91\u5931\u8d25\uff0c%s\u3002", (String)"APIHelper_11", (String)"fi-er-business", (Object[])new Object[0]);
        throw new KDBizException(String.format(msgfmt, errMsg));
    }

    private static Map handleRawResponse(String raw_response, Long orgId, AbstractAction action, boolean reInvoke) {
        String errMsg = ResManager.loadKDString((String)"\u539f\u56e0\u4e0d\u660e", (String)"APIHelper_4", (String)"fi-er-business", (Object[])new Object[0]);
        Map response = null;
        try {
            response = (Map)Er.jsonToObj((String)raw_response, Map.class);
        }
        catch (Exception e) {
            errMsg = ResManager.loadKDString((String)"\u54cd\u5e94\u4fe1\u606f\u89e3\u6790\u51fa\u9519\u3002", (String)"APIHelper_5", (String)"fi-er-business", (Object[])new Object[0]);
            logger.error("\u54cd\u5e94\u4fe1\u606f\u89e3\u6790\u51fa\u9519", (Throwable)e);
        }
        if (response != null && response.get("errcode") != null) {
            String errcode = response.get("errcode").toString();
            if (errcode.equals("0000")) {
                logger.info("\u3010\u8c03\u7528\u53d1\u7968\u4e91\u3011\u6210\u529f");
                return response;
            }
            if (response.get("description") != null) {
                errMsg = response.get("description").toString();
            }
        }
        StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u201c\u8c03\u7528\u53d1\u7968\u4e91\u201d\u5931\u8d25\uff0c\u9519\u8bef\u63cf\u8ff0: %1$s", (String)"APIHelper_30", (String)"fi-er-business", (Object[])new Object[0])).append(System.lineSeparator()).append(ResManager.loadKDString((String)"\u8c03\u7528\u4fe1\u606f: %2$s", (String)"APIHelper_31", (String)"fi-er-business", (Object[])new Object[0])).append(System.lineSeparator()).append(ResManager.loadKDString((String)"\u54cd\u5e94\u4fe1\u606f: %3$s", (String)"APIHelper_32", (String)"fi-er-business", (Object[])new Object[0]));
        String logfmt = sb.toString();
        logger.info(String.format(logfmt, errMsg, action.desc(), raw_response));
        String msgfmt = ResManager.loadKDString((String)"\u8c03\u7528\u53d1\u7968\u4e91\u5931\u8d25\uff0c%s\u3002", (String)"APIHelper_11", (String)"fi-er-business", (Object[])new Object[0]);
        throw new KDBizException(String.format(msgfmt, errMsg));
    }

    public static String getBillNoCachedInCloud(DynamicObject dataEntity) {
        String entityName = dataEntity.getDynamicObjectType().getName();
        entityName = sscBillToNormalBill.getOrDefault(entityName, entityName);
        if (dataEntity.getDataEntityType().getProperties().get((Object)"id") != null) {
            Long id = dataEntity.getLong("id");
            if (id == null || Objects.equal((Object)id, (Object)0L)) {
                id = ORM.create().genLongId(dataEntity.getDataEntityType());
                dataEntity.set("id", (Object)id);
            }
            return entityName + "_" + id;
        }
        String uid = UUID.randomUUID().toString().replace("-", "");
        logger.warn("entityName: " + entityName + ", \u4e0d\u5b58\u5728id\u5c5e\u6027, \u4ee5uuid\u4ee3\u66ff: " + uid);
        return entityName + "_" + uid;
    }

    public static String fetchSerialNosFromResOfMiniProgram(String msg) {
        logger.info("\u89e3\u6790\u4e91\u4e4b\u5bb6\u8c03\u7528\u5c0f\u7a0b\u5e8f\u7684\u8fd4\u56de: " + msg);
        if (ErStdConfig.getBoolean("intranet")) {
            return "ssssss";
        }
        JSONObject yzj = JSON.parseObject((String)msg);
        String errMsg = ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"APIHelper_12", (String)"fi-er-business", (Object[])new Object[0]);
        StringBuilder errStrBuilder = new StringBuilder(errMsg);
        if (yzj.get((Object)"success") != null) {
            if (!Boolean.parseBoolean(yzj.get((Object)"success").toString())) {
                if (yzj.get((Object)"errorCode") != null && yzj.get((Object)"errorCode").toString().equals("404")) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7248\u672c\u4e0d\u652f\u6301\u5c0f\u7a0b\u5e8f\u8c03\u7528\uff0c\u8bf7\u5347\u7ea7\u4e91\u4e4b\u5bb6\u3002", (String)"APIHelper_13", (String)"fi-er-business", (Object[])new Object[0]));
                }
                if (yzj.get((Object)"error") != null) {
                    errMsg = ResManager.loadKDString((String)"\u539f\u56e0\uff1a", (String)"APIHelper_14", (String)"fi-er-business", (Object[])new Object[0]);
                    errStrBuilder.append(errMsg).append(yzj.get((Object)"error"));
                }
            } else {
                JSONObject yzjData = yzj.getJSONObject("data");
                Object invoiceCloudRawRes = yzjData.get((Object)"extraData");
                if (invoiceCloudRawRes == null) {
                    return null;
                }
                JSONObject data = null;
                data = invoiceCloudRawRes instanceof String ? JSON.parseObject((String)invoiceCloudRawRes.toString()).getJSONObject("data") : ((JSONObject)invoiceCloudRawRes).getJSONObject("data");
                if (data != null && data.getString("serialNos") != null) {
                    return data.getString("serialNos");
                }
                return null;
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89e3\u6790\u4e91\u4e4b\u5bb6\u8c03\u53d1\u7968\u4e91\u5c0f\u7a0b\u5e8f\u7684\u8fd4\u56de\u7ed3\u679c\u65f6\u51fa\u9519\uff1a%s", (String)"APIHelper_33", (String)"fi-er-business", (Object[])new Object[0]), errStrBuilder));
    }

    @Deprecated
    public static void putSerialNosToInvoiceCloudCache(String taxRegNum, String key, Collection<String> serialNos) throws Exception {
        logger.info("\u5c06\u5982\u4e0b\u6570\u636e\u5b58\u50a8\u5230\u53d1\u7968\u4e91\u7684\u7f13\u5b58\u4e2d>>>key:" + key + ", serialNos:" + serialNos);
        APIHelper.updateInvoiceStatus(taxRegNum, InvoiceStatusEnum.save, key, StringUtils.join(serialNos, (String)","), key);
    }

    public static void putSerialNosToInvoiceCloudCache(InvoiceCloudCfgBO config, String key, Collection<String> serialNos) throws Exception {
        logger.info("\u5c06\u5982\u4e0b\u6570\u636e\u5b58\u50a8\u5230\u53d1\u7968\u4e91\u7684\u7f13\u5b58\u4e2d>>>key:" + key + ", serialNos:" + serialNos);
        APIHelper.updateInvoiceStatus(config, InvoiceStatusEnum.save, key, StringUtils.join(serialNos, (String)","), key);
    }

    public static String post(String url, String jsonReq, String desc) {
        String response = KingdeeInvoiceCloudConfig.checkHttpsCertificate() ? HttpServiceHelper.doPost_returnOriginResponse(url, jsonReq) : HttpServiceHelper.doPost_noVerify(desc, url, null, jsonReq);
        return response;
    }

    @Deprecated
    public static String getEventCode(String taxRegNum, Collection<String> invoiceSerialNos, Collection<String> certifacateSerialNos) throws InvoiceCloudException {
        EventCodeReqBean eventCodeReqBean = new EventCodeReqBean();
        String clientId = KingdeeInvoiceCloudConfig.getClientId(taxRegNum);
        String clientSecret = KingdeeInvoiceCloudConfig.getClientSecret(taxRegNum);
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = MD5.md5crypt((String)(clientId + clientSecret + timestamp));
        eventCodeReqBean.setClient_id(clientId);
        eventCodeReqBean.setSign(sign);
        eventCodeReqBean.setTimestamp(timestamp);
        eventCodeReqBean.setType("EXPENSE_SERIALNO_QUERY");
        EventCodeReqBean.Data data = new EventCodeReqBean.Data();
        data.setInvoiceSerialNos((List<String>)(invoiceSerialNos != null ? invoiceSerialNos.stream().collect(Collectors.toList()) : Lists.newArrayList()));
        data.setCertifacateSerialNos((List<String>)(certifacateSerialNos != null ? certifacateSerialNos.stream().collect(Collectors.toList()) : Lists.newArrayList()));
        eventCodeReqBean.setData(data);
        eventCodeReqBean.setTicketParam(KingdeeInvoiceCloudConfig.getTicketParam(taxRegNum));
        int repeat = 3;
        long sleepMilliseconds = 1000L;
        for (int i = 1; i <= repeat; ++i) {
            String resp = null;
            try {
                resp = APIHelper.post(AllInvoiceUrl.eventCodeUrl(), JSON.toJSONString((Object)eventCodeReqBean), ResManager.loadKDString((String)"\u7b2c", (String)"APIHelper_18", (String)"fi-er-business", (Object[])new Object[0]) + i + ResManager.loadKDString((String)"\u6b21\u83b7\u53d6\u53d1\u7968\u6d41\u6c34\u53f7\u548c\u9644\u4ef6\u6d41\u6c34\u53f7\u5bf9\u5e94\u7684event_code", (String)"APIHelper_19", (String)"fi-er-business", (Object[])new Object[0]));
            }
            catch (Exception e) {
                if (i == repeat) {
                    logger.error((Throwable)e);
                    throw new InvoiceCloudException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u63a5\u53e3\u8bbf\u95ee\u5f02\u5e38\u3002", (String)"APIHelper_20", (String)"fi-er-business", (Object[])new Object[0]), (Throwable)e);
                }
                try {
                    Thread.sleep(sleepMilliseconds);
                }
                catch (InterruptedException e1) {
                    logger.error((Throwable)e1);
                }
                continue;
            }
            EventCodeRespBean eventCodeRespBean = (EventCodeRespBean)JSON.parseObject((String)resp, EventCodeRespBean.class);
            int errcode = 1000;
            if (Integer.parseInt(eventCodeRespBean.getErrcode()) <= errcode) {
                return eventCodeRespBean.getEvent_code();
            }
            logger.info(resp);
            throw new InvoiceCloudException(eventCodeRespBean.getDescription());
        }
        return null;
    }

    public static String getEventCode(Long orgId, Collection<String> invoiceSerialNos, Collection<String> certifacateSerialNos) throws InvoiceCloudException {
        EventCodeReqBean eventCodeReqBean = new EventCodeReqBean();
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(orgId);
        String clientId = config.getClientId();
        String clientSecret = config.getClientSecret();
        String ticketParam = config.genTicketParam();
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = MD5.md5crypt((String)(clientId + clientSecret + timestamp));
        eventCodeReqBean.setClient_id(clientId);
        eventCodeReqBean.setSign(sign);
        eventCodeReqBean.setTimestamp(timestamp);
        eventCodeReqBean.setType("EXPENSE_SERIALNO_QUERY");
        EventCodeReqBean.Data data = new EventCodeReqBean.Data();
        data.setInvoiceSerialNos((List<String>)(invoiceSerialNos != null ? invoiceSerialNos.stream().collect(Collectors.toList()) : Lists.newArrayList()));
        data.setCertifacateSerialNos((List<String>)(certifacateSerialNos != null ? certifacateSerialNos.stream().collect(Collectors.toList()) : Lists.newArrayList()));
        eventCodeReqBean.setData(data);
        eventCodeReqBean.setTicketParam(ticketParam);
        int repeat = 3;
        long sleepMilliseconds = 1000L;
        for (int i = 1; i <= repeat; ++i) {
            String resp = null;
            try {
                resp = APIHelper.post(AllInvoiceUrl.eventCodeUrl(), JSON.toJSONString((Object)eventCodeReqBean), new StringBuffer(ResManager.loadKDString((String)"\u7b2c", (String)"APIHelper_18", (String)"fi-er-business", (Object[])new Object[0])).append(i).append(ResManager.loadKDString((String)"\u6b21\u83b7\u53d6\u53d1\u7968\u6d41\u6c34\u53f7\u548c\u9644\u4ef6\u6d41\u6c34\u53f7\u5bf9\u5e94\u7684event_code", (String)"APIHelper_19", (String)"fi-er-business", (Object[])new Object[0])).toString());
            }
            catch (Exception e) {
                if (i == repeat) {
                    logger.error((Throwable)e);
                    throw new InvoiceCloudException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u63a5\u53e3\u8bbf\u95ee\u5f02\u5e38\u3002", (String)"APIHelper_20", (String)"fi-er-business", (Object[])new Object[0]), (Throwable)e);
                }
                try {
                    Thread.sleep(sleepMilliseconds);
                }
                catch (InterruptedException e1) {
                    logger.error((Throwable)e1);
                }
                continue;
            }
            EventCodeRespBean eventCodeRespBean = (EventCodeRespBean)JSON.parseObject((String)resp, EventCodeRespBean.class);
            int errcode = 1000;
            if (Integer.parseInt(eventCodeRespBean.getErrcode()) <= errcode) {
                return eventCodeRespBean.getEvent_code();
            }
            logger.info(resp);
            throw new InvoiceCloudException(eventCodeRespBean.getDescription());
        }
        return null;
    }

    public static List<AttachVo> queryInvoiceAttach(DynamicObject dataEntity) {
        if (ErStdConfig.isDev()) {
            return Collections.emptyList();
        }
        Long billId = ErCommonUtils.getPk(dataEntity);
        String billNo = dataEntity.getString("billno");
        String entityName = dataEntity.getDataEntityType().getName();
        String costCompanyField = entityName.equals("er_checkingpaybill") ? "company" : "costcompany";
        Long costCompany = ErCommonUtils.getPk(dataEntity.getDynamicObject(costCompanyField));
        String bxdKey = entityName + "_" + billId;
        return APIHelper.queryInvoiceAttach(dataEntity.getDataEntityType().getName(), billId, billNo, costCompany);
    }

    public static List<AttachVo> queryInvoiceAttach(String entityName, Long billId, String billNo, Long costCompanyId) {
        String bxdKey = entityName + "_" + billId;
        String userKey = null;
        try {
            userKey = APIHelper.getCommonUserKey(costCompanyId, bxdKey, billNo);
        }
        catch (InvoiceCloudException e) {
            logger.error((Throwable)e);
            return Collections.emptyList();
        }
        String url = AllInvoiceUrl.getQueryAttachUrl();
        HashMap<String, String> requestParam = new HashMap<String, String>();
        requestParam.put("userKey", userKey);
        String data = HttpServiceHelper.doGet(url, requestParam);
        logger.info(String.format("\u5355\u636e(%s)\u3010\u53d1\u7968\u4e91\u3011\u67e5\u8be2\u9644\u4ef6\u8fd4\u56de\u6570\u636e: %s", bxdKey, data));
        try {
            List r = Response.parseInvoiceData((String)data);
            return r;
        }
        catch (InvoiceCloudException e) {
            logger.error((Throwable)e);
            return Collections.emptyList();
        }
    }

    public static String getCommonUserKey(Long costCompany, String bxdKey, String billNo) throws InvoiceCloudException {
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(costCompany);
        if (config == null) {
            throw new InvoiceCloudException(ResManager.loadKDString((String)"\u5f53\u524d\u8d39\u7528\u627f\u62c5\u516c\u53f8\u7684\u53d1\u7968\u4e91\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"APIHelper_38", (String)"fi-er-business", (Object[])new Object[0]));
        }
        CommonUserKeyRequestParam requestParam = CommonUserKeyRequestParam.buildUserKeyRequestParam(config, bxdKey, billNo);
        return APIHelper.getCommonUserKey(requestParam);
    }

    public static String getCommonUserKey(CommonUserKeyRequestParam userKeyRequestParamParam) throws InvoiceCloudException {
        String url = AllInvoiceUrl.getCommonUserKey();
        String userKeyResp = HttpServiceHelper.doPost_noVerify(ResManager.loadKDString((String)"\u83b7\u53d6userKey", (String)"APIHelper_21", (String)"fi-er-business", (Object[])new Object[0]), url, null, JSON.toJSONString((Object)userKeyRequestParamParam));
        logger.info("commonUserKey resp" + userKeyResp);
        CommonUserKeyRespParam respParam = (CommonUserKeyRespParam)JSON.parseObject((String)userKeyResp, CommonUserKeyRespParam.class);
        if (StringUtils.equals((CharSequence)respParam.getErrcode().trim(), (CharSequence)"0000")) {
            return respParam.getData().getUserKey();
        }
        throw new InvoiceCloudException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6userKey\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"APIHelper_34", (String)"fi-er-business", (Object[])new Object[0]), respParam.getDescription() + ", code:" + respParam.getErrcode()));
    }

    public static String uploadImage(String uploadUrl, String userKey) throws InvoiceCloudException {
        JSONObject data;
        boolean isSuccess;
        String url = AllInvoiceUrl.upload();
        JSONObject param = new JSONObject();
        param.put("uploadUrl", (Object)uploadUrl);
        param.put("userKey", (Object)userKey);
        long stracttime = System.currentTimeMillis();
        String responseStr = HttpServiceHelper.doPost_noVerify(ResManager.loadKDString((String)"\u5c06\u5f71\u50cf\u5730\u5740\u4e0a\u4f20\u81f3\u91c7\u96c6\u63a5\u53e3\u3002", (String)"APIHelper_39", (String)"fi-er-business", (Object[])new Object[0]), url, null, JSON.toJSONString((Object)param));
        long endtime = System.currentTimeMillis();
        logger.info("\u5f71\u50cf\u5730\u5740\u4e0a\u4f20\u91c7\u96c6\u63a5\u53e3\u8017\u65f6" + (endtime - stracttime) + "uploadImage resp" + responseStr);
        JSONObject respone = (JSONObject)JSON.parseObject((String)responseStr, JSONObject.class);
        boolean bl = isSuccess = !respone.isEmpty() && StringUtils.equals((CharSequence)respone.getString("errcode"), (CharSequence)"0000");
        if (isSuccess && (data = respone.getJSONArray("data").getJSONObject(0)) != null) {
            String serialno = data.getString("serialNo");
            return serialno;
        }
        throw new InvoiceCloudException(String.format(ResManager.loadKDString((String)"\u5c06\u5f71\u50cf\u5730\u5740\u4e0a\u4f20\u81f3\u91c7\u96c6\u63a5\u53e3\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a%1$s\uff0c\u53d1\u7968\u4e91\u8fd4\u56decode\u4e3a\uff1a%2$s\uff0ctraceid\u4e3a\uff1a%3$s\u3002", (String)"APIHelper_35", (String)"fi-er-business", (Object[])new Object[0]), respone.getString("description"), respone.getString("errcode"), RequestContext.get().getTraceId()));
    }

    public static ValidateInvocieRespParam validateInvoice(ValidateInvocieReqParam validateInvoiceReqParam) throws Exception {
        return InvoiceService.getInstanceService().validateInvoice(validateInvoiceReqParam, null);
    }

    public static JSONObject getTempInvoiceFiles(DynamicObject dataEntity, long orgId) {
        String attachmentUrl;
        if (dataEntity == null) {
            logger.info("APIHelper_getInoviceFiles>>> [dataEntity is null]");
            return null;
        }
        String expenseId = APIHelper.getBillNoCachedInCloud(dataEntity);
        if (StringUtils.isEmpty((CharSequence)expenseId)) {
            logger.info("APIHelper>>> expenseId \u83b7\u53d6\u5931\u8d25");
            return null;
        }
        DynamicObject applier = dataEntity.getDynamicObject("applier");
        Long applierId = 0L;
        if (applier != null) {
            applierId = ErCommonUtils.getPk(applier);
        }
        if (StringUtils.isEmpty((CharSequence)(attachmentUrl = KingdeeInvoiceCloudConfig.getInvoiceAttachmentAPIURL()))) {
            logger.info("APIHelper>>> \u540c\u6b65\u53d1\u7968\u9644\u4ef6\uff1aer_stdconfig \u672a\u914d\u7f6e\u53d1\u7968\u4e91\u9644\u4ef6api\u5730\u5740");
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u53d1\u7968\u9644\u4ef6\uff1aer_stdconfig \u672a\u914d\u7f6e\u53d1\u7968\u4e91\u9644\u4ef6api\u5730\u5740\u3002", (String)"APIHelper_23", (String)"fi-er-business", (Object[])new Object[0]));
        }
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(orgId);
        if (config == null || StringUtils.isEmpty((CharSequence)config.getTaxRegnum())) {
            logger.info("APIHelper>>> \u540c\u6b65\u53d1\u7968\u9644\u4ef6\uff1a\u7ec4\u7ec7: " + orgId + "\u672a\u53d6\u5230\u4f01\u4e1a\u7a0e\u53f7");
            String format = ResManager.loadKDString((String)"\u540c\u6b65\u53d1\u7968\u9644\u4ef6\uff1a\u7ec4\u7ec7\u201c%s\u201d\u672a\u53d6\u5230\u4f01\u4e1a\u7a0e\u53f7\u3002", (String)"APIHelper_24", (String)"fi-er-business", (Object[])new Object[0]);
            throw new KDBizException(String.format(format, orgId));
        }
        try {
            QueryTemplateInvoiceFileAction queryInvoiceFileAction = new QueryTemplateInvoiceFileAction(orgId, attachmentUrl, expenseId, applierId);
            JSONObject result = JSON.parseObject((String)queryInvoiceFileAction.execute());
            logger.info(LOGSTRING + result);
            String errorCode = result.getString("errcode");
            if (StringUtils.equals((CharSequence)"0000", (CharSequence)errorCode)) {
                return result;
            }
            logger.info("APIHelper>>> \u8fd4\u56de\u7ed3\u679c\u5f02\u5e38" + result);
            String format = ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u9644\u4ef6\u540c\u6b65\u82cd\u7a79\u5355\u636e\u5f02\u5e38\uff1a\u8c03\u7528\u67e5\u8be2\u9644\u4ef6\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\uff1a%s\u3002", (String)"APIHelper_26", (String)"fi-er-business", (Object[])new Object[0]);
            throw new KDBizException(String.format(format, result));
        }
        catch (Exception e) {
            logger.error("APIHelper>>> : " + e);
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u9644\u4ef6\u540c\u6b65\u82cd\u7a79\u5355\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u83b7\u53d6\u53d1\u7968\u9644\u4ef6\u4fe1\u606f\u73af\u5883\u5730\u5740\u662f\u5426\u51c6\u786e\u3002", (String)"APIHelper_27", (String)"fi-er-business", (Object[])new Object[0]));
        }
    }

    public static List<InvoiceAttachmentVo> getTempInvoiceAttachments(DynamicObject dataEntity, long orgId) {
        List<Object> attachments = new ArrayList<InvoiceAttachmentVo>(2);
        JSONObject returnData = APIHelper.getTempInvoiceFiles(dataEntity, orgId);
        if (returnData != null && StringUtils.equals((CharSequence)"0000", (CharSequence)returnData.getString("errcode"))) {
            JSONArray attachmentJSonArray = returnData.getJSONArray("data");
            if (attachmentJSonArray == null) {
                return attachments;
            }
            attachments = JSON.parseArray((String)attachmentJSonArray.toJSONString(), InvoiceAttachmentVo.class);
        }
        return attachments;
    }

    public static String getEntityNameSSc(String entityName) {
        return sscBillToNormalBill.getOrDefault(entityName, entityName);
    }

    static {
        sscBillToNormalBill.put("er_dailyreimbursebil_ssc", "er_dailyreimbursebill");
        sscBillToNormalBill.put("er_publicreimburse_ssc", "er_publicreimbursebill");
        sscBillToNormalBill.put("er_tripreimbursebill_ssc", "er_tripreimbursebill");
    }
}

