/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.privatization.utils;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.image.ImageServiceHelper;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.privatization.bean.ErrorInfoBean;
import kd.fi.er.business.invoicecloud.privatization.bean.ReqParamBean;
import kd.fi.er.business.invoicecloud.privatization.bean.RespParam;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.utils.MD5;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class PrivatizationUtils {
    private static Log logger = LogFactory.getLog(PrivatizationUtils.class);
    private static final int DEFAULT_OVERTIME = 10000;

    public static ReqParamBean buildReqParamBean(DynamicObject dataEntity) {
        ReqParamBean reqParam = new ReqParamBean();
        reqParam.setId((Long)dataEntity.getPkValue());
        reqParam.setBillno(dataEntity.getString("billno"));
        if (dataEntity.getDynamicObjectType().getProperty("costcompany") != null) {
            DynamicObject costCompany = dataEntity.getDynamicObject("costcompany");
            if (costCompany != null) {
                reqParam.setCompanyId((Long)costCompany.getPkValue());
            }
        } else {
            DynamicObject company = dataEntity.getDynamicObject("company");
            if (company != null) {
                reqParam.setCompanyId((Long)company.getPkValue());
            }
        }
        reqParam.setEntityName(dataEntity.getDataEntityType().getName());
        DynamicObject creator = dataEntity.getDynamicObject("creator");
        if (creator != null) {
            reqParam.setCreatorId((Long)creator.getPkValue());
            reqParam.setCreatorName(creator.getLocaleString("name").toString());
            reqParam.setCreatorPhone(creator.getString("phone"));
            reqParam.setCreatorEmail(creator.getString("email"));
        }
        return reqParam;
    }

    public static List<ReqParamBean> querryBeans4Err(List<Long> errorIdlist) {
        QFilter filters = new QFilter("id", "in", errorIdlist);
        String select = "billid,billtype";
        DynamicObjectCollection dataEntitys = QueryServiceHelper.query((String)"er_notifyofinvoice_fail", (String)select, (QFilter[])new QFilter[]{filters});
        return PrivatizationUtils.buildReqParamBeans4Err(dataEntitys);
    }

    public static List<ReqParamBean> querryBeans4Err() {
        QFilter filters = new QFilter("1", "=", (Object)"1");
        String select = "billid,billtype";
        DynamicObjectCollection dataEntitys = QueryServiceHelper.query((String)"er_notifyofinvoice_fail", (String)select, (QFilter[])new QFilter[]{filters});
        return PrivatizationUtils.buildReqParamBeans4Err(dataEntitys);
    }

    public static List<ReqParamBean> buildReqParamBeans4Err(DynamicObjectCollection dataEntitys) {
        HashMap entityMapId = Maps.newHashMapWithExpectedSize((int)3);
        for (int i = 0; i < dataEntitys.size(); ++i) {
            String billType = ((DynamicObject)dataEntitys.get(i)).getString("billtype");
            List typeId = (List)entityMapId.get(billType);
            if (typeId == null) {
                typeId = Lists.newArrayListWithExpectedSize((int)dataEntitys.size());
                entityMapId.put(billType, typeId);
            }
            typeId.add(((DynamicObject)dataEntitys.get(i)).getLong("billid"));
        }
        ArrayList allError = Lists.newArrayListWithExpectedSize((int)dataEntitys.size());
        for (Map.Entry entry : entityMapId.entrySet()) {
            List<ReqParamBean> single = PrivatizationUtils.buildReqParamBeans((List)entry.getValue(), (String)entry.getKey());
            if (single == null) continue;
            allError.addAll(single);
        }
        return allError;
    }

    public static List<ReqParamBean> buildReqParamBeans(List<Long> list, String entityName) {
        DynamicObject[] dataEntitys;
        ArrayList reqParamList = Lists.newArrayListWithExpectedSize((int)list.size());
        Object[] pkArray = list.toArray();
        ArrayList select = Lists.newArrayList((Object[])new String[]{"billno", "costcompany", "creator.name", "creator.phone", "creator.email"});
        DynamicObjectType type = EntityMetadataCache.getSubDataEntityType((String)entityName, (Collection)select);
        for (DynamicObject dynamicObject : dataEntitys = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)type)) {
            reqParamList.add(PrivatizationUtils.buildReqParamBean(dynamicObject));
        }
        return reqParamList;
    }

    public static ErrorInfoBean imageNotify(ReqParamBean reqParam, String opType) {
        ErrorInfoBean error = new ErrorInfoBean();
        error.setLastRunTime(new Date(System.currentTimeMillis()));
        error.setReqParamBean(reqParam);
        String taxRegNum = PrivatizationUtils.getTaxRegNum(reqParam.getCompanyId(), reqParam.getBillno(), error);
        if (ErStdConfig.getBoolean("intranet")) {
            error.setErrorInfo(String.format(ResManager.loadKDString((String)"%s,\u901a\u77e5\u5f71\u50cf\u62c9\u53d6\u53d1\u7968\uff1a\u3010\u5355\u636e\u64cd\u4f5c\u3011\u5185\u7f51\u6a21\u5f0f", (String)"PrivatizationUtils_0", (String)"fi-er-business", (Object[])new Object[0]), opType));
            error.setSuccess(false);
        } else if (taxRegNum == null) {
            error.setSuccess(false);
        } else {
            logger.info(opType + ",\u901a\u77e5\u5f71\u50cf\u62c9\u53d6\u53d1\u7968\uff1a\u5f00\u59cb\u901a\u77e5\uff01");
            String imageurl = PrivatizationUtils.getNotifyUrl();
            InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(reqParam.getCompanyId());
            if (StringUtils.isNotBlank((CharSequence)imageurl) && config != null) {
                String url = imageurl + "imgsys/outside/match/fpzs/inform";
                String client_id = config.getClientId();
                String client_secret = config.getClientSecret();
                Long timestamp = new Date().getTime();
                String raw_sign = client_id + client_secret + timestamp;
                String sign = MD5.md5crypt((String)raw_sign);
                HashMap param = Maps.newHashMap();
                param.put("fclientId", client_id);
                param.put("sign", sign);
                param.put("timestamp", timestamp);
                if (StringUtils.contains((CharSequence)reqParam.getEntityName(), (CharSequence)"ssc")) {
                    reqParam.setEntityName(reqParam.getEntityName().replace("ssc", ""));
                }
                param.put("fexpenseId", reqParam.getEntityName() + "_" + reqParam.getId());
                param.put("fexpenseNum", reqParam.getBillno());
                String iamgeno = ImageServiceHelper.getImageNumber(reqParam.getEntityName(), reqParam.getId());
                param.put("fscanBillNo", iamgeno);
                param.put("fsource", "4");
                param.put("fcreatorId", reqParam.getCreatorId());
                param.put("fcreatorName", reqParam.getCreatorName());
                param.put("fcreatorPhone", reqParam.getCreatorPhone());
                param.put("fcreatorEmail", reqParam.getCreatorEmail());
                String respStr = "";
                try {
                    respStr = PrivatizationUtils.doPost(String.format(ResManager.loadKDString((String)"%s\u901a\u77e5\u5f71\u50cf\u62c9\u53d6\u53d1\u7968", (String)"PrivatizationUtils_1", (String)"fi-er-business", (Object[])new Object[0]), opType), url, null, JSON.toJSONString((Object)param));
                    if (StringUtils.isNotBlank((CharSequence)respStr)) {
                        RespParam stdResp = (RespParam)JSON.parseObject((String)respStr, RespParam.class);
                        error.setSuccess(StringUtils.equals((CharSequence)stdResp.getErrcode(), (CharSequence)"0000"));
                        error.setErrorInfo(String.format(ResManager.loadKDString((String)"%1$s,\u901a\u77e5\u5f71\u50cf\u62c9\u53d6\u53d1\u7968\uff1a%2$s", (String)"PrivatizationUtils_2", (String)"fi-er-business", (Object[])new Object[0]), opType, stdResp.getDescription()));
                    }
                    logger.info(opType + ",\u901a\u77e5\u5f71\u50cf\u62c9\u53d6\u53d1\u7968\uff1a" + respStr);
                }
                catch (Exception e) {
                    error.setErrorInfo(String.format(ResManager.loadKDString((String)"%1$s,\u901a\u77e5\u5f71\u50cf\u62c9\u53d6\u53d1\u7968\u901a\u77e5\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38,%2$s", (String)"PrivatizationUtils_6", (String)"fi-er-business", (Object[])new Object[0]), opType, e.getMessage()));
                    error.setSuccess(false);
                }
            } else if (config == null) {
                error.setSuccess(false);
                error.setErrorInfo(String.format(ResManager.loadKDString((String)"%s,\u8be5\u7ec4\u7ec7\u672a\u542f\u7528\u53d1\u7968\u4e91", (String)"PrivatizationUtils_7", (String)"fi-er-business", (Object[])new Object[0]), opType));
            } else {
                error.setSuccess(false);
                error.setErrorInfo(String.format(ResManager.loadKDString((String)"%s,\u901a\u77e5\u5f71\u50cf\u62c9\u53d6\u53d1\u7968:\u672a\u6b63\u786e\u914d\u7f6e\u5f71\u50cfurl", (String)"PrivatizationUtils_8", (String)"fi-er-business", (Object[])new Object[0]), opType));
            }
        }
        error.setCount(error.getCount() + 1);
        return error;
    }

    public static void updateErrorInfo(Collection<ErrorInfoBean> errorList, String opType) {
        Set billIdList = errorList.stream().map(info -> String.valueOf(info.getReqParamBean().getId())).collect(Collectors.toSet());
        QFilter qf = new QFilter("billid", "in", new ArrayList(billIdList));
        String select = "billid,errorcount,errorloginfo,billno,lastruntime,billtype";
        DynamicObjectCollection dataEntitys = QueryServiceHelper.query((String)"er_notifyofinvoice_fail", (String)select, (QFilter[])new QFilter[]{qf});
        Map<Long, DynamicObject> idsMap = dataEntitys.stream().collect(Collectors.toMap(dataEntity -> dataEntity.getLong("billid"), dataEntity -> dataEntity));
        Set<Long> billIds = idsMap.keySet();
        ArrayList delList = Lists.newArrayListWithExpectedSize((int)errorList.size());
        ArrayList updateList = Lists.newArrayListWithExpectedSize((int)errorList.size());
        for (ErrorInfoBean errorInfoBean : errorList) {
            if (errorInfoBean.isSuccess()) {
                if (!billIds.contains(errorInfoBean.getReqParamBean().getId())) continue;
                delList.add(errorInfoBean);
                continue;
            }
            updateList.add(errorInfoBean);
        }
        QFilter qFilter = new QFilter("billid", "in", delList.stream().map(info -> info.getReqParamBean().getId()).collect(Collectors.toList()));
        DeleteServiceHelper.delete((String)"er_notifyofinvoice_fail", (QFilter[])new QFilter[]{qFilter});
        logger.info(String.format("%1$s, notify image to pull invoice\uff0cprocessing data\uff1a%2$s;data to be processed\uff1a%3$s;delete:%4$s;save\uff1a%5$s", opType, billIdList, billIds, delList, updateList));
        DynamicObject[] newDataEntitys = new DynamicObject[updateList.size()];
        for (int i = 0; i < updateList.size(); ++i) {
            ErrorInfoBean errorInfoBean = (ErrorInfoBean)updateList.get(i);
            DynamicObject errorDataEntity = idsMap.get(errorInfoBean.getReqParamBean().getId());
            if (errorDataEntity == null) {
                errorDataEntity = BusinessDataServiceHelper.newDynamicObject((String)"er_notifyofinvoice_fail");
            }
            errorDataEntity.set("billid", (Object)errorInfoBean.getReqParamBean().getId());
            errorDataEntity.set("errorcount", (Object)errorInfoBean.getCount());
            errorDataEntity.set("errorloginfo", (Object)errorInfoBean.getErrorInfo());
            errorDataEntity.set("billno", (Object)errorInfoBean.getReqParamBean().getBillno());
            errorDataEntity.set("lastruntime", (Object)errorInfoBean.getLastRunTime());
            errorDataEntity.set("billtype", (Object)errorInfoBean.getReqParamBean().getEntityName());
            newDataEntitys[i] = errorDataEntity;
        }
        SaveServiceHelper.save((DynamicObject[])newDataEntitys);
    }

    protected static String getNotifyUrl() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"A");
        enableFilter.and(new QFilter("number", "=", (Object)"FPY"));
        DynamicObject imageConfig = QueryServiceHelper.queryOne((String)"bas_imageconfig", (String)"imageurl", (QFilter[])new QFilter[]{enableFilter});
        if (imageConfig != null) {
            return imageConfig.getString("imageurl");
        }
        return null;
    }

    protected static String getTaxRegNum(long orgPk, String billno, ErrorInfoBean error) {
        if (orgPk == 0L) {
            error.setErrorInfo(String.format(ResManager.loadKDString((String)"%s\u5355\u636e\u8d39\u7528\u627f\u62c5\u516c\u53f8\uff0c\u4f01\u4e1a\u7a0e\u53f7\u4e3a\u7a7a", (String)"PrivatizationUtils_9", (String)"fi-er-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u901a\u77e5\u5f71\u50cf\u62c9\u53d6\u53d1\u7968", (String)"PrivatizationUtils_11", (String)"fi-er-business", (Object[])new Object[0]), billno));
            return null;
        }
        String taxRegNum = KingdeeInvoiceCloudConfig.getTaxRegNum(orgPk);
        if (taxRegNum == null) {
            error.setErrorInfo(String.format(ResManager.loadKDString((String)"%s\u5355\u636e\uff0c\u4f01\u4e1a\u7a0e\u53f7\u4e3a\u7a7a", (String)"PrivatizationUtils_10", (String)"fi-er-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u901a\u77e5\u5f71\u50cf\u62c9\u53d6\u53d1\u7968", (String)"PrivatizationUtils_11", (String)"fi-er-business", (Object[])new Object[0]), billno));
            return null;
        }
        return taxRegNum;
    }

    protected static String doPost(String desc, String url, Map<String, String> headerMap, String bodyJson) {
        String logfmt = ResManager.loadKDString((String)"%1$s\uff0c\u6267\u884cpost\u8bf7\u6c42 - url: %2$s, body: %3$s", (String)"PrivatizationUtils_3", (String)"fi-er-business", (Object[])new Object[0]);
        logger.info(String.format(logfmt, desc, url, bodyJson));
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        CloseableHttpResponse response = null;
        InputStreamReader in = null;
        BufferedReader bfreader = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(180000).setConnectTimeout(5000).build();
            httpPost.setConfig(requestConfig);
            StringEntity entity = new StringEntity(bodyJson);
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("Content-Type", "application/json;charset=utf8");
            response = httpClient.execute((HttpUriRequest)httpPost);
            logger.info("\u54cd\u5e94\u72b6\u6001\u4e3a\uff1a" + response.getStatusLine());
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                in = new InputStreamReader(responseEntity.getContent(), StandardCharsets.UTF_8);
                bfreader = new BufferedReader(in);
                StringBuffer sb = new StringBuffer();
                String line = "";
                while ((line = bfreader.readLine()) != null) {
                    sb.append(line);
                }
                String responseContext = sb.toString();
                logfmt = ResManager.loadKDString((String)"%1$s\uff0c\u6267\u884cpost\u8bf7\u6c42 - response: %2$s", (String)"PrivatizationUtils_4", (String)"fi-er-business", (Object[])new Object[0]);
                logger.info(String.format(logfmt, desc, responseContext));
                String string = responseContext;
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("doPost", String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u6267\u884c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38\uff1a%s\u3002", (String)"PrivatizationUtils_5", (String)"fi-er-business", (Object[])new Object[0]), desc)), new Object[0]);
        }
        finally {
            try {
                if (bfreader != null) {
                    bfreader.close();
                }
                if (in != null) {
                    in.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error("doPost" + desc + " - an exception was detected during resource release. Procedure  : ", (Throwable)e);
            }
        }
    }
}

