/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.provider.service.factory;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.invoicecloud.provider.service.CommonInvoiceService;
import kd.fi.er.business.invoicecloud.provider.service.IAfterCreateExpenseItemEntryService;
import kd.fi.er.business.invoicecloud.provider.service.IAfterCreateInvoiceEntryService;
import kd.fi.er.business.invoicecloud.provider.service.IAfterCreateInvoiceInfoService;
import kd.fi.er.business.invoicecloud.provider.service.IAfterProcessExtService;
import kd.fi.er.business.invoicecloud.provider.service.IBeforeCreateExpenseItemEntryService;
import kd.fi.er.business.invoicecloud.provider.service.IBeforeCreateInvoiceInfoService;
import kd.fi.er.business.invoicecloud.provider.service.InvoiceServiceForMob;
import kd.fi.er.business.invoicecloud.provider.service.InvoiceServiceForPC;
import org.apache.commons.lang3.StringUtils;

public class InvoiceServiceFactory {
    private static Log logger = LogFactory.getLog(InvoiceServiceFactory.class);
    private static final ConcurrentHashMap<Class<?>, Object> services = new ConcurrentHashMap();
    private static Object lock = new Object();
    private static Set<Class<?>> invoiceServiceInterfaces = new HashSet(3);

    private InvoiceServiceFactory() {
        throw new RuntimeException("factory couldn't be instanced...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getSingletonService(Class<T> clazz) {
        Object object = lock;
        synchronized (object) {
            if (invoiceServiceInterfaces.contains(clazz)) {
                try {
                    InvoiceServiceFactory.updateServiceFromConfig(clazz);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    logger.error((Throwable)e);
                    throw new KDBizException(e.getCause(), new ErrorCode("0", e.getMessage()), new Object[]{e});
                }
            }
            try {
                services.put(clazz, clazz.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.error((Throwable)e);
                throw new KDBizException(e.getCause(), new ErrorCode("0", e.getMessage()), new Object[]{e});
            }
        }
        return (T)services.get(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearInvoiceServiceBean() {
        Object object = lock;
        synchronized (object) {
            invoiceServiceInterfaces.forEach(inter -> services.remove(inter));
        }
    }

    private static void updateServiceFromConfig(Class clazz) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        QFilter qFilter = QFilter.of((String)"enable=? and status=?", (Object[])new Object[]{"1", "C"});
        Map serviceDOFromCache = BusinessDataServiceHelper.loadFromCache((String)"er_invoicecloudprovider", (QFilter[])new QFilter[]{qFilter});
        if (serviceDOFromCache == null || serviceDOFromCache.size() != 1) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u53ef\u7528\u7684\u53d1\u7968\u4e91\u670d\u52a1\u5546\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a\uff0c\u5f53\u524d\u670d\u52a1\u5546\u6570\u91cf\uff1a%s", (String)"InvoiceServiceFactory_2", (String)"fi-er-business", (Object[])new Object[0]), serviceDOFromCache == null ? 0 : serviceDOFromCache.size()));
        }
        DynamicObject serviceDO = (DynamicObject)serviceDOFromCache.values().iterator().next();
        DynamicObjectCollection serviceEntrys = serviceDO.getDynamicObjectCollection("invoiceserviceentry");
        Map<String, String> serviceMap = serviceEntrys.stream().collect(Collectors.toMap(entry -> entry.getString("servicename"), entry -> entry.getString("serviceclass")));
        if (!serviceMap.containsKey(clazz.getName()) && services.containsKey(clazz)) {
            services.remove(clazz);
        }
        for (Map.Entry<String, String> entry2 : serviceMap.entrySet()) {
            String implClassName;
            Class<?> serviceInterfaceClass;
            if (StringUtils.isBlank((CharSequence)entry2.getKey()) || !StringUtils.equals((CharSequence)clazz.getName(), (CharSequence)entry2.getKey()) || services.containsKey(serviceInterfaceClass = Class.forName(entry2.getKey())) && StringUtils.equals((CharSequence)services.get(serviceInterfaceClass).getClass().getName(), (CharSequence)entry2.getValue()) || !StringUtils.isNotEmpty((CharSequence)(implClassName = entry2.getValue()))) continue;
            services.put(Class.forName(entry2.getKey()), Class.forName(implClassName).newInstance());
        }
    }

    private static Class updateServiceFromConfigNew(Class clazz) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        QFilter qFilter = QFilter.of((String)"enable=? and status=?", (Object[])new Object[]{"1", "C"});
        Map serviceDOFromCache = BusinessDataServiceHelper.loadFromCache((String)"er_invoicecloudprovider", (QFilter[])new QFilter[]{qFilter});
        if (serviceDOFromCache == null || serviceDOFromCache.size() != 1) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u53ef\u7528\u7684\u53d1\u7968\u4e91\u670d\u52a1\u5546\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a\uff0c\u5f53\u524d\u670d\u52a1\u5546\u6570\u91cf\uff1a%s", (String)"InvoiceServiceFactory_2", (String)"fi-er-business", (Object[])new Object[0]), serviceDOFromCache == null ? 0 : serviceDOFromCache.size()));
        }
        DynamicObject serviceDO = (DynamicObject)serviceDOFromCache.values().iterator().next();
        DynamicObjectCollection serviceEntrys = serviceDO.getDynamicObjectCollection("invoiceserviceentry");
        Map<String, String> serviceMap = serviceEntrys.stream().collect(Collectors.toMap(entry -> entry.getString("servicename"), entry -> entry.getString("serviceclass")));
        for (Map.Entry<String, String> entry2 : serviceMap.entrySet()) {
            if (StringUtils.isBlank((CharSequence)entry2.getKey()) || !clazz.getName().equals(entry2.getKey())) continue;
            Class<?> serviceInterfaceClass = null;
            if (StringUtils.isNotEmpty((CharSequence)entry2.getValue())) {
                serviceInterfaceClass = Class.forName(entry2.getValue());
            }
            return serviceInterfaceClass;
        }
        return null;
    }

    static {
        invoiceServiceInterfaces.add(CommonInvoiceService.class);
        invoiceServiceInterfaces.add(InvoiceServiceForPC.class);
        invoiceServiceInterfaces.add(InvoiceServiceForMob.class);
        invoiceServiceInterfaces.add(IAfterCreateInvoiceEntryService.class);
        invoiceServiceInterfaces.add(IBeforeCreateExpenseItemEntryService.class);
        invoiceServiceInterfaces.add(IAfterCreateExpenseItemEntryService.class);
        invoiceServiceInterfaces.add(IAfterProcessExtService.class);
        invoiceServiceInterfaces.add(IAfterCreateInvoiceInfoService.class);
        invoiceServiceInterfaces.add(IBeforeCreateInvoiceInfoService.class);
    }
}

