/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.provider.service.std;

import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.provider.param.req.H5ImportInvoiceIframReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.H5ShowAllInvoiceIframParam;
import kd.fi.er.business.invoicecloud.provider.param.req.H5ShowInvoiceIframReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.ImportInvoiceFromInvoicePackageParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.IframeParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.WeChatMiniProgramShowInvoiceIframeReqParam;
import kd.fi.er.business.invoicecloud.provider.service.InvoiceServiceForMob;
import kd.fi.er.business.invoicecloud.request.bean.CommonUserKeyRequestParam;
import kd.fi.er.business.invoicecloud.v2.util.AllInvoiceUrl;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;
import kd.fi.er.common.utils.MD5;
import org.apache.commons.lang3.StringUtils;

public class InvoiceServiceForMobImpl
implements InvoiceServiceForMob {
    private static final Log log = LogFactory.getLog(InvoiceServiceForMobImpl.class);

    @Override
    public IframeParam getImportInvoiceIframParam(H5ImportInvoiceIframReqParam request, IFormView formView) throws InvoiceCloudException {
        Boolean isInvokeMiniProgram = ErStdConfig.isInvokeMiniProgramInImportInvoice();
        String timestamp = String.valueOf(System.currentTimeMillis());
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("invoketype", "invokeMiniProgram");
        m.put("invokeMiniProgram", isInvokeMiniProgram);
        m.put("userName", ErStdConfig.get("invoicecloud.miniProg.userName"));
        m.put("miniprogramType", ErStdConfig.get("invoicecloud.miniProg.miniprogramType"));
        m.put("openType", "selectInvoice");
        m.put("isProd", ErStdConfig.isProduct());
        String socketName = timestamp + new SecureRandom().nextDouble();
        m.put("name", socketName);
        m.put("pageId", formView.getPageId());
        if (isInvokeMiniProgram.booleanValue()) {
            log.info("\u5bfc\u5165\u53d1\u7968\u516c\u53f8: " + request.getCompanyId() + "  \u7a0e\u53f7:" + request.getTaxRegNum());
            String path = ErStdConfig.get("invoicecloud.miniProg.path_of_select");
            String userKey = request.getCompanyId() != null ? APIHelper.getUserKey(request.getCompanyId(), RequestContext.get().getUserId(), request.getBillId()) : APIHelper.getUserKey(request.getTaxRegNum(), RequestContext.get().getUserId(), request.getBillId());
            path = path.replace("${userKey}", userKey);
            m.put("path", path);
        }
        InvoiceCloudCfgBO config = request.getCompanyId() != null ? KingdeeInvoiceCloudConfig.getConfig(request.getCompanyId()) : KingdeeInvoiceCloudConfig.getConfig(request.getTaxRegNum());
        Map<String, Object> h5Param = this.addParamForImportInvoiceInMobH5(request.getBillId(), config);
        m.putAll(h5Param);
        log.info("\u524d\u7aef\u5bfc\u5165\u53d1\u7968, \u4f20\u9012\u7684\u53c2\u6570\u4e3a:" + m);
        IframeParam iframeParam = new IframeParam();
        iframeParam.setContent(m);
        String url = ErStdConfig.get("invoicecloud.checkback.html.url");
        if (StringUtils.isBlank((CharSequence)url)) {
            url = RequestContext.get().getClientFullContextPath() + "invoicecloud/checkback.html";
        }
        iframeParam.setUrl(url + "?pageId=" + formView.getPageId());
        return iframeParam;
    }

    @Override
    public IframeParam getH5ShowInvoiceIframParam(H5ShowInvoiceIframReqParam request, IFormView formView) throws InvoiceCloudException {
        String eventCode = request.getOrgId() != null ? APIHelper.getEventCode(request.getOrgId(), request.getSerialNos(), Collections.emptyList()) : APIHelper.getEventCode(request.getTaxRegNum(), request.getSerialNos(), Collections.emptyList());
        String url = ErStdConfig.getShowInvoiceListInMobH5Url() + "?event_code={event_code}";
        url = url.replace("{event_code}", eventCode);
        IframeParam iframeParam = new IframeParam();
        iframeParam.setUrl(url);
        return iframeParam;
    }

    @Override
    public IframeParam getH5ShowAllInvoiceIframParam(H5ShowAllInvoiceIframParam request, IFormView formView) throws InvoiceCloudException {
        String url = ErStdConfig.getShowAllInvoiceListInMobH4Url();
        String bxd = request.getBillId();
        InvoiceCloudCfgBO config = request.getOrgId() != null ? KingdeeInvoiceCloudConfig.getConfig(request.getOrgId()) : KingdeeInvoiceCloudConfig.getConfig(request.getTaxRegNum());
        String clientId = config.getClientId();
        String clientSecret = config.getClientSecret();
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = MD5.md5crypt((String)(clientId + clientSecret + timestamp));
        HashMap paraMap = Maps.newHashMap();
        paraMap.put("timestamp", timestamp);
        paraMap.put("client_id", clientId);
        paraMap.put("sign", sign);
        paraMap.put("bxd_key", bxd);
        paraMap.put("ticketParam", config.genTicketParam());
        String urlParam = paraMap.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
        url = url + "?" + urlParam;
        IframeParam iframeParam = new IframeParam();
        iframeParam.setUrl(url);
        return iframeParam;
    }

    @Override
    public IframeParam getWeChatMiniProgramShowInvoiceIframeParam(WeChatMiniProgramShowInvoiceIframeReqParam request, IFormView formView) throws InvoiceCloudException {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("invoketype", "invokeMiniProgram");
        m.put("userName", ErStdConfig.get("invoicecloud.miniProg.userName"));
        m.put("miniprogramType", ErStdConfig.get("invoicecloud.miniProg.miniprogramType"));
        m.put("openType", "viewInvoice");
        String path = ErStdConfig.get("invoicecloud.miniProg.path_of_view");
        InvoiceCloudCfgBO config = request.getOrgId() != null ? KingdeeInvoiceCloudConfig.getConfig(request.getOrgId()) : KingdeeInvoiceCloudConfig.getConfig(request.getTaxRegNum());
        String client_id = config.getClientId();
        String ticketParam = config.genTicketParam();
        path = String.format("%s&serialno=%s&client_id=%s&ticketParam=%s", path, StringUtils.join(request.getSerialNos(), (String)","), client_id, ticketParam);
        m.put("path", path);
        m.put("pageId", formView.getPageId());
        IframeParam iframeParam = new IframeParam();
        iframeParam.setContent(m);
        String url = ErStdConfig.get("invoicecloud.checkback.html.url");
        if (StringUtils.isBlank((CharSequence)url)) {
            url = RequestContext.get().getClientFullContextPath() + "invoicecloud/checkback.html";
        }
        iframeParam.setUrl(url + "?pageId=" + formView.getPageId());
        return iframeParam;
    }

    private Map<String, Object> addParamForImportInvoiceInMobH5(String billId, InvoiceCloudCfgBO config) throws InvoiceCloudException {
        HashMap m = Maps.newHashMap();
        m.put("env", ErStdConfig.isProduct() ? "prod" : "test");
        m.put("tin", config.getTaxRegnum());
        String uid = RequestContext.get().getUserId();
        m.put("edi", uid);
        String clientId = config.getClientId();
        String clientSecret = config.getClientSecret();
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String sign = MD5.md5crypt((String)(clientId + clientSecret + timeStamp));
        m.put("client_id", clientId);
        m.put("sign", sign);
        m.put("timestamp", timeStamp);
        String linkKey = UUID.randomUUID().toString().replace("-", "");
        m.put("linkKey", linkKey);
        m.put("app", ErStdConfig.getApp());
        m.put("openType", "importInvoice");
        CommonUserKeyRequestParam userKeyRequestParam = new CommonUserKeyRequestParam();
        userKeyRequestParam.setTimestamp(timeStamp);
        userKeyRequestParam.setClient_id(clientId);
        userKeyRequestParam.setTin(config.getTaxRegnum());
        userKeyRequestParam.setGhf_mc(config.getFirmname());
        userKeyRequestParam.setEid(uid);
        userKeyRequestParam.setSign(sign);
        userKeyRequestParam.setBillNumber(billId);
        userKeyRequestParam.setBxd_key(billId);
        userKeyRequestParam.setRandom(linkKey);
        userKeyRequestParam.setTicketParam(config.genTicketParam());
        userKeyRequestParam.setBillType(billId.substring(0, 8));
        String commonUserKey = APIHelper.getCommonUserKey(userKeyRequestParam);
        HashMap urlParamMap = Maps.newHashMapWithExpectedSize((int)3);
        String app = ErStdConfig.getApp().trim();
        urlParamMap.put("userKey", commonUserKey);
        urlParamMap.put("app", app);
        urlParamMap.put("model", StringUtils.equals((CharSequence)app, (CharSequence)"dingding") ? "yes" : "no");
        urlParamMap.put("dockingMode", ErStdConfig.getDockingMode());
        urlParamMap.put("wechatCard", ErStdConfig.includeWechatCardInInvoicePackage());
        String urlParam = urlParamMap.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
        m.put("importInvoiceUrlInMobH5", ErStdConfig.getImportInvoiceUrlInMobH5() + "?" + urlParam);
        return m;
    }

    private Map<String, Object> addParamForImportInvoiceFromInvoicePackageInMob(InvoiceCloudCfgBO config, List<ImportInvoiceFromInvoicePackageParam.NameAndKey> billNameAndKeys) throws InvoiceCloudException {
        HashMap m = Maps.newHashMap();
        m.put("env", ErStdConfig.isProduct() ? "prod" : "test");
        m.put("tin", config.getTaxRegnum());
        String uid = RequestContext.get().getUserId();
        m.put("edi", uid);
        String clientId = config.getClientId();
        String clientSecret = config.getClientSecret();
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String sign = MD5.md5crypt((String)(clientId + clientSecret + timeStamp));
        m.put("client_id", clientId);
        m.put("sign", sign);
        m.put("timestamp", timeStamp);
        String linkKey = UUID.randomUUID().toString().replace("-", "");
        m.put("linkKey", linkKey);
        m.put("app", ErStdConfig.getApp());
        m.put("openType", "importInvoice");
        CommonUserKeyRequestParam userKeyRequestParam = new CommonUserKeyRequestParam();
        userKeyRequestParam.setTimestamp(timeStamp);
        userKeyRequestParam.setClient_id(clientId);
        userKeyRequestParam.setTin(config.getTaxRegnum());
        userKeyRequestParam.setGhf_mc(config.getFirmname());
        userKeyRequestParam.setEid(uid);
        userKeyRequestParam.setSign(sign);
        String billno = "QR-" + UUID.randomUUID();
        String billId = "QucikReimId-" + timeStamp;
        userKeyRequestParam.setBillNumber(billno);
        userKeyRequestParam.setBxd_key(billId);
        userKeyRequestParam.setRandom(linkKey);
        userKeyRequestParam.setTicketParam(config.genTicketParam());
        userKeyRequestParam.setBillType("quickReim");
        String commonUserKey = APIHelper.getCommonUserKey(userKeyRequestParam);
        HashMap urlParamMap = Maps.newHashMapWithExpectedSize((int)3);
        String app = ErStdConfig.getApp().trim();
        urlParamMap.put("userKey", commonUserKey);
        urlParamMap.put("app", app);
        urlParamMap.put("wechatCard", ErStdConfig.includeWechatCardInInvoicePackage());
        if (billNameAndKeys != null && !billNameAndKeys.isEmpty()) {
            try {
                String billListParam = billNameAndKeys.stream().map(nameAndKey -> nameAndKey.getKey() + "=" + nameAndKey.getName()).collect(Collectors.joining(";"));
                urlParamMap.put("billList", URLEncoder.encode(billListParam, "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        String urlParam = urlParamMap.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
        m.put("importInvoiceUrlInMobH5", ErStdConfig.getImportInvoiceFromInvoicePackage() + "?" + urlParam);
        return m;
    }

    @Override
    public IframeParam getImportInvoiceFromInvoicePackageIframeParam(ImportInvoiceFromInvoicePackageParam request, IFormView formView) throws InvoiceCloudException {
        Boolean isInvokeMiniProgram = ErStdConfig.isInvokeMiniProgramInImportInvoice();
        String timestamp = String.valueOf(System.currentTimeMillis());
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("invoketype", "invokeMiniProgram");
        m.put("invokeMiniProgram", isInvokeMiniProgram);
        m.put("userName", ErStdConfig.get("invoicecloud.miniProg.userName"));
        m.put("miniprogramType", ErStdConfig.get("invoicecloud.miniProg.miniprogramType"));
        m.put("openType", "selectInvoice");
        m.put("isProd", ErStdConfig.isProduct());
        String socketName = timestamp + new SecureRandom().nextDouble();
        m.put("name", socketName);
        m.put("pageId", formView.getPageId());
        Long orgInvoiceId = request.getOrgInvoiceId();
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(orgInvoiceId);
        Map<String, Object> h5Param = this.addParamForImportInvoiceFromInvoicePackageInMob(config, request.getNameKeys());
        m.putAll(h5Param);
        log.info("\u3010\u53d1\u7968\u5939\u3011\u524d\u7aef\u6253\u5f00\u7968\u5939, \u4f20\u9012\u7684\u53c2\u6570\u4e3a:" + m);
        IframeParam iframeParam = new IframeParam();
        iframeParam.setContent(m);
        String url = ErStdConfig.get("invoicecloud.checkback.html.url");
        if (StringUtils.isBlank((CharSequence)url)) {
            url = RequestContext.get().getClientFullContextPath() + "invoicecloud/checkback.html";
        }
        iframeParam.setUrl(url + "?pageId=" + formView.getPageId());
        return iframeParam;
    }

    @Override
    public IframeParam getShowDeleteAttachIframeParam(H5ImportInvoiceIframReqParam request, IFormView formView) throws InvoiceCloudException {
        String bxd = request.getBillId();
        String url = AllInvoiceUrl.getDeleteAttachMOBPageUrl();
        IframeParam iframeParam = this.getImportInvoiceIframParam(request, formView);
        Map<String, Object> content = iframeParam.getContent();
        String tmpUrl = (String)content.get("importInvoiceUrlInMobH5");
        URI uri = null;
        try {
            uri = new URI(tmpUrl);
        }
        catch (URISyntaxException e) {
            log.error((Throwable)e);
        }
        String queryString = uri != null ? uri.getRawQuery() : "empty";
        url = url + "&" + queryString + "&client_id=" + content.get("client_id") + "&bxd_key=" + bxd;
        content.put("importInvoiceUrlInMobH5", url);
        content.put("invokeMiniProgram", false);
        content.put("path", "");
        return iframeParam;
    }
}

