/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.util;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class InvoicePackageUtil {
    private static final Log logger = LogFactory.getLog(InvoicePackageUtil.class);

    public static boolean needDoImportInvoice(AbstractFormPlugin plugin) {
        String sign = plugin.getPageCache().get("PACKAGE_IMPORT");
        if (StringUtils.isEmpty((CharSequence)sign) && InvoicePackageUtil.isFromPackageImport(plugin)) {
            InvoicePackageUtil.setPackageSign(plugin);
            return true;
        }
        return false;
    }

    public static boolean isFromPackageImport(AbstractFormPlugin plugin) {
        IFormView formView = plugin.getView();
        String pluginSign = (String)formView.getFormShowParameter().getCustomParam("PACKAGE_SIGN");
        String className = plugin.getClass().getName();
        return StringUtils.isNotEmpty((CharSequence)pluginSign) && StringUtils.equalsIgnoreCase((CharSequence)pluginSign, (CharSequence)className);
    }

    public static void setPackageSign(AbstractFormPlugin plugin) {
        if (InvoicePackageUtil.isFromPackageImport(plugin)) {
            String clickSign = (String)plugin.getView().getFormShowParameter().getCustomParam("PACKAGE_CLICK_SIGN");
            plugin.getView().getPageCache().put("PACKAGE_IMPORT", "PACKAGE_IMPORT");
            plugin.getView().getPageCache().put("package_clickKey", clickSign);
        }
    }

    public static boolean checkPackageSign(AbstractFormPlugin plugin) {
        String sign = plugin.getPageCache().get("PACKAGE_IMPORT");
        return !StringUtils.isEmpty((CharSequence)sign);
    }

    public static void clearPackageSign(AbstractFormPlugin plugin) {
        String sign = plugin.getPageCache().get("PACKAGE_IMPORT");
        if (StringUtils.isNotEmpty((CharSequence)sign)) {
            plugin.getPageCache().remove("PACKAGE_IMPORT");
            plugin.getPageCache().remove("package_clickKey");
        }
    }

    public static void initPackageFormData(AbstractFormPlugin plugin) {
        IFormView view = plugin.getView();
        FormShowParameter showParameter = view.getFormShowParameter();
        JSONObject applier = (JSONObject)showParameter.getCustomParam("package_applier");
        JSONObject org = (JSONObject)showParameter.getCustomParam("package_org");
        JSONObject company = (JSONObject)showParameter.getCustomParam("package_company");
        JSONObject costCompany = (JSONObject)showParameter.getCustomParam("package_costCompany");
        JSONObject currency = (JSONObject)showParameter.getCustomParam("package_currency");
        IDataModel model = view.getModel();
        model.setValue("applier", (Object)applier.getLong("id"));
        model.setValue("costdept", (Object)org.getLong("id"));
        model.setValue("org", (Object)org.getLong("id"));
        model.setValue("company", (Object)company.getLong("id"));
        model.setValue("costcompany", (Object)costCompany.getLong("id"));
        model.setValue("currency", (Object)currency.getLong("id"));
    }

    public static Map<String, Object> createNewData(Map<String, Object> customParams) {
        HashMap<String, Object> newData = new HashMap<String, Object>();
        for (Map.Entry<String, Object> objectEntry : customParams.entrySet()) {
            String key = objectEntry.getKey();
            if (!key.startsWith("quickreim_")) continue;
            String newKey = key.replace("quickreim_", "");
            newData.put(newKey, objectEntry.getValue());
        }
        return newData;
    }
}

