/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.util;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.Label;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.fi.er.formplugin.util.OffsetUtils;
import org.apache.commons.lang3.StringUtils;

public class InvoiceProcessUtil {
    public static void refreshLinkage(IFormView view) {
        DynamicObject dynamicObject = view.getModel().getDataEntity(true);
        DynamicObjectCollection invoiceEntry = dynamicObject.getDynamicObjectCollection("invoiceentry");
        List invoiceHeadIds = invoiceEntry.stream().map(entry -> (Long)entry.getPkValue()).collect(Collectors.toList());
        for (Long invoiceHeadId : invoiceHeadIds) {
            Set<Long> expenseIds = InvoiceUtils.getExpenseEntryByInvoiceEntryId(dynamicObject, invoiceHeadId);
            for (Long expenseId : expenseIds) {
                Set<Long> ids = Arrays.stream(new Long[]{expenseId}).collect(Collectors.toSet());
                Set<Long> invoiceIds = InvoiceUtils.getInvoiceIdsOfItems(dynamicObject, ids);
                boolean isOne2One = OffsetUtils.itemIsOne2One(view, view.getModel(), invoiceIds);
                for (int i = 0; i < invoiceEntry.size(); ++i) {
                    IDataModel model;
                    Long invoiceObjID = (Long)((DynamicObject)invoiceEntry.get(i)).getPkValue();
                    if (!invoiceIds.contains(invoiceObjID) || (model = view.getModel()).getProperty("islinkagedetail") == null) continue;
                    model.setValue("islinkagedetail", (Object)isOne2One, i);
                }
            }
        }
    }

    public static void updateInvoiceValidateSummary(IFormView view) {
        Label label;
        IDataModel model = view.getModel();
        if (((EntityType)model.getDataEntityType().getAllEntities().get("invoiceentry")).getProperty("ie_validatest") == null) {
            return;
        }
        DynamicObjectCollection invoiceHeadDOs = model.getDataEntity(true).getDynamicObjectCollection("invoiceentry");
        String notOKInvoiceNos = invoiceHeadDOs.stream().filter(entry -> StringUtils.equals((CharSequence)entry.getString("ie_validatest"), (CharSequence)InvoiceVO.CheckStatus.NOT_OK.getValue())).map(entry -> entry.getString("invoiceno")).collect(Collectors.joining("\uff0c"));
        String validateSummary = "";
        if (StringUtils.isNotBlank((CharSequence)notOKInvoiceNos)) {
            validateSummary = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u201c%1$s\u201d%2$s", (String)"AbstractImportInvoiceForReimPCByItemEntry_0", (String)"fi-er-formplugin", (Object[])new Object[0]), notOKInvoiceNos, ResManager.loadKDString((String)"\u67e5\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"AbstractImportInvoiceForReimPCByItemEntry_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        if ((label = (Label)view.getControl("invoice_validate_summary")) != null) {
            label.setText(validateSummary);
        }
    }

    public static void updateInvoiceContainerCollapse(IFormView view) {
        int entryRowCount = view.getModel().getEntryRowCount("invoiceentry");
        AdvContainer invoiceAdvContainer = (AdvContainer)view.getControl("invoice_entry_container");
        if (entryRowCount > 0) {
            invoiceAdvContainer.setCollapse(false);
        }
    }
}

