/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.EnumMap;
import java.util.Map;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceTypeEnum;

public class TaxRatePool {
    private static final Map<InvoiceTypeEnum, BigDecimal> taxRateMap = new EnumMap<InvoiceTypeEnum, BigDecimal>(InvoiceTypeEnum.class);
    private static final LocalDate startNewTaxPlocyDate = LocalDate.of(2019, 4, 1);

    private TaxRatePool() {
    }

    public static BigDecimal getTaxRate(InvoiceTypeEnum invoiceType, LocalDate invoiceDate) {
        if (invoiceDate == null) {
            return BigDecimal.ZERO;
        }
        if (invoiceDate.compareTo(startNewTaxPlocyDate) >= 0) {
            return taxRateMap.getOrDefault((Object)invoiceType, BigDecimal.ZERO);
        }
        return BigDecimal.ZERO;
    }

    public static boolean containInvoiceType(InvoiceTypeEnum invoiceType) {
        return taxRateMap.containsKey((Object)invoiceType);
    }

    static {
        taxRateMap.put(InvoiceTypeEnum.key_10, new BigDecimal("0.09"));
        taxRateMap.put(InvoiceTypeEnum.key_9, new BigDecimal("0.09"));
        taxRateMap.put(InvoiceTypeEnum.key_16, new BigDecimal("0.03"));
        taxRateMap.put(InvoiceTypeEnum.key_20, new BigDecimal("0.03"));
    }
}

