/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.seatstd;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.invoicecloud.v2.seatstd.AirSeatGradeType;
import kd.fi.er.business.invoicecloud.v2.seatstd.ShipSeatGradeType;
import kd.fi.er.business.invoicecloud.v2.seatstd.TrainSeatGradeType;
import org.apache.commons.lang.StringUtils;

public class TripVhcStdChangeUtils {
    private static Log logger = LogFactory.getLog(TripVhcStdChangeUtils.class);
    public static final String EXPENSE_ITEM_TRAIN = "4";
    public static final String EXPENSE_ITEM_AIR = "2";
    public static final String EXPENSE_ITEM_SHIP = "7";
    protected static final String[] AIR = new String[]{"01", "02", "03"};
    protected static final String[] TRAIN = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14"};

    public static String attrib2Type(String attribute) {
        return StringUtils.equals((String)attribute, (String)EXPENSE_ITEM_AIR) ? "air" : (StringUtils.equals((String)attribute, (String)EXPENSE_ITEM_TRAIN) ? "train" : (StringUtils.equals((String)attribute, (String)EXPENSE_ITEM_SHIP) ? "ship" : null));
    }

    public static String Type2attrib(String attribute) {
        return StringUtils.equals((String)attribute, (String)ResManager.loadKDString((String)"\u98de\u673a", (String)"TripVhcStdChangeUtils_0", (String)"fi-er-business", (Object[])new Object[0])) ? EXPENSE_ITEM_AIR : (StringUtils.equals((String)attribute, (String)ResManager.loadKDString((String)"\u706b\u8f66", (String)"TripVhcStdChangeUtils_1", (String)"fi-er-business", (Object[])new Object[0])) ? EXPENSE_ITEM_TRAIN : (StringUtils.equals((String)attribute, (String)ResManager.loadKDString((String)"\u8f6e\u8239", (String)"TripVhcStdChangeUtils_2", (String)"fi-er-business", (Object[])new Object[0])) ? EXPENSE_ITEM_SHIP : null));
    }

    public static String[] getList(String attribute) {
        return StringUtils.equals((String)attribute, (String)EXPENSE_ITEM_AIR) ? AIR : (StringUtils.equals((String)attribute, (String)EXPENSE_ITEM_TRAIN) ? TRAIN : null);
    }

    public static List<String> getVhcStd(DynamicObject curTripItemEntry) {
        ArrayList vhcStd = Lists.newArrayList();
        String vhcStdText = curTripItemEntry.getString("textvehiclestandard");
        if (StringUtils.isNotBlank((String)vhcStdText)) {
            vhcStd.addAll(Arrays.stream(vhcStdText.split("\uff0c")).map(String::trim).collect(Collectors.toList()));
        }
        return vhcStd;
    }

    public static boolean isOverVhcStd(IDataModel model, String attribute) {
        DynamicObjectCollection mulseatgrade = (DynamicObjectCollection)model.getValue("mulseatgrade");
        String vhc = (String)model.getValue("textvehiclestandard");
        List<String> vhcStd = Arrays.stream(vhc.split("\uff0c")).collect(Collectors.toList());
        List<String> seat = mulseatgrade.stream().map(seatGrade -> seatGrade.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toList());
        logger.info("\u5ea7\u4f4d\u7b49\u7ea7 \uff1a" + seat + ", \u6807\u51c6 \uff1a " + vhcStd);
        return !TripVhcStdChangeUtils.vhcStdContainAllSeatGrade(vhcStd, seat, attribute);
    }

    public static boolean vhcStdContainAllSeatGrade(List<String> vhcStd, List<String> seatGrade, String attribute) {
        Set vhcStdKey = vhcStd.stream().map(vhc -> TripVhcStdChangeUtils.getVhcSeatGrade(vhc, attribute)).filter(vhc -> vhc != null).map(vhc -> vhc[1]).collect(Collectors.toSet());
        Set seatGradeKey = seatGrade.stream().map(vhc -> TripVhcStdChangeUtils.getVhcSeatGrade(vhc, attribute)).filter(vhc -> vhc != null).map(vhc -> vhc[1]).collect(Collectors.toSet());
        return vhcStdKey.containsAll(seatGradeKey);
    }

    public static boolean isOverVhcStd(DynamicObject dataEntity, long tripItemEntryId, List<String> vhcStd) {
        Set invoiceHeadIds = dataEntity.getDynamicObjectCollection("invoiceitementry").stream().filter(invoiceItemEntry -> Objects.equals(tripItemEntryId, invoiceItemEntry.getLong("itementryid"))).map(invoiceItemEntry -> invoiceItemEntry.getLong("invoiceheadentryid")).collect(Collectors.toSet());
        boolean isOverStd = dataEntity.getDynamicObjectCollection("invoiceentry").stream().filter(invoiceEntry -> invoiceHeadIds.contains(invoiceEntry.getPkValue())).anyMatch(invoiceEntry -> !vhcStd.contains(invoiceEntry.getString("seatgrade")));
        return isOverStd;
    }

    public static List<String> setExpenseSeatGrade(DynamicObject dataEntity, long tripItemEntryId, int tripItemIndex, String attribute) {
        Set invoiceHeadIds = dataEntity.getDynamicObjectCollection("invoiceitementry").stream().filter(invoiceItemEntry -> Objects.equals(tripItemEntryId, invoiceItemEntry.getLong("itementryid"))).map(invoiceItemEntry -> invoiceItemEntry.getLong("invoiceheadentryid")).collect(Collectors.toSet());
        Set invoiceList = dataEntity.getDynamicObjectCollection("invoiceentry").stream().filter(invoiceEntry -> invoiceHeadIds.contains(invoiceEntry.getPkValue())).filter(invoiceEntry -> StringUtils.isNotBlank((String)invoiceEntry.getString("seatgrade"))).map(invoiceEntry -> invoiceEntry.getString("seatgrade")).collect(Collectors.toSet());
        List<String> seatgrades = invoiceList.stream().map(seatgrade -> TripVhcStdChangeUtils.getVhcSeatGrade(seatgrade, attribute)).filter(seatgrade -> seatgrade != null).map(seatgrade -> seatgrade[1]).collect(Collectors.toList());
        return seatgrades;
    }

    public static String[] getVhcSeatGrade(String vhcName, String attribute) {
        if (vhcName == null) {
            return null;
        }
        Enum sgt = null;
        if (StringUtils.equals((String)attribute, (String)EXPENSE_ITEM_TRAIN)) {
            sgt = TripVhcStdChangeUtils.getTrainSeatGrade(vhcName);
        } else if (StringUtils.equals((String)attribute, (String)EXPENSE_ITEM_SHIP)) {
            sgt = TripVhcStdChangeUtils.getShipSeatGrade(vhcName);
        } else if (StringUtils.equals((String)attribute, (String)EXPENSE_ITEM_AIR)) {
            sgt = TripVhcStdChangeUtils.getAirSeatGrade(vhcName);
        }
        logger.info("\u5ea7\u4f4d\u7b49\u7ea7\uff1a" + vhcName + "\uff0c \u5c5e\u6027\uff1a" + attribute + "\uff0c\u679a\u4e3e\uff1a" + sgt);
        if (sgt != null) {
            String sValue = sgt.getKey();
            String sTittle = sgt.getName();
            return new String[]{sTittle, sValue};
        }
        return null;
    }

    public static List<Object> getTripUserId(DynamicObject dataEntity, DynamicObject curTripEntry) {
        DynamicObjectCollection traveler;
        ArrayList allTravlerId = Lists.newArrayList();
        Long userId = (Long)dataEntity.getDynamicObject("applier").getPkValue();
        if (curTripEntry.getDynamicObjectType().getProperty("travelers") != null && (traveler = curTripEntry.getDynamicObjectCollection("travelers")) != null && !traveler.isEmpty()) {
            List travelersList = traveler.stream().filter(trav -> trav.getDynamicObject("fbasedataid") != null).map(trav -> trav.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
            allTravlerId.addAll(travelersList);
        }
        if (allTravlerId.isEmpty()) {
            traveler = curTripEntry.getDynamicObject("traveler");
            if (traveler != null) {
                userId = (Long)traveler.getPkValue();
            }
            allTravlerId.add(userId);
        }
        return allTravlerId;
    }

    public static TrainSeatGradeType getTrainSeatGrade(String trainName) {
        switch (trainName) {
            case "\u5546\u52a1\u5ea7": 
            case "01": {
                return TrainSeatGradeType.tain_11;
            }
            case "\u7279\u7b49\u5ea7": 
            case "00": {
                return TrainSeatGradeType.tain_00;
            }
            case "\u4e00\u7b49\u5ea7": 
            case "02": {
                return TrainSeatGradeType.tain_12;
            }
            case "\u4e8c\u7b49\u5ea7": 
            case "03": {
                return TrainSeatGradeType.tain_13;
            }
            case "\u52a8\u5367": 
            case "04": 
            case "\u4e00\u7b49\u5367": 
            case "11": {
                return TrainSeatGradeType.tain_14;
            }
            case "\u9ad8\u7ea7\u8f6f\u5367": 
            case "05": {
                return TrainSeatGradeType.tain_15;
            }
            case "\u8f6f\u5367": 
            case "06": {
                return TrainSeatGradeType.tain_16;
            }
            case "\u786c\u5367": 
            case "07": 
            case "\u4e8c\u7b49\u5367": 
            case "12": {
                return TrainSeatGradeType.tain_17;
            }
            case "\u8f6f\u5ea7": 
            case "08": {
                return TrainSeatGradeType.tain_18;
            }
            case "\u786c\u5ea7": 
            case "09": {
                return TrainSeatGradeType.tain_19;
            }
            case "\u65e0\u5ea7": 
            case "10": {
                return TrainSeatGradeType.tain_20;
            }
        }
        return null;
    }

    public static AirSeatGradeType getAirSeatGrade(String airName) {
        switch (airName) {
            case "\u5934\u7b49\u8231": 
            case "01": {
                return AirSeatGradeType.air_A;
            }
            case "\u516c\u52a1/\u5546\u52a1\u8231": 
            case "\u5546\u52a1\u8231": 
            case "\u516c\u52a1\u8231": 
            case "02": {
                return AirSeatGradeType.air_B;
            }
            case "\u7ecf\u6d4e\u8231": 
            case "03": {
                return AirSeatGradeType.air_C;
            }
        }
        return null;
    }

    public static ShipSeatGradeType getShipSeatGrade(String airName) {
        switch (airName) {
            case "\u7279\u7b49\u8231": 
            case "21": {
                return ShipSeatGradeType.ship_A;
            }
            case "\u4e00\u7b49\u8231": 
            case "22": {
                return ShipSeatGradeType.ship_B;
            }
            case "\u4e8c\u7b49\u8231": 
            case "23": {
                return ShipSeatGradeType.ship_C;
            }
            case "\u4e09\u7b49\u8231": 
            case "24": {
                return ShipSeatGradeType.ship_D;
            }
            case "\u56db\u7b49\u8231": 
            case "25": {
                return ShipSeatGradeType.ship_E;
            }
            case "\u4e94\u7b49\u8231": 
            case "26": {
                return ShipSeatGradeType.ship_F;
            }
            case "\u5750\u5e2d": 
            case "27": {
                return ShipSeatGradeType.ship_G;
            }
        }
        return null;
    }

    public static TrainSeatGradeType getFuzzyMatchingTrainSeatGrade(String vhcName) {
        if (vhcName.contains(TrainSeatGradeType.tain_11.getName())) {
            return TrainSeatGradeType.tain_11;
        }
        if (vhcName.contains(TrainSeatGradeType.tain_00.getName())) {
            return TrainSeatGradeType.tain_00;
        }
        if (vhcName.contains(TrainSeatGradeType.tain_12.getName())) {
            return TrainSeatGradeType.tain_12;
        }
        if (vhcName.contains(TrainSeatGradeType.tain_13.getName())) {
            return TrainSeatGradeType.tain_13;
        }
        if (vhcName.contains(TrainSeatGradeType.tain_14.getName())) {
            return TrainSeatGradeType.tain_14;
        }
        if (vhcName.contains(TrainSeatGradeType.tain_15.getName())) {
            return TrainSeatGradeType.tain_15;
        }
        if (vhcName.contains(TrainSeatGradeType.tain_16.getName()) || vhcName.contains(TrainSeatGradeType.tain_21.getName())) {
            return TrainSeatGradeType.tain_16;
        }
        if (vhcName.contains(TrainSeatGradeType.tain_17.getName()) || vhcName.contains(TrainSeatGradeType.tain_22.getName())) {
            return TrainSeatGradeType.tain_17;
        }
        if (vhcName.contains(TrainSeatGradeType.tain_18.getName())) {
            return TrainSeatGradeType.tain_18;
        }
        if (vhcName.contains(TrainSeatGradeType.tain_19.getName())) {
            return TrainSeatGradeType.tain_19;
        }
        if (vhcName.contains(TrainSeatGradeType.tain_20.getName())) {
            return TrainSeatGradeType.tain_20;
        }
        return null;
    }

    public static AirSeatGradeType getFuzzyMatchingAirSeatGrade(String vhcName) {
        if (vhcName.contains(TripVhcStdChangeUtils.getSubStringVhcName(AirSeatGradeType.air_A.getName()))) {
            return AirSeatGradeType.air_A;
        }
        if (vhcName.contains(TripVhcStdChangeUtils.getSubStringVhcName(AirSeatGradeType.air_D.getName())) || vhcName.contains(TripVhcStdChangeUtils.getSubStringVhcName(AirSeatGradeType.air_E.getName()))) {
            return AirSeatGradeType.air_B;
        }
        if (vhcName.contains(TripVhcStdChangeUtils.getSubStringVhcName(AirSeatGradeType.air_C.getName()))) {
            return AirSeatGradeType.air_C;
        }
        return null;
    }

    private static String getSubStringVhcName(String vhcName) {
        if (vhcName != null && vhcName.length() >= 2) {
            vhcName = vhcName.substring(0, 2);
        }
        return vhcName;
    }

    public static String[] getFuzzyMatchingVhcSeatGrade(String vhcName, String attribute) {
        if (vhcName == null) {
            return null;
        }
        Enum sgt = StringUtils.equals((String)attribute, (String)EXPENSE_ITEM_TRAIN) ? TripVhcStdChangeUtils.getFuzzyMatchingTrainSeatGrade(vhcName) : TripVhcStdChangeUtils.getFuzzyMatchingAirSeatGrade(vhcName);
        logger.info("\u5ea7\u4f4d\u7b49\u7ea7\uff1a" + vhcName + "\uff0c \u5c5e\u6027\uff1a" + attribute + "\uff0c\u679a\u4e3e\uff1a" + sgt);
        if (sgt != null) {
            String sValue = sgt.getKey();
            String sTittle = sgt.getName();
            return new String[]{sTittle, sValue};
        }
        return null;
    }

    public static DynamicObject getMulSeatGradeBasedataId(String vhcName, String number) {
        QFilter qf = new QFilter("name", "=", (Object)vhcName);
        qf.and(new QFilter("number", "=", (Object)number));
        DynamicObject seatGradeDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"er_seatgradestd", (String)"id,name,attribute,number", (QFilter[])new QFilter[]{qf});
        if (seatGradeDyn != null) {
            return seatGradeDyn;
        }
        return null;
    }

    public static DynamicObject getTripAreaByCityIdAndCompanyId(Long cityId, QFilter tripareaOrgCtrlFilter) {
        QFilter filter = new QFilter("entryentity.city.id", "=", (Object)cityId);
        filter.and(new QFilter("enable", "=", (Object)true));
        if (null != tripareaOrgCtrlFilter) {
            filter.and(tripareaOrgCtrlFilter);
        }
        DynamicObject dobject = BusinessDataServiceHelper.loadSingleFromCache((String)"er_triparea", (String)"id", (QFilter[])new QFilter[]{filter});
        return dobject;
    }
}

