/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl;

import java.math.BigDecimal;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.AbstractInvoiceService;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.constant.ErTripReimburseBillConstant;

public class TripRemoveSameItemServiceImpl
extends AbstractInvoiceService {
    private static final String TRIP_ITEM_ENTRY = "entryentity";
    private static final String TRIP_ENTRY = "tripentry";
    private static final Log log = LogFactory.getLog(TripRemoveSameItemServiceImpl.class);
    private IDataModel dataModel;

    public TripRemoveSameItemServiceImpl(InvoiceContext invoiceContext, IDataModel dataModel) {
        super(invoiceContext);
        this.dataModel = dataModel;
    }

    @Override
    public void process() {
        if (ErStdConfig.getBoolean("orientryamount_of_tripreimbill")) {
            return;
        }
        DynamicObject dataEntity = this.dataModel.getDataEntity(true);
        int tripRowIndex = this.dataModel.getEntryCurrentRowIndex(TRIP_ENTRY);
        log.info(String.format("\u3010\u53d1\u7968\u4e91\u3011\u5220\u9664\u4e0e\u6620\u5c04\u5230\u7684\u5dee\u65c5\u9879\u76ee\u76f8\u540c\u4e14\u62a5\u9500\u91d1\u989d\u4e3a0\u7684\u5dee\u65c5\u660e\u7ec6, tripRowIndex: %d", tripRowIndex));
        DynamicObject tripEntryDOs = (DynamicObject)dataEntity.getDynamicObjectCollection(TRIP_ENTRY).get(tripRowIndex);
        DynamicObjectCollection tripItemEntryDOs = tripEntryDOs.getDynamicObjectCollection(TRIP_ITEM_ENTRY);
        int expenseItemEntryCount = tripItemEntryDOs.size();
        Set expenseItemIdSets = this.invoiceContext.getExpenseEntryBOs().stream().map(item -> item.getExpenseItemId()).collect(Collectors.toSet());
        for (int rowIndex = expenseItemEntryCount - 1; rowIndex >= 0; --rowIndex) {
            BigDecimal expenseAmount = (BigDecimal)this.dataModel.getValue("orientryamount", rowIndex, tripRowIndex);
            String invoiceNo = (String)this.dataModel.getValue("invoiceno_entry", rowIndex, tripRowIndex);
            DynamicObject expenseItem = (DynamicObject)this.dataModel.getValue("expenseitem", rowIndex, tripRowIndex);
            String settlement = (String)this.dataModel.getValue("settlementtype", rowIndex, tripRowIndex);
            Long expenseItemid = 0L;
            if (expenseItem != null) {
                expenseItemid = (Long)expenseItem.getPkValue();
            }
            if (expenseAmount != null && expenseAmount.abs().compareTo(BigDecimal.valueOf(1.0E-8)) >= 0 || !expenseItemIdSets.contains(expenseItemid) || !StringUtils.isBlank((CharSequence)invoiceNo) || ErTripReimburseBillConstant.SettlementType.MonthlySettlement.getValue().equals(settlement)) continue;
            log.info(String.format("\u3010\u53d1\u7968\u4e91\u3011\u5220\u9664\u4e0e\u6620\u5c04\u5230\u7684\u5dee\u65c5\u9879\u76ee\u76f8\u540c\u4e14\u62a5\u9500\u91d1\u989d\u4e3a0\u7684\u5dee\u65c5\u660e\u7ec6\uff0c\u5206\u5f55\u6807\u8bc6(%s), new tripRowIndex: %d, rowIndex:%d ", TRIP_ITEM_ENTRY, this.dataModel.getEntryCurrentRowIndex(TRIP_ENTRY), rowIndex));
            this.dataModel.deleteEntryRow(TRIP_ITEM_ENTRY, rowIndex);
        }
    }
}

