/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateEntryService;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.servicehelper.AdminDivisionServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.UserServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripBillTravelerUtils;
import kd.fi.er.common.constant.StdConfigConstant;
import kd.fi.er.common.model.invoice.bo.ExpenseEntryBO;
import kd.fi.er.formplugin.web.tripstandard.util.PlaneSeatUtil;
import org.apache.commons.lang3.StringUtils;

public class CreateTripItemEntryServiceImpl
extends CreateEntryService {
    private final String TRIP_ITEM_ENTRY = "entryentity";
    private final String TRIP_ENTRY = "tripentry";
    private static final Log log = LogFactory.getLog(CreateTripItemEntryServiceImpl.class);

    public CreateTripItemEntryServiceImpl(InvoiceContext invoiceContext, IDataModel dataModel) {
        super(invoiceContext);
        this.dataModel = dataModel;
        this.isOrgOffset = invoiceContext.getInvoiceConfig().isOrgOffset();
    }

    public CreateTripItemEntryServiceImpl(InvoiceContext invoiceContext, IDataModel dataModel, boolean isOrgOffset) {
        this(invoiceContext, dataModel);
        this.isOrgOffset = isOrgOffset;
    }

    @Override
    public void process() {
        int i;
        int tripEntryCount = this.dataModel.getEntryRowCount("tripentry");
        if (tripEntryCount < 1) {
            log.info("\u5dee\u65c5\u62a5\u9500\u5355\u7684\u884c\u7a0b\u5206\u5f55\u6570\u91cf\u4e3a0, \u4e0d\u80fd\u5bfc\u53d1\u7968");
            return;
        }
        int tripRowIndex = this.dataModel.getEntryCurrentRowIndex("tripentry");
        log.info("\u5bfc\u5165\u53d1\u7968CreateTripItemEntryServiceImpl \u5f53\u524d\u884c\u7a0b\u884c\uff1a" + tripRowIndex);
        DynamicObject tripEntryDO = (DynamicObject)this.dataModel.getEntryEntity("tripentry").get(tripRowIndex);
        List<Object> expenseEntryBOs = this.invoiceContext.getExpenseEntryBOs();
        String zeroCreate = ErStdConfig.getInvoiceZeroAmountCreateItem();
        if (StringUtils.equals((CharSequence)zeroCreate, (CharSequence)"0")) {
            expenseEntryBOs = expenseEntryBOs.stream().filter(entry -> entry.getTotalAmount().abs().compareTo(BigDecimal.valueOf(1.0E-6)) > 0).collect(Collectors.toList());
        }
        if (expenseEntryBOs.size() <= 0) {
            log.info("\u672a\u5bfc\u5165\u4efb\u4f55\u6709\u6548\u53d1\u7968");
            return;
        }
        this.setHeadIsCurrency();
        this.setEntryIdInFirst(expenseEntryBOs);
        DynamicObjectCollection tripItemEntrys = tripEntryDO.getDynamicObjectCollection("entryentity");
        HashMap rowIndexByEntryId = Maps.newHashMapWithExpectedSize((int)tripItemEntrys.size());
        for (i = 0; i < tripItemEntrys.size(); ++i) {
            rowIndexByEntryId.put(((DynamicObject)tripItemEntrys.get(i)).getLong("id"), i);
        }
        for (i = 0; i < expenseEntryBOs.size(); ++i) {
            int curTripItemRowIndex = rowIndexByEntryId.containsKey(((ExpenseEntryBO)expenseEntryBOs.get(i)).getEntryId()) ? ((Integer)rowIndexByEntryId.get(((ExpenseEntryBO)expenseEntryBOs.get(i)).getEntryId())).intValue() : this.dataModel.createNewEntryRow("entryentity");
            this.genExpenseItemEntry(this.invoiceContext, (ExpenseEntryBO)expenseEntryBOs.get(i), curTripItemRowIndex, tripRowIndex);
        }
    }

    @Override
    protected void createExpenseItemEntry(ExpenseEntryBO expenseEntryBO, int tripItemRowIndex, int tripIndex) {
        DynamicObject selectExpenseitem;
        log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011CreateTripItemEntryServiceImpl \u5dee\u65c5\u660e\u7ec6\u4fe1\u606f: " + expenseEntryBO + "\uff0c \u884c\u7a0b\uff1a" + tripIndex + ", \u660e\u7ec6\uff1a" + tripItemRowIndex);
        DynamicObject tripEntryDO = (DynamicObject)this.dataModel.getEntryEntity("tripentry").get(tripIndex);
        DynamicObject tripItemEntryDO = (DynamicObject)tripEntryDO.getDynamicObjectCollection("entryentity").get(tripItemRowIndex);
        tripItemEntryDO.set("id", (Object)expenseEntryBO.getEntryId());
        this.dataModel.setValue("itemfrom", (Object)ItemFrom.InvoiceCloud.getValue(), tripItemRowIndex, tripIndex);
        this.dataModel.setValue("invoicetypeitem", (Object)expenseEntryBO.getInvoiceType(), tripItemRowIndex, tripIndex);
        this.dataModel.setValue("expenseitem", (Object)expenseEntryBO.getExpenseItemId(), tripItemRowIndex, tripIndex);
        if (this.dataModel.getProperty("entrycurrency") != null) {
            boolean isCurrencyShowInTripEntry = SystemParamterUtil.getIsCurrencyShowinTripentry(ErCommonUtils.getPk(this.dataModel.getValue("company")));
            if (isCurrencyShowInTripEntry) {
                this.dataModel.setValue("tripcurrency", (Object)expenseEntryBO.getEntryCurrencyId(), tripIndex);
            }
            if (this.dataModel.getProperty("currency") != null) {
                DynamicObject currency = (DynamicObject)this.dataModel.getValue("currency");
                this.dataModel.beginInit();
                this.dataModel.setValue("entrycurrency", (Object)currency, tripItemRowIndex, tripIndex);
                this.dataModel.endInit();
            }
            this.dataModel.setValue("entrycurrency", (Object)expenseEntryBO.getEntryCurrencyId(), tripItemRowIndex, tripIndex);
        }
        this.dataModel.beginInit();
        this.dataModel.setValue("offset", (Object)(expenseEntryBO.getIsOffset() == false ? 1 : 0), tripItemRowIndex, tripIndex);
        this.dataModel.endInit();
        this.dataModel.setValue("offset", (Object)expenseEntryBO.getIsOffset(), tripItemRowIndex, tripIndex);
        if (expenseEntryBO.getExpenseItemId() != null && !expenseEntryBO.getExpenseItemId().equals(0L) && (selectExpenseitem = CommonServiceHelper.getObjById("er_tripexpenseitem", expenseEntryBO.getExpenseItemId())) != null) {
            this.dataModel.setValue("pic", (Object)selectExpenseitem.getString("expenseitemicon"), tripItemRowIndex, tripIndex);
        }
        this.dataModel.setValue("orientryamount", (Object)expenseEntryBO.getTotalAmount(), tripItemRowIndex, tripIndex);
        AmountUtils.refreshCurrAmount(this.dataModel, expenseEntryBO.getTotalAmount(), "entryamount", "exchangerate", "detailquotetype", tripItemRowIndex, tripIndex);
        this.dataModel.setValue("orientryappamount", (Object)expenseEntryBO.getTotalAmount(), tripItemRowIndex, tripIndex);
        AmountUtils.refreshCurrAmount(this.dataModel, expenseEntryBO.getTotalAmount(), "entryappamount", "exchangerate", "detailquotetype", tripItemRowIndex, tripIndex);
        this.dataModel.setValue("airportconstructionfee", (Object)expenseEntryBO.getAirportConstructionFee(), tripItemRowIndex, tripIndex);
        this.dataModel.setValue("isvactax", (Object)expenseEntryBO.getIsSpecialInvoice(), tripItemRowIndex, tripIndex);
        this.dataModel.setValue("taxclasscode", (Object)expenseEntryBO.getTaxClassCodeId(), tripItemRowIndex, tripIndex);
        this.dataModel.setValue("invoicelink", (Object)InvoiceUtils.getLimitedInvoiceCode(expenseEntryBO.getInvoiceCodeUnion()), tripItemRowIndex, tripIndex);
        this.dataModel.setValue("invoiceno_entry", (Object)InvoiceUtils.getLimitedInvoiceNo(expenseEntryBO.getInvoiceNoUnion()), tripItemRowIndex, tripIndex);
        this.dataModel.setValue("comment", (Object)expenseEntryBO.getRemark(), tripItemRowIndex, tripIndex);
        if (expenseEntryBO.getSeatGrades() != null) {
            log.info("\u5ea7\u4f4d\u7b49\u7ea7\uff1a {}", (Object)SerializationUtils.toJsonString((Object)expenseEntryBO.getSeatGrades()));
        }
        if (this.dataModel.getProperty("mulseatgrade") != null) {
            this.genSeatGrade(expenseEntryBO, tripItemRowIndex, tripIndex);
        }
        if (!this.isOrgOffset) {
            this.dataModel.setValue("taxrate", (Object)BigDecimal.ZERO, tripItemRowIndex, tripIndex);
            this.dataModel.setValue("taxamount", (Object)BigDecimal.ZERO, tripItemRowIndex, tripIndex);
            this.dataModel.setValue("notaxamount", (Object)expenseEntryBO.getTotalAmount(), tripItemRowIndex, tripIndex);
            if (this.dataModel.getProperty("approvetax") != null) {
                this.dataModel.setValue("approvetax", (Object)BigDecimal.ZERO, tripItemRowIndex, tripIndex);
            }
            this.dataModel.setValue("deductibletax", (Object)BigDecimal.ZERO, tripItemRowIndex, tripIndex);
            this.dataModel.setValue("iteminoutamount", (Object)BigDecimal.ZERO, tripItemRowIndex, tripIndex);
        } else {
            this.dataModel.setValue("taxrate", (Object)expenseEntryBO.getTaxRate().multiply(BigDecimal.valueOf(100L)), tripItemRowIndex, tripIndex);
            this.dataModel.setValue("taxamount", (Object)expenseEntryBO.getTaxAmount(), tripItemRowIndex, tripIndex);
            this.dataModel.setValue("notaxamount", (Object)expenseEntryBO.getNotIncludeTaxAmount(), tripItemRowIndex, tripIndex);
            if (this.dataModel.getProperty("approvetax") != null) {
                this.dataModel.setValue("approvetax", (Object)expenseEntryBO.getTaxAmount(), tripItemRowIndex, tripIndex);
            }
            this.dataModel.setValue("deductibletax", (Object)expenseEntryBO.getOffsetAmount(), tripItemRowIndex, tripIndex);
            this.dataModel.setValue("iteminoutamount", (Object)expenseEntryBO.getItemInOutAmount(), tripItemRowIndex, tripIndex);
        }
        String billKind = (String)this.dataModel.getValue("billkind");
        if (StringUtils.equals((CharSequence)billKind, (CharSequence)"1")) {
            List<DynamicObject> wayToCities;
            List<DynamicObject> endCityDOs;
            List<DynamicObject> startCityDOs;
            if (Objects.equals(this.invoiceContext.getInvoiceConfig().getExpenseDateValue(), StdConfigConstant.EXPENSE_DATE_VALUE_INVOICE)) {
                if (this.dataModel.getValue("trip2startdate", tripItemRowIndex, tripIndex) == null) {
                    this.dataModel.setValue("trip2startdate", (Object)expenseEntryBO.getStartDate(), tripItemRowIndex, tripIndex);
                }
                if (this.dataModel.getValue("trip2enddate", tripItemRowIndex, tripIndex) == null) {
                    this.dataModel.setValue("trip2enddate", (Object)expenseEntryBO.getEndDate(), tripItemRowIndex, tripIndex);
                }
            }
            if (this.dataModel.getValue("trip2from", tripItemRowIndex, tripIndex) == null && (startCityDOs = AdminDivisionServiceHelper.getCityByName(expenseEntryBO.getStartCity())).size() == 1) {
                this.dataModel.setValue("trip2from", startCityDOs.get(0).getPkValue(), tripItemRowIndex, tripIndex);
            }
            if (this.dataModel.getValue("trip2to", tripItemRowIndex, tripIndex) == null && (endCityDOs = AdminDivisionServiceHelper.getCityByName(expenseEntryBO.getEndCity())).size() == 1) {
                this.dataModel.setValue("trip2to", endCityDOs.get(0).getPkValue(), tripItemRowIndex, tripIndex);
            }
            if (!(wayToCities = AdminDivisionServiceHelper.getCityByNames(expenseEntryBO.getWayToCities())).isEmpty()) {
                DynamicObjectCollection wayToCityDOs = new DynamicObjectCollection();
                wayToCities.forEach(c -> wayToCityDOs.add(c));
                this.dataModel.setValue("trip2mulwayto", (Object)wayToCityDOs, tripItemRowIndex, tripIndex);
            }
            QFilter travelerQFilter = TripBillTravelerUtils.getTravelerF7QFilter((DynamicObject)this.dataModel.getValue("company"), (DynamicObject)this.dataModel.getValue("org"));
            List<DynamicObject> userDOs = UserServiceHelper.getUserByNames(expenseEntryBO.getPassengers(), travelerQFilter);
            if (!userDOs.isEmpty()) {
                Long applierId = ErCommonUtils.getPk(this.dataModel.getValue("applier"));
                boolean isMultiReimburser = userDOs.stream().anyMatch(userDO -> !userDO.getPkValue().equals(applierId));
                if (isMultiReimburser) {
                    this.dataModel.setValue("istravelers", (Object)true);
                }
                DynamicObjectCollection userDOCollection = new DynamicObjectCollection();
                userDOs.forEach(u -> userDOCollection.add(u));
                this.dataModel.setValue("trip2travelers", (Object)userDOCollection, tripItemRowIndex, tripIndex);
            }
        }
        DynamicObject tripEntryCostcompany = tripEntryDO.getDynamicObject("entrycostcompany");
        if (tripItemEntryDO.getDynamicObject("travelcostcompany") == null) {
            tripItemEntryDO.set("travelcostcompany", (Object)tripEntryCostcompany);
        }
        DynamicObject tripEntryCostdept = tripEntryDO.getDynamicObject("entrycostdept");
        if (tripItemEntryDO.getDynamicObject("travelcostdept") == null) {
            tripItemEntryDO.set("travelcostdept", (Object)tripEntryCostdept);
        }
        Date tripEntryHappendate = tripEntryDO.getDate("triphappendate");
        if (tripItemEntryDO.getDate("travelhappendate") == null) {
            tripItemEntryDO.set("travelhappendate", (Object)tripEntryHappendate);
        }
        DynamicObject tripEntryExpenseitem = tripEntryDO.getDynamicObject("tripexpenseitem");
        if (tripItemEntryDO.getDynamicObject("travelexpenseitem") == null) {
            tripItemEntryDO.set("travelexpenseitem", (Object)tripEntryExpenseitem);
        }
        if (tripItemEntryDO.getDynamicObject("travelquotactldept") == null) {
            Long quotaCtrlDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId(tripEntryExpenseitem, tripEntryCostdept, this.dataModel);
            tripItemEntryDO.set("travelquotactldept_id", (Object)quotaCtrlDeptId);
        }
        this.copyItem(tripItemRowIndex, tripIndex);
    }

    private void genSeatGrade(ExpenseEntryBO expenseEntryBO, int tripItemRowIndex, int tripRowIndex) {
        DynamicObject expenseItemDO = (DynamicObject)this.dataModel.getValue("expenseitem", tripItemRowIndex, tripRowIndex);
        RefObject attrRef = new RefObject();
        Set seatGrade = this.getSeatGradle(expenseEntryBO, expenseItemDO, (RefObject<String>)attrRef);
        log.info("lxc==============222: {}", (Object)SerializationUtils.toJsonString((Object)seatGrade));
        if (!seatGrade.isEmpty() && StringUtils.isNotEmpty((CharSequence)((CharSequence)attrRef.getValue()))) {
            DynamicObject[] seatGradeArr = PlaneSeatUtil.findSeatByAttribute((String)attrRef.getValue(), seatGrade);
            log.info("lxc==============000: {}", (Object)seatGradeArr.length);
            if (seatGradeArr != null && seatGradeArr.length > 0) {
                DynamicObjectCollection mulseatgrades = ((DynamicObject)((DynamicObject)this.dataModel.getDataEntity(true).getDynamicObjectCollection("tripentry").get(tripRowIndex)).getDynamicObjectCollection("entryentity").get(tripItemRowIndex)).getDynamicObjectCollection("mulseatgrade");
                if (null != mulseatgrades) {
                    mulseatgrades.clear();
                    for (DynamicObject dynamicObject : seatGradeArr) {
                        DynamicObject mulseatgrade = mulseatgrades.addNew();
                        mulseatgrade.set("fbasedataid", (Object)dynamicObject);
                        mulseatgrade.set("fbasedataid_id", dynamicObject.getPkValue());
                    }
                }
            } else {
                this.dataModel.setValue("mulseatgrade", null, tripItemRowIndex, tripRowIndex);
            }
        }
    }

    protected void setHeadIsCurrency() {
        long currencyid;
        List<ExpenseEntryBO> expenseEntryBOs = this.invoiceContext.getExpenseEntryBOs();
        long entryid = expenseEntryBOs.get(0).getEntryCurrencyId();
        if (entryid != (currencyid = ErCommonUtils.getPk(this.dataModel.getValue("currency")).longValue())) {
            this.dataModel.setValue("iscurrency", (Object)Boolean.TRUE);
        }
    }

    private void copyItem(int tripItemRowIndex, int tripRowIndex) {
        if (this.curSelectedItem != null) {
            this.dataModel.setValue("entrycurrency", (Object)ErCommonUtils.getPk(this.curSelectedItem.getDynamicObject("entrycurrency")), tripItemRowIndex, tripRowIndex);
            this.dataModel.setValue("exchangerate", (Object)this.curSelectedItem.getBigDecimal("exchangerate"), tripItemRowIndex, tripRowIndex);
            this.dataModel.beginInit();
            this.dataModel.setValue("travelcostcompany", (Object)ErCommonUtils.getPk(this.curSelectedItem.getDynamicObject("travelcostcompany")), tripItemRowIndex, tripRowIndex);
            this.dataModel.setValue("travelcostdept", (Object)ErCommonUtils.getPk(this.curSelectedItem.getDynamicObject("travelcostdept")), tripItemRowIndex, tripRowIndex);
            this.dataModel.setValue("travelhappendate", (Object)this.curSelectedItem.getDate("travelhappendate"), tripItemRowIndex, tripRowIndex);
            this.dataModel.setValue("travelexpenseitem", (Object)ErCommonUtils.getPk(this.curSelectedItem.getDynamicObject("travelexpenseitem")), tripItemRowIndex, tripRowIndex);
            this.dataModel.setValue("travelquotactldept", (Object)ErCommonUtils.getPk(this.curSelectedItem.getDynamicObject("travelquotactldept")), tripItemRowIndex, tripRowIndex);
            this.dataModel.endInit();
        }
    }

    public void setEntryIdInFirst(List<ExpenseEntryBO> expenseEntryExcludeZeroBOs) {
        if (this.curSelectedItem != null) {
            expenseEntryExcludeZeroBOs.get(0).setEntryId(ErCommonUtils.getPk(this.curSelectedItem));
        }
    }
}

