/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService.CreateInvoiceServiceI;
import kd.fi.er.common.model.invoice.bo.InvoiceEntryBO;
import kd.fi.er.common.model.invoice.bo.InvoiceItemEntryBO;
import org.apache.commons.lang3.StringUtils;

public class CreateInvoiceEntryServiceImpForTripMob
extends CreateInvoiceServiceI {
    private static final Log log = LogFactory.getLog(CreateInvoiceEntryServiceImpForTripMob.class);
    private AbstractFormPlugin formPlugin;
    private Long expenseId;

    public CreateInvoiceEntryServiceImpForTripMob(InvoiceContext invoiceContext, Long expenseId, AbstractFormPlugin formPlugin) {
        super(invoiceContext);
        this.formPlugin = formPlugin;
        this.expenseId = expenseId;
    }

    @Override
    public void process() {
        List<InvoiceEntryBO> invoiceEntryBOs = this.invoiceContext.getInvoiceEntryBOs();
        if (invoiceEntryBOs.size() <= 0) {
            log.info("\u672a\u5bfc\u5165\u4efb\u4f55\u53d1\u7968");
            return;
        }
        invoiceEntryBOs.sort(Comparator.comparing(InvoiceEntryBO::getInvoiceDateForSort));
        this.createInvoiceHeadEntry(invoiceEntryBOs);
        this.createInvoiceItemEntry(this.invoiceContext.getInvoiceItemEntryBOs());
    }

    private void createInvoiceHeadEntry(List<InvoiceEntryBO> invoiceEntryBOs) {
        IPageCache pCache = this.formPlugin.getPageCache();
        String headStr = "invoiceentry" + this.expenseId;
        String existsJson = pCache.get(headStr);
        ArrayList<InvoiceEntryBO> invoiceEntryBOList = new ArrayList<InvoiceEntryBO>();
        if (!StringUtils.isEmpty((CharSequence)existsJson)) {
            invoiceEntryBOList.addAll(JSON.parseArray((String)existsJson, InvoiceEntryBO.class));
        }
        invoiceEntryBOList.addAll(invoiceEntryBOs);
        String invoiceEntry = JSON.toJSONString(invoiceEntryBOList);
        pCache.put(headStr, invoiceEntry);
    }

    private void createInvoiceItemEntry(List<InvoiceItemEntryBO> invoiceItemEntryBOs) {
        IPageCache pCache = this.formPlugin.getPageCache();
        String headStr = "invoiceitementry" + this.expenseId;
        String existsJson = pCache.get(headStr);
        ArrayList<InvoiceItemEntryBO> invoiceItemEntryBOList = new ArrayList<InvoiceItemEntryBO>();
        if (!StringUtils.isEmpty((CharSequence)existsJson)) {
            invoiceItemEntryBOList.addAll(JSON.parseArray((String)existsJson, InvoiceItemEntryBO.class));
        }
        invoiceItemEntryBOList.addAll(invoiceItemEntryBOs);
        String invoiceItemEntry = JSON.toJSONString(invoiceItemEntryBOList);
        pCache.put(headStr, invoiceItemEntry);
    }
}

