/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.incrementalService;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.impl.incrementalService.IncrementalMergeExpenseOrTripItemInvoiceServiceImp;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.model.invoice.bo.ExpenseEntryBO;
import org.apache.commons.lang3.StringUtils;

public class IncrementalMergeExpenseOrTripItemInvoiceForMobServiceImp
extends IncrementalMergeExpenseOrTripItemInvoiceServiceImp {
    public IncrementalMergeExpenseOrTripItemInvoiceForMobServiceImp(InvoiceContext invoiceContext, int index, int parentIndex) {
        super(invoiceContext, invoiceContext.getView().getModel());
        this.invoiceContext = invoiceContext;
        this.setInvoiceCurrencyId(invoiceContext.getInvoiceConfig().getInvoiceCurrencyId());
        if (this.getModel().getProperty("expenseentryentity") != null) {
            this.setTripItem(false);
        } else if (this.getModel().getProperty("tripentry") != null) {
            this.setTripItem(true);
        } else {
            this.setTripItem(true);
        }
    }

    @Override
    public ExpenseEntryBO changeVOToBO(DynamicObject oldItem) {
        DynamicObject item;
        DynamicObject oldEntry = oldItem;
        if (!this.isTripItem()) {
            return super.changeVOToBO(oldEntry);
        }
        ExpenseEntryBO expenseEntryBO = new ExpenseEntryBO();
        expenseEntryBO.setEntryId(Long.valueOf(oldEntry.getLong("enpenseid")));
        expenseEntryBO.setInvoiceType(oldEntry.getString("invoicetypeitem"));
        expenseEntryBO.setIsOffset(Boolean.valueOf(oldEntry.getBoolean("offset")));
        expenseEntryBO.setIsSpecialInvoice(Boolean.valueOf(oldEntry.getBoolean(this.isTripItem() ? "isvactax" : "is_special_invoice")));
        expenseEntryBO.setOffsetAmount(oldEntry.getBigDecimal("deductibletax"));
        expenseEntryBO.setItemInOutAmount(oldEntry.getBigDecimal("iteminoutamount"));
        if (oldEntry.getDynamicObjectType().getProperty("happendate") != null) {
            expenseEntryBO.setHappenDate(oldEntry.getDate("happendate"));
        } else {
            expenseEntryBO.setHappenDate(new Date());
        }
        if (oldEntry.getDynamicObjectType().getProperty("expenseamount") != null) {
            expenseEntryBO.setTotalAmount(oldEntry.getBigDecimal("expenseamount"));
        } else if (oldEntry.getDynamicObjectType().getProperty("orientryamount") != null) {
            expenseEntryBO.setTotalAmount(oldEntry.getBigDecimal("orientryamount"));
        }
        expenseEntryBO.setAirportConstructionFee(oldEntry.getBigDecimal("airportconstructionfee"));
        expenseEntryBO.setTaxRate(oldEntry.getBigDecimal("taxrate").divide(BigDecimal.valueOf(100L)));
        expenseEntryBO.setTaxAmount(oldEntry.getBigDecimal("taxamount"));
        DynamicObject taxClassCode = oldEntry.getDynamicObject("taxclasscode");
        if (taxClassCode != null) {
            expenseEntryBO.setTaxClassCodeId((Long)taxClassCode.getPkValue());
        }
        expenseEntryBO.setInvoiceCodeUnion(oldEntry.getString("invoicelink"));
        expenseEntryBO.setInvoiceNoUnion(oldEntry.getString("invoiceno_entry"));
        if (oldEntry.getDynamicObjectType().getProperty("expensegoodsname") != null) {
            expenseEntryBO.setGoodName(oldEntry.getString("expensegoodsname"));
        }
        if (oldEntry.getDynamicObjectType().getProperty("comment") != null) {
            expenseEntryBO.setRemark(oldEntry.getString("comment"));
        } else if (oldEntry.getDynamicObjectType().getProperty("remark") != null) {
            expenseEntryBO.setRemark(oldEntry.getString("remark"));
        }
        if (oldEntry.getDynamicObjectType().getProperty("expenseitem") != null && (item = oldEntry.getDynamicObject("expenseitem")) != null && item.getDynamicObjectType().getProperty("attribute") != null) {
            expenseEntryBO.setExpenseItemId((Long)item.getPkValue());
            String attribute = item.getString("attribute");
            DynamicObjectCollection seatGradeDC = oldEntry.getDynamicObjectCollection("mulseatgrade");
            Set seat = seatGradeDC.stream().map(seatGrade -> seatGrade.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toSet());
            HashMap seatGrades = Maps.newHashMapWithExpectedSize((int)2);
            if (StringUtils.equals((CharSequence)attribute, (CharSequence)"2")) {
                seatGrades.put("2", seat);
            } else if (StringUtils.equals((CharSequence)attribute, (CharSequence)"4")) {
                seatGrades.put("4", seat);
            }
            expenseEntryBO.setSeatGrades((Map)seatGrades);
        }
        String parentPageId = this.invoiceContext.getView().getFormShowParameter().getParentPageId();
        IDataModel parentDdataModel = this.invoiceContext.getView().getViewNoPlugin(parentPageId).getModel();
        DynamicObject parentObj = parentDdataModel.getDataEntity(true);
        Set<Long> invoiceHeadIds = InvoiceUtils.mapInvoiceSet(parentObj, oldItem.getLong("enpenseid"));
        Boolean isInvoiceOffset = null;
        if (!CollectionUtils.isEmpty(invoiceHeadIds)) {
            isInvoiceOffset = InvoiceOffsetUtils.isInvoiceOffset(parentDdataModel, invoiceHeadIds);
        }
        expenseEntryBO.setInvoiceIsOffset(isInvoiceOffset);
        DynamicObject expenseItem = oldItem.getDynamicObject("expenseitem");
        if (expenseItem != null) {
            Boolean expenseItemOffset = this.getItemOffset(expenseItem);
            if (expenseItemOffset != null) {
                expenseEntryBO.setExpenseItemIsOffset(expenseItemOffset);
            }
        } else {
            expenseEntryBO.setExpenseItemIsOffset(Boolean.valueOf(false));
        }
        return expenseEntryBO;
    }
}

