/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.amount.control.feestandard.FeeStandardHelper;
import kd.fi.er.business.invoicecloud.v2.expenserange.MappingItemUtils;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class MappingItemRangeImpl
implements IInvoiceService {
    private static final String ALGO_KEY = MappingItemRangeImpl.class.getName();
    private static final Log log = LogFactory.getLog(MappingItemRangeImpl.class);
    private MappingItemWithOrgInvoiceServiceImp.BillType billType;
    private ExpRangeFactor rangeFactor;
    private DynamicObject dataEntity;

    public MappingItemRangeImpl(MappingItemWithOrgInvoiceServiceImp.BillType billType, ExpRangeFactor rangeFactor, DynamicObject dataEntity) {
        this.billType = billType;
        this.rangeFactor = rangeFactor;
        this.dataEntity = dataEntity;
    }

    @Override
    public void process() {
        throw new UnsupportedOperationException();
    }

    public Set<Long> getItemIds() {
        log.info(String.format("\u8d39\u7528\u9879\u76ee\u8303\u56f4\u8fc7\u6ee4\uff0c\u5355\u636e\u5206\u5f55\u884c\u6570\u636e rangeFactor: %s", this.rangeFactor));
        Object org = this.dataEntity.get(this.billType.getOrgClumn());
        if (org == null) {
            return Collections.emptySet();
        }
        List<DynamicObject> mappings = MappingItemUtils.getAvailableMapping(this.billType, ErCommonUtils.getPk(org), this.getSelectFields());
        String goodName = this.rangeFactor.getGoodName();
        String invoiceType = this.rangeFactor.getInvoiceType();
        invoiceType = "0".equalsIgnoreCase(invoiceType) ? "" : invoiceType;
        boolean goodNameBlank = StringUtils.isBlank((CharSequence)goodName);
        ArrayList collection = new ArrayList(0);
        for (DynamicObject mapping : mappings) {
            String configType = mapping.getString("inv_invoicetype");
            if (!configType.equals(invoiceType)) continue;
            boolean matched = false;
            boolean hasConfig = false;
            DynamicObjectCollection configOtherFactors = mapping.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < configOtherFactors.size(); ++i) {
                DynamicObject factor = (DynamicObject)configOtherFactors.get(i);
                String factorKey = factor.getString("invoicefactor");
                if (!"inv_ext_goodnames".equals(factorKey)) continue;
                hasConfig = true;
                String mappingType = factor.getString("inv_mappingtype");
                String mappingValue = factor.getString("mapfactor");
                log.info(String.format("\u8d39\u7528\u9879\u76ee\u8303\u56f4\u8fc7\u6ee4\uff0c\u6620\u5c04\u56e0\u7d20 index: %d, mappingType: %s, mappingValue: %s", i, mappingType, mappingValue));
                if (StringUtils.equals((CharSequence)mappingType, (CharSequence)"0")) {
                    matched = StringUtils.equals((CharSequence)goodName, (CharSequence)mappingValue);
                } else if (StringUtils.equals((CharSequence)mappingType, (CharSequence)"1")) {
                    matched = StringUtils.contains((CharSequence)goodName, (CharSequence)mappingValue);
                }
                if (matched) break;
            }
            if (!hasConfig) {
                boolean bl = matched = StringUtils.isNotBlank((CharSequence)invoiceType) && goodNameBlank;
            }
            if (!matched) continue;
            collection.addAll(mapping.getDynamicObjectCollection("expitemrange"));
        }
        if (collection.size() == 0) {
            return null;
        }
        String entityName = this.billType.getItemEnum().getEntityName();
        String entryItemId = this.getEntryItemId();
        Collection set = collection.stream().map(e -> e.get(entryItemId)).collect(Collectors.toSet());
        Collection c = this.getBizItemExpenseItems();
        if (!c.isEmpty()) {
            set = CollectionUtils.intersection((Collection)set, (Collection)c);
        }
        QFilter filter = new QFilter("id", "in", (Object)set);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)entityName, (String)"id", (QFilter[])filter.toArray(), null);){
            DynamicObjectCollection ids = ORM.create().toPlainDynamicObjectCollection(ds);
            Set<Long> set2 = ids.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            return set2;
        }
    }

    private Collection getBizItemExpenseItems() {
        DynamicObjectCollection expenseItemRange;
        DynamicObject bizItem;
        DynamicObject setting;
        boolean hasProperty;
        boolean bl = hasProperty = this.dataEntity.getDynamicObjectType().getProperty("bizitem") != null;
        if (hasProperty && this.dataEntity.getDynamicObject("bizitem") != null && (setting = FeeStandardHelper.queryBizItem((bizItem = this.dataEntity.getDynamicObject("bizitem")).getString("number"))) != null && !(expenseItemRange = setting.getDynamicObjectCollection("entryentity")).isEmpty()) {
            Set set = expenseItemRange.stream().map(e -> e.getLong("expenseitem.id")).collect(Collectors.toSet());
            return set;
        }
        return Collections.emptySet();
    }

    protected String getSelectFields() {
        String entryItemField = this.getEntryItemId();
        String selectFields = "ctrlstrategy, id, modifytime, createorg, relbilltype, inv_invoicetype,entryentity.inv_mappingtype,entryentity.invoicefactor,entryentity.mapfactor," + entryItemField + ",expitemrange.isdefault";
        return selectFields;
    }

    private String getEntryItemId() {
        return "entry" + this.billType.getItem() + ".id";
    }

    public static class ExpRangeFactor {
        private String invoiceType;
        private String goodName;

        public ExpRangeFactor(String invoiceType, String goodName) {
            this.invoiceType = invoiceType;
            this.goodName = goodName;
        }

        public String getInvoiceType() {
            return this.invoiceType;
        }

        public void setInvoiceType(String invoiceType) {
            this.invoiceType = invoiceType;
        }

        public String getGoodName() {
            return this.goodName;
        }

        public void setGoodName(String goodName) {
            this.goodName = goodName;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("invoiceType", (Object)this.invoiceType).append("goodName", (Object)this.goodName).toString();
        }
    }
}

