/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.preHandleInvoiceService;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceTypeEnum;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.TaxRatePool;
import kd.fi.er.business.invoicecloud.v2.service.impl.preHandleInvoiceService.PreHandleInvoiceService;
import kd.fi.er.common.model.invoice.InvoiceItemVO;
import kd.fi.er.common.model.invoice.InvoiceProcessMessage;
import kd.fi.er.common.model.invoice.InvoiceProcessResult;
import kd.fi.er.common.model.invoice.InvoiceVO;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class PreHandleInvoiceServiceImpl
extends PreHandleInvoiceService {
    private static final Log log = LogFactory.getLog(PreHandleInvoiceServiceImpl.class);

    public PreHandleInvoiceServiceImpl(InvoiceContext invoiceContext) {
        super(invoiceContext);
    }

    @Override
    public void process() {
        List<InvoiceVO> invoiceVOs = this.invoiceContext.getInvoiceVOs();
        InvoiceProcessResult ipr = new InvoiceProcessResult();
        ipr.setServiceName(this.getClass().getName());
        this.invoiceContext.getInvoiceResult().put(this.getClass().getName(), ipr);
        for (InvoiceVO invoiceVO : invoiceVOs) {
            Long currencyId;
            List invoiceItemVOs = invoiceVO.getItems();
            this.processInvoiceHead(invoiceVO, ipr);
            if (invoiceItemVOs == null || invoiceItemVOs.size() < 1) {
                this.createInvoiceItem(invoiceVO);
                invoiceItemVOs = invoiceVO.getItems();
            }
            this.processWhenDetailAmountIsZero(invoiceVO, invoiceItemVOs, ipr);
            String rawInvoiceType = (String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getInvoiceType(), (CharSequence)InvoiceTypeEnum.key_11.getValue());
            QFilter numberQf = new QFilter("number", "=", (Object)rawInvoiceType);
            QFilter enableQf = new QFilter("enable", "=", (Object)Character.valueOf('1'));
            DynamicObjectCollection typeArr = QueryServiceHelper.query((String)"er_invoicetype", (String)"id", (QFilter[])new QFilter[]{numberQf, enableQf});
            if (typeArr == null || typeArr.size() == 0) {
                String notExistInfo = String.format(ResManager.loadKDString((String)"%s,\u8fd9\u79cd\u53d1\u7968\u7c7b\u578b\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff0c\u8bf7\u53ca\u65f6\u8054\u7cfb\u53d1\u7968\u4e91\u66f4\u65b0\u53d1\u7968\u679a\u4e3e\u7c7b\u578b\u3001\u6216\u5728\u82cd\u7a79\u53d1\u7968\u7c7b\u578b(\u53d1\u7968\u4e91)\u57fa\u7840\u8d44\u6599\u4e2d\u589e\u52a0\u3002", (String)"PreHandleInvoiceServiceImpl_1", (String)"fi-er-business", (Object[])new Object[0]), rawInvoiceType);
                log.info(notExistInfo);
                ipr.getProcessResult().add(new InvoiceProcessMessage(notExistInfo, "info"));
                rawInvoiceType = InvoiceTypeEnum.key_11.getValue();
            }
            invoiceVO.setInvoiceType(rawInvoiceType);
            if (StringUtils.equals((CharSequence)rawInvoiceType, (CharSequence)InvoiceTypeEnum.key_19.getValue())) {
                invoiceVO.setInvoiceNo(invoiceVO.getTaxPaidProofNo());
            }
            if (!"30".equalsIgnoreCase(invoiceVO.getInvoiceType()) || (currencyId = invoiceVO.getCurrencyId()) != null) continue;
            invoiceVO.setCurrencyId(Long.valueOf(0L));
        }
    }

    private void processInvoiceHead(InvoiceVO invoiceVO, InvoiceProcessResult ipr) {
        InvoiceTypeEnum invoiceType;
        Date invoiceDate = invoiceVO.getInvoiceDate();
        if (invoiceDate == null) {
            String nullDateInfo = String.format(ResManager.loadKDString((String)"\u8fd9\u5f20\u53d1\u7968\u7684\u5f00\u7968\u65e5\u671f\u4e3a\u7a7a\uff1a%s\uff0c\u53d6\u5f53\u524d\u65e5\u671f\u3002", (String)"PreHandleInvoiceServiceImpl_2", (String)"fi-er-business", (Object[])new Object[0]), invoiceVO.getSerialNo());
            log.info(nullDateInfo);
            ipr.getProcessResult().add(new InvoiceProcessMessage(nullDateInfo, "info"));
            invoiceVO.setInvoiceDate(new Date());
        }
        if (TaxRatePool.containInvoiceType(invoiceType = InvoiceTypeEnum.getByValue(invoiceVO.getInvoiceType())) && invoiceType == InvoiceTypeEnum.key_10) {
            BigDecimal oldTotalAmount = (BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceVO.getTotalAmount(), (Object)BigDecimal.ZERO);
            BigDecimal insuranceAmount = (BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceVO.getInsurancePremium(), (Object)BigDecimal.ZERO);
            invoiceVO.setTotalAmount(oldTotalAmount.add(insuranceAmount));
        }
        if (invoiceVO.getOriBalanceAmount() == null || BigDecimal.ZERO.compareTo(invoiceVO.getOriBalanceAmount()) == 0) {
            invoiceVO.setOriBalanceAmount(invoiceVO.getTotalAmount());
        }
    }

    private void processWhenDetailAmountIsZero(InvoiceVO invoiceVO, List<InvoiceItemVO> invoiceItemVOs, InvoiceProcessResult ipr) {
        List invoiceItemVOsIsZero = invoiceItemVOs.stream().filter(invoiceItemVO -> ((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceItemVO.getDetailAmount(), (Object)BigDecimal.ZERO)).abs().compareTo(BigDecimal.valueOf(1.0E-6)) < 0).collect(Collectors.toList());
        BigDecimal invoiceItemTotalAmount = invoiceItemVOs.stream().map(invoiceItemVO -> ((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceItemVO.getDetailAmount(), (Object)BigDecimal.ZERO)).add((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceItemVO.getTaxAmount(), (Object)BigDecimal.ZERO))).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        if (invoiceItemTotalAmount.subtract(invoiceVO.getTotalAmount()).abs().compareTo(BigDecimal.valueOf(1.0E-6)) > 0) {
            if (invoiceItemVOsIsZero.size() == 1) {
                InvoiceItemVO invoiceItemVONeedCalc = (InvoiceItemVO)invoiceItemVOsIsZero.get(0);
                List correctInvoiceItems = invoiceItemVOs.stream().filter(invoiceItemVO -> !invoiceItemVO.equals(invoiceItemVONeedCalc)).collect(Collectors.toList());
                BigDecimal correctTaxAmount = correctInvoiceItems.stream().map(invoiceItem -> (BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceItem.getTaxAmount(), (Object)BigDecimal.ZERO)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal correctTotalAmount = correctInvoiceItems.stream().map(invoiceItem -> ((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceItem.getTaxAmount(), (Object)BigDecimal.ZERO)).add((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceItem.getDetailAmount(), (Object)BigDecimal.ZERO))).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal taxAmount = invoiceVO.getTaxAmount().subtract(correctTaxAmount);
                BigDecimal excludedTaxAmount = invoiceVO.getTotalAmount().subtract(correctTotalAmount).subtract(taxAmount);
                invoiceItemVONeedCalc.setTaxAmount(taxAmount);
                invoiceItemVONeedCalc.setDetailAmount(excludedTaxAmount);
                BigDecimal taxRate = BigDecimal.ZERO;
                if (excludedTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
                    taxRate = taxAmount.divide(excludedTaxAmount, 2, RoundingMode.HALF_EVEN);
                }
                invoiceItemVONeedCalc.setTaxRate(taxRate);
            } else if (invoiceItemVOsIsZero.size() > 1) {
                invoiceVO.setItems(null);
                this.createInvoiceItem(invoiceVO);
                String oldValidateMessage = invoiceVO.getValidateMessage();
                String msg = ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u5df2\u5408\u5e76\u4e3a\u4e00\u6761\u3002", (String)"PreHandleInvoiceServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]);
                ipr.getProcessResult().add(new InvoiceProcessMessage(msg, "info"));
                msg = StringUtils.isBlank((CharSequence)oldValidateMessage) ? msg : oldValidateMessage + ";" + msg;
                invoiceVO.setValidateMessage(msg);
            }
        }
    }

    private void createInvoiceItem(InvoiceVO invoiceVO) {
        ArrayList<InvoiceItemVO> invoiceItemVOs = new ArrayList<InvoiceItemVO>(1);
        InvoiceItemVO invoiceItemVO = new InvoiceItemVO();
        invoiceItemVOs.add(invoiceItemVO);
        invoiceVO.setItems(invoiceItemVOs);
        invoiceItemVO.setGoodsCode(invoiceVO.getInvoiceType());
        invoiceItemVO.setGoodsName("");
        invoiceItemVO.setNum(BigDecimal.ONE);
        BigDecimal taxAmount = invoiceVO.getTaxAmount();
        if (taxAmount == null) {
            taxAmount = BigDecimal.ZERO;
        }
        BigDecimal excludedTaxAmount = invoiceVO.getTotalAmount().subtract(taxAmount);
        invoiceItemVO.setUnitPrice(excludedTaxAmount);
        invoiceItemVO.setDetailAmount(excludedTaxAmount);
        invoiceItemVO.setTaxAmount(taxAmount);
        invoiceItemVO.setUnit("");
        invoiceItemVO.setSpecModel("");
        invoiceItemVO.setTaxRate(invoiceVO.getTaxRate());
        log.info("\u3010\u53d1\u7968\u4e91\u3011PreHandleInvoiceServiceImpl createInvoiceItem:" + JSON.toJSONString((Object)invoiceItemVO));
    }
}

