/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.util;

import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.Random;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.utils.ErStdConfig;
import org.apache.http.client.utils.URIBuilder;

public class AllInvoiceUrl {
    private static Log logger = LogFactory.getLog(AllInvoiceUrl.class);
    private static final String KEY_QUERY_INVOICE = "invoicecloud.queryInvoice";
    private static final String KEY_DEL_ACTION = "invoicecloud.delAction";
    private static final String KEY_SELECT_INVOICE_ACTION = "invoicecloud.selectInvoiceAction";
    private static final String KEY_TOKEN_ACTION = "invoicecloud.tokenAction";
    private static final String KEY_UPDATE_INVOICE_STATUS = "invoicecloud.updateInvoiceStatus";
    private static final String KEY_USERKEY_ACTION = "invoicecloud.userKeyAction";
    private static final String KEY_VALIDATE = "invoicecloud.validate";
    private static final String KEY_GET_COMMON_USERKEY = "invoicecloud.getCommonUserKey";
    private static final String KEY_GET_EDIT_INVOICE_URL_PC = "invoicecloud.pc_editinvoice";
    private static final String KEY_EVENT_CODE_URL = "invoicecloud.eventCodeUrl";
    private static final String KEY_HTTP_OF_PC = "invoicecloud.httpOfPC";
    private static final String KEY_UP_LOAD = "invoicecloud.uploadImage";
    private static final String KEY_SAVE_VOUCHER = "invoicecloud.saveVoucher";
    private static final String KEY_DELETE_VOUCHER = "invoicecloud.deleteVoucher";
    private static final String KEY_QUERY_INVOICE_BY_USER = "invoicecloud.queryInvoiceByuser";
    private static final String KEY_DELETE_ATTACH_PAGE_PC = "invoicecloud.deleteattachpagepc";
    private static final String KEY_DELETE_ATTACH_PAGE_MOB = "invoicecloud.deleteattachpagemob";
    private static final String KEY_QUERY_ATTACH = "invoicecloud.queryattach";
    private static final Random random = new SecureRandom();

    public static String queryInvoice(String token) {
        String path = ErStdConfig.get(KEY_QUERY_INVOICE);
        return AllInvoiceUrl.buildUrl(path, token);
    }

    public static String getQueryInvoiceRelativeUrl() {
        return ErStdConfig.get(KEY_QUERY_INVOICE);
    }

    public static String delAction(String token) {
        String path = ErStdConfig.get(KEY_DEL_ACTION);
        return AllInvoiceUrl.buildUrl(path, token);
    }

    public static String selectInvoiceAction(String token) {
        String path = ErStdConfig.get(KEY_SELECT_INVOICE_ACTION);
        return AllInvoiceUrl.buildUrl(path, token);
    }

    public static String selectInvoiceActionByUser(String token) {
        String path = ErStdConfig.get(KEY_QUERY_INVOICE_BY_USER);
        return AllInvoiceUrl.buildUrl(path, token);
    }

    public static String updateInvoiceStatus(String token) {
        String path = ErStdConfig.get(KEY_UPDATE_INVOICE_STATUS);
        return AllInvoiceUrl.buildUrl(path, token);
    }

    public static String userKeyAction(String token) {
        String path = ErStdConfig.get(KEY_USERKEY_ACTION);
        return AllInvoiceUrl.finalUrl(path) + AllInvoiceUrl.concatToken(token);
    }

    public static String validate(String token) {
        String path = ErStdConfig.get(KEY_VALIDATE);
        return AllInvoiceUrl.buildUrl(path, token);
    }

    public static String getCommonUserKey() {
        String path = ErStdConfig.get(KEY_GET_COMMON_USERKEY);
        return AllInvoiceUrl.buildUrl(path);
    }

    public static String upload() {
        String path = ErStdConfig.get(KEY_UP_LOAD);
        return AllInvoiceUrl.buildUrl(path);
    }

    public static String getEditInvoiceUrlPc() {
        String domainUrl = ErStdConfig.getInvoiceCloudApiDomain();
        return ErStdConfig.getInvoiceIframeUrlProtocal() + domainUrl + ErStdConfig.get(KEY_GET_EDIT_INVOICE_URL_PC);
    }

    public static String tokenAction() {
        String path = ErStdConfig.get(KEY_TOKEN_ACTION);
        return AllInvoiceUrl.buildUrl(path);
    }

    public static String eventCodeUrl() {
        String path = ErStdConfig.get(KEY_EVENT_CODE_URL);
        return AllInvoiceUrl.buildUrl(path);
    }

    public static String httpOrHttps() {
        String httpOfPC = ErStdConfig.get(KEY_HTTP_OF_PC);
        if (StringUtils.isBlank((CharSequence)httpOfPC) || !StringUtils.equals((CharSequence)"http://", (CharSequence)httpOfPC)) {
            return "https://";
        }
        return httpOfPC;
    }

    public static String finalUrl(String path) {
        String ip = ErStdConfig.getInvoiceCloudApiDomain();
        StringBuilder finalUrl = new StringBuilder();
        finalUrl.append(AllInvoiceUrl.httpOrHttps());
        while (ip.endsWith("//")) {
            ip = ip.substring(ip.length() - 1);
        }
        finalUrl.append(ip);
        if (!path.startsWith("//")) {
            finalUrl.append("//");
        }
        finalUrl.append(path);
        logger.info("\u53d1\u7968\u4e91url\uff1a" + finalUrl);
        return finalUrl.toString();
    }

    public static String concatToken(String token) {
        return "?access_token=" + token;
    }

    public static String getSaveVoucherUrl(String token) {
        String path = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)ErStdConfig.get(KEY_SAVE_VOUCHER), (CharSequence)"/m4/bill/expense/additionalInformation/collect");
        return AllInvoiceUrl.buildUrl(path, token);
    }

    public static String getDeleteVoucherUrl(String token) {
        String path = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)ErStdConfig.get(KEY_DELETE_VOUCHER), (CharSequence)"/m4/bill/expense/voucher/del");
        return AllInvoiceUrl.buildUrl(path, token);
    }

    public static String getDeleteAttachPCPageUrl() {
        String path = (String)StringUtils.defaultIfBlank((CharSequence)ErStdConfig.get(KEY_DELETE_ATTACH_PAGE_PC), (CharSequence)"/m4/fpzs/web/bill-attaches/v3");
        return AllInvoiceUrl.buildUrl(path);
    }

    public static String getQueryAttachUrl() {
        String path = (String)StringUtils.defaultIfBlank((CharSequence)ErStdConfig.get(KEY_QUERY_ATTACH), (CharSequence)"/m4/fpzs/bill-attaches");
        return AllInvoiceUrl.buildUrl(path);
    }

    public static String getDeleteAttachMOBPageUrl() {
        String path = (String)StringUtils.defaultIfBlank((CharSequence)ErStdConfig.get(KEY_DELETE_ATTACH_PAGE_MOB), (CharSequence)"/m4-web/fpzs/bill-attachments");
        URIBuilder builder = AllInvoiceUrl.getBaseBuilder(path, "");
        builder.setHost(ErStdConfig.getInvoiceMobH5Domain());
        return AllInvoiceUrl.buildUrl(builder, path, "");
    }

    public static URIBuilder getBaseBuilder(String path, String token) {
        URIBuilder uriBuilder = new URIBuilder();
        String httpOfPC = ErStdConfig.get(KEY_HTTP_OF_PC);
        if (StringUtils.isBlank((CharSequence)httpOfPC) || !StringUtils.equals((CharSequence)"http://", (CharSequence)httpOfPC)) {
            uriBuilder.setScheme("https");
        } else {
            uriBuilder.setScheme("http");
        }
        uriBuilder.setHost(ErStdConfig.getInvoiceCloudApiDomain());
        uriBuilder.setPath(path);
        if (!StringUtils.isBlank((CharSequence)token)) {
            uriBuilder.addParameter("access_token", token);
        }
        uriBuilder.addParameter("reqid", AllInvoiceUrl.getRequestId());
        return uriBuilder;
    }

    public static String buildUrl(String path) {
        return AllInvoiceUrl.buildUrl(path, "");
    }

    public static String buildUrl(String path, String token) {
        URIBuilder builder = AllInvoiceUrl.getBaseBuilder(path, token);
        return AllInvoiceUrl.buildUrl(builder, path, token);
    }

    public static String buildUrl(URIBuilder builder, String path, String token) {
        String url = "";
        try {
            url = builder.build().toString();
        }
        catch (URISyntaxException e) {
            logger.error((Throwable)e);
        }
        logger.info(String.format("\u53d1\u7968\u4e91\u8bf7\u6c42 url\uff1a%s", url));
        return url;
    }

    public static String getRequestId() {
        int rand = random.nextInt(900) + 100;
        String reqId = String.format("%d%d", System.currentTimeMillis(), rand);
        return reqId;
    }
}

