/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.log.task;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.er.business.messagepublish.ErMessagePublisher;
import kd.fi.er.business.messagepublish.ErMqConstants;

public class ErMQLogCheckTask
extends AbstractTask {
    public static final String SCHEDULE_ENTITY_ID = "sch_schedule";

    public static DynamicObject getMQLogScheduleDO() {
        return BusinessDataServiceHelper.loadSingle((String)SCHEDULE_ENTITY_ID, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)"39KWYXYK68M=")});
    }

    public static OperationResult enableMQLogSchedule() {
        return ErMQLogCheckTask.executeOptForMQLogSchedule("enable");
    }

    public static OperationResult disableMQLogSchedule() {
        return ErMQLogCheckTask.executeOptForMQLogSchedule("disable");
    }

    private static OperationResult executeOptForMQLogSchedule(String opt) {
        return OperationServiceHelper.executeOperate((String)opt, (String)SCHEDULE_ENTITY_ID, (DynamicObject[])new DynamicObject[]{ErMQLogCheckTask.getMQLogScheduleDO()}, (OperateOption)OperateOption.create());
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (this.isStop()) {
            return;
        }
        DynamicObjectCollection logColl = QueryServiceHelper.query((String)ErMqConstants.ER_MQLOG.entityID, (String)String.join((CharSequence)",", "id", ErMqConstants.ER_MQLOG.MESSAGEDATA, ErMqConstants.ER_MQLOG.MESSAGEDATA_TAG, ErMqConstants.ER_MQLOG.CREATETIME), (QFilter[])new QFilter[0]);
        if (logColl.size() == 0) {
            ErMQLogCheckTask.disableMQLogSchedule();
            return;
        }
        ArrayList<Long> removedPkList = new ArrayList<Long>(logColl.size());
        ArrayList<Long> expirePkList = new ArrayList<Long>(logColl.size());
        Calendar today = Calendar.getInstance();
        today.add(2, -1);
        Date todayTime = today.getTime();
        for (DynamicObject row : logColl) {
            String messageContext;
            long id = row.getLong("id");
            String queueName = row.getString(ErMqConstants.ER_MQLOG.MESSAGEDATA);
            boolean send = ErMessagePublisher.publishMessageToMq("fi", queueName, messageContext = row.getString(ErMqConstants.ER_MQLOG.MESSAGEDATA_TAG), false);
            if (send) {
                removedPkList.add(id);
                continue;
            }
            if (todayTime.getTime() <= row.getDate(ErMqConstants.ER_MQLOG.CREATETIME).getTime()) continue;
            expirePkList.add(id);
        }
        Optional.of(expirePkList).ifPresent(list -> DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)ErMqConstants.ER_MQLOG.entityID), (Object[])list.toArray()));
        if (removedPkList.isEmpty()) {
            this.stop();
        } else {
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)ErMqConstants.ER_MQLOG.entityID), (Object[])removedPkList.toArray());
        }
        if (removedPkList.size() == logColl.size()) {
            ErMQLogCheckTask.disableMQLogSchedule();
        }
    }
}

