/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.mytrip;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.mytrip.IOrderBillStrategy;

public class HotelBillStrategy
implements IOrderBillStrategy {
    @Override
    public List<Map> getData(String tabKey) {
        DynamicObject[] bills = this.queryData(tabKey);
        int size = bills.length;
        ArrayList ret = Lists.newArrayListWithExpectedSize((int)size);
        int len = size;
        for (int i = 0; i < len; ++i) {
            DynamicObject bill = bills[i];
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("billId", bill.get("id"));
            m.put("billType", "er_hotelbill");
            m.put("title", bill.get("hotelName"));
            m.put("amount", bill.get("totalAmount"));
            m.put("orderStatus", bill.get("orderStatus"));
            String info = "";
            StringBuilder sb = new StringBuilder();
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat df2 = new SimpleDateFormat("MM-dd");
                Date checkInDate = df.parse(bill.get("checkInDate").toString());
                Date checkOutDate = df.parse(bill.get("checkInDate").toString());
                String beginDateFmt = df2.format(checkInDate);
                String endDateFmt = df2.format(checkOutDate);
                sb.append(beginDateFmt).append(ResManager.loadKDString((String)"\u81f3", (String)"HotelBillStrategy_0", (String)"fi-er-business", (Object[])new Object[0])).append(endDateFmt).append("\u3000").append((checkOutDate.getTime() - checkInDate.getTime()) / 86400000L).append(ResManager.loadKDString((String)"\u665a/", (String)"HotelBillStrategy_1", (String)"fi-er-business", (Object[])new Object[0]));
                df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                m.put("orderDate", df.parse(bill.getString("orderDate")));
            }
            catch (ParseException e) {
                throw new KDException(ResManager.loadKDString((String)"\u9152\u5e97\u8ba2\u5355\u65e5\u671f\u8f6c\u6362\u51fa\u9519\u3002", (String)"HotelBillStrategy_2", (String)"fi-er-business", (Object[])new Object[0]));
            }
            sb.append(bill.get("roomCount")).append(ResManager.loadKDString((String)"\u95f4", (String)"HotelBillStrategy_3", (String)"fi-er-business", (Object[])new Object[0]));
            info = sb.toString();
            m.put("info", info);
            m.put("address", bill.get("hoteladdress"));
            ret.add(m);
        }
        return ret;
    }

    private DynamicObject[] queryData(String tabKey) {
        IErDao erDao = ErDaoFactory.getInstance("er_hotelbill");
        DynamicObject[] bills = erDao.query(this.getFilter(tabKey));
        return bills;
    }

    private QFilter getFilter(String tabKey) {
        RequestContext requestContext = RequestContext.get();
        Long userId = Long.valueOf(requestContext.getUserId());
        QFilter fi = new QFilter("sourcetravelerid", "=", (Object)userId);
        HashSet<String> wholeSet = new HashSet<String>(Arrays.asList("1", "2", "3", "5", "6", "7", "14", "8", "10"));
        HashSet<String> closedSet = new HashSet<String>(Arrays.asList("7", "14", "10"));
        HashSet<String> unusedSet = new HashSet<String>(wholeSet);
        unusedSet.removeAll(closedSet);
        if ("tabpageap".equalsIgnoreCase(tabKey)) {
            return fi.and(new QFilter("orderStatus", "in", unusedSet));
        }
        return fi.and(new QFilter("orderStatus", "in", closedSet));
    }

    @Override
    public int count(String tabKey) {
        return this.queryData(tabKey).length;
    }
}

