/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.openapi;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class GetTripBillInfoOpenApi
implements IBillWebApiPlugin {
    private static final Log logger = LogFactory.getLog(GetTripBillInfoOpenApi.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult ar = new ApiResult();
        String applier = (String)params.get("applier");
        String company = (String)params.get("company");
        if (applier == null && company == null) {
            return this.errorResult(ar);
        }
        try {
            this.getList(params, ar);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u51fa\u5dee\u7533\u8bf7\u5355\u5931\u8d25GetTripBillListPlugIn:{}", (Object)e.getMessage());
            throw e;
        }
        return ar;
    }

    private void getList(Map<String, Object> params, ApiResult ar) {
        String applierId = (String)params.get("applier");
        String companyId = (String)params.get("company");
        String status = (String)params.get("billstatus");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (null != applierId && !applierId.isEmpty()) {
            QFilter applierFilter = new QFilter("applier", "=", (Object)Long.valueOf(applierId));
            filters.add(applierFilter);
        }
        if (null != companyId && !companyId.isEmpty()) {
            QFilter companyFilter = new QFilter("company", "=", (Object)Long.valueOf(companyId));
            filters.add(companyFilter);
        }
        if (null != status && !status.isEmpty()) {
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)status);
            filters.add(statusFilter);
        }
        String selectFields = "applier,createtime,billno,description,approveamount,billstatus,tripentry,from,to,startdate,enddate,vehicle,triporiaccappamount";
        DynamicObject[] tripList = BusinessDataServiceHelper.load((String)"er_tripreqbill", (String)selectFields, (QFilter[])filters.toArray(new QFilter[filters.size()]));
        JSONArray jsonArray = new JSONArray();
        for (DynamicObject trip : tripList) {
            JSONObject dataObject = new JSONObject(new LinkedHashMap());
            DynamicObject applier = (DynamicObject)trip.get("applier");
            dataObject.put("applier", applier == null ? null : applier.getPkValue());
            dataObject.put("createtime", trip.get("createtime"));
            dataObject.put("billno", trip.get("billno"));
            dataObject.put("description", trip.get("description"));
            dataObject.put("approveamount", trip.get("approveamount"));
            dataObject.put("billstatus", trip.get("billstatus"));
            DynamicObjectCollection tripEntries = trip.getDynamicObjectCollection("tripentry");
            JSONArray entryList = new JSONArray();
            for (DynamicObject tripEntry : tripEntries) {
                JSONObject entry = new JSONObject(new LinkedHashMap());
                DynamicObject from = (DynamicObject)tripEntry.get("from");
                entry.put("from", from == null ? null : from.getPkValue());
                DynamicObject to = (DynamicObject)tripEntry.get("to");
                entry.put("to", to == null ? null : to.getPkValue());
                entry.put("startdate", tripEntry.get("startdate"));
                entry.put("enddate", tripEntry.get("enddate"));
                entry.put("vehicle", tripEntry.get("vehicle"));
                entry.put("triporiaccappamount", tripEntry.get("triporiaccappamount"));
                entryList.add((Object)entry);
            }
            dataObject.put("tripentry", (Object)entryList);
            jsonArray.add((Object)dataObject);
        }
        ar.setSuccess(true);
        ar.setData((Object)jsonArray);
    }

    private ApiResult errorResult(ApiResult ar) {
        ar.setSuccess(false);
        ar.setMessage("at least one of applier and company is needed ");
        return ar;
    }
}

