/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.pub;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.MobileFormPosition;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IMobileListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.dao.impl.ErDaoOrmImpl;
import kd.fi.er.business.ext.enums.ErExtcaseEnum;
import kd.fi.er.business.ext.helper.ErExtHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.ExpenseItemServiceHelper;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.AttachmentUtils;
import kd.fi.er.business.utils.BotpDrawServiceUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.PayerTypeEnum;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.common.field.writeoffmoney.ContractProjectWriteOffFields;
import kd.fi.er.common.field.writeoffmoney.WriteOffFields;
import kd.fi.er.formplugin.util.EntryCopyUtil;
import kd.fi.er.model.EntityInfo;
import kd.fi.er.opplugin.daily.web.importplugin.utils.ImportUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ContractUtil {
    private static Log logger = LogFactory.getLog(ContractUtil.class);
    private static ErDaoOrmImpl dao;
    public static final String CONTACT_SELECT_FIELD = "id,entry_linkman.contactperson,entry_linkman.phone";
    public static final String CONTRACT_HEAD_FIELD = "applier,costcompany,iscurrency,partbtype,partb";
    private static final String EXPENSEITEM_ID = "expenseitem.id";
    public static final String UID_PREFIX_CONTRACT = "contract";
    private static Set<String> frozenOPs;
    public static final int PRECISION = 4;
    public static final long DIVISIOR = 100L;

    public static void refreshExpTaxAmount(IDataModel model, IFormView view, int rowIndex, Boolean needRecalculate) {
        BigDecimal acorientryamount;
        BigDecimal actaxamount;
        int precision = 4;
        DynamicObject expenseCurrencyDO = (DynamicObject)model.getValue("entrycurrency", rowIndex);
        if (expenseCurrencyDO != null) {
            precision = expenseCurrencyDO.getInt("amtprecision");
        }
        BigDecimal expAmount = (BigDecimal)model.getValue("expenseamount", rowIndex);
        BigDecimal taxRate = (BigDecimal)model.getValue("taxrate", rowIndex);
        taxRate = taxRate.divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_EVEN);
        BigDecimal expTaxAmount = needRecalculate != false ? expAmount.multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), precision, RoundingMode.HALF_EVEN) : (BigDecimal)model.getValue("taxamount", rowIndex);
        model.setValue("taxamount", (Object)expTaxAmount, rowIndex);
        model.setValue("orientryamount", (Object)expAmount.subtract(expTaxAmount), rowIndex);
        String changetype = (String)model.getValue("changetype");
        if (!"B".equals(changetype)) {
            BigDecimal changetaxamount = (BigDecimal)model.getValue("changetaxamount", rowIndex);
            BigDecimal entrycontracttax = (BigDecimal)model.getValue("orientrycontracttax", rowIndex);
            BigDecimal entrycontractamount = (BigDecimal)model.getValue("entrycontractamount", rowIndex);
            BigDecimal changeorientryamount = (BigDecimal)model.getValue("changeorientryamount", rowIndex);
            actaxamount = expTaxAmount.add(changetaxamount).add(entrycontracttax);
            acorientryamount = expAmount.subtract(expTaxAmount).add(changeorientryamount).add(entrycontractamount).subtract(entrycontracttax);
        } else {
            actaxamount = expTaxAmount;
            acorientryamount = expAmount.subtract(expTaxAmount);
        }
        model.setValue("actaxamount", (Object)actaxamount, rowIndex);
        model.setValue("acorientryamount", (Object)acorientryamount, rowIndex);
    }

    public static void setFrameworkcontractChange(IDataModel model, IFormView view, Boolean newValueBoolean) {
        AdvContainer advconap311 = (AdvContainer)view.getControl("advconap311");
        AdvContainer advconap3 = (AdvContainer)view.getControl("advconap3");
        if (newValueBoolean.booleanValue()) {
            DynamicObjectCollection expenseentryentity = model.getEntryEntity("expenseentryentity");
            int[] indexArr = new int[expenseentryentity.size()];
            for (int i = 0; i < expenseentryentity.size(); ++i) {
                indexArr[i] = ((DynamicObject)expenseentryentity.get(i)).getInt("seq") - 1;
            }
            model.deleteEntryRows("expenseentryentity", indexArr);
            view.updateView("expenseentryentity");
            model.beginInit();
            model.setValue("contractamount", null);
            model.setValue("oriapplyamount", null);
            model.setValue("originalamount", null);
            model.setValue("orinotpayamount", null);
            model.setValue("changeamount", null);
            model.setValue("billtaxrate", null);
            model.endInit();
            view.updateView("advconap311");
            view.setVisible(Boolean.valueOf(false), new String[]{"advconap3"});
            view.setVisible(Boolean.valueOf(false), new String[]{"advconap311"});
            advconap311.setCollapse(true);
            advconap3.setCollapse(true);
            ((FieldEdit)view.getControl("contractcurrency")).setMustInput(false);
            ((FieldEdit)view.getControl("changerate")).setMustInput(false);
            return;
        }
        view.setVisible(Boolean.valueOf(true), new String[]{"advconap3"});
        view.setVisible(Boolean.valueOf(true), new String[]{"advconap311"});
        advconap311.setCollapse(false);
        advconap3.setCollapse(false);
        ((FieldEdit)view.getControl("contractcurrency")).setMustInput(true);
        ((FieldEdit)view.getControl("changerate")).setMustInput(true);
        ((EntryGrid)view.getControl("expenseentryentity")).setMustInput("expenseentryentity", true);
    }

    public static void refreshExpCurrAmount(IDataModel model, IFormView view, int rowIndex, Boolean iscalculate) {
        BigDecimal expAmount;
        DynamicObject expCurrency = (DynamicObject)model.getValue("contractcurrency");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        Map<String, Object> changeMap = AmountChangeUtil.refreshEnrtyExchangeRate(model, view, expCurrency);
        String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)changeMap.get("quoteType")), (Object)"0");
        BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)model.getValue("exchangerate", rowIndex)), (Object)BigDecimal.ONE);
        int precision = AmountUtils.getCurrencyPrecision(ErCommonUtils.getPk(currency));
        boolean ispaybyrata = (Boolean)model.getValue("paybyrata");
        if (ispaybyrata && iscalculate.booleanValue()) {
            BigDecimal prorataamount = (BigDecimal)model.getValue("prorataamount");
            expAmount = prorataamount.multiply((BigDecimal)model.getValue("paypercent", rowIndex)).setScale(precision, RoundingMode.HALF_UP).divide(BigDecimal.valueOf(100L));
            BigDecimal taxamount = (BigDecimal)model.getValue("taxamount", rowIndex);
            model.beginInit();
            model.setValue("expenseamount", (Object)expAmount, rowIndex);
            model.setValue("orgiexpebalanceamount", (Object)expAmount, rowIndex);
            model.setValue("canloanamount", (Object)expAmount, rowIndex);
            model.setValue("oriexpnotpayamount", (Object)expAmount, rowIndex);
            model.setValue("orientryamount", (Object)expAmount.subtract(taxamount), rowIndex);
            model.setValue("acexpeapproveamount", (Object)expAmount, rowIndex);
            model.endInit();
            view.updateView("expenseamount", rowIndex);
            view.updateView("orgiexpebalanceamount", rowIndex);
            view.updateView("canloanamount", rowIndex);
            view.updateView("oriexpnotpayamount", rowIndex);
            view.updateView("orientryamount", rowIndex);
            view.updateView("acexpeapproveamount", rowIndex);
        } else {
            expAmount = (BigDecimal)model.getValue("expenseamount", rowIndex);
        }
        BigDecimal currencyAmount = AmountUtils.getCurrencyAmount(expAmount, exchangeRate, precision, quoteType);
        model.setValue("currexpenseamount", (Object)currencyAmount, rowIndex);
        BigDecimal acexpeapproveamount = (BigDecimal)model.getValue("acexpeapproveamount", rowIndex);
        BigDecimal acexpeapprovecurramount = AmountUtils.getCurrencyAmount(acexpeapproveamount, exchangeRate, precision, quoteType);
        model.setValue("acexpeapprovecurramount", (Object)acexpeapprovecurramount, rowIndex);
    }

    public static void refreshEntryValue(IDataModel model, Object value, String propName) {
        int entryCount = model.getEntryRowCount("expenseentryentity");
        IDataEntityProperty prop = model.getProperty(propName);
        if (prop == null) {
            return;
        }
        for (int index = 0; index < entryCount; ++index) {
            model.setValue(propName, value, index);
        }
    }

    public static void refreshExchangeRate(IDataModel model, IFormView view, DynamicObject currency, String changeRateProp, String quoteTypeProp) {
        Map<String, Object> changeMap = AmountChangeUtil.refreshEnrtyExchangeRate(model, view, currency);
        String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)changeMap.get("quoteType")), (Object)"0");
        model.setValue(quoteTypeProp, (Object)quoteType);
        BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)changeMap.get("exchangeRate")), (Object)BigDecimal.ONE);
        model.setValue(changeRateProp, (Object)exchangeRate);
    }

    public static void refreshOriEntryAmount(IDataModel model, IFormView view, int rowIndex) {
        BigDecimal acorientryamount;
        BigDecimal expAmount = (BigDecimal)model.getValue("expenseamount", rowIndex);
        BigDecimal expTaxAmount = (BigDecimal)model.getValue("taxamount", rowIndex);
        BigDecimal oriEntryAmount = expAmount.subtract(expTaxAmount);
        model.setValue("orientryamount", (Object)oriEntryAmount, rowIndex);
        String changetype = (String)model.getValue("changetype");
        if ("B".equals(changetype)) {
            acorientryamount = oriEntryAmount;
        } else {
            BigDecimal changeorientryamount = (BigDecimal)model.getValue("changeorientryamount", rowIndex);
            BigDecimal entrycontracttax = (BigDecimal)model.getValue("orientrycontracttax", rowIndex);
            BigDecimal entrycontractamount = (BigDecimal)model.getValue("entrycontractamount", rowIndex);
            acorientryamount = oriEntryAmount.add(changeorientryamount).add(entrycontractamount).subtract(entrycontracttax);
        }
        model.setValue("acorientryamount", (Object)acorientryamount, rowIndex);
    }

    public static void refreshExpPriceWithTax(IDataModel model, IFormView view, int rowIndex) {
        BigDecimal expAmount = (BigDecimal)model.getValue("expenseamount", rowIndex);
        Integer num = (Integer)model.getValue("num", rowIndex);
        int precision = AmountUtils.getCurrencyPrecision(model, "currency");
        if (num != null && num > 0) {
            BigDecimal priceWithTax = expAmount.divide(BigDecimal.valueOf(num.intValue()), precision, RoundingMode.HALF_EVEN);
            model.setValue("exppricewithtax", (Object)priceWithTax, rowIndex);
        }
    }

    public static void refreshHeadAmountByExpense(IDataModel model, IFormView view) {
        DynamicObjectCollection entries = model.getEntryEntity("expenseentryentity");
        BigDecimal headAmount = entries == null || entries.isEmpty() ? BigDecimal.ZERO : entries.stream().map(d -> d.get("expenseamount") == null ? BigDecimal.ZERO : (BigDecimal)d.get("expenseamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        model.setValue("oriapplyamount", (Object)headAmount);
        if (model.getValue("detailtype").equals("biztype_applybill")) {
            model.setValue("contractamount", (Object)headAmount);
        }
    }

    public static void refreshBillTaxAmountByExpense(IDataModel model, IFormView view) {
        DynamicObjectCollection entries = model.getEntryEntity("expenseentryentity");
        if (entries == null || entries.isEmpty()) {
            return;
        }
        BigDecimal billTaxAmount = entries.stream().map(d -> d.get("taxamount") == null ? BigDecimal.ZERO : (BigDecimal)d.get("taxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        model.setValue("billtaxamount", (Object)billTaxAmount);
    }

    public static void refreshOriginalAmount(IDataModel model, IFormView view) {
        BigDecimal originalAmount = BigDecimal.ZERO;
        DynamicObjectCollection exps = model.getEntryEntity("expenseentryentity");
        for (int index = 0; index < exps.size(); ++index) {
            BigDecimal orientryAmount = (BigDecimal)model.getValue("orientryamount", index);
            originalAmount = originalAmount.add(orientryAmount);
        }
        model.setValue("originalamount", (Object)originalAmount);
    }

    public static void refreshBillTaxAmount(IDataModel model, IFormView view) {
        BigDecimal applyAmount = (BigDecimal)model.getValue("oriapplyamount");
        BigDecimal billTaxRate = (BigDecimal)model.getValue("billtaxrate");
        billTaxRate = billTaxRate.divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_EVEN);
        BigDecimal taxAmount = applyAmount.divide(BigDecimal.ONE.add(billTaxRate), 4, RoundingMode.HALF_EVEN).multiply(billTaxRate);
        if (billTaxRate.compareTo(BigDecimal.ZERO) != 0) {
            model.setValue("billtaxamount", (Object)taxAmount);
        }
        if (taxAmount.compareTo(BigDecimal.ZERO) == 0) {
            model.setValue("originalamount", (Object)applyAmount);
        }
    }

    @Deprecated
    public static void setHeadPart(IDataModel model, int rowIndex, Object newPart) {
        DynamicObject part = (DynamicObject)newPart;
        if (rowIndex == 0) {
            String partatypenew = (String)model.getValue("partytype", rowIndex);
            model.setValue("partatypenew", (Object)partatypenew);
            model.setValue("partanew", (Object)part);
            if ("bos_org".equals(partatypenew)) {
                model.setValue("parta", (Object)part);
            } else {
                model.setValue("parta", null);
            }
        } else if (rowIndex == 1) {
            model.setValue("partbtype", model.getValue("partytype", rowIndex));
            model.setValue("partb", (Object)part);
        } else {
            DynamicObjectCollection parties = model.getEntryEntity("contractpartyentry");
            if (parties == null || parties.size() <= 2) {
                return;
            }
            if (parties.get(2) != null) {
                DynamicObject partOther = (DynamicObject)parties.get(2);
                if ((DynamicObject)partOther.get("contractparty") == null) {
                    return;
                }
                OrmLocaleValue partNameORM = (OrmLocaleValue)((DynamicObject)partOther.get("contractparty")).get("name");
                String partName = partNameORM.getLocaleValue();
                for (int index = 3; index < parties.size(); ++index) {
                    DynamicObject partI = (DynamicObject)parties.get(index);
                    DynamicObject contract = (DynamicObject)partI.get("contractparty");
                    if (contract == null) continue;
                    partName = String.format("%1$s%2$s%3$s", partName, ";", ((OrmLocaleValue)contract.get("name")).getLocaleValue());
                }
                model.setValue("partother", (Object)partName);
            }
        }
    }

    public static void setHeadConnContracts(IDataModel model) {
        DynamicObjectCollection contracts = model.getEntryEntity("contractrelation");
        StringBuffer contractsFiled = new StringBuffer();
        if (contracts != null) {
            for (DynamicObject contract : contracts) {
                String billNo = contract.getString("basedatabillno");
                contractsFiled.append(billNo);
            }
        }
        model.setValue("contractsconn", (Object)contractsFiled);
    }

    public static void setDefaultParty(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObjectCollection parties = model.getEntryEntity("contractpartyentry");
        ContractUtil.setPartyEntry(view);
        model.setValue("partytype", (Object)"bos_org", 0);
        model.setValue("signcontract", (Object)"0", 0);
        model.setValue("partytype", (Object)"bd_supplier", 1);
        model.setValue("signcontract", (Object)"1", 1);
        model.setValue("partbtype", (Object)"bd_supplier");
    }

    public static void setPartyEntry(IFormView view) {
        DynamicObjectCollection parties = view.getModel().getEntryEntity("contractpartyentry");
        if (parties != null && parties.size() > 1) {
            return;
        }
        int currSize = parties == null ? 0 : parties.size();
        view.getModel().batchCreateNewEntryRow("contractpartyentry", 2 - currSize);
        ContractUtil.setDefaultParty(view);
    }

    public static void resolvePushChange(EventObject e, IFormView view) {
        IDataModel model = view.getModel();
        if (model.getDataEntity().getDataEntityState().isPushChanged()) {
            // empty if block
        }
    }

    public static void refreshHeadContacts(IFormView view, EventObject e) {
        IDataModel model = view.getModel();
        DynamicObjectCollection contracts = model.getEntryEntity("contractrelation");
        if (contracts == null || contracts.size() == 0) {
            model.setValue("contractsconn", null);
            return;
        }
        DynamicObject contractF = (DynamicObject)contracts.get(0);
        String billNos = contractF.getString("basedatabillno");
        for (int index = 1; index < contracts.size(); ++index) {
            DynamicObject contract = (DynamicObject)contracts.get(index);
            billNos = String.format("%1$s%2$s%3$s", billNos, ";", contract.getString("basedatabillno"));
        }
        model.setValue("contractsconn", (Object)billNos);
    }

    public static void setTel(IDataModel model, int rowIndex) {
        DynamicObject part = (DynamicObject)model.getValue("contractparty", rowIndex);
        if (part == null) {
            ContractUtil.clearTel(model, rowIndex);
        } else {
            Long partId = part != null ? (Long)part.getPkValue() : 0L;
            String entityName = part.getDataEntityType().getName();
            if ("bos_org".equals(entityName) || "bos_adminorg".equals(entityName)) {
                return;
            }
            QFilter defQ = new QFilter("entry_linkman.isdefault_linkman", "=", (Object)Boolean.TRUE);
            DynamicObjectCollection parts = QueryServiceHelper.query((String)entityName, (String)CONTACT_SELECT_FIELD, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)partId), defQ});
            if (parts == null || parts.size() <= 0) {
                return;
            }
            DynamicObject contact = (DynamicObject)parts.get(0);
            model.setValue("contactperson", contact.get("entry_linkman.contactperson"), rowIndex);
            model.setValue("signtel", contact.get("entry_linkman.phone"), rowIndex);
        }
    }

    public static void clearTel(IDataModel model, int rowIndex) {
        model.setValue("contactperson", null, rowIndex);
        model.setValue("signtel", null, rowIndex);
    }

    public static void refreshWriteOffAmount(IDataModel model, WriteOffFields fields) {
        String writeOffType = (String)model.getValue("writeofftype");
        if (writeOffType.equals("1")) {
            ContractUtil.writeOffOri(model, fields.entryKey, fields.approveAmtOriKey, fields.entryCurrencyKey, fields.checkAmtOriKey, fields.checkAmtKey);
        } else {
            ContractUtil.writeOffCurr(model, fields.entryKey, fields.approveAmtKey, fields.approveAmtOriKey, fields.checkAmtOriKey, fields.checkAmtKey, fields.entryQuoteTypeKey, fields.entryExchangerateKey, fields.expAmountKey);
        }
    }

    private static void writeOffCurr(IDataModel dataModel, String writeOffEntryProp, String canAmountProp, String oriCanAmountProp, String writeAmountProp, String currWriteAmountProp, String quoteTypeProp, String changeRateProp, String expAmountKey) {
        BigDecimal currReimburseAmount = AmountUtils.getEntryAmount(dataModel, "expenseentryentity", expAmountKey);
        DynamicObjectCollection woEntrys = dataModel.getEntryEntity(writeOffEntryProp);
        for (int i = 0; i < woEntrys.size(); ++i) {
            DynamicObject woEntry = (DynamicObject)woEntrys.get(i);
            if (currReimburseAmount.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal currLoanAmount = woEntry.getBigDecimal(canAmountProp);
                if (currLoanAmount.compareTo(currReimburseAmount) > 0) {
                    dataModel.setValue(currWriteAmountProp, (Object)currReimburseAmount, i);
                } else {
                    dataModel.setValue(currWriteAmountProp, (Object)currLoanAmount, i);
                }
                currReimburseAmount = currReimburseAmount.subtract(currLoanAmount);
            } else {
                dataModel.setValue(currWriteAmountProp, (Object)BigDecimal.ZERO, i);
            }
            BigDecimal woCurrAmount = woEntry.getBigDecimal(currWriteAmountProp);
            if (woCurrAmount.compareTo(woEntry.getBigDecimal(canAmountProp)) == 0) {
                dataModel.setValue(writeAmountProp, (Object)woEntry.getBigDecimal(oriCanAmountProp), i);
                continue;
            }
            BigDecimal woExchageRate = woEntry.getBigDecimal(changeRateProp);
            if (woExchageRate == null || woExchageRate.compareTo(BigDecimal.ZERO) == 0) {
                woExchageRate = BigDecimal.ONE;
            }
            String quoteType = dataModel.getProperty(quoteTypeProp) == null ? "0" : (String)woEntry.get(quoteTypeProp);
            int precision = AmountUtils.getAmountFieldPrecision(woEntry, writeAmountProp);
            BigDecimal accloanamount = "0".equals(quoteType) ? woCurrAmount.divide(woExchageRate, precision, RoundingMode.HALF_UP) : woCurrAmount.multiply(woExchageRate).setScale(precision, RoundingMode.HALF_UP);
            dataModel.setValue(writeAmountProp, (Object)accloanamount, i);
        }
    }

    private static void writeOffOri(IDataModel dataModel, String writeOffEntryProp, String canAmountProp, String writeCurrency, String writeAmountProp, String currWriteAmountProp) {
        Set<Long> expeIds = AmountUtils.getCurrencyIdSet(dataModel, "expenseentryentity", "entrycurrency");
        Set<Long> woIds = AmountUtils.getCurrencyIdSet(dataModel, writeOffEntryProp, writeCurrency);
        HashSet totalIds = Sets.newHashSet();
        totalIds.addAll(woIds);
        totalIds.addAll(expeIds);
        int len = expeIds.size() + woIds.size();
        if (totalIds.size() == len) {
            DynamicObjectCollection woColl = dataModel.getEntryEntity(writeOffEntryProp);
            for (int i = 0; i < woColl.size(); ++i) {
                dataModel.setValue(writeAmountProp, (Object)BigDecimal.ZERO, i);
                dataModel.setValue(currWriteAmountProp, (Object)BigDecimal.ZERO, i);
            }
        } else {
            DynamicObjectCollection expeColl = dataModel.getEntryEntity("expenseentryentity");
            DynamicObjectCollection woColl = dataModel.getEntryEntity(writeOffEntryProp);
            Map<String, BigDecimal> expeCurrcyAmount = null;
            expeCurrcyAmount = "projectentryentity".equals(writeOffEntryProp) ? AmountUtils.groupByCurrency(expeColl, "entrycurrency", "expenseamount") : AmountUtils.groupByCurrency(expeColl, "entrycurrency", "expeapproveamount");
            for (Map.Entry<String, BigDecimal> entry : expeCurrcyAmount.entrySet()) {
                if (entry.getValue().compareTo(BigDecimal.ZERO) < 0) continue;
                for (int i = 0; i < woColl.size(); ++i) {
                    DynamicObject woDynamicObject = (DynamicObject)woColl.get(i);
                    String currcyId = "";
                    if (woDynamicObject != null && woDynamicObject.get(writeCurrency) != null) {
                        currcyId = ((DynamicObject)woDynamicObject.get(writeCurrency)).getPkValue().toString();
                    }
                    if (entry.getKey().equals(currcyId)) {
                        if (woDynamicObject != null && entry.getValue().compareTo(woDynamicObject.getBigDecimal(canAmountProp)) > 0) {
                            dataModel.setValue(writeAmountProp, (Object)woDynamicObject.getBigDecimal(canAmountProp), i);
                            entry.setValue(entry.getValue().subtract(woDynamicObject.getBigDecimal(canAmountProp)));
                        } else {
                            dataModel.setValue(writeAmountProp, (Object)entry.getValue(), i);
                            entry.setValue(BigDecimal.ZERO);
                        }
                    }
                    if (expeCurrcyAmount.containsKey(currcyId)) continue;
                    dataModel.setValue(writeAmountProp, (Object)BigDecimal.ZERO, i);
                }
            }
        }
    }

    public static void refreshWriteOffCurrAmount(IDataModel model, int index, IFormView view) {
        String writeOffType = (String)model.getValue("writeofftype");
        BigDecimal expAmount = (BigDecimal)model.getValue("oriprojectwriteoffamount", index);
        BigDecimal projAmount = (BigDecimal)model.getValue("oriprojectcanamount", index);
        if (writeOffType.equals(WriteOffTypeEnum.ORGI_WO.getValue()) && !ContractUtil.currencyValidate(model, index, "entrycurrency", "projectcurrency") && expAmount.compareTo(BigDecimal.ZERO) > 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e01\u79cd\u4e0d\u5728\u8d39\u7528\u660e\u7ec6\u4e2d\uff0c\u4e0d\u80fd\u51b2\u9500\u3002", (String)"ContractUtil_20", (String)"fi-er-business", (Object[])new Object[0]));
            model.setValue("oriprojectwriteoffamount", (Object)BigDecimal.ZERO, index);
            return;
        }
        if (expAmount.compareTo(projAmount) > 0) {
            model.setValue("oriprojectwriteoffamount", (Object)projAmount, index);
            expAmount = projAmount;
        }
        BigDecimal exchangeRate = model.getValue("projectchangerate", index) == null ? BigDecimal.ZERO : (BigDecimal)model.getValue("projectchangerate", index);
        String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue("projectquotetype", index)), (Object)"0");
        DynamicObject currency = (DynamicObject)model.getValue("currency", index);
        if (null == currency) {
            return;
        }
        int precision = AmountUtils.getCurrencyPrecision(ErCommonUtils.getPk(currency));
        BigDecimal currencyAmount = AmountUtils.getCurrencyAmount(expAmount, exchangeRate, precision, quoteType);
        model.setValue("projectwriteoffamount", (Object)currencyAmount, index);
    }

    public static boolean currencyValidate(IDataModel dataModel, int index, String entryCurrency, String projectCurrency) {
        Set<Long> currencyIds = AmountUtils.getCurrencyIdSet(dataModel, "expenseentryentity", entryCurrency);
        DynamicObject writeOffCurrency = (DynamicObject)dataModel.getValue(projectCurrency, index);
        return writeOffCurrency == null || currencyIds.contains(writeOffCurrency.getPkValue());
    }

    public static boolean froze(Long billId, IFormView view) {
        dao = new ErDaoOrmImpl("er_contractbill");
        DynamicObject[] collection = dao.query(new QFilter("id", "=", (Object)billId));
        if (collection.length > 0) {
            DynamicObject bill = collection[0];
            String billStatus = bill.getString("billstatus");
            if (!billStatus.equals("E") && !billStatus.equals("F")) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5ba1\u6838\u901a\u8fc7\u6216\u6267\u884c\u4e2d\u7684\u5355\u636e\u5141\u8bb8\u51bb\u7ed3\u3002", (String)"ContractUtil_0", (String)"fi-er-business", (Object[])new Object[0]));
                return false;
            }
            bill.set("billstatus", (Object)"J");
            bill.set("beforefrozenstatu", (Object)billStatus);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            view.invokeOperation("refresh");
            return true;
        }
        return false;
    }

    public static boolean isFrozen(List<String> status) {
        for (String st : status) {
            if (!st.equals("J")) continue;
            return true;
        }
        return false;
    }

    public static boolean unFroze(Long billId, IFormView view) {
        dao = new ErDaoOrmImpl("er_contractbill");
        DynamicObject[] collection = dao.query(new QFilter("id", "=", (Object)billId));
        if (collection.length > 0) {
            DynamicObject bill = collection[0];
            String billStatus = bill.getString("billstatus");
            if (!billStatus.equals("J")) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4ec5\u51bb\u7ed3\u7684\u5355\u636e\u5141\u8bb8\u89e3\u51bb\u3002", (String)"ContractUtil_35", (String)"fi-er-business", (Object[])new Object[0]));
                return false;
            }
            String beforeStatus = bill.getString("beforefrozenstatu");
            bill.set("billstatus", (Object)beforeStatus);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            view.invokeOperation("refresh");
            return true;
        }
        return false;
    }

    public static boolean isFrozenOp(String opKey) {
        return frozenOPs.stream().anyMatch(s -> {
            Pattern p = Pattern.compile(s);
            Matcher m = p.matcher(opKey);
            return m.find();
        });
    }

    public static void setCurrency(IDataModel model) {
        DynamicObject headCurrency = (DynamicObject)model.getValue("currency");
        if (headCurrency == null) {
            return;
        }
        model.setValue("contractcurrency", (Object)headCurrency);
    }

    public static void clearExpAmount(IDataModel model, IFormView view) {
        DynamicObjectCollection expcoll = model.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
        for (int i = 0; i < expcoll.size(); ++i) {
            model.setValue("expenseamount", (Object)BigDecimal.ZERO, i);
            model.setValue("currexpenseamount", (Object)BigDecimal.ZERO, i);
            model.setValue("taxamount", (Object)BigDecimal.ZERO, i);
            model.setValue("orientryamount", (Object)BigDecimal.ZERO, i);
            view.updateView("expenseamount", i);
        }
    }

    public static void changeBillHeadContractsconn(IDataModel model, String entry) {
        if (entry != null && !"expenseentryentity".equals(entry)) {
            return;
        }
        DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
        IDataEntityProperty contractsconn = (IDataEntityProperty)properties.get((Object)"contractsconn");
        if (contractsconn != null) {
            String contractno = model.getEntryEntity("expenseentryentity").stream().map(it -> it.getString("entrycontractno")).filter(StringUtils::isNotBlank).distinct().collect(Collectors.joining(","));
            model.setValue("contractsconn", (Object)contractno);
        }
    }

    public static boolean checkMultiPublicReim(ListSelectedRowCollection rows, IFormView view) {
        HashSet<String> errFields = new HashSet<String>(5);
        if (rows.size() == 1) {
            return true;
        }
        ListSelectedRow baseRow = rows.get(0);
        DynamicObject base = QueryServiceHelper.queryOne((String)"er_contractbill", (String)CONTRACT_HEAD_FIELD, (QFilter[])new QFilter[]{new QFilter("id", "=", baseRow.getPrimaryKeyValue())});
        for (int index = 1; index < rows.size(); ++index) {
            ListSelectedRow itemRow = rows.get(index);
            DynamicObject item = QueryServiceHelper.queryOne((String)"er_contractbill", (String)CONTRACT_HEAD_FIELD, (QFilter[])new QFilter[]{new QFilter("id", "=", itemRow.getPrimaryKeyValue())});
            if (item.getLong("costcompany") != base.getLong("costcompany")) {
                errFields.add(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ContractUtil_3", (String)"fi-er-business", (Object[])new Object[0]));
            }
            if (item.getBoolean("iscurrency") ^ base.getBoolean("iscurrency")) {
                errFields.add(ResManager.loadKDString((String)"\u591a\u5e01\u79cd", (String)"ContractUtil_4", (String)"fi-er-business", (Object[])new Object[0]));
            }
            if (!item.getString("partbtype").equals(base.getString("partbtype"))) {
                errFields.add(ResManager.loadKDString((String)"\u4e59\u65b9\u7c7b\u578b", (String)"ContractUtil_5", (String)"fi-er-business", (Object[])new Object[0]));
            }
            if (item.getLong("partb") == base.getLong("partb")) continue;
            errFields.add(ResManager.loadKDString((String)"\u4e59\u65b9", (String)"ContractUtil_6", (String)"fi-er-business", (Object[])new Object[0]));
        }
        if (errFields.size() > 0) {
            String msg = String.join((CharSequence)",", errFields);
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u9009\u5355\u636e%1$s\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ContractUtil_1", (String)"fi-er-business", (Object[])new Object[0]), msg));
            return false;
        }
        return true;
    }

    public static void controlEndDate(IDataModel model, Object newValue, DateEdit endDateControl) {
        if (newValue == null) {
            return;
        }
        Date beginDate = (Date)newValue;
        endDateControl.setMinDate((Date)newValue);
        Date endDate = (Date)model.getValue("enddate");
        if (endDate == null) {
            return;
        }
        if (endDate.before(beginDate)) {
            model.setValue("enddate", (Object)beginDate);
        }
    }

    public static String handleHeadDataForContractBill(Map<String, Object> dataMap) {
        String code;
        DynamicObjectCollection exists;
        Date stardate = new Date();
        if (dataMap.get("enddate") != null) {
            String formatType = (String)dataMap.get("enddate");
            Date enddate = new Date();
            if (ContractUtil.checkBizdate(formatType) || ContractUtil.checkBizdate((String)dataMap.get("startdate")) || ContractUtil.checkBizdate((String)dataMap.get("signdate"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7b7e\u7ea6\u65e5\u671f\u3001\u8d77\u59cb\u65e5\u671f\u6216\u622a\u6b62\u65e5\u671f\u683c\u5f0f\u9519\u8bef\u3002", (String)"ContractUtil_34", (String)"fi-er-business", (Object[])new Object[0]));
            }
            try {
                stardate = new SimpleDateFormat("yyyy-MM-dd").parse((String)dataMap.get("startdate"));
                enddate = new SimpleDateFormat("yyyy-MM-dd").parse(formatType);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            if (enddate.before(stardate)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u8d77\u59cb\u65e5\u671f\u3002", (String)"ContractUtil_7", (String)"fi-er-business", (Object[])new Object[0]));
            }
        }
        if ((exists = QueryServiceHelper.query((String)"er_contractbill", (String)"billno,stdbilltype", (QFilter[])new QFilter[]{new QFilter("contractcode", "=", (Object)(code = (String)dataMap.get("contractcode")))})).size() > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5408\u540c\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"ContractUtil_26", (String)"fi-er-business", (Object[])new Object[0]));
        }
        JSONObject contractcurrency = (JSONObject)dataMap.get("contractcurrency");
        if (contractcurrency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e01\u79cd\u5fc5\u987b\u5f55\u5165\u3002", (String)"ContractUtil_41", (String)"fi-er-business", (Object[])new Object[0]));
        }
        String contractcurrencyNumber = contractcurrency.getString("number");
        Map<String, Object> exchangeRateAndQuoteMap = ContractUtil.getExchangerate(dataMap, contractcurrencyNumber);
        BigDecimal exchangerate = (BigDecimal)exchangeRateAndQuoteMap.get("exchangeRate");
        String expquotetype = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeRateAndQuoteMap.get("quoteType")), (Object)"0");
        Object changerate = dataMap.get("changerate");
        if (changerate != null) {
            try {
                changerate = new BigDecimal(String.valueOf(changerate));
                dataMap.put("changerate", changerate);
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6c47\u7387\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"ErBillBaseImportHandle_10", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
        } else {
            if (exchangerate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5e01\u79cd\u5728\u6c47\u7387\u8868\u4e2d\u6ca1\u6709\u5bf9\u5e94\u7684\u6c47\u7387\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u8bbe\u7f6e\u6216\u624b\u5de5\u586b\u5199\u6c47\u7387\u3002", (String)"ErPubBillInitImportBaseHandle_27", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            Object object = changerate = exchangerate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : exchangerate;
        }
        if (changerate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5e01\u79cd\u5728\u6c47\u7387\u8868\u4e2d\u6ca1\u6709\u5bf9\u5e94\u7684\u6c47\u7387\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u8bbe\u7f6e\u6216\u624b\u5de5\u586b\u5199\u6c47\u7387\u3002", (String)"ErPubBillInitImportBaseHandle_27", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        dataMap.put("changerate", changerate);
        dataMap.put("quotetype", expquotetype);
        if (!contractcurrencyNumber.equals(((JSONObject)dataMap.get("currency")).getString("number"))) {
            dataMap.put("iscurrency", Boolean.TRUE);
        } else {
            dataMap.put("iscurrency", Boolean.FALSE);
        }
        JSONArray expenseEntry = (JSONArray)dataMap.get("expenseentryentity");
        if (expenseEntry != null) {
            for (int i = 0; i < expenseEntry.size(); ++i) {
                Map row = (Map)expenseEntry.get(i);
                row.put("entrycurrency", contractcurrency);
                row.put("exchangerate", changerate);
                row.put("expquotetype", expquotetype);
            }
        }
        Boolean frameworkcontract = Boolean.FALSE;
        Object frameworkcontractobj = dataMap.get("frameworkcontract");
        if (frameworkcontractobj != null) {
            frameworkcontract = (Boolean)dataMap.get("frameworkcontract");
        }
        if (frameworkcontract.booleanValue()) {
            Object invoiceamountobj;
            Object costimateamountobj;
            Object oripayedamountobj;
            Object oriloanedamountobj;
            BigDecimal usedamount = BigDecimal.ZERO;
            BigDecimal oriusedamount = BigDecimal.ZERO;
            BigDecimal loanedamount = BigDecimal.ZERO;
            BigDecimal oriloanedamount = BigDecimal.ZERO;
            BigDecimal payedamount = BigDecimal.ZERO;
            BigDecimal oripayedamount = BigDecimal.ZERO;
            BigDecimal costimateamount = BigDecimal.ZERO;
            BigDecimal invoiceamount = BigDecimal.ZERO;
            DynamicObject currency = ImportUtils.getCurrencyIdByNumber(((JSONObject)dataMap.get("currency")).getString("number"));
            int amtprecision = currency.getInt("amtprecision");
            Object oriusedamountobj = dataMap.get("oriusedamount");
            if (oriusedamountobj != null) {
                oriusedamount = ContractUtil.getBigDecimal(dataMap, "oriusedamount");
                usedamount = AmountUtils.getCurrencyAmount(oriusedamount, new BigDecimal(String.valueOf(changerate)), amtprecision, expquotetype);
                dataMap.put("oriusedamount", oriusedamount);
                dataMap.put("usedamount", usedamount);
            }
            if ((oriloanedamountobj = dataMap.get("oriloanedamount")) != null) {
                oriloanedamount = ContractUtil.getBigDecimal(dataMap, "oriloanedamount");
                loanedamount = AmountUtils.getCurrencyAmount(oriloanedamount, new BigDecimal(String.valueOf(changerate)), amtprecision, expquotetype);
                dataMap.put("oriloanedamount", oriloanedamount);
                dataMap.put("loanedamount", loanedamount);
            }
            if ((oripayedamountobj = dataMap.get("oripayedamount")) != null) {
                oripayedamount = ContractUtil.getBigDecimal(dataMap, "oripayedamount");
                payedamount = AmountUtils.getCurrencyAmount(oripayedamount, new BigDecimal(String.valueOf(changerate)), amtprecision, expquotetype);
                dataMap.put("oripayedamount", oripayedamount);
                dataMap.put("payedamount", payedamount);
            }
            if ((costimateamountobj = dataMap.get("costimateamount")) != null) {
                costimateamount = ContractUtil.getBigDecimal(dataMap, "costimateamount");
                dataMap.put("costimateamount", costimateamount);
            }
            if ((invoiceamountobj = dataMap.get("invoiceamount")) != null) {
                invoiceamount = ContractUtil.getBigDecimal(dataMap, "invoiceamount");
                dataMap.put("invoiceamount", invoiceamount);
            }
        }
        return null;
    }

    private static Map<String, Object> getExchangerate(Map<String, Object> data, String entrycurrencyNumber) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)entrycurrencyNumber), new QFilter("enable", "=", (Object)"1")});
        if (dynamicObject == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u5e01\u79cd\u4e0d\u5b58\u5728\u3002", (String)"ContractUtil_8", (String)"fi-er-business", (Object[])new Object[0]), entrycurrencyNumber);
            throw new KDBizException(msg);
        }
        Date curr = null;
        try {
            int exchangeRateFrom = SystemParamterUtil.getExchangeRateFrom(((JSONObject)data.get("company")).getLong("id"));
            if (0 == exchangeRateFrom || null == data.get("signdate")) {
                curr = new Date();
            } else {
                SimpleDateFormat siDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                curr = siDateFormat.parse(data.get("signdate").toString());
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        Map<String, Object> exchangeRateAndQuoteMap = CommonServiceHelper.getExchangeRateAndQuoteTypeNoDefault(((JSONObject)data.get("company")).getLong("id"), ((JSONObject)data.get("costcompany")).getLong("id"), (Long)dynamicObject.getPkValue(), ((JSONObject)data.get("currency")).getLong("id"), curr);
        return exchangeRateAndQuoteMap;
    }

    public static String handleExpEntryDataForContractBill(Map<String, Object> dataMap) {
        Boolean frameworkcontract = Boolean.FALSE;
        if (dataMap.get("frameworkcontract") != null) {
            frameworkcontract = (Boolean)dataMap.get("frameworkcontract");
        }
        if (!frameworkcontract.booleanValue()) {
            JSONArray expenseEntry = (JSONArray)dataMap.get("expenseentryentity");
            BigDecimal originalamount = BigDecimal.ZERO;
            BigDecimal oriapplyamount = BigDecimal.ZERO;
            BigDecimal applyamount = BigDecimal.ZERO;
            BigDecimal balanceamount = BigDecimal.ZERO;
            BigDecimal oribalanceamount = BigDecimal.ZERO;
            BigDecimal usedamount = BigDecimal.ZERO;
            BigDecimal oriusedamount = BigDecimal.ZERO;
            BigDecimal billcanloanamount = BigDecimal.ZERO;
            BigDecimal oricanloanamount = BigDecimal.ZERO;
            BigDecimal loanedamount = BigDecimal.ZERO;
            BigDecimal oriloanedamount = BigDecimal.ZERO;
            BigDecimal notpayamount = BigDecimal.ZERO;
            BigDecimal orinotpayamount = BigDecimal.ZERO;
            BigDecimal payedamount = BigDecimal.ZERO;
            BigDecimal oripayedamount = BigDecimal.ZERO;
            BigDecimal billtaxamount = BigDecimal.ZERO;
            BigDecimal tolpaypercent = BigDecimal.ZERO;
            BigDecimal prorataamount = BigDecimal.ZERO;
            BigDecimal proratataxamount = BigDecimal.ZERO;
            boolean paybyrata = Boolean.FALSE;
            if (dataMap.get("paybyrata") != null) {
                paybyrata = (Boolean)dataMap.get("paybyrata");
            }
            if (paybyrata && dataMap.get("prorataamount") != null) {
                prorataamount = new BigDecimal((String)dataMap.get("prorataamount"));
            }
            if (paybyrata && dataMap.get("proratataxamount") != null) {
                proratataxamount = new BigDecimal((String)dataMap.get("proratataxamount"));
            }
            JSONObject contractcurrencyjson = (JSONObject)dataMap.get("contractcurrency");
            DynamicObject contractcurrency = ImportUtils.getCurrencyIdByNumber(contractcurrencyjson.getString("number"));
            BigDecimal diff = ErStdConfig.getAccentryDiffRange();
            JSONObject currencyjson = (JSONObject)dataMap.get("currency");
            DynamicObject currency = ImportUtils.getCurrencyIdByNumber(currencyjson.getString("number"));
            Object projectTypeExpItemNumbers = dataMap.get("projectTypeExpItemNumbers");
            if ((expenseEntry == null || expenseEntry.size() == 0) && "true".equals(ErStdConfig.get("contratct.expenseentity.must"))) {
                String err = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ed8\u6b3e\u8ba1\u5212\u201d\u3002", (String)"ContractToChangeBillOp_5", (String)"fi-er-opplugin", (Object[])new Object[0]);
                return err;
            }
            if (expenseEntry != null) {
                for (int i = 0; i < expenseEntry.size(); ++i) {
                    BigDecimal num;
                    DynamicObject costCenter;
                    String entryCostCenterNumber;
                    BigDecimal expenseamount;
                    String expenseitemnumber;
                    List ptExpItemNumbers;
                    Map row = (Map)expenseEntry.get(i);
                    row.put("entrycurrency", contractcurrency);
                    row.put("expquotetype", dataMap.get("quotetype"));
                    row.put("exchangerate", dataMap.get("changerate"));
                    if (projectTypeExpItemNumbers != null && row.get("expenseitem") != null && !(ptExpItemNumbers = (List)projectTypeExpItemNumbers).contains(expenseitemnumber = ((JSONObject)row.get("expenseitem")).getString("number"))) {
                        return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u8d39\u7528\u9879\u76ee\u4e0e\u4e1a\u52a1\u5206\u7c7b\u6240\u5173\u8054\u7684\u8d39\u7528\u9879\u76ee\u4e0d\u5339\u914d\u3002", (String)"ContractUtil_9", (String)"fi-er-business", (Object[])new Object[0]), expenseitemnumber);
                    }
                    if (ContractUtil.checkBizdate((String)row.get("happendate"))) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u9884\u8ba1\u4ed8\u6b3e\u65e5\u671f\u683c\u5f0f\u6709\u8bef\u3002", (String)"ContractUtil_33", (String)"fi-er-business", (Object[])new Object[0]));
                    }
                    if (paybyrata && prorataamount.compareTo(BigDecimal.ZERO) == 0) {
                        return ResManager.loadKDString((String)"\u6309\u6bd4\u4f8b\u4ed8\u6b3e\u5fc5\u987b\u586b\u5199\uff1a\u5408\u540c\u91d1\u989d\uff08prorataamount\uff09\u3002", (String)"ContractUtil_22", (String)"fi-er-business", (Object[])new Object[0]);
                    }
                    if (paybyrata && row.get("paypercent") == null) {
                        return ResManager.loadKDString((String)"\u6309\u6bd4\u4f8b\u4ed8\u6b3e\u5fc5\u987b\u586b\u5199\u4ed8\u6b3e\u8ba1\u5212\u5206\u5f55\u7684\u4ed8\u6b3e\u6bd4\u4f8b\u3002", (String)"ContractUtil_24", (String)"fi-er-business", (Object[])new Object[0]);
                    }
                    if (!paybyrata && row.get("expenseamount") == null) {
                        return ResManager.loadKDString((String)"\u5408\u540c\u4e0d\u6309\u6bd4\u4f8b\u4ed8\u6b3e\u65f6\uff0c\u5fc5\u987b\u586b\u5199\u542b\u7a0e\u91d1\u989d\u3002", (String)"ContractUtil_25", (String)"fi-er-business", (Object[])new Object[0]);
                    }
                    BigDecimal paypercent = BigDecimal.ZERO;
                    if (paybyrata) {
                        DynamicObject entrycurrency = (DynamicObject)row.get("entrycurrency");
                        paypercent = row.get("paypercent") == null ? BigDecimal.ZERO : new BigDecimal((String)row.get("paypercent"));
                        expenseamount = prorataamount.multiply(paypercent).divide(BigDecimal.valueOf(100L), entrycurrency.getInt("amtprecision"), RoundingMode.HALF_EVEN);
                        row.put("expenseamount", expenseamount);
                    } else {
                        expenseamount = ContractUtil.getBigDecimal(row, "expenseamount");
                    }
                    int amtprecision = currency.getInt("amtprecision");
                    BigDecimal exchangerate = (BigDecimal)row.get("exchangerate");
                    String expquotetype = (String)row.get("expquotetype");
                    oriapplyamount = oriapplyamount.add(expenseamount);
                    tolpaypercent = tolpaypercent.add(paypercent);
                    if (i == expenseEntry.size() - 1 && paybyrata) {
                        if (paybyrata && tolpaypercent.compareTo(new BigDecimal(100L)) != 0) {
                            return ResManager.loadKDString((String)"\u4ed8\u6b3e\u6bd4\u4f8b\u5408\u8ba1\u5fc5\u987b\u7b49\u4e8e100%\uff0c\u8bf7\u5148\u4fee\u6539\u4ed8\u6b3e\u6bd4\u4f8b\u3002", (String)"ContractUtil_23", (String)"fi-er-business", (Object[])new Object[0]);
                        }
                        BigDecimal tailDiff = oriapplyamount.subtract(prorataamount);
                        if (oriapplyamount.compareTo(prorataamount) != 0) {
                            if (tailDiff.compareTo(diff) <= 0 && tailDiff.compareTo(diff.multiply(BigDecimal.valueOf(-1L))) >= 0) {
                                expenseamount = expenseamount.add(tailDiff.multiply(BigDecimal.valueOf(-1L)));
                                oriapplyamount = oriapplyamount.add(tailDiff.multiply(BigDecimal.valueOf(-1L)));
                                row.put("expenseamount", expenseamount);
                            } else {
                                String msg = String.format(ResManager.loadKDString((String)"\u542b\u7a0e\u91d1\u989d\u5408\u8ba1\u548c\u5408\u540c\u91d1\u989d\u5dee\u5f02\u4e3a%s\uff0c\u8d85\u8fc7\u5168\u5c40\u53c2\u6570accentryDiffRange\u8bbe\u7f6e\u7684\u8303\u56f4\uff0c\u82e5\u7ee7\u7eed\u5bfc\u5165\u8bf7\u4fee\u6539\u53c2\u6570accentryDiffRange\u8303\u56f4\u3002", (String)"ContractUtil_27", (String)"fi-er-business", (Object[])new Object[0]), tailDiff);
                                return msg;
                            }
                        }
                    }
                    logger.info(i + ">>>>>>>>>>>>>expenseentryentity \u8ba1\u7b97\u672c\u4f4d\u5e01>>>>>exchangerate " + exchangerate + "&&  amtprecision " + amtprecision + "&&  expquotetype " + expquotetype);
                    BigDecimal currexpenseamount = AmountUtils.getCurrencyAmount(expenseamount, exchangerate, amtprecision, expquotetype);
                    row.put("currexpenseamount", currexpenseamount);
                    row.put("acexpeapprovecurramount", currexpenseamount);
                    row.put("acexpeapproveamount", expenseamount);
                    BigDecimal reimbursedamount = BigDecimal.ZERO;
                    Object reimbursedamountobj = row.get("reimbursedamount");
                    if (reimbursedamountobj != null && (reimbursedamount = ContractUtil.getBigDecimal(row, "reimbursedamount")).compareTo(expenseamount) > 0) {
                        return ResManager.loadKDString((String)"\u5df2\u62a5\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u91d1\u989d\u3002", (String)"ContractUtil_10", (String)"fi-er-business", (Object[])new Object[0]);
                    }
                    BigDecimal orgiexpebalanceamount = expenseamount.subtract(reimbursedamount);
                    row.put("orgiexpebalanceamount", orgiexpebalanceamount);
                    BigDecimal pushedamount = BigDecimal.ZERO;
                    Object pushedamountobj = row.get("pushedamount");
                    if (pushedamountobj != null && (pushedamount = ContractUtil.getBigDecimal(row, "pushedamount")).compareTo(expenseamount) > 0) {
                        return ResManager.loadKDString((String)"\u5df2\u9884\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u91d1\u989d\u3002", (String)"ContractUtil_11", (String)"fi-er-business", (Object[])new Object[0]);
                    }
                    BigDecimal canloanamount = expenseamount.subtract(pushedamount);
                    row.put("canloanamount", expenseamount.subtract(pushedamount));
                    BigDecimal oriexppayedamount = BigDecimal.ZERO;
                    BigDecimal exppayedamount = BigDecimal.ZERO;
                    Object oriexppayedamountobj = row.get("oriexppayedamount");
                    if (oriexppayedamountobj != null && (oriexppayedamount = ContractUtil.getBigDecimal(row, "oriexppayedamount")).compareTo(expenseamount) > 0) {
                        return ResManager.loadKDString((String)"\u5df2\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u91d1\u989d\u3002", (String)"ContractUtil_28", (String)"fi-er-business", (Object[])new Object[0]);
                    }
                    BigDecimal oriexpnotpayamount = BigDecimal.ZERO;
                    Object oriexpnotpayamountobj = row.get("oriexpnotpayamount");
                    if (oriexpnotpayamountobj != null && (oriexpnotpayamount = ContractUtil.getBigDecimal(row, "oriexpnotpayamount")).compareTo(expenseamount) > 0) {
                        return ResManager.loadKDString((String)"\u672a\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u91d1\u989d\u3002", (String)"ContractUtil_12", (String)"fi-er-business", (Object[])new Object[0]);
                    }
                    oriexpnotpayamount = expenseamount.subtract(oriexppayedamount);
                    row.put("oriexpnotpayamount", oriexpnotpayamount);
                    JSONObject entryCostCenter = (JSONObject)row.get("std_entrycostcenter");
                    if (entryCostCenter != null && (entryCostCenterNumber = entryCostCenter.getString("number")) != null && (costCenter = ImportUtils.getCostCenterByNumber(entryCostCenterNumber)) == null) {
                        return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u6210\u672c\u4e2d\u5fc3\u4e0d\u5b58\u5728\u3002", (String)"ContractUtil_13", (String)"fi-er-business", (Object[])new Object[0]), entryCostCenterNumber);
                    }
                    int conamtprecision = contractcurrency.getInt("amtprecision");
                    Object taxamountobj = row.get("taxamount");
                    BigDecimal taxamount = BigDecimal.ZERO;
                    if (taxamountobj == null) {
                        Object taxrate = row.get("taxrate");
                        if (taxrate != null) {
                            BigDecimal rate = new BigDecimal((String)taxrate).divide(new BigDecimal("100"));
                            taxamount = expenseamount.divide(BigDecimal.ONE.add(rate), conamtprecision, 4).multiply(rate).setScale(conamtprecision, 4);
                        }
                    } else {
                        taxamount = new BigDecimal((String)taxamountobj);
                    }
                    billtaxamount = billtaxamount.add(taxamount);
                    if (i == expenseEntry.size() - 1 && paybyrata && proratataxamount.compareTo(BigDecimal.ZERO) > 0) {
                        if (paybyrata && tolpaypercent.compareTo(new BigDecimal(100L)) != 0) {
                            return ResManager.loadKDString((String)"\u4ed8\u6b3e\u6bd4\u4f8b\u5408\u8ba1\u5fc5\u987b\u7b49\u4e8e100%\uff0c\u8bf7\u5148\u4fee\u6539\u4ed8\u6b3e\u6bd4\u4f8b\u3002", (String)"ContractUtil_23", (String)"fi-er-business", (Object[])new Object[0]);
                        }
                        BigDecimal tailDiff = billtaxamount.subtract(proratataxamount);
                        if (billtaxamount.compareTo(proratataxamount) != 0) {
                            if (tailDiff.compareTo(diff) <= 0 && tailDiff.compareTo(diff.multiply(BigDecimal.valueOf(-1L))) >= 0) {
                                taxamount = taxamount.add(tailDiff.multiply(BigDecimal.valueOf(-1L)));
                                billtaxamount = proratataxamount;
                            } else {
                                String msg = String.format(ResManager.loadKDString((String)"\u7a0e\u989d\u5206\u5f55\u5408\u8ba1\u548c\u5408\u540c\u7a0e\u989d\u5dee\u5f02\u4e3a%s\uff0c\u8d85\u8fc7\u5168\u5c40\u53c2\u6570accentryDiffRange\u8bbe\u7f6e\u7684\u8303\u56f4\uff0c\u82e5\u7ee7\u7eed\u5bfc\u5165\u8bf7\u4fee\u6539\u53c2\u6570accentryDiffRange\u8303\u56f4\u3002", (String)"ContractUtil_30", (String)"fi-er-business", (Object[])new Object[0]), tailDiff);
                                return msg;
                            }
                        }
                    }
                    row.put("taxamount", taxamount);
                    row.put("actaxamount", taxamount);
                    BigDecimal orientryamount = expenseamount.subtract(taxamount);
                    row.put("orientryamount", orientryamount);
                    row.put("acorientryamount", orientryamount);
                    exppayedamount = AmountUtils.getCurrencyAmount(oriexppayedamount, exchangerate, amtprecision, expquotetype);
                    row.put("exppayedamount", exppayedamount);
                    BigDecimal expnotpayamount = currexpenseamount.subtract(exppayedamount);
                    row.put("expnotpayamount", expnotpayamount);
                    BigDecimal reimbursedcurramount = AmountUtils.getCurrencyAmount(reimbursedamount, exchangerate, amtprecision, expquotetype);
                    row.put("reimbursedcurramount", reimbursedcurramount);
                    BigDecimal expebalanceamount = currexpenseamount.subtract(reimbursedcurramount);
                    row.put("expebalanceamount", expebalanceamount);
                    BigDecimal pushedcurramount = AmountUtils.getCurrencyAmount(pushedamount, exchangerate, amtprecision, expquotetype);
                    row.put("pushedcurramount", pushedcurramount);
                    BigDecimal canloancurramount = currexpenseamount.subtract(pushedcurramount);
                    row.put("canloancurramount", canloancurramount);
                    BigDecimal bigDecimal = num = row.get("num") == null ? BigDecimal.ZERO : new BigDecimal((String)row.get("num"));
                    if (BigDecimal.ZERO.compareTo(num) != 0) {
                        row.put("exppricewithtax", expenseamount.divide(num, amtprecision, RoundingMode.HALF_UP));
                    }
                    applyamount = applyamount.add(currexpenseamount);
                    originalamount = originalamount.add(orientryamount);
                    balanceamount = balanceamount.add(expebalanceamount);
                    oribalanceamount = oribalanceamount.add(orgiexpebalanceamount);
                    billcanloanamount = billcanloanamount.add(canloancurramount);
                    oricanloanamount = oricanloanamount.add(canloanamount);
                    orinotpayamount = orinotpayamount.add(oriexpnotpayamount);
                    notpayamount = notpayamount.add(expnotpayamount);
                    usedamount = usedamount.add(reimbursedcurramount);
                    oriusedamount = oriusedamount.add(reimbursedamount);
                    payedamount = payedamount.add(exppayedamount);
                    oripayedamount = oripayedamount.add(oriexppayedamount);
                    loanedamount = loanedamount.add(pushedcurramount);
                    oriloanedamount = oriloanedamount.add(pushedamount);
                }
            }
            dataMap.put("originalamount", originalamount);
            dataMap.put("contractamount", oriapplyamount);
            dataMap.put("oriapplyamount", oriapplyamount);
            dataMap.put("applyamount", applyamount);
            dataMap.put("balanceamount", balanceamount);
            dataMap.put("oribalanceamount", oribalanceamount);
            dataMap.put("usedamount", usedamount);
            dataMap.put("oriusedamount", oriusedamount);
            dataMap.put("billcanloanamount", billcanloanamount);
            dataMap.put("oricanloanamount", oricanloanamount);
            dataMap.put("loanedamount", loanedamount);
            dataMap.put("oriloanedamount", oriloanedamount);
            dataMap.put("notpayamount", notpayamount);
            dataMap.put("orinotpayamount", orinotpayamount);
            dataMap.put("availableamount", notpayamount);
            dataMap.put("oriavailableamount", orinotpayamount);
            dataMap.put("payedamount", payedamount);
            dataMap.put("oripayedamount", oripayedamount);
            dataMap.put("invoiceamountremain", applyamount);
            dataMap.put("billtaxamount", billtaxamount);
        }
        return null;
    }

    public static String handlepartyEntryDataForContractBill(Map<String, Object> dataMap) {
        JSONArray partyentry = (JSONArray)dataMap.get("contractpartyentry");
        if (partyentry.size() < 2) {
            return ResManager.loadKDString((String)"\u7b7e\u7ea6\u65b9\u5206\u5f55\uff0c\u8981\u6709\u4e00\u6761\u7532\u65b9\u4e0e\u4e00\u6761\u4e59\u65b9\u3002", (String)"ContractUtil_14", (String)"fi-er-business", (Object[])new Object[0]);
        }
        int partA = 0;
        int partB = 0;
        HashSet<String> setA = new HashSet<String>();
        HashSet<String> setB = new HashSet<String>();
        String partName = "";
        for (int i = 0; i < partyentry.size(); ++i) {
            Map row2 = (Map)partyentry.get(i);
            String signcontract = (String)row2.get("signcontract");
            JSONObject contractparty = (JSONObject)row2.get("contractparty");
            if ("0".equals(signcontract)) {
                dataMap.put("partanew", contractparty);
                dataMap.put("partatypenew", row2.get("partytype"));
                ++partA;
                if ("bos_org".equals(row2.get("partytype"))) {
                    dataMap.put("parta", contractparty);
                }
                setA.add((String)row2.get("partytype"));
                continue;
            }
            if (!"1".equals(signcontract)) continue;
            dataMap.put("partb", contractparty);
            dataMap.put("partbtype", row2.get("partytype"));
            setB.add((String)row2.get("partytype"));
            ++partB;
        }
        if (partA == 0 || partB == 0) {
            return ResManager.loadKDString((String)"\u7b7e\u7ea6\u65b9\u5206\u5f55\uff0c\u8981\u6709\u4e00\u6761\u7532\u65b9\u4e0e\u4e00\u6761\u4e59\u65b9\u3002", (String)"ContractUtil_14", (String)"fi-er-business", (Object[])new Object[0]);
        }
        if (setA.size() > 1 || setB.size() > 1) {
            return ResManager.loadKDString((String)"\u7b7e\u7ea6\u65b9\u5206\u5f55\uff1a\u7532\u65b9\u7c7b\u578b\u987b\u76f8\u540c\u3001\u4e59\u65b9\u7c7b\u578b\u987b\u76f8\u540c\u3002", (String)"ContractUtil_40", (String)"fi-er-business", (Object[])new Object[0]);
        }
        Set orgset = partyentry.stream().filter(v -> null != v && null != ((Map)v).get("partytype") && null != ((Map)v).get("contractparty") && "bos_org".equals((String)((Map)v).get("partytype"))).map(row -> ((JSONObject)((Map)row).get("contractparty")).get((Object)"number")).collect(Collectors.toSet());
        Set cusset = partyentry.stream().filter(v -> null != v && null != ((Map)v).get("partytype") && null != ((Map)v).get("contractparty") && "bd_customer".equals((String)((Map)v).get("partytype"))).map(row -> ((JSONObject)((Map)row).get("contractparty")).get((Object)"number")).collect(Collectors.toSet());
        Set supset = partyentry.stream().filter(v -> null != v && null != ((Map)v).get("partytype") && null != ((Map)v).get("contractparty") && "bd_supplier".equals((String)((Map)v).get("partytype"))).map(row -> ((JSONObject)((Map)row).get("contractparty")).get((Object)"number")).collect(Collectors.toSet());
        Set adminorgset = partyentry.stream().filter(v -> null != v && null != ((Map)v).get("partytype") && null != ((Map)v).get("contractparty") && "bos_adminorg".equals((String)((Map)v).get("partytype"))).map(row -> ((JSONObject)((Map)row).get("contractparty")).get((Object)"number")).collect(Collectors.toSet());
        DynamicObjectCollection orgColl = QueryServiceHelper.query((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("number", "in", orgset), new QFilter("orgpattern.patterntype", "in", (Object)new String[]{"1", "2"})});
        DynamicObjectCollection adminorgColl = QueryServiceHelper.query((String)"bos_adminorg", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("number", "in", adminorgset), new QFilter("orgpattern.patterntype", "in", (Object)new String[]{"1", "2"})});
        Long companyId = 0L;
        if (null != dataMap.get("costcompany")) {
            JSONObject company = (JSONObject)dataMap.get("costcompany");
            companyId = company.getLong("id");
        }
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_customer", (Long)companyId);
        Map cusColl = BusinessDataServiceHelper.loadFromCache((String)"bd_customer", (String)"id, name,number, enable", (QFilter[])new QFilter[]{new QFilter("number", "in", cusset).and(baseDataFilter)});
        QFilter sbaseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)companyId);
        Map supColl = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id, name,number, enable", (QFilter[])new QFilter[]{new QFilter("number", "in", supset).and(sbaseDataFilter)});
        for (int i = 0; i < partyentry.size(); ++i) {
            List<Object> collect;
            Map row3 = (Map)partyentry.get(i);
            if (null == row3.get("partytype")) continue;
            String partytype = (String)row3.get("partytype");
            Object accountBanks = null;
            PayerTypeEnum partyEnum = PayerTypeEnum.getValue((String)partytype);
            JSONObject contractparty = new JSONObject();
            if (null != row3.get("contractparty")) {
                contractparty = (JSONObject)row3.get("contractparty");
            }
            String signcontract = "";
            if (null != row3.get("signcontract")) {
                signcontract = (String)row3.get("signcontract");
            }
            if ("bos_org".equals(partytype)) {
                JSONObject finalContractparty = contractparty;
                collect = new ArrayList(16);
                if (null != orgColl) {
                    collect = orgColl.stream().filter(v -> v.get("number").equals(finalContractparty.getString("number"))).collect(Collectors.toList());
                }
                if (collect.size() == 0) {
                    return String.format(ResManager.loadKDString((String)"\u7b7e\u7ea6\u65b9\u7c7b\u578b\u4e3a\u516c\u53f8\uff0c\u7f16\u7801\u4e3a%s\u7684\u7b7e\u7ea6\u65b9\u4e0d\u5b58\u5728\u3002", (String)"ContractUtil_17", (String)"fi-er-business", (Object[])new Object[0]), contractparty.getString("number"));
                }
                if (!"2".equals(signcontract)) continue;
                partName = String.format("%1$s%2$s%3$s", partName, ";", ((DynamicObject)collect.get(0)).get("name"));
                continue;
            }
            if (PayerTypeEnum.SUPPLIER == partyEnum) {
                JSONObject finalContractparty1 = contractparty;
                collect = new ArrayList(16);
                if (null != supColl) {
                    collect = supColl.values().stream().filter(v -> v.get("number").equals(finalContractparty1.getString("number"))).collect(Collectors.toList());
                }
                if (collect.size() == 0) {
                    return String.format(ResManager.loadKDString((String)"\u7b7e\u7ea6\u65b9\u7c7b\u578b\u4e3a\u201c%1$s\u201d\uff0c\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u7b7e\u7ea6\u65b9\u4e0d\u5b58\u5728\u3002", (String)"ContractUtil_21", (String)"fi-er-business", (Object[])new Object[0]), partyEnum.getTypeName(), contractparty.getString("number"));
                }
                if (!"2".equals(signcontract)) continue;
                partName = String.format("%1$s%2$s%3$s", partName, ";", ((DynamicObject)collect.get(0)).get("name"));
                continue;
            }
            if (PayerTypeEnum.CUSTOMER == partyEnum) {
                JSONObject finalContractparty2 = contractparty;
                collect = new ArrayList(16);
                if (null != cusColl) {
                    collect = cusColl.values().stream().filter(v -> v.get("number").equals(finalContractparty2.getString("number"))).collect(Collectors.toList());
                }
                if (collect.size() == 0) {
                    return String.format(ResManager.loadKDString((String)"\u7b7e\u7ea6\u65b9\u7c7b\u578b\u4e3a\u201c%1$s\u201d\uff0c\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u7b7e\u7ea6\u65b9\u4e0d\u5b58\u5728\u3002", (String)"ContractUtil_21", (String)"fi-er-business", (Object[])new Object[0]), partyEnum.getTypeName(), contractparty.getString("number"));
                }
                if (!"2".equals(signcontract)) continue;
                partName = String.format("%1$s%2$s%3$s", partName, ";", ((DynamicObject)collect.get(0)).get("name"));
                continue;
            }
            if (!"bos_adminorg".equals(partytype)) continue;
            JSONObject finalContractparty3 = contractparty;
            collect = new ArrayList(16);
            if (null != adminorgColl) {
                collect = adminorgColl.stream().filter(v -> v.get("number").equals(finalContractparty3.getString("number"))).collect(Collectors.toList());
            }
            if (collect.size() == 0) {
                return String.format(ResManager.loadKDString((String)"\u7b7e\u7ea6\u65b9\u7c7b\u578b\u4e3a\u516c\u53f8\uff0c\u7f16\u7801\u4e3a%s\u7684\u7b7e\u7ea6\u65b9\u4e0d\u5b58\u5728\u3002", (String)"ContractUtil_37", (String)"fi-er-business", (Object[])new Object[0]), contractparty.getString("number"));
            }
            if (!"2".equals(signcontract)) continue;
            partName = String.format("%1$s%2$s%3$s", partName, ";", ((DynamicObject)collect.get(0)).get("name"));
        }
        if (partName != null && partName.startsWith(";")) {
            partName = partName.substring(1);
        }
        dataMap.put("partother", partName);
        return null;
    }

    public static void setLinkman(Map<String, Object> row, List<DynamicObject> cucollect, String partytype) {
        if (row.get("contactperson") != null) {
            return;
        }
        QFilter defQ = new QFilter("entry_linkman.isdefault_linkman", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection parts = QueryServiceHelper.query((String)partytype, (String)CONTACT_SELECT_FIELD, (QFilter[])new QFilter[]{new QFilter("id", "=", cucollect.get(0).getPkValue()), defQ});
        if (parts != null && parts.size() != 0) {
            DynamicObject contact = (DynamicObject)parts.get(0);
            row.put("contactperson", contact.get("entry_linkman.contactperson"));
            row.put("signtel", contact.get("entry_linkman.phone"));
        }
    }

    public static boolean isFilterBySup(IDataModel model) {
        Long company = ErCommonUtils.getPk(model.getValue("company"));
        return SystemParamterUtil.getIsPublicUpFilterBySupplier(company);
    }

    public static boolean checkRelationContract(IFormView view, ListSelectedRowCollection rows, String bill) {
        boolean res = true;
        HashSet hashSet = Sets.newHashSetWithExpectedSize((int)2);
        HashSet billnoSet = Sets.newHashSetWithExpectedSize((int)1);
        StringBuilder err = new StringBuilder();
        for (int index = 0; index < rows.size(); ++index) {
            Boolean frameworkcontract;
            Boolean contractdeadlinecontrol;
            ListSelectedRow row = rows.get(index);
            DynamicObject curr = QueryServiceHelper.queryOne((String)"er_contractbill", (String)"company,frameworkcontract,enddate,billno", (QFilter[])new QFilter[]{new QFilter("id", "=", row.getPrimaryKeyValue())});
            String contractType = SystemParamterUtil.getRelationContract((Long)curr.get("company"));
            hashSet.add(curr.getString("frameworkcontract"));
            if (contractType.equals("0")) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5355\u636e\uff0c\u96c6\u6210\u8bbe\u7f6e\u5173\u8054\u5408\u540c\u4e3a\u9879\u76ee\u4e91\u5408\u540c\uff0c\u5408\u540c\u53f0\u8d26\u4e0d\u5141\u8bb8\u4e0b\u63a8\u5bf9\u516c\u5355\u636e\u3002", (String)"ContractBillList_5", (String)"fi-er-formplugin", (Object[])new Object[0]), row.getRowKey() + 1));
                res = false;
            }
            if (!(contractdeadlinecontrol = Boolean.valueOf(ErStdConfig.getContractDeadlineControl())).booleanValue() && curr.get("enddate") != null) {
                Date enddate = TripCommonUtil.strToDate(TripCommonUtil.DateToStr((Date)curr.get("enddate")), "yyyy-MM-dd");
                Date now = TripCommonUtil.strToDate(TripCommonUtil.DateToStr(new Date()), "yyyy-MM-dd");
                LocalDate localDate = LocalDate.now();
                if (now.after(enddate) && res) {
                    view.showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u5df2\u8d85\u8fc7\u5408\u540c\u622a\u6b62\u65e5\u671f\uff0c\u65e0\u6cd5\u4e0b\u63a8\u201c%2$s\u201d\u3002", (String)"ContractBillList_21", (String)"fi-er-formplugin", (Object[])new Object[0]), curr.get("billno"), bill));
                    res = false;
                }
            }
            if (!(frameworkcontract = Boolean.valueOf(curr.getBoolean("frameworkcontract"))).booleanValue()) continue;
            billnoSet.add(curr.getString("billno"));
        }
        if (hashSet.size() > 1 && res) {
            res = false;
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u540c\u65f6\u9009\u62e9\u6846\u67b6\u5408\u540c\u4e0e\u975e\u6846\u67b6\u5408\u540c\u4e0b\u63a8%1$s\u3002", (String)"ContractBillList_29", (String)"fi-er-formplugin", (Object[])new Object[0]), bill));
        }
        if (billnoSet.size() > 1 && res) {
            res = false;
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6846\u67b6\u5408\u540c\u4e0d\u5141\u8bb8\u591a\u5bf9\u4e00\u751f\u6210%1$s\u3002", (String)"ContractBillList_22", (String)"fi-er-formplugin", (Object[])new Object[0]), bill));
        }
        return res;
    }

    public static String checkContractCode(DynamicObject stdbilltype, String code, String billNo) {
        String errorMsg = "";
        if (!StringUtils.isBlank((String)code)) {
            DynamicObjectCollection exists = QueryServiceHelper.query((String)"er_contractbill", (String)"billno,stdbilltype,detailtype", (QFilter[])new QFilter[]{new QFilter("contractcode", "=", (Object)code)});
            QFilter stdF = new QFilter("billformid", "=", (Object)"er_contractbill");
            stdF.and(new QFilter("isdefault", "=", (Object)"0"));
            DynamicObjectCollection stdTypes = QueryServiceHelper.query((String)"bos_billtype", (String)"id,number,isdefault", (QFilter[])new QFilter[]{stdF});
            Set types = stdTypes.stream().map(stdType -> (Long)stdType.get("id")).collect(Collectors.toSet());
            if (exists == null || exists.size() == 0) {
                return errorMsg;
            }
            if (stdbilltype == null && "biztype_applybill".equals(((DynamicObject)exists.get(0)).getString("detailtype")) || stdbilltype != null && !types.contains(stdbilltype.getPkValue())) {
                DynamicObject existOne;
                String eBillNo;
                Boolean valid = true;
                if (exists.size() > 1) {
                    valid = false;
                }
                if (exists.size() == 1 && !(eBillNo = (existOne = (DynamicObject)exists.get(0)).getString("billno")).equals(billNo)) {
                    valid = false;
                }
                if (!valid.booleanValue()) {
                    errorMsg = ResManager.loadKDString((String)"\u5408\u540c\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"ErContractCodeValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]);
                }
            }
        }
        return errorMsg;
    }

    public static boolean checkBillType(ListSelectedRowCollection rows, IFormView view) {
        boolean res = true;
        for (int index = 0; index < rows.size(); ++index) {
            ListSelectedRow row = rows.get(index);
            DynamicObject curr = QueryServiceHelper.queryOne((String)"er_contractbill", (String)"detailtype", (QFilter[])new QFilter[]{new QFilter("id", "=", row.getPrimaryKeyValue())});
            String detailType = curr.getString("detailtype");
            if (detailType.equals("biztype_applybill")) continue;
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5355\u636e\uff0c\u975e\u5408\u540c\u7533\u8bf7\u5355\u636e\u3002", (String)"ContractUtil_19", (String)"fi-er-business", (Object[])new Object[0]), row.getRowKey() + 1));
            res = false;
        }
        return res;
    }

    public static void handleProjectHyperLink(IDataModel model, IFormView view, int row) {
        String projectNo = (String)model.getValue("projectbillno", row);
        QFilter projectNoFilter = new QFilter("billno", "=", (Object)projectNo);
        DynamicObject project = BusinessDataServiceHelper.loadSingle((String)"er_applyprojectbill", (String)"id", (QFilter[])new QFilter[]{projectNoFilter});
        if (ObjectUtils.isEmpty((Object)project)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u7acb\u9879\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ContractUtil_18", (String)"fi-er-business", (Object[])new Object[0]));
            return;
        }
        ShowPageUtils.openLinkedForm((Object)project.getPkValue().toString(), (String)"er_applyprojectbill", (IFormView)view);
    }

    public static void handlePurContractHyperLink(IDataModel model, IFormView view, int row) {
        String contractNo = (String)model.getValue("wbsrcbillno", row);
        QFilter contractNoFilter = new QFilter("billno", "=", (Object)contractNo);
        DynamicObject purcontract = BusinessDataServiceHelper.loadSingle((String)"conm_purcontract", (String)"id", (QFilter[])new QFilter[]{contractNoFilter});
        if (ObjectUtils.isEmpty((Object)purcontract)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u91c7\u8d2d\u5408\u540c\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ContractUtil_36", (String)"fi-er-business", (Object[])new Object[0]));
            return;
        }
        ShowPageUtils.openLinkedForm((Object)purcontract.getPkValue().toString(), (String)"conm_purcontract", (IFormView)view);
    }

    public static List checkHasOnWayBills(ListSelectedRowCollection selectedRows, String OnWayCondition) {
        ArrayList<String> billTypes = new ArrayList<String>(4);
        Long[] billsId = (Long[])selectedRows.stream().map(b -> (Long)b.getPrimaryKeyValue()).toArray(Long[]::new);
        if (!"2".equals(ErStdConfig.getApplyprojectbillRelated())) {
            EntityInfo reimburseInfo;
            EntityInfo prepayInfo = new EntityInfo.Builder().entityName("er_prepaybill").entryName("expenseentryentity").sourceName("wbsrcbillid").build();
            if (ContractUtil.getProjectHasOnWayBills(billsId, prepayInfo, OnWayCondition = "B,C,E,F").size() > 0) {
                billTypes.add("er_prepaybill");
            }
            if (ContractUtil.getProjectHasOnWayBills(billsId, prepayInfo = new EntityInfo.Builder().entityName("er_prepaybill").entryName("contractentry").sourceName("contractsid").build(), OnWayCondition).size() > 0) {
                billTypes.add("er_prepaybill");
            }
            if (ContractUtil.getProjectHasOnWayBills(billsId, reimburseInfo = new EntityInfo.Builder().entityName("er_publicreimbursebill").entryName("contractentry").sourceName("contractsid").build(), OnWayCondition).size() > 0) {
                billTypes.add("er_publicreimbursebill");
            }
            if (ContractUtil.getProjectHasOnWayBills(billsId, reimburseInfo = new EntityInfo.Builder().entityName("er_publicreimbursebill").entryName("expenseentryentity").sourceName("wbsrcbillid").build(), OnWayCondition).size() > 0) {
                billTypes.add("er_publicreimbursebill");
            }
        }
        OnWayCondition = "A,B,C,D";
        EntityInfo contractInfo = new EntityInfo.Builder().entityName("er_contractbill").entryName("expenseentryentity").sourceName("wbsrcbillid").build();
        if (ContractUtil.getProjectHasOnWayBills(billsId, contractInfo, OnWayCondition).size() > 0) {
            billTypes.add("er_contractbill");
        }
        return billTypes;
    }

    public static List<Long> getProjectHasOnWayBills(Long[] billsId, EntityInfo info, String OnWayCondition) {
        String selectedProperties = String.join((CharSequence)",", "id", "billstatus", info.entryName + ".id", info.entryName + "." + info.sourceName);
        List<Object> collect = Lists.newArrayList();
        DynamicObject[] onwayBills = null;
        if ("er_publicreimbursebill".equals(info.entityName)) {
            onwayBills = BusinessDataServiceHelper.load((String)info.entityName, (String)(selectedProperties + ",payamount"), (QFilter[])new QFilter[]{new QFilter(info.entryName + "." + info.sourceName, "in", (Object)billsId), new QFilter("billstatus", "in", Arrays.asList("B", "C", "F")).or(new QFilter("billstatus", "=", (Object)"E").and(QFilter.of((String)"payamount > 0", (Object[])new Object[0])))});
            collect = Arrays.stream(onwayBills).flatMap(onWayBill -> onWayBill.getDynamicObjectCollection(info.entryName).stream().map(OnWayBillEntry -> OnWayBillEntry.getLong(info.sourceName))).collect(Collectors.toList());
        } else {
            onwayBills = BusinessDataServiceHelper.load((String)info.entityName, (String)selectedProperties, (QFilter[])new QFilter[]{new QFilter(info.entryName + "." + info.sourceName, "in", (Object)billsId)});
            collect = Arrays.stream(onwayBills).filter(prepayBillOnWay -> OnWayCondition.contains(prepayBillOnWay.getString("billstatus"))).flatMap(onWayBill -> onWayBill.getDynamicObjectCollection(info.entryName).stream().map(OnWayBillEntry -> OnWayBillEntry.getLong(info.sourceName))).collect(Collectors.toList());
        }
        return collect;
    }

    public static int getCostestimateHasOnWayBills(Object[] billsId, EntityInfo info, List<String> autuStatus) {
        String selectedProperties = String.join((CharSequence)",", "id", "billstatus", info.entryName + ".id", info.entryName + "." + info.sourceName);
        DynamicObject[] prepayBills = BusinessDataServiceHelper.load((String)info.entityName, (String)selectedProperties, (QFilter[])new QFilter[]{new QFilter(info.entryName + "." + info.sourceName, "in", (Object)billsId), new QFilter("billstatus", "not in", autuStatus)});
        return prepayBills.length;
    }

    public static boolean checkExpenseItem(IDataModel model, IFormView view, int rowIndex) {
        Long expItemId = ErCommonUtils.getPk(model.getValue("expenseitem", rowIndex));
        if (expItemId == null) {
            return true;
        }
        return ExpenseItemServiceHelper.checkExpenseItem(model, rowIndex, expItemId);
    }

    public static boolean checkExpenseItemByProjecttype(DynamicObject projecttype, DynamicObject expenseitem) {
        List numbers;
        if (projecttype != null && expenseitem != null && !(numbers = projecttype.getDynamicObjectCollection("entryentity").stream().map(a -> a.getLong(EXPENSEITEM_ID)).collect(Collectors.toList())).isEmpty()) {
            return numbers.contains(expenseitem.getPkValue());
        }
        return true;
    }

    public static void changeOriWriteOffAmount(BigDecimal currAmount, int rowIndex, IDataModel model) {
        BigDecimal orgiAmount;
        BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)model.getValue("projectchangerate", rowIndex)), (Object)BigDecimal.ONE);
        String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue("projectquotetype", rowIndex)), (Object)"0");
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"0", (CharSequence)quoteType)) {
            exchangeRate = exchangeRate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : exchangeRate;
            orgiAmount = currAmount.divide(exchangeRate, AmountUtils.getCurrencyPrecision(model, "projectcurrency"), RoundingMode.HALF_UP);
        } else {
            orgiAmount = currAmount.multiply(exchangeRate).setScale(AmountUtils.getCurrencyPrecision(model, "projectcurrency"), RoundingMode.HALF_UP);
        }
        model.setValue("oriprojectwriteoffamount", (Object)orgiAmount, rowIndex);
    }

    public static void deleteProjectEntry(Object oldValue, IDataModel model) {
        DynamicObjectCollection partycoll = model.getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("contractpartyentry");
        if (partycoll.size() == 0) {
            return;
        }
        HashSet collect = new HashSet(partycoll.size());
        partycoll.stream().forEach(v -> {
            long contractpartyid = v.getDynamicObject("contractparty") == null ? 0L : (Long)v.getDynamicObject("contractparty").getPkValue();
            collect.add(contractpartyid);
        });
        DynamicObjectCollection projectcoll = model.getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("projectentryentity");
        ArrayList deleteIndex = Lists.newArrayList();
        for (int i = 0; i < projectcoll.size(); ++i) {
            DynamicObject projectwunit = ((DynamicObject)projectcoll.get(i)).getDynamicObject("projectwunit");
            if (projectwunit == null || collect.contains(projectwunit.getPkValue())) continue;
            deleteIndex.add(i);
        }
        model.deleteEntryRows("projectentryentity", deleteIndex.stream().mapToInt(Integer::intValue).toArray());
    }

    public static List checkDownBills(ListSelectedRowCollection rows, String operateKey) {
        String onWayStatus = "A,B,C,F";
        List downBills = ContractUtil.checkHasOnWayBills(rows, onWayStatus);
        return downBills;
    }

    public static List<Integer> loadErContract(IDataModel model, Set<String> entrybillno) {
        ArrayList deleteIndex = Lists.newArrayList();
        DynamicObjectCollection dynamicObjectCollection = model.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
        String selectPropties = "billno,changerate,quotetype,contractcode,description,signdate,contractcurrency,oribalanceamount,oriusedamount,contractname,oriapplyamount";
        DynamicObject[] contractDynamicObjts = (DynamicObject[])QueryServiceHelper.query((String)"er_contractbill", (String)selectPropties, (QFilter[])new QFilter[]{new QFilter("contractcode", "in", entrybillno)}).toArray((Object[])new DynamicObject[0]);
        HashSet<String> entrycontractFordel = new HashSet<String>();
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            if (entrycontractFordel.contains(((DynamicObject)dynamicObjectCollection.get(i)).get("entrycontractno"))) {
                deleteIndex.add(i);
                continue;
            }
            for (int j = 0; j < contractDynamicObjts.length; ++j) {
                if (!((DynamicObject)dynamicObjectCollection.get(i)).get("entrycontractno").equals(contractDynamicObjts[j].get("contractcode"))) continue;
                entrycontractFordel.add((String)((DynamicObject)dynamicObjectCollection.get(i)).get("entrycontractno"));
                model.setValue("entrycontractname", contractDynamicObjts[j].get("contractname"), i);
                model.setValue("totalamount", contractDynamicObjts[j].get("oriapplyamount"), i);
                model.setValue("expusedamount", contractDynamicObjts[j].get("oriusedamount"), i);
                model.setValue("expreimbursableamount", contractDynamicObjts[j].get("oribalanceamount"), i);
                model.setValue("entrycurrency", contractDynamicObjts[j].get("contractcurrency"), i);
                model.setValue("expquotetype", contractDynamicObjts[j].get("quotetype"), i);
                model.setValue("exchangerate", contractDynamicObjts[j].get("changerate"), i);
                model.setValue("expusedamount", contractDynamicObjts[j].get("oriusedamount"), i);
                model.setValue("signingdate", contractDynamicObjts[j].get("signdate"), i);
            }
        }
        return deleteIndex;
    }

    public static void refreshWriteOffAmount(IDataModel model, WriteOffFields fields, String writeOffType) {
        if (writeOffType.equals("1")) {
            ContractUtil.writeOffOri(model, fields.entryKey, fields.approveAmtOriKey, fields.entryCurrencyKey, fields.checkAmtOriKey, fields.checkAmtKey);
        } else {
            ContractUtil.writeOffCurr(model, fields.entryKey, fields.approveAmtKey, fields.approveAmtOriKey, fields.checkAmtOriKey, fields.checkAmtKey, fields.entryQuoteTypeKey, fields.entryExchangerateKey, fields.expAmountKey);
        }
    }

    public static void synAttachment(IFormView view, Map<String, Object> returnData) {
        BillList billList = (BillList)view.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        List attachmentData = (List)returnData.get("attachmentData");
        if (attachmentData != null && attachmentData.size() > 0) {
            for (Map map : attachmentData) {
                String url = (String)map.get("url");
                String name = (String)map.get("name");
                if (url.contains("tempfile/download.do?configKey")) {
                    logger.info(url);
                    url = AttachmentUtils.uploadTempfile(url, name);
                    map.put("url", url);
                    ArrayList<Map> needAddData = new ArrayList<Map>();
                    needAddData.add(map);
                    for (ListSelectedRow listSelectedRow : selectedRows) {
                        AttachmentServiceHelper.upload((String)billList.getEntityId(), (Object)listSelectedRow.getPrimaryKeyValue(), (String)"attachmentpanel", needAddData);
                    }
                }
                map.put("creator", UserServiceHelper.getCurrentUserId());
                map.put("modifytime", new Date().getTime());
            }
            for (ListSelectedRow listSelectedRow : selectedRows) {
                List billAttachmentList = AttachmentServiceHelper.getAttachments((String)billList.getEntityId(), (Object)listSelectedRow.getPrimaryKeyValue(), (String)"attachmentpanel");
                if (billAttachmentList == null || billAttachmentList.size() <= 0) continue;
                block3: for (int i = 0; i < billAttachmentList.size(); ++i) {
                    Map billAttachment = (Map)billAttachmentList.get(i);
                    for (int j = 0; j < attachmentData.size(); ++j) {
                        Map attachment = (Map)attachmentData.get(j);
                        String uid = (String)billAttachment.get("uid");
                        if (!uid.contains(UID_PREFIX_CONTRACT) || attachment.get("uid").equals(uid)) {
                            if (!uid.contains(UID_PREFIX_CONTRACT) || !attachment.get("uid").equals(uid)) continue block3;
                            String name = (String)attachment.get("name");
                            String billAttachname = (String)billAttachment.get("name");
                            if (billAttachname.equals(name)) continue block3;
                            AttachmentServiceHelper.rename((String)uid, (String)name);
                            continue block3;
                        }
                        if (!uid.contains(UID_PREFIX_CONTRACT) || j != attachmentData.size() - 1) continue;
                        AttachmentServiceHelper.remove((String)billList.getEntityId(), (Object)listSelectedRow.getPrimaryKeyValue(), billAttachment.get("uid"));
                        logger.info("----\u5220\u9664\u9644\u4ef61----" + billList.getEntityId() + "-----\u5355\u636eid1-----" + listSelectedRow.getPrimaryKeyValue() + "-----\u9644\u4ef6id1-----" + billAttachment.get("uid"));
                    }
                }
            }
        } else {
            for (ListSelectedRow listSelectedRow : selectedRows) {
                List attachmentList = AttachmentServiceHelper.getAttachments((String)billList.getEntityId(), (Object)listSelectedRow.getPrimaryKeyValue(), (String)"attachmentpanel");
                if (attachmentList == null || attachmentList.size() <= 0) continue;
                for (Map attachment : attachmentList) {
                    String uid = (String)attachment.get("uid");
                    if (!uid.contains(UID_PREFIX_CONTRACT)) continue;
                    AttachmentServiceHelper.remove((String)billList.getEntityId(), (Object)listSelectedRow.getPrimaryKeyValue(), (Object)uid);
                    logger.info("----\u5220\u9664\u9644\u4ef6----" + billList.getEntityId() + "-----\u5355\u636eid-----" + listSelectedRow.getPrimaryKeyValue() + "-----\u9644\u4ef6id-----" + uid);
                }
            }
        }
    }

    public static void contractPageRules(IDataModel model, IFormView view, String entryName, Boolean delete) {
        int entrySize = model.getEntryRowCount(entryName);
        CardEntry cardEntry = (CardEntry)view.getControl(entryName);
        switch (entryName) {
            case "contractpartyentry": {
                view.setVisible(Boolean.valueOf(true), new String[]{"signflex", entryName});
                if (delete.booleanValue()) {
                    view.setVisible(Boolean.valueOf(true), new String[]{"label_sign_done"});
                    view.setVisible(Boolean.valueOf(false), new String[]{"label_sign_delete"});
                } else {
                    view.setVisible(Boolean.valueOf(true), new String[]{"label_sign_delete"});
                    view.setVisible(Boolean.valueOf(false), new String[]{"label_sign_done"});
                }
                for (int rowIndex = 0; rowIndex < entrySize; ++rowIndex) {
                    cardEntry.setChildVisible(delete.booleanValue(), rowIndex, new String[]{"image_sign_delete"});
                }
                break;
            }
            case "termentry": {
                if (entrySize == 0) {
                    view.setVisible(Boolean.valueOf(false), new String[]{"contractitemflex", entryName});
                    break;
                }
                view.setVisible(Boolean.valueOf(true), new String[]{"contractitemflex", entryName});
                if (delete.booleanValue()) {
                    view.setVisible(Boolean.valueOf(true), new String[]{"label_item_done"});
                    view.setVisible(Boolean.valueOf(false), new String[]{"label_item_delete"});
                } else {
                    view.setVisible(Boolean.valueOf(true), new String[]{"label_item_delete"});
                    view.setVisible(Boolean.valueOf(false), new String[]{"label_item_done"});
                }
                for (int rowIndex = 0; rowIndex < entrySize; ++rowIndex) {
                    cardEntry.setChildVisible(delete.booleanValue(), rowIndex, new String[]{"image_item_delete"});
                }
                break;
            }
            case "projectentryentity": {
                if (entrySize == 0) {
                    view.setVisible(Boolean.valueOf(false), new String[]{"contractprojectflex", entryName});
                    break;
                }
                view.setVisible(Boolean.valueOf(true), new String[]{"contractprojectflex", entryName});
                if (delete.booleanValue()) {
                    view.setVisible(Boolean.valueOf(true), new String[]{"label_project_done"});
                    view.setVisible(Boolean.valueOf(false), new String[]{"label_project_delete"});
                } else {
                    view.setVisible(Boolean.valueOf(true), new String[]{"label_project_delete"});
                    view.setVisible(Boolean.valueOf(false), new String[]{"label_project_done"});
                }
                for (int rowIndex = 0; rowIndex < entrySize; ++rowIndex) {
                    cardEntry.setChildVisible(delete.booleanValue(), rowIndex, new String[]{"image_project_delete"});
                }
                break;
            }
            case "expenseentryentity": {
                if (((Boolean)model.getValue("frameworkcontract")).booleanValue()) {
                    view.setVisible(Boolean.valueOf(false), new String[]{"expflex", entryName, "btn_plan_add"});
                    break;
                }
                view.setVisible(Boolean.valueOf(true), new String[]{"btn_plan_add"});
                if (entrySize == 0) {
                    view.setVisible(Boolean.valueOf(false), new String[]{"expflex", entryName});
                    break;
                }
                view.setVisible(Boolean.valueOf(true), new String[]{"expflex", entryName});
                if (delete.booleanValue()) {
                    view.setVisible(Boolean.valueOf(true), new String[]{"label_exp_done"});
                    view.setVisible(Boolean.valueOf(false), new String[]{"label_exp_delete"});
                } else {
                    view.setVisible(Boolean.valueOf(true), new String[]{"label_exp_delete"});
                    view.setVisible(Boolean.valueOf(false), new String[]{"label_exp_done"});
                }
                for (int rowIndex = 0; rowIndex < entrySize; ++rowIndex) {
                    cardEntry.setChildVisible(delete.booleanValue(), rowIndex, new String[]{"image_exp_delete"});
                }
                break;
            }
        }
    }

    public static void setWriteOffType(IDataModel model) {
        DynamicObject company = (DynamicObject)model.getValue("company");
        String writeType = (String)ErCommonUtils.getEMParameter(ErCommonUtils.getPk(company), "er010");
        model.setValue("writeofftype", (Object)writeType);
    }

    public static void addContractPartByHand(IDataModel model, IFormView view, AbstractFormPlugin formPlugin, int rowIndex, String formid) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("formType", "6");
        paramMap.put("formId", formid);
        paramMap.put("writeofftype", model.getValue("writeofftype"));
        param.put("isquerybudget", (Boolean)model.getValue("isquerybudget"));
        param.put("billstatus", model.getValue("billstatus"));
        param.put("std_costcenter", model.getValue("std_costcenter"));
        if (rowIndex != -1) {
            param.put("index", rowIndex);
        } else {
            param.put("index", -1);
        }
        Object[] parma = new Object[]{view, model, param, paramMap};
        List<Object> result = ErExtHelper.invokeMutiParamsExpandPlugin(ErExtcaseEnum.ER_EXTCASE_SUPERBEFORESHOWFORM, formPlugin.getClass(), formid, Boolean.TRUE, parma);
        Boolean boo = Boolean.TRUE;
        if (!result.isEmpty() && result.get(0) != null) {
            boo = (Boolean)result.get(0);
        }
        if (boo.booleanValue()) {
            ShowPageUtils.setFormStatusToCustomParam(param, (IFormView)view);
            paramMap.put("customParam", param);
            paramMap.put("needCallBack", Boolean.TRUE);
            ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)formPlugin);
        }
    }

    public static void saveContractPartOrItemByHand(IDataModel model, IFormView view, String entryName) {
        DynamicObjectCollection contractPartEntry = (DynamicObjectCollection)model.getDataEntity(true).get(entryName);
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        DynamicObjectCollection parentContractPartEntry = (DynamicObjectCollection)parentModel.getDataEntity(true).get(entryName);
        FormShowParameter param = view.getFormShowParameter();
        HashMap<String, Integer> returnData = new HashMap<String, Integer>();
        if (param.getCustomParam("index") != null && (Integer)param.getCustomParam("index") != -1) {
            int index = (Integer)param.getCustomParam("index");
            EntryCopyUtil.updateColl2TargetColl(parentContractPartEntry, contractPartEntry, index);
            returnData.put("index", index);
        } else {
            EntryCopyUtil.copyColl2TargetColl(parentContractPartEntry, contractPartEntry);
            returnData.put("index", -1);
        }
        view.returnDataToParent(returnData);
        view.sendFormAction(parentView);
        view.close();
    }

    public static void setAndGetSelectedRowEntryId(IDataModel model, IFormView formView, String entryName) {
        DynamicObjectCollection entryList = model.getEntryEntity(entryName);
        long[] ids = ORM.create().genLongIds(formView.getEntityId(), entryList.size());
        for (int i = 0; i < entryList.size(); ++i) {
            DynamicObject entryEntity = (DynamicObject)entryList.get(i);
            Long entryId = (Long)entryEntity.getPkValue();
            if (!Objects.equals(entryId, 0L)) continue;
            entryEntity.set("id", (Object)ids[i]);
        }
    }

    public static void setContractPartF7Filter(final IDataModel model, IFormView formView) {
        BasedataEdit realCardF7 = (BasedataEdit)formView.getControl("contractparty");
        realCardF7.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent evt) {
                int entryCurrentRowIndex = model.getEntryCurrentRowIndex("contractpartyentry");
                String partytype = (String)model.getValue("partytype", entryCurrentRowIndex);
                if ("bos_org".equals(partytype) || "bos_adminorg".equals(partytype)) {
                    ListShowParameter cardF7Param = (ListShowParameter)evt.getFormShowParameter();
                    QFilter orgPatternFilter = new QFilter("orgpattern.patterntype", "in", (Object)new String[]{"1", "2"});
                    cardF7Param.getListFilterParameter().getQFilters().add(orgPatternFilter);
                    if ("bos_org".equals(partytype)) {
                        evt.getFormShowParameter().setCustomParam("initOrgFuncId", (Object)"10");
                    }
                }
            }
        });
    }

    public static void setMobFrameworkcontractChange(IDataModel model, IFormView view, Boolean newValueBoolean) {
        if (newValueBoolean.booleanValue()) {
            DynamicObjectCollection expenseentryentity = model.getEntryEntity("expenseentryentity");
            int[] indexArr = new int[expenseentryentity.size()];
            for (int i = 0; i < expenseentryentity.size(); ++i) {
                indexArr[i] = i;
            }
            model.deleteEntryRows("expenseentryentity", indexArr);
            model.beginInit();
            model.setValue("contractamount", null);
            model.setValue("oriapplyamount", null);
            model.setValue("originalamount", null);
            model.setValue("orinotpayamount", null);
            model.setValue("changeamount", null);
            model.setValue("billtaxrate", null);
            model.endInit();
            view.setVisible(Boolean.valueOf(false), new String[]{"expflex", "expenseentryentity", "btn_plan_add", "flexpanelap6"});
            ((FieldEdit)view.getControl("contractcurrency")).setMustInput(false);
            ((FieldEdit)view.getControl("changerate")).setMustInput(false);
        } else {
            view.setVisible(Boolean.valueOf(true), new String[]{"btn_plan_add", "flexpanelap6"});
            int entrySize = model.getEntryRowCount("expenseentryentity");
            if (entrySize == 0) {
                view.setVisible(Boolean.valueOf(false), new String[]{"expflex", "expenseentryentity"});
            } else {
                view.setVisible(Boolean.valueOf(true), new String[]{"label_exp_delete"});
                view.setVisible(Boolean.valueOf(false), new String[]{"label_exp_done"});
                CardEntry cardEntry = (CardEntry)view.getControl("expenseentryentity");
                for (int rowIndex = 0; rowIndex < entrySize; ++rowIndex) {
                    cardEntry.setChildVisible(false, rowIndex, new String[]{"image_exp_delete"});
                }
            }
            ((FieldEdit)view.getControl("contractcurrency")).setMustInput(true);
            ((FieldEdit)view.getControl("changerate")).setMustInput(true);
            ((EntryGrid)view.getControl("expenseentryentity")).setMustInput("expenseentryentity", true);
        }
    }

    @Deprecated
    public static void setMobHeadPart(IDataModel model, IFormView view, ClosedCallBackEvent closedCallBackEvent) {
        int index = -1;
        DynamicObject part = null;
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData != null) {
            index = (Integer)returnData.get("index");
        }
        if (index == 0) {
            part = (DynamicObject)model.getValue("contractparty", 0);
        } else if (index == 1) {
            part = (DynamicObject)model.getValue("contractparty", 1);
            if (model.getEntryRowCount("projectentryentity") > 0) {
                DynamicObject wlunit = (DynamicObject)model.getValue("projectwunit", 0);
                if (part == null || wlunit != null && ((Long)wlunit.getPkValue()).longValue() != ((Long)part.getPkValue()).longValue()) {
                    model.deleteEntryData("projectentryentity");
                }
            }
        }
        ContractUtil.setHeadPart(model, index, part);
    }

    public static void callRleAfterClosedCallBack(IDataModel model, IFormView formView, ListSelectedRowCollection selectBill, String entityNumber, String RuleId, String actionId) {
        if (selectBill == null || selectBill.isEmpty()) {
            return;
        }
        DrawArgs args = BotpDrawServiceUtil.buildDrawArgs(entityNumber, model.getDataEntityType().getName(), formView, selectBill, RuleId);
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)4);
        ConvertOperationResult result = ConvertServiceHelper.draw((DrawArgs)args);
        if (!result.isSuccess()) {
            return;
        }
        BotpDrawServiceUtil.dealResult(result, resultList, (BillEntityType)model.getDataEntityType());
        for (DynamicObject bill : resultList) {
            ((IBillModel)model).push((Object)bill);
        }
        if ("er_projectfromcontract_mb".equals(actionId)) {
            Object unit;
            int i;
            ContractUtil.refreshWriteOffAmount(model, (WriteOffFields)ContractProjectWriteOffFields.getInstance());
            String writeOffType = (String)model.getValue("writeofftype");
            int size = model.getEntryRowCount("projectentryentity");
            if ("1".equals(writeOffType)) {
                for (i = 0; i < size; ++i) {
                    ContractUtil.refreshWriteOffCurrAmount(model, i, formView);
                }
            } else {
                for (i = 0; i < size; ++i) {
                    ContractUtil.changeOriWriteOffAmount((BigDecimal)model.getValue("projectwriteoffamount", i), i, model);
                }
            }
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            ContractUtil.setAmountToLabel(model, formView, "projectentryentity", "projectwriteoffamount", "label_project_amount", currency);
            ContractUtil.contractPageRules(model, formView, "projectentryentity", false);
            formView.updateView("projectentryentity");
            if (size > 0 && (unit = model.getValue("projectwunit", 0)) != null && model.getEntryRowCount("contractpartyentry") > 1) {
                model.setValue("contractparty", unit, 1);
            }
        } else if ("er_draw_concontract_mb".equals(actionId)) {
            ContractUtil.refreshHeadContacts(formView, null);
            formView.updateView("contractsconn");
        }
    }

    public static void refreshSecondWriteOffCurrAmount(IDataModel model, IDataModel parentModel, int index, IFormView view) {
        String writeOffType = (String)parentModel.getValue("writeofftype");
        BigDecimal expAmount = (BigDecimal)model.getValue("oriprojectwriteoffamount", index);
        BigDecimal projAmount = (BigDecimal)model.getValue("oriprojectcanamount", index);
        if (writeOffType.equals(WriteOffTypeEnum.ORGI_WO.getValue()) && !ContractUtil.currencyValidate(model, parentModel, index, "entrycurrency", "projectcurrency") && expAmount.compareTo(BigDecimal.ZERO) > 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e01\u79cd\u4e0d\u5728\u8d39\u7528\u660e\u7ec6\u4e2d\uff0c\u4e0d\u80fd\u51b2\u9500\u3002", (String)"ContractUtil_20", (String)"fi-er-business", (Object[])new Object[0]));
            model.setValue("oriprojectwriteoffamount", (Object)BigDecimal.ZERO, index);
            return;
        }
        if (expAmount.compareTo(projAmount) > 0) {
            model.setValue("oriprojectwriteoffamount", (Object)projAmount, index);
            expAmount = projAmount;
        }
        BigDecimal exchangeRate = model.getValue("projectchangerate", index) == null ? BigDecimal.ZERO : (BigDecimal)model.getValue("projectchangerate", index);
        String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue("projectquotetype", index)), (Object)"0");
        DynamicObject currency = (DynamicObject)parentModel.getValue("currency");
        if (null == currency) {
            return;
        }
        int precision = AmountUtils.getCurrencyPrecision(ErCommonUtils.getPk(currency));
        BigDecimal currencyAmount = AmountUtils.getCurrencyAmount(expAmount, exchangeRate, precision, quoteType);
        model.setValue("projectwriteoffamount", (Object)currencyAmount, index);
    }

    public static boolean currencyValidate(IDataModel dataModel, IDataModel parentModel, int index, String entryCurrency, String projectCurrency) {
        Set<Long> currencyIds = AmountUtils.getCurrencyIdSet(parentModel, "expenseentryentity", entryCurrency);
        DynamicObject writeOffCurrency = (DynamicObject)dataModel.getValue(projectCurrency, index);
        return writeOffCurrency == null || currencyIds.contains(writeOffCurrency.getPkValue());
    }

    public static void calBillSumAmount(IDataModel model, IFormView formView) {
        BigDecimal expenseamount = AmountUtils.getEntryAmount(model, "expenseentryentity", "expenseamount");
        model.setValue("oribalanceamount", (Object)expenseamount);
        model.setValue("oricanloanamount", (Object)expenseamount);
        model.setValue("orinotpayamount", (Object)AmountUtils.getEntryAmount(model, "expenseentryentity", "oriexpnotpayamount"));
        model.setValue("oriapplyamount", (Object)expenseamount);
        if (model.getValue("detailtype").equals("biztype_applybill")) {
            model.setValue("contractamount", (Object)expenseamount);
        }
        BigDecimal currexpenseamount = AmountUtils.getEntryAmount(model, "expenseentryentity", "currexpenseamount");
        model.setValue("applyamount", (Object)currexpenseamount);
        model.setValue("balanceamount", (Object)currexpenseamount);
        model.setValue("billcanloanamount", (Object)currexpenseamount);
        if (model.getProperty("cancontractamount") != null) {
            model.setValue("cancontractamount", (Object)currexpenseamount);
        }
        if (model.getProperty("invoiceamountremain") != null) {
            model.setValue("invoiceamountremain", (Object)currexpenseamount);
        }
        model.setValue("notpayamount", (Object)AmountUtils.getEntryAmount(model, "expenseentryentity", "expnotpayamount"));
        model.setValue("availableamount", (Object)currexpenseamount.subtract((BigDecimal)model.getValue("nonpayamount")));
        model.setValue("oriavailableamount", (Object)expenseamount.subtract((BigDecimal)model.getValue("orinonpayamount")));
        ContractUtil.refreshBillTaxAmountByExpense(model, formView);
        ContractUtil.refreshOriginalAmount(model, formView);
    }

    public static void setAmountToLabel(IDataModel model, IFormView formView, String entryName, String amtFieldName, String labelName, DynamicObject currency) {
        BigDecimal loanAmount = AmountUtils.getEntryAmount(model, entryName, amtFieldName);
        String currencySign = "";
        int amountPrecition = 4;
        if (currency != null) {
            currencySign = currency.getString("sign");
            amountPrecition = currency.getInt("amtprecision");
            loanAmount = loanAmount.setScale(amountPrecition, RoundingMode.HALF_UP);
        }
        String formatMoneyByUser = AmountUtils.formatMoneyByUser(Long.valueOf(RequestContext.get().getUserId()), currencySign, amountPrecition, loanAmount);
        Label expenseAmount = (Label)formView.getControl(labelName);
        if (expenseAmount != null) {
            expenseAmount.setText(formatMoneyByUser);
            formView.updateView(labelName);
        }
    }

    public static void setBudgetShow(IDataModel model, IFormView formView, boolean isShowBudget, String budgeMsgValue, int index) {
        if (index == -1) {
            for (int i = 0; i < model.getEntryRowCount("expenseentryentity"); ++i) {
                ContractUtil.setBudgetVisible(formView, "expenseentryentity", budgeMsgValue, isShowBudget, i);
            }
        } else {
            ContractUtil.setBudgetVisible(formView, "expenseentryentity", budgeMsgValue, isShowBudget, index);
        }
    }

    public static void setBudgetVisible(IFormView formView, String entryName, String budgeMsgValue, boolean isQueryBudgetFlag, int index) {
        CardEntry cardEntry = (CardEntry)formView.getControl(entryName);
        if (isQueryBudgetFlag) {
            if ("0".equals(budgeMsgValue)) {
                cardEntry.setChildVisible(true, index, new String[]{"budgetamount"});
                cardEntry.setChildVisible(false, index, new String[]{"budgetmsg"});
            } else {
                cardEntry.setChildVisible(false, index, new String[]{"budgetamount"});
                cardEntry.setChildVisible(true, index, new String[]{"budgetmsg"});
            }
        } else {
            cardEntry.setChildVisible(false, index, new String[]{"budgetamount"});
            cardEntry.setChildVisible(false, index, new String[]{"budgetmsg"});
        }
    }

    public static DynamicObject getSelectBillProjectOwer(IMobileListView view, String entityId) {
        Long pkId = (Long)view.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        return BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entityId);
    }

    public static Map<Long, DynamicObject> getUserInSelectedBillsProjectOwer(IMobileListView mobileListView, String entityId) {
        return ContractUtil.getSelectBillProjectOwer(mobileListView, entityId).getDynamicObjectCollection("projectower").stream().collect(Collectors.toMap(k -> k.getLong("FBASEDATAID_id"), k -> k.getDynamicObject("fbasedataid"), (k, v) -> v));
    }

    public static void setUsersToSelectedBillProjectOwer(Set<Long> ids, IMobileListView mobileListView, String entityId) {
        DynamicObject selectBill = ContractUtil.getSelectBillProjectOwer(mobileListView, entityId);
        DynamicObjectCollection projectowers = selectBill.getDynamicObjectCollection("projectower");
        if (projectowers.size() == 0) {
            projectowers.addNew();
        }
        DynamicObjectType projectOwersType = (DynamicObjectType)((DynamicObject)projectowers.get(0)).getDataEntityType();
        projectowers.clear();
        selectBill.set("projectower", (Object)projectowers);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectBill});
        for (Long r : ids) {
            DynamicObject tmpDynamicObject = new DynamicObject(projectOwersType);
            tmpDynamicObject.set("fbasedataid", (Object)r);
            tmpDynamicObject.set("FBASEDATAID_id", (Object)r);
            projectowers.add((Object)tmpDynamicObject);
        }
        selectBill.set("projectower", (Object)projectowers);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectBill});
    }

    public static void createShowMobileF7ListForm(String formId, boolean isMultiSelect, IMobileListView view, IFormPlugin plugin) {
        ContractUtil.createShowMobileF7ListForm(formId, isMultiSelect, view, plugin, null);
    }

    public static void createShowMobileF7ListForm(String formId, boolean isMultiSelect, IMobileListView view, IFormPlugin plugin, ListFilterParameter lfp) {
        ShowType showType;
        MobileListShowParameter listShowParameter = new MobileListShowParameter();
        FormConfig formConfig = FormMetadataCache.getMobListFormConfig((String)formId);
        listShowParameter.setCaption(formConfig.getCaption().toString());
        listShowParameter.setLookUp(true);
        listShowParameter.setBillFormId(formId);
        if (formConfig.getShowType() == ShowType.MainNewTabPage) {
            showType = ShowType.Floating;
        } else {
            showType = ShowType.Modal;
            listShowParameter.setPosition(MobileFormPosition.Bottom);
        }
        listShowParameter.getOpenStyle().setShowType(showType);
        listShowParameter.setMultiSelect(isMultiSelect);
        String f7ListFormId = formConfig.getF7ListFormId();
        if (StringUtils.isNotBlank((String)f7ListFormId)) {
            listShowParameter.setFormId(f7ListFormId);
        }
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u53d8\u66f4\u5e72\u7cfb\u4eba", (String)"ProjectOwerListPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        listShowParameter.setShowUsed(true);
        listShowParameter.setShowApproved(true);
        listShowParameter.setShowQuickFilter(true);
        listShowParameter.setShowFilter(true);
        listShowParameter.setMustInput(true);
        if (lfp != null) {
            listShowParameter.setListFilterParameter(lfp);
        }
        listShowParameter.setSelectedRows(ContractUtil.getUserInSelectedBillsProjectOwer(view, "er_contractbill").keySet().toArray());
        listShowParameter.setCloseCallBack(new CloseCallBack(plugin, "projectower"));
        view.showForm((FormShowParameter)listShowParameter);
    }

    public static boolean checkChangeProjectOwer(ListSelectedRowCollection listSelectedRows, IMobileListView view) {
        boolean res = Boolean.FALSE;
        if (listSelectedRows == null || listSelectedRows.size() != 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u53d8\u66f4\u5e72\u7cfb\u4eba\u64cd\u4f5c\u3002", (String)"ProjectOwerListPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        QFilter qFilter = new QFilter("id", "in", listSelectedRows.stream().map(v -> (Long)v.getPrimaryKeyValue()).collect(Collectors.toList()));
        String OnWayCondition = "H,I,J";
        DynamicObjectCollection selectedBills = QueryServiceHelper.query((String)"er_contractbill", (String)"id,detailtype,billstatus,company", (QFilter[])new QFilter[]{qFilter});
        Set billstatusSet = selectedBills.stream().filter(v -> OnWayCondition.contains(v.getString("billstatus"))).collect(Collectors.toSet());
        if (billstatusSet.size() > 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u7684\u5355\u636e\u72b6\u6001\u4e0d\u652f\u6301\u53d8\u66f4\u5e72\u7cfb\u4eba\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5355\u636e\u3002", (String)"ContractBillList_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        Set detailtypeSet = selectedBills.stream().filter(v -> "biztype_stopbill".equals(v.get("detailtype")) || "biztype_changebill".equals(v.get("detailtype"))).collect(Collectors.toSet());
        if (detailtypeSet.size() > 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u53d8\u66f4\u5355/\u5408\u540c\u7ec8\u6b62\u5355\u4e0d\u652f\u6301\u53d8\u66f4\u5e72\u7cfb\u4eba\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5355\u636e\u3002", (String)"ContractBillList_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        if ("1".equals(ErCommonUtils.getEMParameter(RequestContext.get().getOrgId(), "stakeholderschange"))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u6682\u4e0d\u652f\u6301\u9700\u8981\u6d41\u7a0b\u5ba1\u6279\u7684\u5e72\u7cfb\u4eba\u53d8\u66f4\u3002", (String)"ContractBillList_23", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        return res;
    }

    public static void setSecondFiledLockAndVisible(String detaiType, String changeType, IDataModel dataModel, IFormView formView, String entryName) {
        if ("biztype_stopbill".equals(detaiType)) {
            if ("projectentryentity".equals(entryName)) {
                formView.setEnable(Boolean.FALSE, new String[]{"flexpanelap"});
                formView.setVisible(Boolean.FALSE, new String[]{"btn_save"});
            } else if ("contractpartyentry".equals(entryName)) {
                formView.setEnable(Boolean.FALSE, new String[]{"flexpanelap"});
                formView.setVisible(Boolean.FALSE, new String[]{"addcontractpart", "btn_save"});
            } else if ("termentry".equals(entryName)) {
                formView.setEnable(Boolean.FALSE, new String[]{"flexpanelap"});
                formView.setVisible(Boolean.FALSE, new String[]{"addcontractitem", "btn_save"});
            } else if ("expenseentryentity".equals(entryName)) {
                formView.setEnable(Boolean.FALSE, new String[]{"flexpanelap"});
                formView.setVisible(Boolean.FALSE, new String[]{"addcontractplan", "btn_save"});
            }
        } else if ("biztype_changebill".equals(detaiType)) {
            if ("projectentryentity".equals(entryName)) {
                formView.setEnable(Boolean.FALSE, new String[]{"flexpanelap"});
                formView.setVisible(Boolean.FALSE, new String[]{"btn_save"});
            } else if ("contractpartyentry".equals(entryName)) {
                formView.setEnable(Boolean.FALSE, new String[]{"flexpanelap"});
                formView.setVisible(Boolean.FALSE, new String[]{"addcontractpart", "btn_save"});
            } else if ("termentry".equals(entryName)) {
                if (!"D".equals(changeType)) {
                    formView.setEnable(Boolean.FALSE, new String[]{"flexpanelap"});
                    formView.setVisible(Boolean.FALSE, new String[]{"addcontractitem", "btn_save"});
                }
            } else if ("expenseentryentity".equals(entryName)) {
                if ("A".equals(changeType)) {
                    formView.setVisible(Boolean.FALSE, new String[]{"addcontractplan"});
                    formView.setEnable(Boolean.FALSE, 0, new String[]{"paymenttypeid", "happendate", "taxrate", "orientryamount", "invoicetype", "entrycostcenter", "expenseitem", "std_project", "entryproducttype", "assetunit", "num", "exppricewithtax", "entryremark", "payterms", "entrycostdept", "entrycostcompany"});
                } else if ("B".equals(changeType)) {
                    formView.setVisible(Boolean.FALSE, new String[]{"addcontractplan"});
                    formView.setEnable(Boolean.FALSE, 0, new String[]{"paymenttypeid", "happendate", "expenseamount", "orientryamount", "invoicetype", "entrycostcenter", "expenseitem", "std_project", "entryproducttype", "assetunit", "num", "exppricewithtax", "entryremark", "payterms", "entrycostdept", "entrycostcompany"});
                } else if ("C".equals(changeType)) {
                    FormShowParameter formShowParameter = formView.getFormShowParameter();
                    int index = (Integer)formShowParameter.getCustomParam("index");
                    if (index != -1 && "1".equals(dataModel.getValue("itemfrom", 0))) {
                        formView.setEnable(Boolean.FALSE, 0, new String[]{"paymenttypeid", "happendate", "expenseamount", "taxrate", "taxamount", "orientryamount", "invoicetype", "entrycostcenter", "expenseitem", "std_project", "entryproducttype", "assetunit", "num", "exppricewithtax", "entryremark", "payterms", "entrycostdept", "entrycostcompany"});
                    }
                } else if ("D".equals(changeType)) {
                    formView.setVisible(Boolean.FALSE, new String[]{"addcontractplan"});
                    formView.setEnable(Boolean.FALSE, 0, new String[]{"expenseamount", "taxamount", "taxrate", "entrycostdept", "entrycostcenter", "entrycostcompany"});
                }
            }
        }
    }

    public static void setFirstFiledLockAndVisible(String detaiType, String changeType, IDataModel dataModel, IFormView formView) {
        if ("biztype_stopbill".equals(detaiType)) {
            formView.setEnable(Boolean.FALSE, new String[]{"alltipsflex", "costcompanyflexpanel", "contractflexpanel", "flexpanelap6", "projectower", "projecttype"});
            formView.setVisible(Boolean.FALSE, new String[]{"label_sign_delete", "label_sign_done", "label_exp_delete", "label_exp_done", "flex_addcontractpart", "btn_plan_add", "btn_contractitem_add", "btn_contractproject_add", "label_item_delete", "label_item_done", "label_project_delete", "label_project_done", "changedate", "lb_change"});
        } else if ("biztype_changebill".equals(detaiType)) {
            formView.setEnable(Boolean.FALSE, new String[]{"costcompanyflexpanel", "contracttype", "contractcode", "contractname", "signdate", "relationconpanelapl", "frameworkcontract", "projecttype"});
            formView.setVisible(Boolean.FALSE, new String[]{"flexcontractpanelap", "label_sign_delete", "label_sign_delete", "flex_addcontractpart", "flexpanelap6", "lb_change"});
            if ("A".equals(changeType)) {
                formView.setVisible(Boolean.FALSE, new String[]{"label_exp_delete", "label_exp_done", "btn_plan_add", "btn_contractitem_add", "label_item_delete", "label_item_done"});
            } else if ("B".equals(changeType)) {
                formView.setVisible(Boolean.FALSE, new String[]{"label_exp_delete", "label_exp_done", "btn_plan_add", "btn_contractitem_add", "label_item_delete", "label_item_done"});
            } else if ("C".equals(changeType)) {
                formView.setVisible(Boolean.FALSE, new String[]{"btn_contractitem_add", "label_item_delete", "label_item_done"});
            } else if ("D".equals(changeType)) {
                formView.setVisible(Boolean.FALSE, new String[]{"label_exp_delete", "label_exp_done", "btn_plan_add"});
            }
        } else {
            formView.setVisible(Boolean.FALSE, new String[]{"changedate"});
        }
    }

    public static void contractPaybyrataCheckAmount(BeforeDoOperationEventArgs e, IDataModel dataModel, IFormView formView) {
        Boolean ispaybyrata = (Boolean)dataModel.getValue("paybyrata");
        if (ispaybyrata.booleanValue()) {
            BigDecimal prorataamount = (BigDecimal)dataModel.getValue("prorataamount");
            BigDecimal proratataxamount = (BigDecimal)dataModel.getValue("proratataxamount");
            DynamicObjectCollection expcoll = dataModel.getEntryEntity("expenseentryentity");
            BigDecimal paypercent = expcoll.stream().map(n -> n.getBigDecimal("paypercent")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (ispaybyrata.booleanValue() && paypercent.compareTo(new BigDecimal(100L)) == 0) {
                BigDecimal diff = ErStdConfig.getAccentryDiffRange();
                if (prorataamount.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal expenseamounttol = expcoll.stream().map(n -> n.getBigDecimal("expenseamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal tailDiff = prorataamount.subtract(expenseamounttol);
                    if (expenseamounttol.compareTo(prorataamount) != 0) {
                        if (tailDiff.compareTo(diff) <= 0 && tailDiff.compareTo(diff.multiply(BigDecimal.valueOf(-1L))) >= 0) {
                            BigDecimal expenseamount = (BigDecimal)dataModel.getValue("expenseamount", expcoll.size() - 1);
                            dataModel.setValue("expenseamount", (Object)expenseamount.add(tailDiff), expcoll.size() - 1);
                        } else {
                            e.setCancel(true);
                            formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u5408\u540c\u91d1\u989d\u4e0d\u7b49\u4e8e\u201c\u4ed8\u6b3e\u8ba1\u5212\u201d\u5206\u5f55\u542b\u7a0e\u91d1\u989d\u5408\u8ba1\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractUtil_31", (String)"fi-er-business", (Object[])new Object[0]), new Object[0]));
                        }
                    }
                    if (proratataxamount.compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal taxamounttol = expcoll.stream().map(n -> n.getBigDecimal("taxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal taxDiff = proratataxamount.subtract(taxamounttol);
                        if (proratataxamount.compareTo(taxamounttol) != 0) {
                            if (taxDiff.compareTo(diff) <= 0 && taxDiff.compareTo(diff.multiply(BigDecimal.valueOf(-1L))) >= 0) {
                                BigDecimal taxamount = (BigDecimal)dataModel.getValue("taxamount", expcoll.size() - 1);
                                dataModel.setValue("taxamount", (Object)taxamount.add(taxDiff), expcoll.size() - 1);
                            } else {
                                e.setCancel(true);
                                formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u5408\u540c\u7a0e\u989d\u4e0d\u7b49\u4e8e\u201c\u4ed8\u6b3e\u8ba1\u5212\u201d\u5206\u5f55\u7a0e\u989d\u5408\u8ba1\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractUtil_32", (String)"fi-er-business", (Object[])new Object[0]), new Object[0]));
                            }
                        }
                    }
                }
            }
        }
    }

    private static boolean checkBizdate(String dateStr) {
        if (dateStr != null) {
            Matcher matcher = Pattern.compile("\\d{4}-\\d{2}-\\d{2}").matcher(dateStr);
            return !matcher.matches();
        }
        return false;
    }

    public static BigDecimal getBigDecimal(Map<String, Object> row, String fieldName) {
        try {
            Object val = row.get(fieldName);
            if (val != null) {
                return new BigDecimal(val.toString());
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u91d1\u989d\u8f93\u5165\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002", (String)"ContractUtil_39", (String)"fi-er-business", (Object[])new Object[0]));
        }
        return BigDecimal.ZERO;
    }

    private static String truncateString(String str, int maxLenght) {
        if (str.length() <= maxLenght) {
            return str;
        }
        return str.substring(0, maxLenght);
    }

    static {
        frozenOPs = new HashSet<String>(){
            {
                this.add("^push");
                this.add("^invalid");
            }
        };
    }
}

