/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.pub;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang3.ObjectUtils;

public class CostestimateBillUtil {
    public static void writeOffContract(IDataModel model) {
        Boolean frameworkcontract = (Boolean)model.getValue("frameworkcontract");
        boolean ispush = (Boolean)model.getValue("ispush");
        if (frameworkcontract.booleanValue() && !ispush && model.getEntryRowCount("contractentry") > 0) {
            DynamicObjectCollection expcoll = model.getEntryEntity("expenseentryentity");
            DynamicObjectCollection contractcoll = model.getEntryEntity("contractentry");
            if (expcoll != null && expcoll.size() > 0) {
                Map<Long, List<DynamicObject>> expenseGroupByWlunit = expcoll.stream().filter(t -> t.get("entrywlunit") != null).collect(Collectors.groupingBy(v -> (Long)v.getDynamicObject("entrywlunit").getPkValue()));
                Map<Long, List<DynamicObject>> contracGroupByPart = contractcoll.stream().filter(t -> t.get("contractpartb") != null).collect(Collectors.groupingBy(v -> (Long)v.getDynamicObject("contractpartb").getPkValue()));
                for (Map.Entry<Long, List<DynamicObject>> entry : expenseGroupByWlunit.entrySet()) {
                    List<DynamicObject> expenseEntryList = entry.getValue();
                    Long key = entry.getKey();
                    BigDecimal expeapprovecurramount = expenseEntryList.stream().map(e -> (BigDecimal)e.get("expeapprovecurramount")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
                    for (Map.Entry<Long, List<DynamicObject>> contractentry : contracGroupByPart.entrySet()) {
                        List<DynamicObject> contractEntryList;
                        if (contractentry == null || contractentry.getKey().compareTo(key) != 0 || (contractEntryList = contractentry.getValue()) == null || contractEntryList.size() <= 0) continue;
                        DynamicObject contractEntry = contractEntryList.get(0);
                        int amtprecision = 4;
                        DynamicObject contractexpcurrency = contractEntry.getDynamicObject("contractexpcurrency");
                        if (contractexpcurrency != null) {
                            amtprecision = contractexpcurrency.getInt("amtprecision");
                        }
                        BigDecimal expeapproveamount = AmountUtils.getOriAmount(expeapprovecurramount, contractEntry.getBigDecimal("contractexpchangerate"), amtprecision, contractEntry.getString("contractexpquotetype"));
                        contractEntry.set("contractcurrwriteoff", (Object)expeapprovecurramount);
                        contractEntry.set("contractwriteoff", (Object)expeapproveamount);
                    }
                }
            }
        }
    }

    public static void refreshContractEntry(IDataModel model) {
        Boolean frameworkcontract = (Boolean)model.getValue("frameworkcontract");
        boolean ispush = (Boolean)model.getValue("ispush");
        if (frameworkcontract.booleanValue() && !ispush && model.getEntryRowCount("contractentry") > 0) {
            model.updateCache();
            DynamicObjectCollection expcoll = model.getEntryEntity("expenseentryentity");
            DynamicObjectCollection contractcoll = model.getEntryEntity("contractentry");
            if (expcoll != null && expcoll.size() > 0) {
                ArrayList deleteRows = Lists.newArrayList();
                Set itemset = expcoll.stream().map(v -> (DynamicObject)v.get("entrywlunit") != null ? ((DynamicObject)v.get("entrywlunit")).getPkValue() : null).collect(Collectors.toSet());
                if (itemset != null && !itemset.isEmpty()) {
                    for (int i2 = 0; i2 < contractcoll.size(); ++i2) {
                        if (itemset.contains(((DynamicObject)((DynamicObject)contractcoll.get(i2)).get("contractpartb")).getPkValue())) continue;
                        deleteRows.add(i2);
                    }
                }
                if (!deleteRows.isEmpty() && contractcoll != null && contractcoll.size() > 0) {
                    model.deleteEntryRows("contractentry", deleteRows.stream().mapToInt(i -> i).toArray());
                }
            } else {
                model.deleteEntryData("contractentry");
            }
        }
    }

    public static void refreshContractCurrWriteAmount(IDataModel model, BigDecimal oriAmount, int rowIndex) {
        BigDecimal changeRate = model.getValue("contractexpchangerate", rowIndex) == null ? BigDecimal.ZERO : (BigDecimal)model.getValue("contractexpchangerate", rowIndex);
        String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue("contractexpquotetype", rowIndex)), (Object)"0");
        DynamicObject expCurrency = (DynamicObject)model.getValue("contractexpcurrency", rowIndex);
        if (null == expCurrency) {
            return;
        }
        int precision = AmountUtils.getCurrencyPrecision(ErCommonUtils.getPk(expCurrency));
        BigDecimal currencyAmount = AmountUtils.getCurrencyAmount(oriAmount, changeRate, precision, quoteType);
        model.setValue("contractcurrwriteoff", (Object)currencyAmount, rowIndex);
    }

    public static void refreshExpenseContractInfo(IDataModel model) {
        DynamicObjectCollection expenseEntry = model.getEntryEntity("expenseentryentity");
        DynamicObjectCollection contractEntry = model.getEntryEntity("contractentry");
        if (expenseEntry != null && expenseEntry.size() > 0) {
            for (DynamicObject contract : contractEntry) {
                for (int i = 0; i < expenseEntry.size(); ++i) {
                    DynamicObject wlunit = contract.getDynamicObject("contractpartb");
                    DynamicObject entryWlunit = ((DynamicObject)expenseEntry.get(i)).getDynamicObject("entrywlunit");
                    if (wlunit == null || entryWlunit == null || wlunit.getPkValue() != entryWlunit.getPkValue()) continue;
                    String contractcode = contract.getString("contractcode");
                    String contractname = contract.getString("contractname");
                    model.setValue("entrycontractno", (Object)contractcode, i);
                    model.setValue("entrycontractname", (Object)contractname, i);
                }
            }
        }
    }
}

