/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reimamountctl.method;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.er.business.amount.control.impl.AmountFreedImpl;
import kd.fi.er.business.reimamountctl.method.QuotaCtlMethodService;
import kd.fi.er.business.reimamountctl.model.ExpItemAmountBO;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.utils.CollectorsUtil;

public class MonthlyQuotaCtlMethodServiceImpl
implements QuotaCtlMethodService {
    @Override
    public Map<String, LocalDate> genHappenDatePeriod(QuotaAmountBO quotaAmountBO) {
        if (quotaAmountBO.getHappenDatePeriod() != null && quotaAmountBO.getHappenDatePeriod().size() > 0) {
            return quotaAmountBO.getHappenDatePeriod();
        }
        if (quotaAmountBO.getHappenDate() != null) {
            YearMonth happenDate = quotaAmountBO.getHappenDate();
            LocalDate beginDate = LocalDate.of(happenDate.getYear(), happenDate.getMonth(), 1);
            LocalDate endDate = happenDate.atEndOfMonth();
            HashMap<String, LocalDate> datePeriod = new HashMap<String, LocalDate>(2);
            datePeriod.put("start", beginDate);
            datePeriod.put("end", endDate);
            return datePeriod;
        }
        return null;
    }

    @Override
    public Map<YearMonth, BigDecimal> groupAmountDataByHappendate(List<ExpItemAmountBO> reimburseAmountBOs) {
        return reimburseAmountBOs.stream().collect(Collectors.groupingBy(reimburseAmountBO -> YearMonth.from(reimburseAmountBO.getHappenDate()), CollectorsUtil.summingBigDecimal(ExpItemAmountBO::getAmount)));
    }

    @Override
    public Map<YearMonth, List<ExpItemAmountBO>> groupListDataByHappenDate(List<ExpItemAmountBO> reimburseAmountBOs) {
        return reimburseAmountBOs.stream().collect(Collectors.groupingBy(reimburseAmountBO -> YearMonth.from(reimburseAmountBO.getHappenDate())));
    }

    @Override
    public BigDecimal getEmpQuotaAmountByCltMethod(DynamicObject quota, QuotaAmountBO reimAmountBO) {
        BigDecimal amount = quota.getBigDecimal("month" + reimAmountBO.getHappenDate().getMonthValue());
        BigDecimal releaseRatio = BigDecimal.ONE;
        if (reimAmountBO.getIsByFreedRatio()) {
            DynamicObject amountFeed;
            AmountFreedImpl amountFreedService = new AmountFreedImpl();
            if ("1".equals(reimAmountBO.getCtrlMode()) && YearMonth.now().equals(reimAmountBO.getHappenDate())) {
                releaseRatio = amountFreedService.getHaveFreededAmount(reimAmountBO.getCompanyId(), reimAmountBO.getExpenseItemId());
            }
            if ("1".equals(reimAmountBO.getCtrlMode()) && reimAmountBO.getHappenDate().isAfter(YearMonth.now()) && (amountFeed = amountFreedService.getAmountFreed(reimAmountBO.getCompanyId(), reimAmountBO.getExpenseItemId())) != null && amountFeed.getBoolean("nextmonthfree")) {
                releaseRatio = BigDecimal.ZERO;
            }
        }
        return amount.multiply(releaseRatio);
    }

    @Override
    public BigDecimal getDeptQuotaAmountByCltMethod(DynamicObject quota, QuotaAmountBO reimAmountBO) {
        return quota.getBigDecimal("month" + reimAmountBO.getHappenDate().getMonthValue());
    }
}

