/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reimamountctl.method;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.time.YearMonth;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.er.business.reimamountctl.method.QuotaCtlMethodService;
import kd.fi.er.business.reimamountctl.model.ExpItemAmountBO;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.utils.CollectorsUtil;

public class QuarterlyQuotaCtlMethodServiceImpl
implements QuotaCtlMethodService {
    @Override
    public Map<String, LocalDate> genHappenDatePeriod(QuotaAmountBO quotaAmountBO) {
        if (quotaAmountBO.getHappenDatePeriod() != null && quotaAmountBO.getHappenDatePeriod().size() > 0) {
            return quotaAmountBO.getHappenDatePeriod();
        }
        if (quotaAmountBO.getHappenDate() != null) {
            YearMonth happenDate = quotaAmountBO.getHappenDate();
            int quarter = (happenDate.getMonth().firstMonthOfQuarter().getValue() + 2) / 3;
            LocalDate localDate = LocalDate.of(happenDate.getYear(), 1, 1);
            LocalDate quarterEndDate = localDate.withMonth(quarter * 3);
            Month firstMonthOfQuarter = quarterEndDate.getMonth().firstMonthOfQuarter();
            Month endMonthOfQuarter = quarterEndDate.getMonth();
            LocalDate start = LocalDate.of(localDate.getYear(), firstMonthOfQuarter, 1);
            LocalDate end = LocalDate.of(localDate.getYear(), endMonthOfQuarter, endMonthOfQuarter.length(localDate.isLeapYear()));
            HashMap<String, LocalDate> quarterPeriod = new HashMap<String, LocalDate>(2);
            quarterPeriod.put("start", start);
            quarterPeriod.put("end", end);
            return quarterPeriod;
        }
        return null;
    }

    @Override
    public Map<YearMonth, BigDecimal> groupAmountDataByHappendate(List<ExpItemAmountBO> reimburseAmountBOs) {
        return reimburseAmountBOs.stream().collect(Collectors.groupingBy(reimburseAmountBO -> YearMonth.of(reimburseAmountBO.getHappenDate().getYear(), reimburseAmountBO.getHappenDate().getMonth().firstMonthOfQuarter()), CollectorsUtil.summingBigDecimal(ExpItemAmountBO::getAmount)));
    }

    @Override
    public Map<YearMonth, List<ExpItemAmountBO>> groupListDataByHappenDate(List<ExpItemAmountBO> reimburseAmountBOs) {
        return reimburseAmountBOs.stream().collect(Collectors.groupingBy(reimburseAmountBO -> YearMonth.of(reimburseAmountBO.getHappenDate().getYear(), reimburseAmountBO.getHappenDate().getMonth().firstMonthOfQuarter())));
    }

    @Override
    public BigDecimal getEmpQuotaAmountByCltMethod(DynamicObject quota, QuotaAmountBO reimAmountBO) {
        int quarter = (reimAmountBO.getHappenDate().getMonth().firstMonthOfQuarter().getValue() + 2) / 3;
        return quota.getBigDecimal("quarter" + quarter);
    }

    @Override
    public BigDecimal getDeptQuotaAmountByCltMethod(DynamicObject quota, QuotaAmountBO reimAmountBO) {
        int quarter = (reimAmountBO.getHappenDate().getMonth().firstMonthOfQuarter().getValue() + 2) / 3;
        return quota.getBigDecimal("quarter" + quarter);
    }
}

