/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reimamountctl.mode;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.fi.er.business.daily.amount.service.util.DailyAmountUtils;
import kd.fi.er.business.daily.service.model.ReimburseAmountDetailBean;
import kd.fi.er.business.ext.enums.ErExtcaseEnum;
import kd.fi.er.business.ext.helper.ErExtHelper;
import kd.fi.er.business.reimamountctl.method.QuotaCtlMethodFactory;
import kd.fi.er.business.reimamountctl.method.QuotaCtlMethodService;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlMode;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.reimamountctl.model.ReimAmountQuotaAmountBO;
import kd.fi.er.business.reimamountctl.quota.DeptQuotaQueryServiceImpl;
import kd.fi.er.business.reimamountctl.reimed.ExpenseReimedQueryServiceImpl;
import kd.fi.er.business.reimamountctl.reimed.PublicExpenseReimedQueryServiceImpl;
import kd.fi.er.business.reimamountctl.reimed.TripReimedQueryServiceImpl;
import kd.fi.er.business.utils.ErStdConfig;

public class DeptQuotaCtrlMode
implements QuotaCtrlMode {
    @Override
    public Map<Month, BigDecimal> getMonthQuotaAmount(QuotaAmountBO quotaAmountBO) {
        DeptQuotaQueryServiceImpl deptQuotaQueryService = new DeptQuotaQueryServiceImpl();
        Map<Month, BigDecimal> deptMonthQuotaAmount = deptQuotaQueryService.getDeptMonthQuotaAmount(quotaAmountBO);
        return deptMonthQuotaAmount;
    }

    @Override
    public BigDecimal getQuotaAmount(QuotaAmountBO quotaAmountBO) {
        DeptQuotaQueryServiceImpl deptQuotaQueryService = new DeptQuotaQueryServiceImpl();
        BigDecimal quotaAmount = deptQuotaQueryService.getDeptQuotaAmount(quotaAmountBO);
        if (quotaAmount == null) {
            return null;
        }
        return quotaAmount;
    }

    @Override
    public BigDecimal getReimedAmount(QuotaAmountBO quotaAmountBO) {
        BigDecimal reimedAmount = BigDecimal.ZERO;
        QuotaCtlMethodService quotaCtlMethodService = QuotaCtlMethodFactory.get(quotaAmountBO.getCtrlMethod());
        Map<String, LocalDate> happenDatePeriod = quotaCtlMethodService.genHappenDatePeriod(quotaAmountBO);
        BigDecimal extAmount = DailyAmountUtils.getDeptReimbursedAmountBetween(quotaAmountBO.getCompanyId(), quotaAmountBO.getUserOrDeptId(), quotaAmountBO.getExpenseItemId(), quotaAmountBO.getCurrencyId(), happenDatePeriod.get("start"), happenDatePeriod.get("end"), quotaAmountBO.getNotInIds(), Maps.newHashMapWithExpectedSize((int)0));
        HashMap<String, Object> paramExt = new HashMap<String, Object>();
        paramExt.put("company", quotaAmountBO.getCompanyId());
        paramExt.put("dept", quotaAmountBO.getUserOrDeptId());
        paramExt.put("expenseitem", quotaAmountBO.getExpenseItemId());
        paramExt.put("currency", quotaAmountBO.getCurrencyId());
        paramExt.put("begindate", happenDatePeriod.get("start"));
        paramExt.put("enddate", happenDatePeriod.get("end"));
        paramExt.put("existids", quotaAmountBO.getNotInIds());
        BigDecimal extBosAmount = ErExtHelper.invokeExpandAmount(paramExt, ErExtcaseEnum.ER_EXTCASE_REIMBURSE_AMOUNT.getCode(), "getDeptReimbursedAmountBetween");
        if (ErStdConfig.standardQuotaQuery()) {
            List<String> empCtlBill = quotaAmountBO.getDeptCtlBill();
            if (empCtlBill != null) {
                if (empCtlBill.contains("1")) {
                    ExpenseReimedQueryServiceImpl expenseReimedAmountService = new ExpenseReimedQueryServiceImpl();
                    reimedAmount = reimedAmount.add(expenseReimedAmountService.queryDeptReimedAmount(quotaAmountBO));
                }
                if (empCtlBill.contains("2")) {
                    TripReimedQueryServiceImpl tripReimedAmountService = new TripReimedQueryServiceImpl();
                    reimedAmount = reimedAmount.add(tripReimedAmountService.queryDeptReimedAmount(quotaAmountBO));
                }
                if (empCtlBill.contains("3")) {
                    PublicExpenseReimedQueryServiceImpl publicExpenseReimedQueryService = new PublicExpenseReimedQueryServiceImpl();
                    reimedAmount = reimedAmount.add(publicExpenseReimedQueryService.queryDeptReimedAmount(quotaAmountBO));
                }
            }
            reimedAmount = reimedAmount.add(extAmount).add(extBosAmount);
        } else {
            reimedAmount = extAmount.add(extBosAmount);
        }
        return reimedAmount;
    }

    @Override
    public BigDecimal getBalanceAmount(QuotaAmountBO quotaAmountBO) {
        BigDecimal quotaAmount = this.getQuotaAmount(quotaAmountBO);
        if (quotaAmount == null) {
            return null;
        }
        BigDecimal reimedAmount = this.getReimedAmount(quotaAmountBO);
        return quotaAmount.subtract(reimedAmount).max(BigDecimal.ZERO);
    }

    @Override
    public List<ReimburseAmountDetailBean> getReimbursedBills(QuotaAmountBO quotaAmountBO) {
        List<String> deptCtlBill;
        ArrayList<ReimburseAmountDetailBean> reimedBills = new ArrayList<ReimburseAmountDetailBean>();
        QuotaCtlMethodService quotaCtlMethodService = QuotaCtlMethodFactory.get(quotaAmountBO.getCtrlMethod());
        Map<String, LocalDate> happenDatePeriod = quotaCtlMethodService.genHappenDatePeriod(quotaAmountBO);
        List<ReimburseAmountDetailBean> exAmountDetail = DailyAmountUtils.getDeptReimbursedAmountDetailBetween(quotaAmountBO.getCompanyId(), quotaAmountBO.getUserOrDeptId(), quotaAmountBO.getExpenseItemId(), quotaAmountBO.getCurrencyId(), happenDatePeriod.get("start"), happenDatePeriod.get("end"), quotaAmountBO.getNotInIds(), Maps.newHashMapWithExpectedSize((int)0));
        HashMap<String, Object> paramExt = new HashMap<String, Object>();
        paramExt.put("company", quotaAmountBO.getCompanyId());
        paramExt.put("dept", quotaAmountBO.getUserOrDeptId());
        paramExt.put("expenseitem", quotaAmountBO.getExpenseItemId());
        paramExt.put("currency", quotaAmountBO.getCurrencyId());
        paramExt.put("begindate", happenDatePeriod.get("start"));
        paramExt.put("enddate", happenDatePeriod.get("end"));
        paramExt.put("existids", quotaAmountBO.getNotInIds());
        List<ReimburseAmountDetailBean> extBosAmount = ErExtHelper.invokeExpandAmountDetail(paramExt, ErExtcaseEnum.ER_EXTCASE_REIMBURSE_AMOUNT.getCode(), "getDeptReimbursedAmountDetailBetween");
        reimedBills.addAll(exAmountDetail);
        reimedBills.addAll(extBosAmount);
        if (ErStdConfig.standardQuotaQuery() && (deptCtlBill = quotaAmountBO.getDeptCtlBill()) != null) {
            List<ReimburseAmountDetailBean> tripReimedBills;
            if (deptCtlBill.contains("1")) {
                ExpenseReimedQueryServiceImpl expenseReimedAmountService = new ExpenseReimedQueryServiceImpl();
                List<ReimburseAmountDetailBean> expenseReimedBills = expenseReimedAmountService.queryDeptReimedBill(quotaAmountBO);
                reimedBills.addAll(expenseReimedBills);
            }
            if (deptCtlBill.contains("2")) {
                TripReimedQueryServiceImpl tripReimedAmountService = new TripReimedQueryServiceImpl();
                tripReimedBills = tripReimedAmountService.queryDeptReimedBill(quotaAmountBO);
                reimedBills.addAll(tripReimedBills);
            }
            if (deptCtlBill.contains("3")) {
                PublicExpenseReimedQueryServiceImpl publicExpenseReimedQueryService = new PublicExpenseReimedQueryServiceImpl();
                tripReimedBills = publicExpenseReimedQueryService.queryDeptReimedBill(quotaAmountBO);
                reimedBills.addAll(tripReimedBills);
            }
        }
        return reimedBills;
    }

    @Override
    public List<ReimAmountQuotaAmountBO> getReimedAmount(List<QuotaAmountBO> quotaAmountBOList) {
        return null;
    }
}

