/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reimamountctl.mode;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.fi.er.business.daily.amount.service.util.DailyAmountUtils;
import kd.fi.er.business.daily.service.model.ReimburseAmountDetailBean;
import kd.fi.er.business.ext.enums.ErExtcaseEnum;
import kd.fi.er.business.ext.helper.ErExtHelper;
import kd.fi.er.business.reimamountctl.method.QuotaCtlMethodFactory;
import kd.fi.er.business.reimamountctl.method.QuotaCtlMethodService;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlMode;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.reimamountctl.model.ReimAmountQuotaAmountBO;
import kd.fi.er.business.reimamountctl.quota.EmpQuotaQueryServiceImpl;
import kd.fi.er.business.reimamountctl.reimed.ExpenseReimedQueryServiceImpl;
import kd.fi.er.business.reimamountctl.reimed.PublicExpenseReimedQueryServiceImpl;
import kd.fi.er.business.reimamountctl.reimed.TripReimedQueryServiceImpl;
import kd.fi.er.business.utils.ErStdConfig;

public class EmpQuotaCtrlMode
implements QuotaCtrlMode {
    @Override
    public Map<Month, BigDecimal> getMonthQuotaAmount(QuotaAmountBO quotaAmountBO) {
        EmpQuotaQueryServiceImpl empQuotaQueryService = new EmpQuotaQueryServiceImpl();
        Map<Month, BigDecimal> empMonthQuotaAmount = empQuotaQueryService.getEmpMonthQuotaAmount(quotaAmountBO);
        return empMonthQuotaAmount;
    }

    @Override
    public BigDecimal getQuotaAmount(QuotaAmountBO quotaAmountBO) {
        EmpQuotaQueryServiceImpl empQuotaQueryService = new EmpQuotaQueryServiceImpl();
        BigDecimal quotaAmount = empQuotaQueryService.getEmpQuotaAmount(quotaAmountBO);
        if (quotaAmount == null) {
            return null;
        }
        return quotaAmount;
    }

    @Override
    public BigDecimal getReimedAmount(QuotaAmountBO quotaAmountBO) {
        BigDecimal reimedAmount = BigDecimal.ZERO;
        QuotaCtlMethodService quotaCtlMethodService = QuotaCtlMethodFactory.get(quotaAmountBO.getCtrlMethod());
        Map<String, LocalDate> happenDatePeriod = quotaCtlMethodService.genHappenDatePeriod(quotaAmountBO);
        BigDecimal extAmount = DailyAmountUtils.getEmployeeReimbursedAmountBetween(quotaAmountBO.getCompanyId(), quotaAmountBO.getUserOrDeptId(), quotaAmountBO.getExpenseItemId(), quotaAmountBO.getCurrencyId(), happenDatePeriod.get("start"), happenDatePeriod.get("end"), quotaAmountBO.getNotInIds(), Maps.newHashMapWithExpectedSize((int)0));
        HashMap<String, Object> paramExt = new HashMap<String, Object>();
        paramExt.put("company", quotaAmountBO.getCompanyId());
        paramExt.put("userid", quotaAmountBO.getUserOrDeptId());
        paramExt.put("expenseitem", quotaAmountBO.getExpenseItemId());
        paramExt.put("currency", quotaAmountBO.getCurrencyId());
        paramExt.put("begindate", happenDatePeriod.get("start"));
        paramExt.put("enddate", happenDatePeriod.get("end"));
        paramExt.put("existids", quotaAmountBO.getNotInIds());
        BigDecimal extBosAmount = ErExtHelper.invokeExpandAmount(paramExt, ErExtcaseEnum.ER_EXTCASE_REIMBURSE_AMOUNT.getCode(), "getEmployeeReimbursedAmountBetween");
        if (ErStdConfig.standardQuotaQuery()) {
            List<String> empCtlBill = quotaAmountBO.getEmpCtlBill();
            if (empCtlBill != null) {
                if (empCtlBill.contains("1")) {
                    ExpenseReimedQueryServiceImpl expenseReimedAmountService = new ExpenseReimedQueryServiceImpl();
                    reimedAmount = reimedAmount.add(expenseReimedAmountService.queryEmpReimedAmount(quotaAmountBO));
                }
                if (empCtlBill.contains("2")) {
                    TripReimedQueryServiceImpl tripReimedAmountService = new TripReimedQueryServiceImpl();
                    reimedAmount = reimedAmount.add(tripReimedAmountService.queryEmpReimedAmount(quotaAmountBO));
                }
                if (empCtlBill.contains("3")) {
                    PublicExpenseReimedQueryServiceImpl publicExpenseReimedQueryService = new PublicExpenseReimedQueryServiceImpl();
                    reimedAmount = reimedAmount.add(publicExpenseReimedQueryService.queryEmpReimedAmount(quotaAmountBO));
                }
            }
            reimedAmount = reimedAmount.add(extAmount).add(extBosAmount);
        } else {
            reimedAmount = extAmount.add(extBosAmount);
        }
        return reimedAmount;
    }

    @Override
    public List<ReimAmountQuotaAmountBO> getReimedAmount(List<QuotaAmountBO> quotaAmountBOList) {
        ArrayList<ReimAmountQuotaAmountBO> reimAmountQuotaAmountBOList = new ArrayList<ReimAmountQuotaAmountBO>(quotaAmountBOList.size());
        ArrayList<BigDecimal> extBosAmountList = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> extAmountList = new ArrayList<BigDecimal>();
        ArrayList<QuotaAmountBO> expenseReimedQueryList = new ArrayList<QuotaAmountBO>();
        ArrayList<QuotaAmountBO> tripReimedQueryList = new ArrayList<QuotaAmountBO>();
        ArrayList<QuotaAmountBO> publicExpenseReimedQueryList = new ArrayList<QuotaAmountBO>();
        boolean standardQuotaQuery = ErStdConfig.standardQuotaQuery();
        int boListSize = quotaAmountBOList.size();
        for (int i = 0; i < boListSize; ++i) {
            QuotaAmountBO quotaAmountBO = quotaAmountBOList.get(i);
            if (quotaAmountBO.getExpenseItemId() != null) {
                List<String> empCtlBill;
                QuotaCtlMethodService quotaCtlMethodService = QuotaCtlMethodFactory.get(quotaAmountBO.getCtrlMethod());
                Map<String, LocalDate> happenDatePeriod = quotaCtlMethodService.genHappenDatePeriod(quotaAmountBO);
                BigDecimal extAmount = DailyAmountUtils.getEmployeeReimbursedAmountBetween(quotaAmountBO.getCompanyId(), quotaAmountBO.getUserOrDeptId(), quotaAmountBO.getExpenseItemId(), quotaAmountBO.getCurrencyId(), happenDatePeriod.get("start"), happenDatePeriod.get("end"), quotaAmountBO.getNotInIds(), Maps.newHashMapWithExpectedSize((int)0));
                HashMap<String, Object> paramExt = new HashMap<String, Object>();
                paramExt.put("company", quotaAmountBO.getCompanyId());
                paramExt.put("userid", quotaAmountBO.getUserOrDeptId());
                paramExt.put("expenseitem", quotaAmountBO.getExpenseItemId());
                paramExt.put("currency", quotaAmountBO.getCurrencyId());
                paramExt.put("begindate", happenDatePeriod.get("start"));
                paramExt.put("enddate", happenDatePeriod.get("end"));
                paramExt.put("existids", quotaAmountBO.getNotInIds());
                BigDecimal extBosAmount = ErExtHelper.invokeExpandAmount(paramExt, ErExtcaseEnum.ER_EXTCASE_REIMBURSE_AMOUNT.getCode(), "getEmployeeReimbursedAmountBetween");
                extBosAmountList.add(extBosAmount);
                extAmountList.add(extAmount);
                if (!standardQuotaQuery || (empCtlBill = quotaAmountBO.getEmpCtlBill()) == null) continue;
                if (empCtlBill.contains("1")) {
                    expenseReimedQueryList.add(quotaAmountBO);
                }
                if (empCtlBill.contains("2")) {
                    tripReimedQueryList.add(quotaAmountBO);
                }
                if (!empCtlBill.contains("3")) continue;
                publicExpenseReimedQueryList.add(quotaAmountBO);
                continue;
            }
            extBosAmountList.add(BigDecimal.ZERO);
            extAmountList.add(BigDecimal.ZERO);
        }
        ExpenseReimedQueryServiceImpl expenseReimedAmountService = new ExpenseReimedQueryServiceImpl();
        List<ReimAmountQuotaAmountBO> expenseReimedtList = expenseReimedAmountService.queryEmpReimedAmount(expenseReimedQueryList);
        TripReimedQueryServiceImpl tripReimedAmountService = new TripReimedQueryServiceImpl();
        List<ReimAmountQuotaAmountBO> tripReimedList = tripReimedAmountService.queryEmpReimedAmount(tripReimedQueryList);
        PublicExpenseReimedQueryServiceImpl publicExpenseReimedQueryService = new PublicExpenseReimedQueryServiceImpl();
        List<ReimAmountQuotaAmountBO> publicExpenseReimedList = publicExpenseReimedQueryService.queryEmpReimedAmount(publicExpenseReimedQueryList);
        Map<Long, BigDecimal> expenseReimedAmount = expenseReimedtList.stream().collect(Collectors.toMap(e -> e.getQuotaAmountBO().getReimburseamountrowID(), ReimAmountQuotaAmountBO::getReimAmount));
        Map<Long, BigDecimal> tripReimedAmount = tripReimedList.stream().collect(Collectors.toMap(e -> e.getQuotaAmountBO().getReimburseamountrowID(), ReimAmountQuotaAmountBO::getReimAmount));
        Map<Long, BigDecimal> publicExpenseReimedAmount = publicExpenseReimedList.stream().collect(Collectors.toMap(e -> e.getQuotaAmountBO().getReimburseamountrowID(), ReimAmountQuotaAmountBO::getReimAmount));
        for (int i = 0; i < boListSize; ++i) {
            QuotaAmountBO quotaAmountBO = quotaAmountBOList.get(i);
            BigDecimal reimedAmount = BigDecimal.ZERO;
            BigDecimal extBosAmount = (BigDecimal)extBosAmountList.get(i);
            BigDecimal extAmount = (BigDecimal)extAmountList.get(i);
            if (quotaAmountBO.getExpenseItemId() != null && standardQuotaQuery) {
                List<String> empCtlBill = quotaAmountBO.getEmpCtlBill();
                if (empCtlBill != null) {
                    if (expenseReimedAmount.get(quotaAmountBO.getReimburseamountrowID()) != null) {
                        reimedAmount = reimedAmount.add(expenseReimedAmount.get(quotaAmountBO.getReimburseamountrowID()));
                    }
                    if (tripReimedAmount.get(quotaAmountBO.getReimburseamountrowID()) != null) {
                        reimedAmount = reimedAmount.add(tripReimedAmount.get(quotaAmountBO.getReimburseamountrowID()));
                    }
                    if (publicExpenseReimedAmount.get(quotaAmountBO.getReimburseamountrowID()) != null) {
                        reimedAmount = reimedAmount.add(publicExpenseReimedAmount.get(quotaAmountBO.getReimburseamountrowID()));
                    }
                }
                reimedAmount = reimedAmount.add(extAmount).add(extBosAmount);
            } else {
                reimedAmount = extAmount.add(extBosAmount);
            }
            ReimAmountQuotaAmountBO reimAmountQuotaAmountBO = new ReimAmountQuotaAmountBO(quotaAmountBO, reimedAmount);
            reimAmountQuotaAmountBOList.add(reimAmountQuotaAmountBO);
        }
        return reimAmountQuotaAmountBOList;
    }

    @Override
    public BigDecimal getBalanceAmount(QuotaAmountBO quotaAmountBO) {
        BigDecimal quotaAmount = this.getQuotaAmount(quotaAmountBO);
        if (quotaAmount == null) {
            return null;
        }
        BigDecimal reimedAmount = this.getReimedAmount(quotaAmountBO);
        return quotaAmount.subtract(reimedAmount).max(BigDecimal.ZERO);
    }

    @Override
    public List<ReimburseAmountDetailBean> getReimbursedBills(QuotaAmountBO quotaAmountBO) {
        List<String> empCtlBill;
        ArrayList<ReimburseAmountDetailBean> reimedBills = new ArrayList<ReimburseAmountDetailBean>();
        QuotaCtlMethodService quotaCtlMethodService = QuotaCtlMethodFactory.get(quotaAmountBO.getCtrlMethod());
        Map<String, LocalDate> happenDatePeriod = quotaCtlMethodService.genHappenDatePeriod(quotaAmountBO);
        List<ReimburseAmountDetailBean> exAmountDetail = DailyAmountUtils.getEmployeeReimbursedAmountDetailBetween(quotaAmountBO.getCompanyId(), quotaAmountBO.getUserOrDeptId(), quotaAmountBO.getExpenseItemId(), quotaAmountBO.getCurrencyId(), happenDatePeriod.get("start"), happenDatePeriod.get("end"), quotaAmountBO.getNotInIds(), Maps.newHashMapWithExpectedSize((int)0));
        HashMap<String, Object> paramExt = new HashMap<String, Object>();
        paramExt.put("company", quotaAmountBO.getCompanyId());
        paramExt.put("userid", quotaAmountBO.getUserOrDeptId());
        paramExt.put("expenseitem", quotaAmountBO.getExpenseItemId());
        paramExt.put("currency", quotaAmountBO.getCurrencyId());
        paramExt.put("begindate", happenDatePeriod.get("start"));
        paramExt.put("enddate", happenDatePeriod.get("end"));
        paramExt.put("existids", quotaAmountBO.getNotInIds());
        List<ReimburseAmountDetailBean> extBosDetail = ErExtHelper.invokeExpandAmountDetail(paramExt, ErExtcaseEnum.ER_EXTCASE_REIMBURSE_AMOUNT.getCode(), "getEmployeeReimbursedAmountDetailBetween");
        reimedBills.addAll(exAmountDetail);
        reimedBills.addAll(extBosDetail);
        if (ErStdConfig.standardQuotaQuery() && (empCtlBill = quotaAmountBO.getEmpCtlBill()) != null) {
            List<ReimburseAmountDetailBean> tripReimedBills;
            if (empCtlBill.contains("1")) {
                ExpenseReimedQueryServiceImpl expenseReimedAmountService = new ExpenseReimedQueryServiceImpl();
                List<ReimburseAmountDetailBean> expenseReimedBills = expenseReimedAmountService.queryEmpReimedBill(quotaAmountBO);
                reimedBills.addAll(expenseReimedBills);
            }
            if (empCtlBill.contains("2")) {
                TripReimedQueryServiceImpl tripReimedAmountService = new TripReimedQueryServiceImpl();
                tripReimedBills = tripReimedAmountService.queryEmpReimedBill(quotaAmountBO);
                reimedBills.addAll(tripReimedBills);
            }
            if (empCtlBill.contains("3")) {
                PublicExpenseReimedQueryServiceImpl publicExpenseReimedQueryService = new PublicExpenseReimedQueryServiceImpl();
                tripReimedBills = publicExpenseReimedQueryService.queryEmpReimedBill(quotaAmountBO);
                reimedBills.addAll(tripReimedBills);
            }
        }
        return reimedBills;
    }
}

